/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.Token;

public class TokenMgrError
extends Error
implements FileError {
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    int errorCode;
    public int errorLine = 0;
    public int errorColumn = 0;
    public int errorPos = 0;
    public String found = "";
    public String expected = "";
    public String tokenImage = "";

    protected static final String addEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static final String LexicalError(boolean bl, int n, int n2, int n3, String string, char c) {
        return "Lexical error at line " + n2 + ", column " + n3 + ".  Encountered: " + (bl ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(c)) + "\"" + " (" + c + "), ") + "after : \"" + TokenMgrError.addEscapes(string) + "\"";
    }

    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String string, int n) {
        super(string);
        this.errorCode = n;
    }

    public TokenMgrError(boolean bl, int n, int n2, int n3, String string, char c, int n4, int n5) {
        this(bl, n, n2, n3, string, c, n4);
        this.errorPos = n5;
    }

    public TokenMgrError(boolean bl, int n, int n2, int n3, String string, char c, int n4) {
        this(TokenMgrError.LexicalError(bl, n, n2, n3, string, c), n4);
        this.errorLine = n2;
        this.errorColumn = n3;
        this.tokenImage = "" + c;
        this.found = bl ? "<EOF>" : "\"" + TokenMgrError.addEscapes(String.valueOf(c)) + "\"" + " (" + c + ")";
        this.expected = "\"" + TokenMgrError.addEscapes(string) + "\"";
    }

    public String getFound() {
        return this.found;
    }

    public String getFoundTokenImage() {
        return this.tokenImage;
    }

    public int getLine() {
        return this.errorLine;
    }

    public int getLastEndPosition() {
        return this.errorPos;
    }

    public int getEndPosition() {
        return this.errorPos;
    }

    public int getColumn() {
        return this.errorColumn;
    }

    public String[] getExpected() {
        String[] stringArray = new String[]{this.expected};
        return stringArray;
    }

    public String[] getExpectedImages() {
        return new String[0];
    }

    public String[] getLastExpectedImages() {
        return this.getExpectedImages();
    }

    public Token getToken() {
        return null;
    }

    public int getErrorType() {
        return 50;
    }

    public void freeUnusedTokens() {
    }

    public int getEndLine() {
        return this.getLine();
    }

    public int getEndColumn() {
        return this.getColumn();
    }
}

