/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.Node;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParserTreeConstants;
import com.agentpp.smiparser.SMIParserVisitor;
import com.agentpp.smiparser.Token;

public class SimpleNode
implements Node {
    protected Node parent = null;
    protected Node[] children;
    protected int id;
    private Token token = null;

    public SimpleNode(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    private static SimpleNode jjtGetRoot(SimpleNode simpleNode) {
        if (simpleNode.jjtGetParent() != null) {
            return SimpleNode.jjtGetRoot((SimpleNode)simpleNode.jjtGetParent());
        }
        return simpleNode;
    }

    public Node jjtGetRoot() {
        return SimpleNode.jjtGetRoot(this);
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(SMIParserVisitor sMIParserVisitor, Object object) throws SMIParseException {
        return sMIParserVisitor.visit(this, object);
    }

    public Object childrenAccept(SMIParserVisitor sMIParserVisitor, Object object) throws SMIParseException {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(sMIParserVisitor, object);
            }
        }
        return object;
    }

    public String toString() {
        return SMIParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    public void setToken(Token token) {
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }
}

