/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.CreateOidsVisitor;
import com.agentpp.smiparser.ParseScope;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SMIRepository
extends SimpleNode {
    private ImportModuleListener importer = null;
    protected Map modules = new HashMap();
    protected ParseScope scope = null;

    public SMIRepository() {
        super(0);
    }

    public SMIRepository(int n) {
        super(n);
    }

    public void reinit() {
        this.modules = new HashMap();
    }

    public void setImporter(ImportModuleListener importModuleListener) {
        this.importer = importModuleListener;
        if (this.scope != null) {
            this.scope.setImporter(importModuleListener);
        }
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            ((ParseScope)iterator.next()).setImporter(importModuleListener);
        }
    }

    public void addScope(String string) {
        this.scope = new ParseScope(string, this.importer);
        this.modules.put(string, this.scope);
    }

    public void setScope(String string, SMIParseExceptionHandler sMIParseExceptionHandler) {
        this.scope = (ParseScope)this.modules.get(string);
        this.scope.setErrorHandler(sMIParseExceptionHandler);
    }

    protected ParseScope getScope(String string) {
        return (ParseScope)this.modules.get(string);
    }

    public boolean importModule(String string, MIBRepository mIBRepository, boolean bl) {
        if (this.scope == null) {
            return false;
        }
        return this.scope.importModule(string, mIBRepository, bl);
    }

    public String hasCircularImport(String string, String string2) {
        if (this.importer == null) {
            return null;
        }
        return this.getCyclicImport(string, string2);
    }

    private String getCyclicImport(String string, String string2) {
        ImportModuleEvent importModuleEvent = new ImportModuleEvent(this, string);
        this.importer.importModule(importModuleEvent);
        if (importModuleEvent.getObjects() == null) {
            return null;
        }
        IObject[] iObjectArray = importModuleEvent.getObjects();
        for (int i = 0; i < iObjectArray.length; ++i) {
            if (!(iObjectArray[i] instanceof MIBModule)) continue;
            MIBModule mIBModule = (MIBModule)iObjectArray[i];
            if (mIBModule.importsFrom(string) || mIBModule.importsFrom(string2)) {
                return string;
            }
            if (!mIBModule.hasImports()) continue;
            String[] stringArray = mIBModule.getImportSources();
            for (int j = 0; j < stringArray.length; ++j) {
                String string3 = this.hasCircularImport(stringArray[j], string2);
                if (string3 == null) continue;
                return string3;
            }
        }
        return null;
    }

    public MIBObject getObject(String string, String string2) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObject(string, string2);
    }

    public boolean setErrorHandler(SMIParseExceptionHandler sMIParseExceptionHandler) {
        if (this.scope != null) {
            this.scope.setErrorHandler(sMIParseExceptionHandler);
            return true;
        }
        return false;
    }

    public ObjectID getObjectID(String string) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObjectID(string);
    }

    public ObjectID getObjectID(String string, String string2) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObjectID(string, string2);
    }

    public boolean isModuleAlreadyImported(String string) {
        if (this.scope == null) {
            return false;
        }
        return this.scope.isModuleAlreadyImported(string);
    }

    public boolean isObjectKnown(String string) {
        if (this.scope == null) {
            return false;
        }
        return this.scope.isObjectKnown(string);
    }

    public MIBObject getKnownObject(String string) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getKnownObject(string);
    }

    public String getModuleName(Object object) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getModuleName(object);
    }

    public void createOids() {
        try {
            this.jjtAccept(new CreateOidsVisitor(this), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createOids(String string) {
        try {
            this.jjtAccept(new CreateOidsVisitor(this, string), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addObject(MIBObject mIBObject) {
        if (this.scope != null) {
            this.scope.addObject(mIBObject);
        }
    }

    public void addKnownObject(MIBObject mIBObject) throws SMIParseException {
        if (this.scope != null) {
            this.scope.addKnownObject(mIBObject);
        }
    }

    public void replaceKnownObject(String string, MIBObject mIBObject) {
        if (this.scope != null) {
            this.scope.replaceKnownObject(string, mIBObject);
        }
    }

    public void addUnresolvedName(StringToken[] stringTokenArray, StringToken stringToken) {
        if (this.scope != null) {
            this.scope.addUnresolvedName(stringTokenArray, stringToken);
        }
    }

    public void checkUnresolved(StringToken stringToken, StringToken[] stringTokenArray) {
        if (this.scope != null) {
            this.scope.checkUnresolved(stringToken, stringTokenArray);
        }
    }

    public void resolveNames() {
        if (this.scope != null) {
            this.scope.resolveNames();
        }
    }

    public boolean existsUnresolvedNames() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsUnresolvedNames();
    }

    public Iterator getUnresolvedNames() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getUnresolvedNames();
    }

    public void checkUnresolvedSyntax(StringToken stringToken) {
        if (this.scope != null) {
            this.scope.checkUnresolvedSyntax(stringToken);
        }
    }

    public void checkUnresolvedObject(StringToken stringToken, Class clazz) {
        if (this.scope != null) {
            this.scope.checkUnresolvedObject(stringToken, clazz);
        }
    }

    public boolean existsUnresolvedSyntaxes() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsUnresolvedSyntaxes();
    }

    public boolean existsWrongTypes() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsWrongTypes();
    }

    public void resolveSyntaxes() {
        if (this.scope != null) {
            this.scope.resolveSyntaxes();
        }
    }

    public Iterator getWrongTypes() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getWrongTypes();
    }

    public Iterator getUnresolvedSyntaxes() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getUnresolvedSyntaxes();
    }

    public void addSequence(String string) {
        if (this.scope != null) {
            this.scope.addSequence(string);
        }
    }

    public Vector getSequence(String string) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getSequence(string);
    }

    public ImportModuleListener getModuleImporter() {
        return this.importer;
    }
}

