/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.ObjectID;
import com.agentpp.smiparser.SMIObjectEntry;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.ArrayList;

public class SMIObjectIdentifier
extends SimpleNode {
    private StringToken name;
    private StringToken[] tokenOid;
    private String[] oid;
    public static final int ID = -17;

    public SMIObjectIdentifier() {
        super(-17);
        this.name = new StringToken("", null);
    }

    public SMIObjectIdentifier(StringToken stringToken) {
        super(-17);
        this.name = stringToken;
        this.oid = null;
    }

    public long size() {
        return this.jjtGetNumChildren();
    }

    public final String[] getOid(SMIRepository sMIRepository) {
        if (this.oid == null) {
            this.oid = SMIObjectIdentifier.buildOid(this.createOid(sMIRepository));
            return this.oid;
        }
        return this.oid;
    }

    public String getName() {
        return this.name.string;
    }

    public static final ObjectID buildObjectID(StringToken[] stringTokenArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        for (int i = 0; i < stringTokenArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(stringTokenArray[i].string);
        }
        return new ObjectID(stringBuffer.toString());
    }

    public final ObjectID buildObjectID() {
        return SMIObjectIdentifier.buildObjectID(this.tokenOid);
    }

    public static String[] buildOid(StringToken[] stringTokenArray) {
        String[] stringArray = new String[stringTokenArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenArray[i].string;
        }
        return stringArray;
    }

    public StringToken[] createOid(SMIRepository sMIRepository) {
        boolean bl = true;
        int n = this.jjtGetNumChildren();
        ArrayList<StringToken> arrayList = new ArrayList<StringToken>();
        for (int i = 0; i < n; ++i) {
            SMIObjectEntry sMIObjectEntry = (SMIObjectEntry)this.jjtGetChild(i);
            String string = sMIObjectEntry.getSubID();
            String string2 = sMIObjectEntry.getName();
            if (string == null) {
                ObjectID objectID = sMIRepository.getObjectID(string2);
                if (objectID != null) {
                    arrayList = new ArrayList();
                    String[] stringArray = SMIObjectIdentifier.fromString(objectID.toString());
                    for (int j = 0; j < stringArray.length; ++j) {
                        arrayList.add(new StringToken(stringArray[j], null));
                    }
                    continue;
                }
                bl = false;
                arrayList.add(new StringToken(string2, sMIObjectEntry.getNameToken()));
                continue;
            }
            arrayList.add(new StringToken(string, null));
        }
        this.tokenOid = arrayList.toArray(new StringToken[arrayList.size()]);
        this.oid = SMIObjectIdentifier.buildOid(this.tokenOid);
        if (!this.name.equals("")) {
            if (bl) {
                try {
                    sMIRepository.addKnownObject(new MIBObject(this.buildObjectID(), this.name.string));
                }
                catch (SMIParseException sMIParseException) {
                    // empty catch block
                }
                sMIRepository.checkUnresolved(this.name, this.tokenOid);
            } else {
                sMIRepository.addUnresolvedName(this.tokenOid, this.name);
                StringToken[] stringTokenArray = this.tokenOid;
                this.tokenOid = null;
                this.oid = null;
                return stringTokenArray;
            }
        }
        return this.tokenOid;
    }

    public StringToken getFirstUnresolvedSubId(SMIRepository sMIRepository) {
        if (this.oid != null) {
            return null;
        }
        StringToken[] stringTokenArray = this.createOid(sMIRepository);
        for (int i = 0; i < stringTokenArray.length; ++i) {
            for (int j = 0; j < stringTokenArray[i].string.length(); ++j) {
                if (Character.isDigit(stringTokenArray[i].string.charAt(j))) continue;
                return stringTokenArray[i];
            }
        }
        return null;
    }

    public static String toString(String[] stringArray) {
        return ObjectID.fromArray(stringArray);
    }

    public static String toSMI(String[] stringArray) {
        return ObjectID.fromArrayToSMI(stringArray);
    }

    public static String[] fromString(String string) {
        return ObjectID.toArray(string);
    }

    public String toString() {
        return ObjectID.fromArray(this.oid);
    }
}

