/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.Node;
import com.agentpp.smiparser.SMIObjectIdentifier;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.Vector;

public class SMIObject
extends SimpleNode {
    private String name;
    private String status = null;
    private int type = 0;
    public String asn1Comment = null;
    public String inlineAsn1Comment;
    public Integer sequenceID = null;
    public static final int ID = -1;

    public SMIObject() {
        super(-1);
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public static Vector getUpTreeSMIObjects(Node node) {
        Vector<SMIObject> vector = new Vector<SMIObject>();
        if (node == null) {
            return vector;
        }
        SMIObject sMIObject = SMIObject.getParentSMIObject(node);
        while (sMIObject != null) {
            vector.addElement(sMIObject);
            Node node2 = sMIObject.jjtGetParent();
            if (node2 != null) {
                int n = node2.jjtGetNumChildren();
                for (int i = 0; i < n; ++i) {
                    if (((SimpleNode)node2.jjtGetChild((int)i)).id != -1) continue;
                    vector.addElement((SMIObject)node2.jjtGetChild(i));
                }
            }
            sMIObject = SMIObject.getParentSMIObject(sMIObject);
        }
        return vector;
    }

    public static SMIObject getParentSMIObject(Node node) {
        if (node.jjtGetParent() == null) {
            return null;
        }
        if (((SimpleNode)node.jjtGetParent()).id == -1) {
            return (SMIObject)node.jjtGetParent();
        }
        return SMIObject.getParentSMIObject(node.jjtGetParent());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String[] getOid(SMIRepository sMIRepository) {
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            if (!(this.jjtGetChild(i) instanceof SMIObjectIdentifier)) continue;
            return ((SMIObjectIdentifier)this.jjtGetChild(i)).getOid(sMIRepository);
        }
        return new String[0];
    }

    public StringToken getFirstUnresolvedSubId(SMIRepository sMIRepository) {
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            if (!(this.jjtGetChild(i) instanceof SMIObjectIdentifier)) continue;
            return ((SMIObjectIdentifier)this.jjtGetChild(i)).getFirstUnresolvedSubId(sMIRepository);
        }
        return null;
    }

    public String getPrintableOid(SMIRepository sMIRepository) {
        String[] stringArray = this.getOid(sMIRepository);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }
}

