/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIAgentCapabilities;
import com.agentpp.smiparser.SMICompliance;
import com.agentpp.smiparser.SMIDefaultValue;
import com.agentpp.smiparser.SMIDescription;
import com.agentpp.smiparser.SMIEnum;
import com.agentpp.smiparser.SMIFile;
import com.agentpp.smiparser.SMIImportList;
import com.agentpp.smiparser.SMIIndex;
import com.agentpp.smiparser.SMIMib;
import com.agentpp.smiparser.SMIModule;
import com.agentpp.smiparser.SMINotifyType;
import com.agentpp.smiparser.SMIObject;
import com.agentpp.smiparser.SMIObjectType;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIParserVisitor;
import com.agentpp.smiparser.SMIRange;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SMIRevision;
import com.agentpp.smiparser.SMISeqEntries;
import com.agentpp.smiparser.SMISyntax;
import com.agentpp.smiparser.SMITextualConvention;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import com.agentpp.smiparser.Token;
import com.objectspace.jgl.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

public class SMI2Java
implements SMIParserVisitor,
SMIParseExceptionHandler {
    protected MIBRepository rep = null;
    protected SMIRepository smiRep;
    protected MIBModule currentModule = null;
    protected ModuleInfo currentModuleInfo = null;
    protected MIBObject currentObject = null;
    protected MIBObjectType currentObjectType = null;
    protected MIBSyntax currentSyntax = null;
    protected Map tableEntryToObject = null;
    protected Map nameToSyntax = null;
    protected Map nameSequences;
    protected Vector groups = null;
    protected int options = 4;
    protected int currentSMIVersion = 1;
    protected String currentFile = "";
    protected int moduleCount = 0;
    protected int maxErrors = 10;
    protected List errors = new LinkedList();
    protected ArrayList failedImports = new ArrayList();
    protected boolean storeFileName = Boolean.getBoolean("com.agentpp.smi.storeMIBFileName");
    protected static final Object[][] IMPORT_MAPPINGS = new Object[][]{{new Integer(12), SMI.SMI_SYNTAX[12]}};

    public SMI2Java(SMIRepository sMIRepository, int n) {
        this.smiRep = sMIRepository;
        this.options = n;
        this.rep = new MIBRepository();
        this.tableEntryToObject = new HashMap(150);
        this.nameToSyntax = new HashMap(150);
        this.nameSequences = new HashMap(50);
        this.groups = new Vector(10, 10);
    }

    public MIBObject getCurrentObject() {
        return this.currentObject;
    }

    public void setParseContext(MIBModule mIBModule, Set set) {
        Object object;
        Object object2;
        Serializable serializable3;
        Iterator iterator = mIBModule.objectsIterator();
        while (iterator.hasNext()) {
            serializable3 = (MIBObject)iterator.next();
            if (set.contains(((MIBObject)serializable3).getName())) continue;
            this.smiRep.scope.addObject(((MIBObject)serializable3).getClone());
            try {
                this.smiRep.scope.addKnownObject((MIBObject)serializable3);
            }
            catch (SMIParseException sMIParseException) {
                // empty catch block
            }
            if (serializable3 instanceof MIBObjectType) {
                Serializable serializable2;
                object2 = (MIBObjectType)serializable3;
                if (((MIBObjectType)object2).isTable()) {
                    serializable2 = new Vector();
                    object = ((MIBObjectType)object2).getTableEntriesVector().iterator();
                    while (object.hasNext()) {
                        String string = (String)object.next();
                        ((Vector)serializable2).add(new StringToken(string, null));
                    }
                    this.nameSequences.put(((MIBObjectType)object2).getTableEntriesVector(), serializable2);
                }
                if ((serializable2 = ((MIBObjectType)object2).getSyntax()) == null || !Character.isUpperCase(((MIBSyntax)serializable2).getSyntax().charAt(0)) || ((MIBSyntax)serializable2).getType() != 3) continue;
                this.tableEntryToObject.put(((MIBSyntax)serializable2).getSyntax(), object2);
                continue;
            }
            if (serializable3 instanceof MIBGroup) {
                this.groups.add(serializable3);
                continue;
            }
            if (serializable3 instanceof MIBCompliance || !(serializable3 instanceof MIBAgentCaps)) continue;
            for (Serializable serializable2 : ((MIBAgentCaps)serializable3).getModules()) {
                if (this.smiRep.isModuleAlreadyImported(((MIBSupportedModule)serializable2).getSupports())) continue;
                this.smiRep.importModule(((MIBSupportedModule)serializable2).getSupports(), this.rep, true);
            }
        }
        for (Serializable serializable3 : mIBModule.getImportsVector()) {
            if (!this.smiRep.isModuleAlreadyImported(((MIBImport)serializable3).getSource())) {
                this.smiRep.importModule(((MIBImport)serializable3).getSource(), this.rep, false);
            }
            object2 = ((MIBImport)serializable3).getImports();
            for (int i = 0; i < ((String[])object2).length; ++i) {
                if (SMI.isKeyWord((String)object2[i]) || (object = this.smiRep.scope.rep.getObject(((MIBImport)serializable3).getSource(), (String)object2[i])) == null) continue;
                try {
                    this.smiRep.addKnownObject((MIBObject)object);
                    continue;
                }
                catch (SMIParseException sMIParseException) {
                    sMIParseException.printStackTrace();
                }
            }
        }
        this.currentModule = (MIBModule)mIBModule.getClone();
        this.currentModuleInfo = new ModuleInfo(mIBModule.getModuleName(), mIBModule.getImportSources());
        iterator = mIBModule.objectsIterator();
        while (iterator.hasNext()) {
            serializable3 = (MIBObject)iterator.next();
            if (set.contains(((MIBObject)serializable3).getName())) continue;
            this.rep.addObject(((MIBObject)serializable3).getClone());
        }
    }

    public final MIBRepository getRepository() {
        return this.rep;
    }

    protected final int getTokenSUPPORTS() {
        return 97;
    }

    protected final int getTokenDEFVAL() {
        return 55;
    }

    protected final int getTokenSYNTAX() {
        return 63;
    }

    protected final int getTokenWRITESYNTAX() {
        return 89;
    }

    protected void checkRestrictedSyntax(Token token, String string, MIBSyntax mIBSyntax, int n) throws SMIParseException {
        if (!mIBSyntax.isRestrictiveSyntax(this.smiRep.scope.rep)) {
            this.throwLocalizedError(token, new Vector<String>(Arrays.asList(string)), 4000, n, 1);
        }
    }

    protected void checkDisplayHint(MIBTextualConvention mIBTextualConvention) throws SMIParseException {
        if (mIBTextualConvention != null && mIBTextualConvention.hasDisplayHint()) {
            MIBSyntax mIBSyntax = mIBTextualConvention.getSyntax();
            if (mIBSyntax == null) {
                return;
            }
            if (mIBSyntax.hasEnums() || SMI.SMI_SYNTAX[2].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[12].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[3].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[5].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[6].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[9].equals(mIBSyntax.getSyntax())) {
                this.throwLocalizedError(mIBTextualConvention, new Vector<String>(Arrays.asList(mIBTextualConvention.getName())), 4100, 80, 1);
            } else if (Pattern.matches(SMIParser.DISPLAYHINT_FORMATS[1], mIBTextualConvention.getDisplayHint())) {
                if (SMI.SMI_SYNTAX[1].equals(mIBSyntax.getSyntax())) {
                    this.throwLocalizedError(mIBTextualConvention, new Vector<String>(Arrays.asList(mIBTextualConvention.getName(), mIBTextualConvention.getDisplayHint())), 4101, 80, 1);
                }
            } else if (!SMI.SMI_SYNTAX[1].equals(mIBSyntax.getSyntax())) {
                this.throwLocalizedError(mIBTextualConvention, new Vector<String>(Arrays.asList(mIBTextualConvention.getName(), mIBTextualConvention.getDisplayHint())), 4101, 80, 1);
            }
        }
    }

    protected void checkSyntax(StringToken stringToken, StringToken stringToken2) throws SMIParseException {
        if (stringToken2 == null) {
            return;
        }
        StringToken stringToken3 = (StringToken)this.nameToSyntax.get(stringToken);
        if (stringToken3 != null && !stringToken2.equals(stringToken3) && (this.options & 2) == 0) {
            MIBObject mIBObject = this.rep.getObject(stringToken.string);
            if (mIBObject != null && mIBObject.userObject instanceof Token) {
                Token token = (Token)mIBObject.userObject;
                SemanticError semanticError = new SemanticError(1200, token.beginLine, token.beginColumn, token.endPos, token, token.image, stringToken.string, new String[0]);
                this.error(new SMIParseException(semanticError, 1200));
            } else {
                this.throwLocalizedError(stringToken.token, 1200);
            }
        }
        this.nameToSyntax.put(stringToken, stringToken2);
    }

    protected ModuleInfo readModule(SMIMib sMIMib) throws SMIParseException {
        this.currentSMIVersion = sMIMib.version;
        ImportModuleListener importModuleListener = this.smiRep.getModuleImporter();
        Integer n = importModuleListener.createModuleID(sMIMib.getName());
        if (n == null) {
            n = new Integer(this.moduleCount);
        }
        this.currentModule = new MIBModule(sMIMib.getName(), n);
        this.currentObject = null;
        this.currentModule.setLastChange(new Date(System.currentTimeMillis()));
        if (this.storeFileName) {
            try {
                this.currentModule.setFileName(new File(this.currentFile).getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentModule.setName(sMIMib.getName());
        if (sMIMib.getToken() != null) {
            this.currentModule.setStartPosition(sMIMib.getToken().endPos - sMIMib.getToken().image.length());
        }
        this.currentModule.setOid(new ObjectID());
        this.currentModule.setSMIVersion(this.currentSMIVersion);
        this.currentModule.setCopyrightComment(sMIMib.asn1Comment);
        this.currentModule.setCopyrightCommentEnd(sMIMib.asn1EndComment);
        this.rep.addObject(this.currentModule);
        return new ModuleInfo(this.currentModule.getModuleName());
    }

    protected void readModuleIdentity(SMIModule sMIModule) throws SMIParseException {
        this.currentSMIVersion = 2;
        this.currentModule.setOrganization(sMIModule.getOrganization());
        this.currentModule.setContactInfo(sMIModule.getContactInfo());
        this.currentModule.setLastUpdated(sMIModule.getLastUpdated());
        this.currentModule.setSMIVersion(2);
        this.currentModule.setReleased(1);
        this.currentObject = this.currentModule;
    }

    protected void readObject(SMIObject sMIObject) throws SMIParseException {
        StringToken stringToken;
        ObjectID objectID = new ObjectID(sMIObject.getPrintableOid(this.smiRep));
        if (!objectID.isValid() && (stringToken = sMIObject.getFirstUnresolvedSubId(this.smiRep)) != null && stringToken.string.length() > 0) {
            if (Character.isUpperCase(stringToken.string.charAt(0))) {
                String string;
                String string2 = objectID.getSubID(0);
                if ((objectID = this.smiRep.getObjectID(string2, string = objectID.getSubID(1))) == null) {
                    if (stringToken.token != null) {
                        this.throwLocalizedError(stringToken.token, 1502);
                    } else if (sMIObject.getToken() != null) {
                        Token token = sMIObject.getToken();
                        this.error(new SMIParseException(new SemanticError(1502, token.beginLine, token.beginColumn, token.endPos, token, stringToken.string, token.image, new String[0]), 1502));
                    } else {
                        this.error(new SMIParseException(stringToken.string, 1502));
                    }
                }
            } else if (stringToken.token != null) {
                this.throwLocalizedError(stringToken.token, 1502);
            } else if (sMIObject.getToken() != null) {
                Token token = sMIObject.getToken();
                this.error(new SMIParseException(new SemanticError(1502, token.beginLine, token.beginColumn, token.endPos, token, stringToken.string, token.image, new String[0]), 1502));
            } else {
                this.error(new SMIParseException(stringToken.string, 1502));
            }
        }
        if (sMIObject.getType() != 4 && !objectID.isValid()) {
            this.currentObject = null;
            return;
        }
        switch (sMIObject.getType()) {
            case 1: {
                this.currentObject = new MIBObjectType(new ObjectID(sMIObject.getPrintableOid(this.smiRep)), sMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(sMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 2: 
            case 3: {
                this.currentObject = new MIBNotifyType(new ObjectID(sMIObject.getPrintableOid(this.smiRep)), sMIObject.getName(), this.currentModule.getModuleID(), sMIObject.getType());
                this.currentObject.setStatus(sMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 4: {
                this.currentObject = new MIBTextualConvention(sMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(sMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 5: {
                this.rep.renameObject(this.currentModule, new ObjectID(sMIObject.getPrintableOid(this.smiRep)), sMIObject.getName());
                this.currentModule.setStatus(sMIObject.getStatus());
                this.currentModule.setComment(sMIObject.asn1Comment);
                this.currentModule.setInlineComment(sMIObject.inlineAsn1Comment);
                break;
            }
            case 6: 
            case 7: {
                this.currentObject = new MIBGroup(new ObjectID(sMIObject.getPrintableOid(this.smiRep)), sMIObject.getName(), this.currentModule.getModuleID(), sMIObject.getType());
                this.currentObject.setStatus(sMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.groups.addElement(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 9: {
                this.currentObject = new MIBAgentCaps(new ObjectID(sMIObject.getPrintableOid(this.smiRep)), sMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(sMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 8: {
                this.currentObject = new MIBCompliance(new ObjectID(sMIObject.getPrintableOid(this.smiRep)), sMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(sMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            default: {
                this.currentObject = new MIBObject(new ObjectID(sMIObject.getPrintableOid(this.smiRep)), sMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(sMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
            }
        }
        if (this.currentObject != null) {
            this.currentObject.setModuleID(this.currentModule.getModuleID());
            this.currentObject.setSequenceID(sMIObject.sequenceID);
            if (!this.currentObject.hasComment()) {
                this.currentObject.setComment(sMIObject.asn1Comment);
            }
            if (!this.currentObject.hasInlineComment()) {
                this.currentObject.setInlineComment(sMIObject.inlineAsn1Comment);
            }
            this.currentObject.setReleased(1);
            this.currentObject.userObject = sMIObject.getToken();
            this.smiRep.addObject(this.currentObject);
        } else {
            this.smiRep.addObject(new MIBObject(new ObjectID(sMIObject.getPrintableOid(this.smiRep)), sMIObject.getName()));
        }
    }

    protected final StringToken getStringToken(MIBSyntax mIBSyntax) {
        if (mIBSyntax == null) {
            return null;
        }
        return mIBSyntax.userObject != null ? (StringToken)mIBSyntax.userObject : new StringToken(mIBSyntax.getSyntax(), null);
    }

    protected void readObjectType(SMIObjectType sMIObjectType) throws SMIParseException {
        MIBSyntax mIBSyntax;
        if (!(this.currentObject instanceof MIBObjectType)) {
            return;
        }
        MIBObjectType mIBObjectType = (MIBObjectType)this.currentObject;
        mIBObjectType.setAccess(sMIObjectType.getAccess());
        mIBObjectType.setUnits(sMIObjectType.getUnits());
        mIBObjectType.setSyntax(sMIObjectType.syntax);
        this.currentSyntax = mIBSyntax = sMIObjectType.syntax;
        if (mIBSyntax == null) {
            return;
        }
        this.checkSyntax(new StringToken(mIBObjectType.getName(), (Token)mIBObjectType.userObject), (StringToken)mIBSyntax.userObject);
        if (mIBSyntax.getType() == 3 || mIBSyntax.getType() == 2) {
            this.smiRep.checkUnresolvedSyntax(this.getStringToken(mIBSyntax));
        }
        if (Character.isUpperCase(mIBSyntax.getSyntax().charAt(0)) && mIBSyntax.getType() == 3) {
            this.tableEntryToObject.put(mIBSyntax.getSyntax(), mIBObjectType);
            Vector vector = this.smiRep.getSequence(mIBSyntax.getSyntax());
            if (vector != null && vector.size() > 0) {
                MIBTextualConvention mIBTextualConvention = new MIBTextualConvention(mIBSyntax.getSyntax());
                mIBTextualConvention.userObject = this.getStringToken((MIBSyntax)mIBSyntax).token;
                this.smiRep.addKnownObject(mIBTextualConvention);
                Vector<String> vector2 = new Vector<String>(vector.size() + 1);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    StringToken stringToken = (StringToken)enumeration.nextElement();
                    vector2.addElement(stringToken.string);
                }
                mIBObjectType.setTableEntriesVector(vector2);
            }
        }
    }

    protected void readNotifyType(SMINotifyType sMINotifyType) throws SMIParseException {
        if (!(this.currentObject instanceof MIBNotifyType)) {
            return;
        }
        MIBNotifyType mIBNotifyType = (MIBNotifyType)this.currentObject;
        mIBNotifyType.setEnterprise(sMINotifyType.getEnterprise());
    }

    protected void readSeqEntries(SMISeqEntries sMISeqEntries) throws SMIParseException {
        Class<MIBObjectType> clazz;
        Object object;
        String string = ((SMIObject)sMISeqEntries.jjtGetParent()).getName();
        MIBObject mIBObject = null;
        if (string.length() == 0) {
            return;
        }
        mIBObject = Character.isUpperCase(string.charAt(0)) ? (MIBObject)this.tableEntryToObject.get(string) : this.rep.getObject(string);
        Vector vector = sMISeqEntries.entries();
        Vector<String> vector2 = new Vector<String>(vector.size());
        Object object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (Pair)object2.nextElement();
            vector2.add(((StringToken)((Pair)object).first).string);
            clazz = null;
            if (mIBObject != null && (mIBObject instanceof MIBObjectType || mIBObject instanceof MIBNotifyType)) {
                clazz = MIBObjectType.class;
            }
            if (mIBObject != null && mIBObject instanceof MIBGroup && ((MIBGroup)mIBObject).getType() == 6) {
                clazz = MIBObjectType.class;
            } else if (mIBObject != null && mIBObject instanceof MIBGroup) {
                clazz = MIBNotifyType.class;
            }
            this.smiRep.checkUnresolvedObject((StringToken)((Pair)object).first, clazz);
            if (((Pair)object).second == null) continue;
            this.checkSyntax((StringToken)((Pair)object).first, (StringToken)((Pair)object).second);
        }
        this.nameSequences.put(vector2, vector);
        if (mIBObject != null) {
            if (mIBObject instanceof MIBObjectType) {
                object2 = (MIBObjectType)mIBObject;
                if (!((MIBObjectType)object2).hasIndexPart()) {
                    if (((MIBObjectType)object2).userObject != null && ((MIBObjectType)object2).userObject instanceof Token) {
                        this.throwLocalizedError((MIBObject)object2, new Vector<String>(Arrays.asList(((MIBObject)object2).getName())), 1200, 63, 1);
                    } else {
                        this.error(new SMIParseException(((MIBObject)object2).getName(), 1200));
                    }
                }
                ((MIBObjectType)object2).setTableEntriesVector(vector2);
                if (((MIBObjectType)object2).getSyntax() != null) {
                    object = new MIBTextualConvention(((MIBObjectType)object2).getSyntax().getSyntax());
                    ((MIBObject)object).userObject = this.getStringToken(((MIBObjectType)object2).getSyntax());
                    this.smiRep.addKnownObject((MIBObject)object);
                }
            }
            if (mIBObject instanceof MIBNotifyType) {
                object2 = (MIBNotifyType)mIBObject;
                ((MIBNotifyType)object2).setVariablesVector(vector2);
            }
            if (mIBObject instanceof MIBGroup) {
                object2 = (MIBGroup)mIBObject;
                ((MIBGroup)object2).setObjectsVector(vector2);
            }
        } else {
            object2 = this.smiRep.getSequence(string);
            if (object2 != null) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    clazz = (Pair)object.nextElement();
                    ((Vector)object2).add(((Pair)((Object)clazz)).first);
                }
            }
        }
    }

    protected void readRevision(SMIRevision sMIRevision) throws SMIParseException {
        this.currentModule.addRevision(new MIBRevision(sMIRevision.getRevision(), sMIRevision.getDescription()));
    }

    protected void readSyntax(SMISyntax sMISyntax) throws SMIParseException {
        MIBSyntax mIBSyntax = new MIBSyntax(sMISyntax.getSyntax().string, sMISyntax.getType());
        mIBSyntax.userObject = sMISyntax.getSyntax();
        if (!(sMISyntax.jjtGetParent() instanceof SMISeqEntries) && this.currentObject instanceof MIBAgentCaps && (sMISyntax.getType() == 3 || sMISyntax.getType() == 2)) {
            this.smiRep.checkUnresolvedSyntax(this.getStringToken(mIBSyntax));
        }
        if (this.currentSyntax == null) {
            this.currentSyntax = mIBSyntax;
        }
    }

    protected void readRange(SMIRange sMIRange) throws SMIParseException {
        if (this.currentSyntax != null) {
            this.currentSyntax.addRange(new MIBRange(sMIRange.getLower(), sMIRange.getUpper()));
        }
    }

    protected void readEnum(SMIEnum sMIEnum) throws SMIParseException {
        if (this.currentSyntax != null) {
            this.currentSyntax.addEnum(new MIBEnum(sMIEnum.getLabel(), sMIEnum.getValue(), sMIEnum.comment));
        }
    }

    protected void readVariable(StringToken stringToken) {
        MIBObject mIBObject;
        Class clazz = null;
        clazz = this.currentObject instanceof MIBGroup && ((MIBGroup)this.currentObject).getType() == 7 ? MIBNotifyType.class : MIBObjectType.class;
        this.smiRep.checkUnresolvedObject(stringToken, clazz);
        if (this.currentObject instanceof MIBNotifyType) {
            mIBObject = (MIBNotifyType)this.currentObject;
            ((MIBNotifyType)mIBObject).addVariable(stringToken.string);
        }
        if (this.currentObject instanceof MIBGroup) {
            mIBObject = (MIBGroup)this.currentObject;
            ((MIBGroup)mIBObject).addObject(stringToken.string);
        }
    }

    protected void readIndex(SMIIndex sMIIndex) throws SMIParseException {
        Object object;
        Vector vector = sMIIndex.getIndecies();
        Vector<String> vector2 = new Vector<String>(vector.size() + 1);
        Object object2 = vector.elements();
        while (object2.hasMoreElements()) {
            Class<MIBObjectType> clazz = MIBObjectType.class;
            object = (StringToken)object2.nextElement();
            if (this.currentModule.getSMIVersion() != 1 || !SMI.isASN1KeyWord(((StringToken)object).string)) {
                this.smiRep.checkUnresolvedObject((StringToken)object, clazz);
            }
            vector2.add(((StringToken)object).string);
        }
        object2 = (MIBObjectType)this.currentObject;
        if (object2 == null) {
            return;
        }
        int n = sMIIndex.getType() == 2 ? 2 : 1;
        object = new MIBIndexPart(n, vector2);
        ((MIBIndexPart)object).setImplied(sMIIndex.getImplied());
        ((MIBObjectType)object2).setIndexPart((MIBIndexPart)object);
        if (((MIBIndexPart)object).isAugment()) {
            String string = (String)((MIBIndexPart)object).getIndexPartVector().get(0);
            String string2 = this.currentModule.getImportSource(string);
            MIBObject mIBObject = null;
            mIBObject = string2 == null ? this.currentModule.getObjectByName(string) : this.smiRep.getObject(string2, string);
            if (mIBObject == null) {
                this.smiRep.checkUnresolvedSyntax(new StringToken(string, sMIIndex.getToken()));
            } else if (!(mIBObject instanceof MIBObjectType) || !((MIBObjectType)mIBObject).isTable()) {
                this.throwLocalizedError((MIBObject)object2, new Vector<String>(Arrays.asList(string, mIBObject.getTypeString())), 1600, this.getTokenINDEX(), 1);
            } else if (((MIBObjectType)mIBObject).getIndexPart() != null && ((MIBObjectType)mIBObject).getIndexPart().isAugment()) {
                this.throwInvalidIndex((MIBObjectType)object2);
            }
        }
    }

    private void checkIndexLength(MIBObjectType mIBObjectType) throws SMIParseException {
        if (mIBObjectType.hasIndexPart()) {
            int n;
            IndexStruct[] indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(this.smiRep.scope.rep);
            if (indexStructArray == null) {
                indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(this.rep);
            }
            if (indexStructArray == null) {
                return;
            }
            int n2 = mIBObjectType.getOid().size();
            for (n = 0; n < indexStructArray.length; ++n) {
                if (indexStructArray[n] == null) continue;
                n2 += indexStructArray[n].minLength;
                if (indexStructArray[n].minLength == indexStructArray[n].maxLength) continue;
                ++n2;
            }
            if (indexStructArray[indexStructArray.length - 1] != null) {
                n = indexStructArray[indexStructArray.length - 1].maxLength;
                if (n <= 0 || n2 > 128) {
                    this.throwInvalidIndex(mIBObjectType, 1812);
                }
                int n3 = indexStructArray[indexStructArray.length - 1].minLength;
                if (mIBObjectType.getIndexPart().isImplied() && n3 != n && n3 == 0) {
                    this.throwInvalidImpliedLengthIndex(mIBObjectType);
                }
            }
        }
    }

    protected int getTokenINDEX() {
        return 54;
    }

    private void throwInvalidIndex(MIBObjectType mIBObjectType) throws SMIParseException {
        this.throwInvalidIndex(mIBObjectType, 1810);
    }

    private void throwInvalidIndex(MIBObjectType mIBObjectType, int n) throws SMIParseException {
        if (mIBObjectType.userObject != null && mIBObjectType.userObject instanceof Token) {
            Token token = (Token)mIBObjectType.userObject;
            this.error(new SMIParseException(new SemanticError(n, token.beginLine, token.beginColumn, token.endPos, token, mIBObjectType.getName(), token.image, new String[0]), n));
        } else {
            this.error(new SMIParseException(mIBObjectType.getName(), n));
        }
    }

    private void throwInvalidImpliedLengthIndex(MIBObjectType mIBObjectType) throws SMIParseException {
        this.throwInvalidIndex(mIBObjectType, 1813);
    }

    public final void throwLocalizedError(MIBObject mIBObject, Vector vector, int n, int n2, int n3) throws SMIParseException {
        if (mIBObject.userObject != null && mIBObject.userObject instanceof Token) {
            Token token = (Token)mIBObject.userObject;
            while (token.next != null && token.kind != n2) {
                token = token.next;
            }
            for (int i = 0; i < n3 && token.next != null; ++i) {
                token = token.next;
            }
            this.error(new SMIParseException(new SemanticError(n, token.beginLine, token.beginColumn, token.endPos, token, mIBObject.getName(), token.image, new String[0]), n, vector));
        } else {
            this.error(new SMIParseException(mIBObject.getName(), n, vector));
        }
    }

    public final void throwLocalizedError(Token token, Vector vector, int n, int n2, int n3) throws SMIParseException {
        if (n2 >= 0) {
            while (token.next != null && token.kind != n2) {
                token = token.next;
            }
        }
        for (int i = 0; i < n3 && token.next != null; ++i) {
            token = token.next;
        }
        this.error(new SMIParseException(new SemanticError(n, token.beginLine, token.beginColumn, token.endPos, token, vector.get(0).toString(), token.image, new String[0]), n, vector));
    }

    public final void throwLocalizedError(Token token, Vector vector, int n, int n2, String string) throws SMIParseException {
        if (n2 >= 0) {
            while (token.next != null && token.kind != n2) {
                token = token.next;
            }
        }
        if (string != null) {
            while (token.next != null && !token.image.equals(string)) {
                token = token.next;
            }
        }
        this.error(new SMIParseException(new SemanticError(n, token.beginLine, token.beginColumn, token.endPos, token, string == null ? vector.get(0).toString() : string, token.image, new String[0]), n, vector));
    }

    public final void throwLocalizedError(Token token, Vector vector, int n, String string) throws SMIParseException {
        if (string != null) {
            while (token.next != null && !token.image.equals(string)) {
                token = token.next;
            }
        }
        this.error(new SMIParseException(new SemanticError(n, token.beginLine, token.beginColumn, token.endPos, token, string == null ? vector.get(0).toString() : string, token.image, new String[0]), n, vector));
    }

    public final void throwLocalizedError(Token token, int n) throws SMIParseException {
        this.error(new SMIParseException(new SemanticError(n, token.beginLine, token.beginColumn, token.endPos, token, token.image, token.image, new String[0]), n, new Vector(1)));
    }

    public final void throwNegativeIndex(MIBObjectType mIBObjectType, String string) throws SMIParseException {
        Vector<String> vector = new Vector<String>(2);
        vector.add(mIBObjectType.getName());
        vector.add(string);
        if (mIBObjectType.userObject != null && mIBObjectType.userObject instanceof Token) {
            Token token = (Token)mIBObjectType.userObject;
            while (token.next != null && token.kind != 54) {
                token = token.next;
            }
            for (int i = 0; i < 2 && token.next != null; ++i) {
                token = token.next;
            }
            this.error(new SMIParseException(new SemanticError(1820, token.beginLine, token.beginColumn, token.endPos, token, mIBObjectType.getName(), token.image, new String[0]), 1820, vector));
        } else {
            this.error(new SMIParseException(mIBObjectType.getName(), 1820, vector));
        }
    }

    protected void checkDefaultValue(MIBObjectType mIBObjectType, MIBSyntax mIBSyntax, String string, Token token, int n) throws SMIParseException {
        MIBTextualConvention mIBTextualConvention;
        if (!mIBObjectType.hasDefaultValue()) {
            return;
        }
        Object object = MIBObjectType.getDefaultValue(this.smiRep.scope.rep, mIBSyntax, string);
        if (object == null) {
            this.throwLocalizedError(token, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3002, n, 2);
        }
        if ((mIBTextualConvention = this.smiRep.scope.rep.getEffectiveSyntax(mIBSyntax)).getSyntax() != null) {
            long l;
            if (SMI.isCounter(mIBTextualConvention.getSyntax().getSyntax())) {
                this.throwLocalizedError(token, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3003, n, 2);
            }
            if (object instanceof Number) {
                long l2 = (Long)object;
                if (!mIBTextualConvention.getSyntax().isIncludedInRanges(l2) || SMI.isUnsignedNumeric(mIBTextualConvention.getSyntax().getSyntax()) && (l2 < 0L || l2 > 0xFFFFFFFFL) || SMI.SMI_SYNTAX[8].equals(mIBTextualConvention.getSyntax().getSyntax()) && (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE)) {
                    this.throwLocalizedError(token, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3000, n, 2);
                }
            } else if (object instanceof byte[]) {
                long l3 = ((byte[])object).length;
                if (mIBTextualConvention.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[9]) && l3 != 4L || !mIBTextualConvention.getSyntax().isIncludedInRanges(l3)) {
                    this.throwLocalizedError(token, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3000, n, 2);
                }
            } else if (object instanceof ObjectID && (l = (long)((ObjectID)object).size()) > 128L) {
                this.throwLocalizedError(token, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3000, n, 2);
            }
        }
    }

    public void checkDefaultValue(MIBObjectType mIBObjectType) throws SMIParseException {
        if (mIBObjectType.hasDefaultValue() && mIBObjectType.getSyntax() != null) {
            Object object = mIBObjectType.getDefaultValue(this.smiRep.scope.rep);
            if (object == null) {
                this.throwLocalizedError(mIBObjectType, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3002, this.getTokenDEFVAL(), 2);
            }
            if (mIBObjectType.getSyntax() != null) {
                long l;
                MIBTextualConvention mIBTextualConvention = this.smiRep.scope.rep.getEffectiveSyntax(mIBObjectType.getSyntax());
                if (SMI.isCounter(mIBTextualConvention.getSyntax().getSyntax())) {
                    this.throwLocalizedError(mIBObjectType, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3003, this.getTokenDEFVAL(), 2);
                }
                if (object instanceof Number) {
                    long l2 = (Long)object;
                    if (!mIBTextualConvention.getSyntax().isIncludedInRanges(l2) || SMI.isUnsignedNumeric(mIBTextualConvention.getSyntax().getSyntax()) && (l2 < 0L || l2 > 0xFFFFFFFFL) || SMI.SMI_SYNTAX[8].equals(mIBTextualConvention.getSyntax().getSyntax()) && (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE)) {
                        this.throwLocalizedError(mIBObjectType, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3000, this.getTokenDEFVAL(), 2);
                    }
                } else if (object instanceof byte[]) {
                    long l3 = ((byte[])object).length;
                    if (mIBTextualConvention.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[9]) && l3 != 4L || !mIBTextualConvention.getSyntax().isIncludedInRanges(l3)) {
                        this.throwLocalizedError(mIBObjectType, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3000, this.getTokenDEFVAL(), 2);
                    }
                } else if (object instanceof ObjectID && (l = (long)((ObjectID)object).size()) > 128L) {
                    this.throwLocalizedError(mIBObjectType, new Vector<Object>(Arrays.asList(mIBObjectType.getName())), 3000, this.getTokenDEFVAL(), 2);
                }
            }
        }
    }

    protected void checkVariation(String string, MIBVariation mIBVariation, Token token) throws SMIParseException {
        Object object;
        Object object2;
        MIBObject mIBObject = null;
        MIBObjectType mIBObjectType = null;
        mIBObject = string != null && string.length() > 0 && !string.equals(this.currentModule.getModuleName()) ? this.smiRep.scope.rep.getObject(string, mIBVariation.getVariation()) : this.rep.getObject(mIBVariation.getVariation());
        if (mIBObject == null && (object2 = this.currentModule.getImportSource(mIBVariation.getVariation())) != null && (object = this.smiRep.scope.rep.getModule((String)object2)) != null) {
            mIBObject = ((MIBModule)object).getObjectByName(mIBVariation.getVariation());
        }
        if (mIBVariation instanceof MIBCondGroup) {
            if (!(mIBObject instanceof MIBGroup)) {
                this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBObject == null ? "undefined" : mIBObject.getTypeString(), mIBVariation.getVariation())), 1601, -1, 0);
            }
            return;
        }
        if (mIBObject instanceof MIBNotifyType) {
            if (mIBVariation.hasAccess() && !mIBVariation.getAccess().equals(SMI.ACCESS[6])) {
                this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 1050, this.getTokenACCESS(), 0);
            }
            if (mIBVariation instanceof MIBException && ((MIBException)mIBVariation).hasAccess() && !mIBVariation.getAccess().equals(SMI.ACCESS[6])) {
                this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 1050, this.getTokenACCESS(), 0);
            }
            if (mIBVariation.hasSyntax()) {
                this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 1050, this.getTokenSYNTAX(), 0);
            }
            if (mIBVariation.hasWriteSyntax()) {
                this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 1050, this.getTokenWRITESYNTAX(), 0);
            }
            if (mIBVariation.hasDefaultValue()) {
                this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 1050, this.getTokenDEFVAL(), 0);
            }
        } else if (mIBObject == null) {
            this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 1502, -1, 0);
        } else if (!(mIBObject instanceof MIBObjectType)) {
            this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation(), mIBObject == null ? "unknown" : mIBObject.getTypeString())), 1602, -1, 0);
        } else {
            mIBObjectType = (MIBObjectType)mIBObject;
            if (mIBObjectType.getSyntax() != null) {
                object2 = this.smiRep.scope.rep.getEffectiveSyntax(mIBObjectType.getSyntax()).getSyntax();
                if (mIBVariation.hasSyntax()) {
                    object2 = this.smiRep.scope.rep.getEffectiveSyntax(mIBVariation.getSyntax()).getSyntax();
                    if (!mIBObjectType.getSyntax().isRestrictiveSyntax(this.smiRep.scope.rep, mIBVariation.getSyntax())) {
                        this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 4000, this.getTokenSYNTAX(), 1);
                    }
                }
                if (mIBVariation.hasSyntax()) {
                    if (SMI.isCounter(mIBVariation.getSyntax().getSyntax())) {
                        this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 3003, this.getTokenSYNTAX(), 1);
                    } else if (mIBVariation.hasDefaultValue()) {
                        this.checkDefaultValue(mIBObjectType, (MIBSyntax)object2, mIBVariation.getDefval(), token, this.getTokenDEFVAL());
                    }
                }
                if (mIBVariation.hasWriteSyntax()) {
                    if (SMI.isCounter(mIBVariation.getWriteSyntax().getSyntax())) {
                        this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 3003, this.getTokenWRITESYNTAX(), 1);
                    }
                    if (!mIBObjectType.getSyntax().isRestrictiveSyntax(this.smiRep.scope.rep, mIBVariation.getWriteSyntax())) {
                        this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 4000, this.getTokenWRITESYNTAX(), 1);
                    }
                }
                if (mIBVariation.hasCreationRequires()) {
                    if (!mIBObjectType.isTable()) {
                        this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 1220, this.getTokenCREATION_REQUIRES(), 0);
                    } else {
                        for (String string2 : mIBVariation.getCreationRequiresVector()) {
                            MIBObjectType mIBObjectType2;
                            MIBObject mIBObject2 = string != null && string.length() > 0 && !string.equals(this.currentModule.getModuleName()) ? this.smiRep.scope.rep.getObject(string, string2) : this.rep.getObject(string2);
                            if (!(mIBObject2 instanceof MIBObjectType) || (mIBObjectType2 = (MIBObjectType)mIBObject2).isColumnarObject() && mIBObjectType2.getAccess().equals(SMI.ACCESS[3])) continue;
                            this.throwLocalizedError(token, new Vector<String>(Arrays.asList(mIBVariation.getVariation())), 1221, this.getTokenCREATION_REQUIRES(), string2);
                        }
                    }
                }
            }
        }
    }

    protected final int getTokenCREATION_REQUIRES() {
        return 100;
    }

    protected final int getTokenACCESS() {
        return 59;
    }

    protected void checkWhetherIndexIsPositive(MIBObjectType mIBObjectType) throws SMIParseException {
        if (mIBObjectType.getIndexPart().isAugment() || mIBObjectType.getOid() == null || !mIBObjectType.getOid().isValid()) {
            return;
        }
        if (!mIBObjectType.isTable()) {
            this.throwLocalizedError(mIBObjectType, new Vector(), 1851, 54, 0);
        }
        int n = 0;
        Enumeration enumeration = mIBObjectType.getIndexPart().getIndexPartVector().elements();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            MIBObject mIBObject = this.smiRep.scope.rep.getObject(string);
            if (mIBObject == null) {
                mIBObject = this.smiRep.getKnownObject(string);
            }
            if (!(mIBObject instanceof MIBObjectType)) {
                this.throwInvalidIndex(mIBObjectType);
            } else {
                MIBSyntax mIBSyntax;
                Serializable serializable;
                if (!((MIBObjectType)mIBObject).isColumnarObject()) {
                    serializable = new Vector<String>(2);
                    ((Vector)serializable).add(mIBObjectType.getName());
                    ((Vector)serializable).add(string);
                    this.throwLocalizedError(mIBObjectType, (Vector)serializable, 1850, 54, 2 + n * 2);
                }
                if (((MIBObjectType)mIBObject).getSyntax() != null && !SMI.isUnsignedNumeric((mIBSyntax = ((MIBTextualConvention)(serializable = this.rep.getEffectiveSyntax(((MIBObjectType)mIBObject).getSyntax()))).getSyntax()).getSyntax()) && SMI.isNumeric(mIBSyntax.getSyntax()) && Math.max(mIBSyntax.getMinOfRanges(), mIBSyntax.getMinOfEnums()) < 0L) {
                    this.throwNegativeIndex(mIBObjectType, mIBObject.getName());
                }
            }
            ++n;
        }
        this.checkIndexLength(mIBObjectType);
    }

    protected String readImports(SMIImportList sMIImportList) throws SMIParseException {
        String string;
        String string2 = sMIImportList.getSource();
        Vector vector = sMIImportList.getImports();
        if (!(this.smiRep.isModuleAlreadyImported(string2) || this.smiRep.importModule(string2, this.rep, false) || this.failedImports.contains(string2))) {
            this.failedImports.add(string2);
            this.throwLocalizedError(sMIImportList.getToken(), new Vector<String>(Arrays.asList(string2)), 1100, string2);
        }
        if ((string = this.smiRep.hasCircularImport(string2, this.currentModule.getModuleName())) != null) {
            this.throwLocalizedError(sMIImportList.getToken(), new Vector<String>(Arrays.asList(string)), 1101, string2);
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            Vector<String> vector2;
            String string3 = (String)object.nextElement();
            if (SMI.isASN1KeyWord(string3)) {
                this.throwLocalizedError(sMIImportList.startToken, new Vector<String>(Arrays.asList(string3)), 1114, string3);
                continue;
            }
            MIBObject mIBObject = this.smiRep.getObject(string2, string3);
            if (mIBObject instanceof MIBNotifyType) {
                vector2 = new Vector<String>(1);
                vector2.add(mIBObject.getName());
                this.error(new SMIParseException(mIBObject.getName() + " cannot be imported", 1114, vector2));
                continue;
            }
            if (mIBObject != null) {
                vector2 = this.currentModule.getImportSources(string3);
                if (vector2.size() > 0) {
                    Serializable serializable;
                    if (!vector2.contains(string2)) {
                        serializable = this.smiRep.getKnownObject(string3);
                        String string4 = this.smiRep.getModuleName(((MIBObject)serializable).getModuleID());
                        if (string4 != null) {
                            serializable = ((MIBObject)serializable).getClone();
                            ((MIBObject)serializable).setName(string4 + "." + ((MIBObject)serializable).getName());
                            this.smiRep.replaceKnownObject(string3, (MIBObject)serializable);
                        }
                    } else {
                        serializable = new Vector(2);
                        ((Vector)serializable).add(string3);
                        ((Vector)serializable).add(string2);
                        this.error(new SMIParseException("Object " + string3 + " is imported twice from MIB module " + string2, 1113, (Vector)serializable));
                    }
                    mIBObject = mIBObject.getClone();
                    mIBObject.setName(string2 + "." + mIBObject.getName());
                    this.smiRep.addKnownObject(mIBObject);
                    continue;
                }
                this.smiRep.addKnownObject(mIBObject);
                continue;
            }
            if (SMI.isKeyWord(string3) || string2 == null || this.failedImports.contains(string2)) continue;
            vector2 = new Vector<String>(2);
            vector2.add(string3);
            vector2.add(string2);
            this.throwLocalizedError(sMIImportList.getToken().next, vector2, 1112, null);
        }
        object = new MIBImport(string2, vector, sMIImportList.comment);
        this.currentModule.addImport((MIBImport)object);
        ((SMIRepository)sMIImportList.jjtGetRoot()).createOids(this.currentModule.getModuleName());
        this.currentModuleInfo.addImport(string2);
        return string2;
    }

    protected void checkAgentCaps(MIBAgentCaps mIBAgentCaps) throws SMIParseException {
        Enumeration enumeration = mIBAgentCaps.getModules().elements();
        while (enumeration.hasMoreElements()) {
            MIBSupportedModule mIBSupportedModule = (MIBSupportedModule)enumeration.nextElement();
            Enumeration enumeration2 = mIBSupportedModule.getVariationsVector().elements();
            while (enumeration2.hasMoreElements()) {
                MIBVariation mIBVariation = (MIBVariation)enumeration2.nextElement();
                this.smiRep.checkUnresolvedObject(new StringToken(mIBVariation.getVariation(), null), null);
                this.checkVariation(mIBSupportedModule.getSupports(), mIBVariation, (Token)mIBVariation.getUserObject());
            }
        }
    }

    protected void readAgentCaps(SMIAgentCapabilities sMIAgentCapabilities) throws SMIParseException {
        MIBAgentCaps mIBAgentCaps = (MIBAgentCaps)this.currentObject;
        if (mIBAgentCaps == null) {
            return;
        }
        mIBAgentCaps.setProductRelease(sMIAgentCapabilities.productRelease);
        Vector vector = sMIAgentCapabilities.acModules;
        mIBAgentCaps.setModules(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            MIBSupportedModule mIBSupportedModule = (MIBSupportedModule)enumeration.nextElement();
            if (!this.smiRep.isModuleAlreadyImported(mIBSupportedModule.getSupports()) && !this.smiRep.importModule(mIBSupportedModule.getSupports(), this.rep, true)) {
                this.throwLocalizedError((Token)mIBSupportedModule.getUserObject(), new Vector<String>(Arrays.asList(mIBSupportedModule.getSupports())), 1100, this.getTokenSUPPORTS(), mIBSupportedModule.getSupports());
            }
            for (int i = 0; i < mIBSupportedModule.getIncludes().size(); ++i) {
                object = (StringToken)mIBSupportedModule.getIncludes().get(i);
                mIBSupportedModule.getIncludes().set(i, ((StringToken)object).string);
                Class<MIBGroup> clazz = MIBGroup.class;
                this.smiRep.checkUnresolvedObject((StringToken)object, clazz);
            }
            Enumeration enumeration2 = mIBSupportedModule.getVariationsVector().elements();
            while (enumeration2.hasMoreElements()) {
                object = (MIBVariation)enumeration2.nextElement();
                this.smiRep.checkUnresolvedObject(new StringToken(((MIBVariation)object).getVariation(), null), null);
                for (int i = 0; i < ((MIBVariation)object).getCreationRequiresVector().size(); ++i) {
                    StringToken stringToken = (StringToken)((MIBVariation)object).getCreationRequiresVector().get(i);
                    ((MIBVariation)object).getCreationRequiresVector().set(i, stringToken.string);
                    Class<MIBObjectType> clazz = MIBObjectType.class;
                    this.smiRep.checkUnresolvedObject(stringToken, clazz);
                }
            }
        }
    }

    protected void readCompliance(SMICompliance sMICompliance) throws SMIParseException {
        if (!(this.currentObject instanceof MIBCompliance)) {
            return;
        }
        MIBCompliance mIBCompliance = (MIBCompliance)this.currentObject;
        mIBCompliance.setModules(sMICompliance.modules);
    }

    public Object visit(SimpleNode simpleNode, Object object) throws SMIParseException {
        if (this.currentModuleInfo != null || simpleNode.getId() == -4) {
            switch (simpleNode.getId()) {
                case -5: {
                    this.currentFile = ((SMIFile)simpleNode).getName();
                    break;
                }
                case -4: {
                    this.smiRep.setScope(((SMIMib)simpleNode).getName(), this);
                    this.currentModuleInfo = this.readModule((SMIMib)simpleNode);
                    ((Vector)object).addElement(this.currentModuleInfo);
                    break;
                }
                case -3: {
                    this.readModuleIdentity((SMIModule)simpleNode);
                    break;
                }
                case -1: {
                    this.currentSyntax = null;
                    if (((SMIObject)simpleNode).getType() == 11) break;
                    this.readObject((SMIObject)simpleNode);
                    break;
                }
                case -16: {
                    this.readObjectType((SMIObjectType)simpleNode);
                    break;
                }
                case -15: {
                    this.readNotifyType((SMINotifyType)simpleNode);
                    break;
                }
                case -12: {
                    break;
                }
                case -20: {
                    this.readSeqEntries((SMISeqEntries)simpleNode);
                    break;
                }
                case -7: {
                    if (this.currentObject == null) break;
                    this.currentObject.setDescription(((SMIDescription)simpleNode).getValue());
                    break;
                }
                case -24: {
                    if (this.currentObject == null) break;
                    this.currentObject.setReference(simpleNode.toString());
                    break;
                }
                case -19: {
                    this.readRevision((SMIRevision)simpleNode);
                    break;
                }
                case -8: {
                    if (!(this.currentObject instanceof MIBObjectType)) break;
                    MIBObjectType mIBObjectType = (MIBObjectType)this.currentObject;
                    mIBObjectType.setDefaultValue(((SMIDefaultValue)simpleNode).getDefaultValue());
                    if (!mIBObjectType.hasDefaultValue() || mIBObjectType.getSyntax() == null || mIBObjectType.getDefaultValue().indexOf("{") >= 0 || !mIBObjectType.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[2])) break;
                    this.smiRep.checkUnresolvedObject(new StringToken(mIBObjectType.getDefaultValue(), null), MIBObject.class);
                    break;
                }
                case -21: {
                    this.readSyntax((SMISyntax)simpleNode);
                    break;
                }
                case -23: {
                    this.readVariable(new StringToken(simpleNode.toString(), simpleNode.getToken()));
                    break;
                }
                case -14: {
                    this.readIndex((SMIIndex)simpleNode);
                    break;
                }
                case -22: {
                    MIBTextualConvention mIBTextualConvention = (MIBTextualConvention)this.currentObject;
                    SMITextualConvention sMITextualConvention = (SMITextualConvention)simpleNode;
                    mIBTextualConvention.setDisplayHint(sMITextualConvention.getDisplayHint());
                    mIBTextualConvention.setSyntax(sMITextualConvention.syntax);
                    this.currentSyntax = sMITextualConvention.syntax;
                    this.checkSyntax(new StringToken(mIBTextualConvention.getName(), (Token)mIBTextualConvention.userObject), (StringToken)this.currentSyntax.userObject);
                    switch (this.currentSyntax.getType()) {
                        case 2: 
                        case 3: {
                            this.smiRep.checkUnresolvedSyntax(this.getStringToken(this.currentSyntax));
                        }
                    }
                    this.smiRep.replaceKnownObject(mIBTextualConvention.getName(), mIBTextualConvention);
                    break;
                }
                case -9: {
                    this.readAgentCaps((SMIAgentCapabilities)simpleNode);
                    break;
                }
                case -11: {
                    this.readCompliance((SMICompliance)simpleNode);
                    break;
                }
                case -13: {
                    this.currentModuleInfo.addImport(this.readImports((SMIImportList)simpleNode));
                    break;
                }
            }
        }
        simpleNode.childrenAccept(this, object);
        if (simpleNode.getId() == -4) {
            this.checkModule();
        }
        return object;
    }

    public void checkModule() throws SMIParseException {
        int n;
        Object object;
        Object object2;
        Iterator iterator;
        if (this.smiRep.existsUnresolvedNames()) {
            this.checkUnresolvedNames();
        }
        this.smiRep.resolveSyntaxes();
        if (this.smiRep.existsUnresolvedSyntaxes()) {
            iterator = this.smiRep.getUnresolvedSyntaxes();
            while (iterator.hasNext()) {
                object2 = (Object[])iterator.next();
                object = (StringToken)object2.getKey();
                if (((StringToken)object).token == null) {
                    this.error(new SMIParseException(((StringToken)object).string, 1500, new Vector<Object>(Arrays.asList(((StringToken)object).string))));
                    continue;
                }
                this.throwLocalizedError(((StringToken)object).token, 1500);
            }
        }
        if (this.smiRep.existsWrongTypes()) {
            iterator = this.smiRep.getWrongTypes();
            while (iterator.hasNext()) {
                object2 = (Object[])iterator.next();
                this.throwLocalizedError(((StringToken)object2[0]).token, new Vector<Object>(Arrays.asList(object2)), 1700, null);
            }
        }
        if ((n = this.currentModule.getSMIVersion()) >= 2) {
            this.rep.structureChanged();
            this.checkAccess();
        }
        object2 = this.buildImportHash(this.currentModule);
        object = this.rep.objectsByName();
        while (object.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)object.nextElement();
            if (this.currentModule != null && !mIBObject.getModuleID().equals(this.currentModule.getModuleID())) continue;
            this.checkImports(this.currentModule, mIBObject, (Hashtable)object2);
            if (n < 2) continue;
            this.checkGroups(mIBObject);
            if (mIBObject instanceof MIBObjectType) {
                MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
                if (mIBObjectType.hasIndexPart()) {
                    this.checkWhetherIndexIsPositive(mIBObjectType);
                }
                if (!mIBObjectType.isTable() && mIBObjectType.getSyntax() != null && mIBObjectType.getSyntax().getType() == 3) {
                    this.checkRestrictedSyntax((Token)mIBObjectType.userObject, mIBObjectType.getName(), mIBObjectType.getSyntax(), this.getTokenSYNTAX());
                }
                this.checkDefaultValue(mIBObjectType);
                continue;
            }
            if (mIBObject instanceof MIBAgentCaps) {
                this.checkAgentCaps((MIBAgentCaps)mIBObject);
                continue;
            }
            if (mIBObject instanceof MIBCompliance) {
                this.checkCompliance((MIBCompliance)mIBObject);
                continue;
            }
            if (!(mIBObject instanceof MIBTextualConvention)) continue;
            this.checkDisplayHint((MIBTextualConvention)mIBObject);
        }
        ++this.moduleCount;
    }

    protected void checkCompliance(MIBCompliance mIBCompliance) throws SMIParseException {
        if (mIBCompliance.getModules() != null) {
            Iterator iterator = mIBCompliance.getModules().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                MIBModule mIBModule = this.rep.getModule(mIBCompliance.getModuleID());
                MIBComplianceModule mIBComplianceModule = (MIBComplianceModule)iterator.next();
                if (mIBComplianceModule.getModuleName() != null && !mIBComplianceModule.getModuleName().equals(mIBModule.getModuleName())) {
                    mIBModule = this.smiRep.scope.rep.getModule(mIBComplianceModule.getModuleName());
                }
                MIBModule mIBModule2 = mIBModule;
                if (mIBModule == null) {
                    this.throwLocalizedError((Token)mIBComplianceModule.getUserObject(), new Vector<String>(Arrays.asList(mIBComplianceModule.getModuleName())), 1100, -1, 0);
                    continue;
                }
                if (mIBComplianceModule.hasMandatory()) {
                    for (Object object3 : mIBComplianceModule.getMandatoryVector()) {
                        object2 = mIBModule.getObjectByName((String)object3);
                        if (object2 == null) {
                            object = this.currentModule.getImportSource((String)object3);
                            if (object != null) {
                                mIBModule2 = this.smiRep.scope.rep.getModule((String)object);
                                if (mIBModule2 != null) {
                                    object2 = mIBModule2.getObjectByName((String)object3);
                                }
                            } else {
                                this.throwLocalizedError((Token)mIBCompliance.userObject, new Vector<String>(Arrays.asList(object3)), 1502, this.getTokenMANDATORYGROUPS(), (String)object3);
                            }
                        }
                        if (object2 instanceof MIBGroup) continue;
                        this.throwLocalizedError((Token)mIBCompliance.userObject, new Vector<String>(Arrays.asList(object3, object2 == null ? "unknown" : ((MIBObject)object2).getTypeString())), 1601, this.getTokenMANDATORYGROUPS(), (String)object3);
                    }
                }
                mIBModule2 = mIBModule;
                if (!mIBComplianceModule.hasVariations()) continue;
                for (Object object3 : mIBComplianceModule.getVariationsVector()) {
                    if (object3 instanceof MIBCondGroup) {
                        object2 = mIBModule.getObjectByName(((MIBVariation)object3).getVariation());
                        if (object2 == null) {
                            object = this.currentModule.getImportSource(((MIBVariation)object3).getVariation());
                            if (object != null) {
                                mIBModule2 = this.smiRep.scope.rep.getModule((String)object);
                                if (mIBModule2 != null) {
                                    object2 = mIBModule2.getObjectByName(((MIBVariation)object3).getVariation());
                                }
                            } else {
                                this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation())), 1502, -1, 0);
                            }
                        }
                        if (!(object2 instanceof MIBGroup)) {
                            this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation(), object2 == null ? "unknown" : ((MIBObject)object2).getTypeString())), 1601, -1, 0);
                        }
                        if (!mIBComplianceModule.hasMandatory() || !mIBComplianceModule.getMandatoryVector().contains(((MIBVariation)object3).getVariation())) continue;
                        this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation(), object2 == null ? "unknown" : ((MIBObject)object2).getTypeString())), 1210, -1, 0);
                        continue;
                    }
                    object2 = mIBModule.getObjectByName(((MIBVariation)object3).getVariation());
                    if (object2 == null) {
                        object = this.currentModule.getImportSource(((MIBVariation)object3).getVariation());
                        if (object != null) {
                            mIBModule2 = this.smiRep.scope.rep.getModule((String)object);
                            if (mIBModule2 != null) {
                                object2 = mIBModule2.getObjectByName(((MIBVariation)object3).getVariation());
                            }
                        } else {
                            this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation())), 1502, -1, 0);
                        }
                    }
                    object2 = mIBComplianceModule.getModuleName();
                    object = this.rep;
                    if (mIBModule2 != this.currentModule) {
                        object = this.smiRep.scope.rep;
                    }
                    if (!((MIBRepository)object).isReferencedBy(((MIBVariation)object3).getVariation(), mIBModule2, mIBComplianceModule)) {
                        this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation())), 1211, -1, 0);
                    } else {
                        this.checkVariation((String)object2, (MIBVariation)object3, (Token)((MIBVariation)object3).getUserObject());
                    }
                    mIBModule2 = mIBModule;
                }
            }
        }
    }

    protected final int getTokenOBJECT() {
        return 88;
    }

    protected final int getTokenMANDATORYGROUPS() {
        return 85;
    }

    protected final int getTokenGROUP() {
        return 87;
    }

    protected void checkAccess() throws SMIParseException {
        if ((this.options & 8) > 0) {
            return;
        }
        Enumeration enumeration = this.rep.objects();
        while (enumeration.hasMoreElements()) {
            MIBObjectType mIBObjectType;
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (!(mIBObject instanceof MIBObjectType) || !(mIBObjectType = (MIBObjectType)mIBObject).isTable()) continue;
            Vector vector = this.rep.getColumnarObjectsOfTable(mIBObjectType, false, true);
            boolean bl = false;
            String string = null;
            for (int i = 0; i < vector.size(); ++i) {
                MIBObjectType mIBObjectType2 = (MIBObjectType)vector.elementAt(i);
                if (mIBObjectType2.getAccess().equals(SMI.ACCESS[3])) {
                    bl = true;
                } else if (mIBObjectType2.getAccess().equals(SMI.ACCESS[2])) {
                    string = mIBObjectType2.getName();
                }
                if (!bl || string == null) continue;
                if (mIBObjectType2.userObject != null && mIBObjectType2.userObject instanceof Token) {
                    this.throwLocalizedError(mIBObjectType, new Vector(), 1202, this.currentSMIVersion == 1 ? 59 : 58, 1);
                    continue;
                }
                this.error(new SMIParseException(string, 1202));
            }
        }
    }

    protected void checkSequence(MIBObjectType mIBObjectType) throws SMIParseException {
        if (mIBObjectType.isTable() && mIBObjectType.getOid() != null && mIBObjectType.getOid().isValid()) {
            int n;
            Vector vector = mIBObjectType.getTableEntriesVector();
            Vector vector2 = this.rep.getColumnarObjectsOfTable(mIBObjectType, true, true);
            if (vector2 == null) {
                vector2 = this.smiRep.scope.rep.getColumnarObjectsOfTable(this.currentModule, mIBObjectType, true, false);
                if (vector2 == null) {
                    Token token = (Token)mIBObjectType.userObject;
                    Vector<String> vector3 = new Vector<String>(vector.subList(0, 1));
                    vector3.insertElementAt(mIBObjectType.getName(), 0);
                    this.error(new SMIParseException(new SemanticError(1800, token.beginLine, token.beginColumn, token.endPos, token, mIBObjectType.getName(), token.image, new String[0]), 1800, vector3));
                }
                vector2.addAll(this.rep.getColumnarObjectsOfTable(mIBObjectType, false, true));
            }
            Collections.sort(vector2);
            for (n = 0; n < vector2.size(); ++n) {
                vector2.set(n, ((MIBObject)vector2.get(n)).getName());
            }
            n = -1;
            for (int i = 0; i < vector.size(); ++i) {
                int n2 = vector2.indexOf(vector.get(i));
                if (n2 <= n) {
                    Token token;
                    Vector<String> vector4 = new Vector<String>(2);
                    vector4.add(mIBObjectType.getName());
                    vector4.add((String)vector.get(i));
                    Vector vector5 = (Vector)this.nameSequences.get(vector);
                    if (vector5 != null) {
                        token = ((StringToken)((Pair)vector5.get((int)i)).first).token;
                        this.throwLocalizedError(token, vector4, 1800, null);
                        continue;
                    }
                    token = (Token)mIBObjectType.userObject;
                    this.error(new SMIParseException(new SemanticError(1800, token.beginLine, token.beginColumn, token.endPos, token, mIBObjectType.getName(), token.image, new String[0]), 1800, vector4));
                    continue;
                }
                n = n2;
            }
        }
    }

    protected void checkNoDescendant(MIBObject mIBObject) throws SMIParseException {
        ObjectID objectID = mIBObject.getOid();
        if (objectID == null) {
            return;
        }
        if (mIBObject.getType() == 0 || mIBObject.getType() == 10 || mIBObject.getType() == 5) {
            return;
        }
        if (mIBObject instanceof MIBObjectType) {
            String[] stringArray;
            String[] stringArray2;
            Vector vector = this.rep.getDescendants(mIBObject);
            MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
            MIBObjectType mIBObjectType2 = this.rep.getTableEntry(mIBObjectType);
            if (mIBObjectType2 != null) {
                Serializable serializable;
                if (this.currentSMIVersion != 1 && mIBObjectType2 != mIBObjectType) {
                    try {
                        MIBObjectType mIBObjectType3;
                        if (!(mIBObjectType.getOid().equals(mIBObjectType2.getOid().trim()) && mIBObjectType2.getOid().getLastSubID() == 1L || SMI.STATUS[3].equals((mIBObjectType3 = mIBObjectType2).getStatus()))) {
                            serializable = (Token)mIBObjectType3.userObject;
                            stringArray2 = new String[]{mIBObject.getName(), mIBObjectType3.getPrintableOid()};
                            this.error(new SMIParseException(new SemanticError(2010, ((Token)serializable).beginLine, ((Token)serializable).beginColumn, ((Token)serializable).endPos, (Token)serializable, mIBObjectType3.getName(), ((Token)serializable).image, stringArray2), 2010));
                        }
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {
                        // empty catch block
                    }
                }
                this.checkSequence(mIBObjectType2);
                if (mIBObjectType2 != mIBObjectType) {
                    for (int i = 0; i < vector.size(); ++i) {
                        serializable = (MIBObject)vector.get(i);
                        if (mIBObjectType2.equals(serializable) || ((MIBObject)serializable).getOid().size() == mIBObjectType2.getOid().size() + 1 && ((MIBObject)serializable).getOid().trim().equals(mIBObjectType2.getOid()) || SMI.STATUS[3].equals(((MIBObject)serializable).getStatus())) continue;
                        stringArray2 = (Token)((MIBObject)serializable).userObject;
                        stringArray = new String[]{mIBObject.getName(), ((MIBObject)serializable).getPrintableOid()};
                        this.error(new SMIParseException(new SemanticError(2010, stringArray2.beginLine, stringArray2.beginColumn, stringArray2.endPos, (Token)stringArray2, ((MIBObject)serializable).getName(), stringArray2.image, stringArray), 2010));
                    }
                }
            }
            for (Serializable serializable : vector) {
                if (serializable instanceof MIBObjectType || SMI.ENTRY_TYPES[10].equals(((MIBObject)serializable).getTypeString()) || SMI.STATUS[3].equals(((MIBObject)serializable).getStatus())) continue;
                stringArray2 = (String[])((MIBObject)serializable).userObject;
                stringArray = new String[]{mIBObject.getName(), ((MIBObject)serializable).getPrintableOid()};
                this.error(new SMIParseException(new SemanticError(2010, stringArray2.beginLine, stringArray2.beginColumn, stringArray2.endPos, (Token)stringArray2, ((MIBObject)serializable).getName(), stringArray2.image, stringArray), 2010));
            }
            return;
        }
        MIBObject mIBObject2 = this.rep.getNextObject(objectID);
        if (mIBObject2 == null || mIBObject2.getOid() == null) {
            return;
        }
        if (objectID.isRootOf(mIBObject2.getOid()) && !SMI.STATUS[3].equals(mIBObject2.getStatus())) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(mIBObject2.getName());
            vector.addElement(mIBObject.getName());
            vector.addElement(mIBObject2.getPrintableOid());
            if (mIBObject2.userObject != null && mIBObject2.userObject instanceof Token) {
                Token token = (Token)mIBObject2.userObject;
                String[] stringArray = new String[]{mIBObject.getName(), mIBObject2.getPrintableOid()};
                this.error(new SMIParseException(new SemanticError(2010, token.beginLine, token.beginColumn, token.endPos, token, mIBObject2.getName(), token.image, stringArray), 2010));
            } else {
                this.error(new SMIParseException("Illegal object registration", 2010, vector));
            }
        }
    }

    protected void checkGroups(MIBObject mIBObject) throws SMIParseException {
        block14: {
            block11: {
                Vector vector;
                MIBObjectType mIBObjectType;
                block12: {
                    block13: {
                        this.checkNoDescendant(mIBObject);
                        if (!(mIBObject instanceof MIBObjectType)) break block11;
                        mIBObjectType = (MIBObjectType)mIBObject;
                        if (mIBObjectType.isTable() && mIBObjectType.getOid() != null && mIBObjectType.getOid().isValid() && (this.options & 2) == 0 && this.rep.getChildren(mIBObjectType).size() != mIBObjectType.getTableEntriesVector().size()) {
                            vector = (Token)mIBObjectType.userObject;
                            this.error(new SMIParseException(new SemanticError(1801, ((Token)((Object)vector)).beginLine, ((Token)((Object)vector)).beginColumn, ((Token)((Object)vector)).endPos, (Token)((Object)vector), mIBObjectType.getName(), ((Token)((Object)vector)).image, new String[0]), 1801));
                        }
                        if (SMI.accessType(mIBObjectType.getAccess()) == 0) break block12;
                        vector = this.isPartOfGroup(mIBObjectType.getName(), 6);
                        if (vector.size() != 0 || (this.options & 1) != 0) break block13;
                        if (mIBObjectType.userObject != null && mIBObjectType.userObject instanceof Token) {
                            Token token = (Token)mIBObjectType.userObject;
                            this.error(new SMIParseException(new SemanticError(5000, token.beginLine, token.beginColumn, token.endPos, token, mIBObjectType.getName(), token.image, new String[0]), 5000));
                        } else {
                            this.error(new SMIParseException(mIBObjectType.getName(), 5000));
                        }
                        break block14;
                    }
                    if ((this.options & 4) != 0) break block14;
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        this.checkStatus(mIBObjectType, (MIBGroup)enumeration.nextElement());
                    }
                    break block14;
                }
                vector = this.isPartOfGroup(mIBObjectType.getName(), 6);
                if (vector.size() <= 0) break block14;
                MIBGroup mIBGroup = (MIBGroup)vector.firstElement();
                Token token = (Token)mIBGroup.userObject;
                vector = new Vector(3);
                vector.add(mIBGroup.getName());
                vector.add(mIBObjectType.getName());
                this.error(new SMIParseException(new SemanticError(5100, token.beginLine, token.beginColumn, token.endPos, token, mIBGroup.getName(), token.image, new String[0]), 5100, vector));
                break block14;
            }
            if (mIBObject instanceof MIBNotifyType) {
                MIBNotifyType mIBNotifyType = (MIBNotifyType)mIBObject;
                Vector vector = this.isPartOfGroup(mIBNotifyType.getName(), 7);
                if (vector.size() == 0 && (this.options & 1) == 0) {
                    if (mIBNotifyType.userObject != null && mIBNotifyType.userObject instanceof Token) {
                        Token token = (Token)mIBNotifyType.userObject;
                        this.error(new SMIParseException(new SemanticError(5000, token.beginLine, token.beginColumn, token.endPos, token, mIBNotifyType.getName(), token.image, new String[0]), 5000));
                    } else {
                        this.error(new SMIParseException(mIBNotifyType.getName(), 5000));
                    }
                } else if ((this.options & 4) == 0) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        this.checkStatus(mIBNotifyType, (MIBGroup)enumeration.nextElement());
                    }
                }
            }
        }
    }

    protected void checkStatus(MIBObject mIBObject, MIBGroup mIBGroup) throws SMIParseException {
        if (SMI.statusType(mIBObject.getStatus()) < SMI.statusType(mIBGroup.getStatus())) {
            if (mIBObject.userObject != null && mIBObject.userObject instanceof Token) {
                this.throwLocalizedError(mIBObject, new Vector<String>(Arrays.asList(mIBObject.getName(), mIBGroup.getName())), 1201, 62, 1);
            } else {
                this.error(new SMIParseException(mIBObject.getName() + ":" + mIBGroup.getName(), 1201));
            }
        }
    }

    private Vector isPartOfGroup(String string, int n) {
        Vector<MIBGroup> vector = new Vector<MIBGroup>();
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            MIBGroup mIBGroup = (MIBGroup)enumeration.nextElement();
            if (mIBGroup.getType() != n || !mIBGroup.contains(string)) continue;
            vector.addElement(mIBGroup);
        }
        return vector;
    }

    protected void checkUnresolvedNames() throws SMIParseException {
        HashSet<StringToken> hashSet = new HashSet<StringToken>();
        Iterator iterator = this.smiRep.getUnresolvedNames();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            for (Pair pair : list) {
                StringToken[] stringTokenArray = (StringToken[])pair.first;
                StringToken stringToken = null;
                block2: for (int i = 0; stringToken == null && i < stringTokenArray.length; ++i) {
                    String string = stringTokenArray[i].string;
                    for (int j = 0; j < string.length(); ++j) {
                        if (Character.isDigit(string.charAt(j))) continue;
                        stringToken = stringTokenArray[i];
                        continue block2;
                    }
                }
                if (stringToken == null || stringToken.string.length() <= 0 || hashSet.contains(stringToken)) continue;
                hashSet.add(stringToken);
                Token token = stringToken.token;
                if (token != null) {
                    this.throwLocalizedError(token, 1502);
                    continue;
                }
                this.error(new SMIParseException(stringToken.string, 1501));
            }
        }
    }

    public void setOptions(int n) {
        this.options = n;
    }

    public void setErrors(List list) {
        this.errors = list;
    }

    public void setMaxErrors(int n) {
        this.maxErrors = n;
    }

    public int getOptions() {
        return this.options;
    }

    public List getErrors() {
        return this.errors;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    protected Hashtable buildImportHash(MIBModule mIBModule) {
        Vector vector = mIBModule.getImportsVector();
        if (vector == null) {
            return new Hashtable(1);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(vector.size() * 5 + 1);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = (MIBImport)enumeration.nextElement();
            Vector vector2 = mIBImport.getImportsVector();
            if (vector2 == null) continue;
            for (int i = 0; i < vector2.size(); ++i) {
                hashtable.put(vector2.elementAt(i).toString(), mIBImport.getSource());
            }
        }
        return hashtable;
    }

    public void checkImports(MIBModule mIBModule, MIBObject mIBObject, Hashtable hashtable) throws SMIParseException {
        MIBObject mIBObject2;
        String string;
        if (!mIBObject.getModuleID().equals(mIBModule.getModuleID())) {
            return;
        }
        int n = mIBModule.getSMIVersion();
        String string2 = mIBObject.getTypeString();
        if (SMI.ENTRY_TYPES[5].equals(string2) && (mIBObject.getObjectID() == null || mIBObject.getObjectID().size() == 0) || SMI.ENTRY_TYPES[4].equals(string2) && (!((MIBTextualConvention)mIBObject).hasStatus() || SMI.statusType(((MIBTextualConvention)mIBObject).getStatus()) == 0)) {
            return;
        }
        int n2 = SMI.getKeyWordType(n, string2);
        String string3 = (String)hashtable.get(string2);
        if (n2 >= 0 && !(string = SMI.smiMIBs[n - 1][n2]).equals(mIBModule.getModuleName())) {
            this.checkImport(string3, string2);
            this.checkImport(string3, string, string2);
        }
        String string4 = null;
        if (mIBObject instanceof MIBObjectType) {
            mIBObject2 = (MIBObjectType)mIBObject;
            if (((MIBObjectType)mIBObject2).getSyntax() == null) {
                return;
            }
            string4 = ((MIBObjectType)mIBObject2).getSyntax().getSyntax();
        } else if (mIBObject instanceof MIBTextualConvention) {
            mIBObject2 = (MIBTextualConvention)mIBObject;
            if (((MIBTextualConvention)mIBObject2).getSyntax() == null) {
                return;
            }
            string4 = ((MIBTextualConvention)mIBObject2).getSyntax().getSyntax();
        } else {
            return;
        }
        int n3 = SMI.getKeyWordType(n, string4);
        if (n3 >= 0) {
            string3 = (String)hashtable.get(string4);
            string = SMI.smiMIBs[n - 1][n3];
            if (!string.equals(mIBModule.getModuleName())) {
                this.checkImport(string3, string4);
                this.checkImport(string3, string, string4);
            }
        }
    }

    protected void checkImport(String string, String string2) throws SMIParseException {
        if (string == null) {
            Vector<String> vector = new Vector<String>(1);
            vector.add(string2);
            this.error(new SMIParseException("Missing import statement for " + string2, 1111, vector));
        }
    }

    protected void checkImport(String string, String string2, String string3) throws SMIParseException {
        if (!string2.equals(string) && string != null) {
            Vector<String> vector = new Vector<String>(3);
            vector.add(string3);
            vector.add(string);
            vector.add(string2);
            this.error(new SMIParseException("Wrong import statement for " + string3, 1110, vector));
        }
    }

    public void error(SMIParseException sMIParseException) throws SMIParseException {
        boolean bl = SMIParseException.addUniqueException(this.errors, sMIParseException);
        if (bl && this.errors.size() >= this.maxErrors) {
            SMIParseException sMIParseException2 = (SMIParseException)this.errors.get(0);
            sMIParseException2.setErrorList(this.errors);
            throw sMIParseException2;
        }
    }
}

