/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import java.util.Arrays;
import java.util.StringTokenizer;

public class SMI {
    public static final String LINE_SEPARATOR = "\n";
    public static final String ALL_LINE_SEPARATORS = "\r\n";
    public static final int SUPPORTED_OBJECT_TYPES = 6;
    public static final int STANDARD = 1;
    public static final int HTML = 2;
    public static final int HTML_LINKED = 4;
    public static final int TO_SMI_V2 = 8;
    public static final int TO_SMI_V1 = 16;
    public static final int WITH_COMMENTS = 32;
    public static final int OMIT_OBJECTS = 64;
    public static final int PRESERVED_ORDER = 128;
    public static final int GROUPING_BY_TYPE = 256;
    public static final int NAVIGATION_LINKS = 512;
    public static final int INLINE_COMMENTS = 1024;
    public static final int ACC_NOACCESS = 0;
    public static final int ACC_READONLY = 1;
    public static final int ACC_READWRITE = 2;
    public static final int ACC_READCREATE = 3;
    public static final int ACC_WRITEONLY = 4;
    public static final int ACC_ACCESSIBLE_FOR_NOTIFY = 5;
    public static final int ACC_NOT_IMPLEMENTED = 6;
    public static final String[] ACCESS = new String[]{"not-accessible", "read-only", "read-write", "read-create", "write-only", "accessible-for-notify", "not-implemented"};
    public static final int[] SMIv1_ACCESS = new int[]{0, 1, 2, 4};
    public static final int STA_UNDEFINED = 0;
    public static final int STA_MANDATORY = 1;
    public static final int STA_OPTIONAL = 2;
    public static final int STA_OBSOLETE = 3;
    public static final int STA_DEPRECATED = 4;
    public static final int STA_CURRENT = 5;
    public static final int SYN_SIMPLE = 0;
    public static final int SYN_APPLICATION = 1;
    public static final int SYN_SEQUENCE = 2;
    public static final int SYN_CONVENTION = 3;
    public static final int OBJECT_IDENTITY = 0;
    public static final int OBJECT_TYPE = 1;
    public static final int TRAP_TYPE = 2;
    public static final int NOTIFICATION_TYPE = 3;
    public static final int TEXTUAL_CONVENTION = 4;
    public static final int MODULE_IDENTITY = 5;
    public static final int OBJECT_GROUP = 6;
    public static final int NOTIFICATION_GROUP = 7;
    public static final int MODULE_COMPLIANCE = 8;
    public static final int AGENT_CAPABILITIES = 9;
    public static final int OBJECT_NAME = 10;
    public static final int SEQUENCE = 11;
    public static final String[] smiv2MIBs = new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-CONF"};
    public static final String[] smiv1MIBs = new String[]{"RFC1155-SMI", "RFC-1212", "RFC-1215"};
    public static final String[][] smiMIBs = new String[][]{smiv1MIBs, smiv2MIBs};
    public static final String[][] smiv2Constructs = new String[][]{{"MODULE-IDENTITY", "OBJECT-IDENTITY", "OBJECT-TYPE", "NOTIFICATION-TYPE", "Counter32", "Counter64", "Gauge32", "Integer32", "IpAddress", "Opaque", "TimeTicks", "Unsigned32"}, {"TEXTUAL-CONVENTION"}, {"OBJECT-GROUP", "NOTIFICATION-GROUP", "MODULE-COMPLIANCE", "AGENT-CAPABILITIES"}};
    public static final String[][] smiv1Constructs = new String[][]{{"OBJECT-IDENTITY", "Counter", "Gauge", "IpAddress", "Opaque", "TimeTicks", "NetworkAddress"}, {"OBJECT-TYPE"}, {"TRAP-TYPE"}};
    public static final String[][][] smiConstructs = new String[][][]{smiv1Constructs, smiv2Constructs};
    public static final String[] asn1Constructs = new String[]{"INTEGER", "OCTET STRING", "BITS"};
    public static final String[] STATUS = new String[]{"undefined", "mandatory", "optional", "obsolete", "deprecated", "current"};
    public static final String[][] rootOids = new String[][]{{"iso", "1"}, {"ccitt", "0"}, {"joint-iso-ccitt", "2"}, {"org", "1.3"}, {"dod", "1.3.6"}, {"internet", "1.3.6.1"}, {"mgmt", "1.3.6.1.2"}, {"mib-2", "1.3.6.1.2.1"}, {"mib", "1.3.6.1.2.1"}, {"experimental", "1.3.6.1.3"}, {"private", "1.3.6.1.4"}, {"enterprises", "1.3.6.1.4.1"}};
    public static final String[] ENTRY_TYPES = new String[]{"OBJECT-IDENTITY", "OBJECT-TYPE", "TRAP-TYPE", "NOTIFICATION-TYPE", "TEXTUAL-CONVENTION", "MODULE-IDENTITY", "OBJECT-GROUP", "NOTIFICATION-GROUP", "MODULE-COMPLIANCE", "AGENT-CAPABILITIES", "OBJECT IDENTIFIER"};
    public static final String[] SYNTAX_TYPES = new String[]{"simple", "application", "sequence", "textual convention"};
    public static final String[] BASIC_SYNTAX = new String[]{"Integer", "String", "Hex String", "Object ID", "Null", "IpAddress", "Counter", "Counter64", "Gauge", "TimeTicks", "Opaque"};
    public static final int SYN_NUMBER = 0;
    public static final int SYN_STRING = 1;
    public static final int SYN_HEXSTRING = 2;
    public static final int SYN_OBJECT = 3;
    public static final int SYN_EMPTY = 4;
    public static final int SYN_IPADDRESS = 5;
    public static final int SYN_COUNTER = 6;
    public static final int SYN_COUNTER64 = 7;
    public static final int SYN_GAUGE = 8;
    public static final int SYN_TIMETICKS = 9;
    public static final int SYN_OPAQUE = 10;
    public static final int SYN_NULL = 11;
    public static final int SYN_NETADDRESS = 12;
    public static final String[] SMI_SYNTAX = new String[]{"INTEGER", "OCTET STRING", "OBJECT IDENTIFIER", "Counter", "Gauge", "Counter32", "Counter64", "Gauge32", "Integer32", "IpAddress", "Opaque", "TimeTicks", "BITS", "Unsigned32", "NULL", "NetworkAddress"};
    public static final int SMI_INTEGER = 0;
    public static final int SMI_OCTETSTRING = 1;
    public static final int SMI_OID = 2;
    public static final int SMI_COUNTER = 3;
    public static final int SMI_GAUGE = 4;
    public static final int SMI_COUNTER32 = 5;
    public static final int SMI_COUNTER64 = 6;
    public static final int SMI_GAUGE32 = 7;
    public static final int SMI_INTEGER32 = 8;
    public static final int SMI_IPADDRESS = 9;
    public static final int SMI_OPAQUE = 10;
    public static final int SMI_TIMETICKS = 11;
    public static final int SMI_BITS = 12;
    public static final int SMI_UNSIGNED32 = 13;
    public static final int SMI_NULL = 14;
    public static final int SMI_NETWORKADDRESS = 15;
    public static final int[] SMIv1_SYNTAX = new int[]{0, 1, 2, 3, 4, 9, 10, 11, 14, 15};
    public static final int[] SMI_SYNTAX_MAPPING = new int[]{0, 1, 3, 6, 8, 6, 7, 8, 0, 5, 10, 9, 1, 8, 3, 5};
    private static final String[][] SMI_CONSTANTS = new String[][]{STATUS, ACCESS, SMI_SYNTAX};
    private static final String[] COMMON_SMI_IDENTIFIER = new String[SMI_CONSTANTS[0].length + SMI_CONSTANTS[1].length + SMI_CONSTANTS[2].length];

    public static int smiv2MIB(String string) {
        for (int i = 0; i < smiv2MIBs.length; ++i) {
            if (!smiv2MIBs[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int smiv1MIB(String string) {
        for (int i = 0; i < smiv1MIBs.length; ++i) {
            if (!smiv1MIBs[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isMacroDefMIB(String string) {
        return SMI.smiv2MIB(string) >= 0 || SMI.smiv1MIB(string) >= 0;
    }

    public static int entryType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < ENTRY_TYPES.length; ++i) {
            if (!string.equals(ENTRY_TYPES[i])) continue;
            return i;
        }
        return -1;
    }

    public static int accessType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < ACCESS.length; ++i) {
            if (!string.equals(ACCESS[i])) continue;
            return i;
        }
        return -1;
    }

    public static final String getCommonIdentifier(String string) {
        if (string == null) {
            return null;
        }
        int n = Arrays.binarySearch(COMMON_SMI_IDENTIFIER, string);
        if (n >= 0) {
            return COMMON_SMI_IDENTIFIER[n];
        }
        return string;
    }

    public static int getKeyWordType(int n, String string) {
        String[][] stringArray = n == 1 ? smiv1Constructs : smiv2Constructs;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (!stringArray[i][j].equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isASN1KeyWord(String string) {
        for (int i = 0; i < asn1Constructs.length; ++i) {
            if (!asn1Constructs[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeyWord(String string) {
        return SMI.isASN1KeyWord(string) || SMI.getKeyWordType(2, string) >= 0 || SMI.getKeyWordType(1, string) >= 0;
    }

    public static boolean isWritable(String string) {
        return SMI.accessType(string) >= 2;
    }

    public static boolean isAccessible(String string) {
        int n = SMI.accessType(string);
        return n > 0 && n < 4;
    }

    public static int statusType(String string) {
        if (string == null) {
            return 0;
        }
        for (int i = 0; i < STATUS.length; ++i) {
            if (!string.equals(STATUS[i])) continue;
            return i;
        }
        return 0;
    }

    public static int basicSyntax(String string) {
        for (int i = 0; i < SMI_SYNTAX.length; ++i) {
            if (!string.equalsIgnoreCase(SMI_SYNTAX[i])) continue;
            return SMI_SYNTAX_MAPPING[i];
        }
        return -1;
    }

    public static int smiSyntax(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < SMI_SYNTAX.length; ++i) {
            if (!string.equalsIgnoreCase(SMI_SYNTAX[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isNumeric(String string) {
        int n = SMI.basicSyntax(string);
        return n == 0 || n == 6 || n == 8 || n == 7 || n == 9;
    }

    public static boolean isOID(String string) {
        int n = SMI.basicSyntax(string);
        return n == 3;
    }

    public static boolean isCounter(String string) {
        int n = SMI.basicSyntax(string);
        return n == 6 || n == 7;
    }

    public static boolean isUnsignedNumeric(String string) {
        int n = SMI.basicSyntax(string);
        return n == 6 || n == 8 || n == 7 || n == 9;
    }

    public static boolean isSubTypable(String string) {
        int n = SMI.basicSyntax(string);
        return SMI.isString(string) || n == 0 || n == 8;
    }

    public static boolean isString(String string) {
        int n = SMI.basicSyntax(string);
        return n == 1 || n == 2 || n == 10;
    }

    public static long parseLongConstant(String string) throws NumberFormatException {
        if (string.endsWith("h") || string.endsWith("H")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'");
            if (!stringTokenizer.hasMoreTokens()) {
                throw new NumberFormatException("Hex string must be enclosed in '.");
            }
            return Long.parseLong(stringTokenizer.nextToken(), 16);
        }
        if (string.endsWith("o") || string.endsWith("O")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'");
            if (!stringTokenizer.hasMoreTokens()) {
                throw new NumberFormatException("Octal string must be enclosed in '.");
            }
            return Long.parseLong(stringTokenizer.nextToken(), 8);
        }
        if (string.endsWith("b") || string.endsWith("B")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'");
            if (!stringTokenizer.hasMoreTokens()) {
                throw new NumberFormatException("Binary string must be enclosed in '.");
            }
            return Long.parseLong(stringTokenizer.nextToken(), 2);
        }
        return Long.parseLong(string, 10);
    }

    public static byte[] stringConstantToByteArray(String string) throws NumberFormatException {
        int n = 10;
        int n2 = 3;
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() >= 2) {
            return string.substring(1, string.length() - 1).getBytes();
        }
        if (string.startsWith("'")) {
            if (string.endsWith("h") || string.endsWith("H")) {
                n = 16;
                n2 = 2;
            } else if (string.endsWith("o") || string.endsWith("O")) {
                n = 8;
                n2 = 4;
            } else if (string.endsWith("b") || string.endsWith("B")) {
                n = 2;
                n2 = 8;
            }
            try {
                String string2 = string.substring(1, string.length() - 2);
                if (string2.length() == 0) {
                    return new byte[0];
                }
                byte[] byArray = new byte[string2.length() / n2];
                for (int i = 0; i < string2.length(); i += n2) {
                    byArray[i / n2] = (byte)Integer.parseInt(string2.substring(i, i + n2), n);
                }
                return byArray;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public static String parseStringConstant(String string) throws NumberFormatException {
        int n = 10;
        int n2 = 3;
        if (string.startsWith("\"")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            if (!stringTokenizer.hasMoreTokens()) {
                return "";
            }
            return stringTokenizer.nextToken();
        }
        if (string.startsWith("'")) {
            StringTokenizer stringTokenizer;
            if (string.endsWith("h") || string.endsWith("H")) {
                n = 16;
                n2 = 2;
            }
            if (string.endsWith("o") || string.endsWith("O")) {
                n = 8;
                n2 = 4;
            }
            if (string.endsWith("b") || string.endsWith("B")) {
                n = 2;
                n2 = 8;
            }
            if (!(stringTokenizer = new StringTokenizer(string, "'")).hasMoreTokens()) {
                throw new NumberFormatException("String must be enclosed in '.");
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) {
                return "";
            }
            try {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < string2.length(); i += n2) {
                    char c = (char)Integer.parseInt(string2.substring(i, i + n2), n);
                    String string3 = Integer.toHexString(c);
                    for (int j = 0; j < 2 - string3.length(); ++j) {
                        string3 = "0" + string3;
                    }
                    stringBuffer.append("\\x" + string3);
                }
                return stringBuffer.toString();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return "";
            }
        }
        return string;
    }

    public static String convertStatusToSMIv2(String string) {
        if (string.equals(STATUS[1]) || string.equals(STATUS[2])) {
            return STATUS[5];
        }
        return string;
    }

    static {
        System.arraycopy(SMI_CONSTANTS[0], 0, COMMON_SMI_IDENTIFIER, 0, SMI_CONSTANTS[0].length);
        System.arraycopy(SMI_CONSTANTS[1], 0, COMMON_SMI_IDENTIFIER, SMI_CONSTANTS[0].length, SMI_CONSTANTS[1].length);
        System.arraycopy(SMI_CONSTANTS[2], 0, COMMON_SMI_IDENTIFIER, SMI_CONSTANTS[0].length + SMI_CONSTANTS[1].length, SMI_CONSTANTS[2].length);
        Arrays.sort(COMMON_SMI_IDENTIFIER);
    }
}

