/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIObjectIdentifier;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.StringToken;
import com.agentpp.smiparser.Token;
import com.objectspace.jgl.Pair;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class ParseScope {
    protected MIBRepository rep = new MIBRepository();
    protected Map unresolved = new HashMap(10);
    protected Map unresolvedSyntaxes = new HashMap(10);
    protected Map knownObjects = new HashMap(100);
    protected Map registeredObjects = new HashMap(100);
    protected Map sequences = new HashMap(100);
    protected Vector wrongTypes = new Vector(10);
    protected String scope = null;
    protected ImportModuleListener importer = null;
    protected SMIParseExceptionHandler errorHandler;

    public ParseScope(String string, ImportModuleListener importModuleListener) {
        this.scope = string;
        this.importer = importModuleListener;
        this.init();
    }

    public String getScope() {
        return this.scope;
    }

    public SMIParseExceptionHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setImporter(ImportModuleListener importModuleListener) {
        this.importer = importModuleListener;
    }

    public void setErrorHandler(SMIParseExceptionHandler sMIParseExceptionHandler) {
        this.errorHandler = sMIParseExceptionHandler;
    }

    public void init() {
        this.rep = new MIBRepository(true);
        this.unresolved = new Hashtable(10);
        this.unresolvedSyntaxes = new Hashtable(10);
        this.knownObjects = new Hashtable(100, 10.0f);
        this.registeredObjects = new Hashtable(100);
        this.sequences = new Hashtable(100);
        Enumeration enumeration = this.rep.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            try {
                this.addKnownObject(mIBObject);
            }
            catch (SMIParseException sMIParseException) {}
        }
    }

    public boolean importModule(String string, MIBRepository mIBRepository, boolean bl) {
        IObject[] iObjectArray = null;
        MIBModule mIBModule = mIBRepository.getModule(string);
        if (mIBModule != null) {
            iObjectArray = mIBModule.getObjects();
        } else {
            if (this.importer == null) {
                return false;
            }
            ImportModuleEvent importModuleEvent = new ImportModuleEvent(this, string);
            this.importer.importModule(importModuleEvent);
            iObjectArray = importModuleEvent.getObjects();
        }
        if (iObjectArray == null) {
            return false;
        }
        for (int i = 0; i < iObjectArray.length; ++i) {
            if (!(iObjectArray[i] instanceof MIBObject)) continue;
            this.rep.addObject((MIBObject)iObjectArray[i]);
            if (!bl) continue;
            this.knownObjects.put(iObjectArray[i].getName(), iObjectArray[i]);
        }
        return true;
    }

    public MIBObject getObject(String string, String string2) {
        return this.rep.getObject(string, string2);
    }

    public ObjectID getObjectID(String string) {
        MIBObject mIBObject = (MIBObject)this.knownObjects.get(string);
        if (mIBObject == null) {
            return null;
        }
        return mIBObject.getOid();
    }

    public ObjectID getObjectID(String string, String string2) {
        return this.rep.getObjectID(string, string2);
    }

    public boolean isModuleAlreadyImported(String string) {
        return this.rep.getModule(string) != null;
    }

    public boolean isObjectKnown(String string) {
        return this.knownObjects.get(string) != null;
    }

    public MIBObject getKnownObject(String string) {
        return (MIBObject)this.knownObjects.get(string);
    }

    public String getModuleName(Object object) {
        MIBModule mIBModule = this.rep.getModule(object);
        if (mIBModule == null) {
            return null;
        }
        return mIBModule.getModuleName();
    }

    public void addObject(MIBObject mIBObject) {
        this.rep.addObject(mIBObject);
    }

    public void addKnownObject(MIBObject mIBObject) throws SMIParseException {
        MIBObject mIBObject2;
        switch (mIBObject.getType()) {
            case 4: 
            case 10: {
                break;
            }
            default: {
                mIBObject2 = (MIBObject)this.registeredObjects.get(mIBObject.getOid());
                if (mIBObject2 != null) {
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(mIBObject.getName());
                    vector.addElement(mIBObject2.getName());
                    vector.addElement(mIBObject.getPrintableOid());
                    if (this.errorHandler != null) {
                        if (mIBObject.userObject instanceof Token) {
                            Token token = (Token)mIBObject.userObject;
                            this.errorHandler.error(new SMIParseException(new SemanticError(2000, token.beginLine, token.beginColumn, token.endPos, token, mIBObject.getName(), mIBObject.getName(), new String[0]), 2000, vector));
                        } else {
                            this.errorHandler.error(new SMIParseException("Duplicate OID registration", 2000, vector));
                        }
                    }
                }
                this.registeredObjects.put(mIBObject.getOid(), mIBObject);
                break;
            }
        }
        mIBObject2 = (MIBObject)this.knownObjects.get(mIBObject.getName());
        if (mIBObject2 == null || mIBObject2.getModuleID() < 0) {
            this.knownObjects.put(mIBObject.getName(), mIBObject);
        }
    }

    public final void replaceKnownObject(String string, MIBObject mIBObject) {
        this.knownObjects.remove(string);
        try {
            this.addKnownObject(mIBObject);
        }
        catch (SMIParseException sMIParseException) {
            // empty catch block
        }
    }

    public final void addUnresolvedName(StringToken[] stringTokenArray, StringToken stringToken) {
        Pair pair = new Pair(stringTokenArray, stringToken);
        LinkedList linkedList = ParseScope.getUnresolvedSubIDs(stringTokenArray);
        for (String string : linkedList) {
            StringToken stringToken2 = new StringToken(string, null);
            LinkedList<Pair> linkedList2 = (LinkedList<Pair>)this.unresolved.get(stringToken2);
            if (linkedList2 == null) {
                linkedList2 = new LinkedList<Pair>();
                this.unresolved.put(stringToken2, linkedList2);
            }
            linkedList2.add(pair);
        }
    }

    private static LinkedList getUnresolvedSubIDs(StringToken[] stringTokenArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < stringTokenArray.length; ++i) {
            String string = stringTokenArray[i].string;
            if (string.length() <= 0 || Character.isDigit(string.charAt(0))) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    public final void checkUnresolved(StringToken stringToken, StringToken[] stringTokenArray) {
        LinkedList linkedList = (LinkedList)this.unresolved.get(stringToken);
        if (linkedList != null) {
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                Pair pair = (Pair)listIterator.next();
                Object[] objectArray = (StringToken[])pair.first;
                StringToken stringToken2 = (StringToken)pair.second;
                int n = Arrays.binarySearch(objectArray, stringToken);
                if (n < 0 || n >= objectArray.length - 1) continue;
                StringToken[] stringTokenArray2 = ParseScope.createResolvedOID(stringTokenArray, (StringToken[])objectArray, n);
                ObjectID objectID = SMIObjectIdentifier.buildObjectID(stringTokenArray2);
                if (objectID.isValid()) {
                    listIterator.remove();
                    try {
                        this.addKnownObject(new MIBObject(objectID, stringToken2.string));
                    }
                    catch (SMIParseException sMIParseException) {}
                    continue;
                }
                pair.first = stringTokenArray2;
            }
        }
    }

    private static StringToken[] createResolvedOID(StringToken[] stringTokenArray, StringToken[] stringTokenArray2, int n) {
        StringToken[] stringTokenArray3 = new StringToken[stringTokenArray2.length - 1 + stringTokenArray.length];
        if (n > 0) {
            System.arraycopy(stringTokenArray2, 0, stringTokenArray3, 0, n);
        }
        if (stringTokenArray.length > 0) {
            System.arraycopy(stringTokenArray, 0, stringTokenArray3, n, stringTokenArray.length);
        }
        System.arraycopy(stringTokenArray2, n + 1, stringTokenArray3, n + stringTokenArray.length, stringTokenArray2.length - n - 1);
        return stringTokenArray3;
    }

    private static boolean isNumber(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void resolveNames() {
        Iterator iterator = this.unresolved.values().iterator();
        while (iterator.hasNext()) {
            LinkedList linkedList = (LinkedList)iterator.next();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                StringToken[] stringTokenArray;
                StringToken[] stringTokenArray2;
                int n;
                Pair pair = (Pair)listIterator.next();
                StringToken[] stringTokenArray3 = (StringToken[])pair.first;
                StringToken stringToken = (StringToken)pair.second;
                ObjectID objectID = null;
                StringToken stringToken2 = null;
                int n2 = -1;
                for (n = 0; n < stringTokenArray3.length; ++n) {
                    if (ParseScope.isNumber(stringTokenArray3[n].string)) continue;
                    stringToken2 = stringTokenArray3[n];
                    n2 = n;
                    break;
                }
                if (Character.isUpperCase(stringToken2.string.charAt(0))) {
                    n = stringToken2.string.indexOf(46);
                    if (n >= 0 && (objectID = this.rep.getObjectID((String)(stringTokenArray2 = stringToken2.string.substring(0, n)), (String)(stringTokenArray = stringToken2.string.substring(n + 1)))) != null) {
                        stringToken2.string = stringTokenArray;
                    }
                } else {
                    objectID = this.rep.getObjectID(stringToken2.string);
                }
                if (objectID == null) continue;
                String[] stringArray = ObjectID.toArray(objectID.toString());
                stringTokenArray2 = new StringToken[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringTokenArray2[i] = new StringToken(stringArray[i], null);
                }
                stringTokenArray = ParseScope.createResolvedOID(stringTokenArray2, stringTokenArray3, n2);
                ObjectID objectID2 = new ObjectID(SMIObjectIdentifier.buildObjectID(stringTokenArray));
                if (objectID2.isValid()) {
                    listIterator.remove();
                    try {
                        MIBObject mIBObject = new MIBObject(objectID2, stringToken.string);
                        mIBObject.userObject = stringTokenArray;
                        this.addKnownObject(mIBObject);
                    }
                    catch (SMIParseException sMIParseException) {}
                    continue;
                }
                pair.first = stringTokenArray;
            }
            if (linkedList.size() != 0) continue;
            iterator.remove();
        }
    }

    public boolean existsUnresolvedNames() {
        this.resolveNames();
        return this.unresolved.size() > 0;
    }

    public Iterator getUnresolvedNames() {
        return this.unresolved.values().iterator();
    }

    public void checkUnresolvedSyntax(StringToken stringToken) {
        if (this.knownObjects.get(stringToken) == null) {
            this.unresolvedSyntaxes.put(stringToken, String.class);
        }
    }

    public void checkUnresolvedObject(StringToken stringToken, Class clazz) {
        MIBObject mIBObject = (MIBObject)this.knownObjects.get(stringToken);
        if (mIBObject == null || mIBObject instanceof MIBTextualConvention || mIBObject.getOid().isEmpty() || clazz != null && !mIBObject.getClass().equals(clazz)) {
            if (clazz == null) {
                this.unresolvedSyntaxes.put(stringToken, String.class);
            } else {
                this.unresolvedSyntaxes.put(stringToken, clazz);
            }
        }
    }

    public boolean existsUnresolvedSyntaxes() {
        return this.unresolvedSyntaxes.size() > 0;
    }

    public void resolveSyntaxes() {
        boolean bl = true;
        block2: while (bl) {
            bl = false;
            for (Map.Entry entry : this.unresolvedSyntaxes.entrySet()) {
                StringToken stringToken = (StringToken)entry.getKey();
                Class clazz = (Class)entry.getValue();
                Object v = this.knownObjects.get(stringToken.string);
                if (v == null) continue;
                this.unresolvedSyntaxes.remove(stringToken);
                if (!clazz.equals(new String().getClass())) {
                    try {
                        String string = ((MIBObject)clazz.newInstance()).getTypeString();
                        String string2 = ((MIBObject)v).getTypeString();
                        if (!v.getClass().equals(clazz) && !SMI.ENTRY_TYPES[10].equals(string)) {
                            this.wrongTypes.add(new Object[]{stringToken, string, string2});
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                bl = true;
                continue block2;
            }
        }
    }

    public boolean existsWrongTypes() {
        return this.wrongTypes.size() > 0;
    }

    public Iterator getWrongTypes() {
        return this.wrongTypes.iterator();
    }

    public Iterator getUnresolvedSyntaxes() {
        return this.unresolvedSyntaxes.entrySet().iterator();
    }

    public void addSequence(String string) {
        this.sequences.put(string, new Vector());
    }

    public Vector getSequence(String string) {
        return (Vector)this.sequences.get(string);
    }
}

