/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.Token;
import java.util.ArrayList;

public class ParseException
extends Exception
implements FileError {
    private boolean next = true;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    public int errorType = 1000;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException(String string, Token token, int[][] nArray, String[] stringArray) {
        super(string);
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException(String string, Token token, int[][] nArray, String[] stringArray, int n) {
        super(string);
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
        this.errorType = n;
        this.next = false;
    }

    public ParseException(String string, Token token, int[][] nArray, String[] stringArray, int n, boolean bl) {
        super(string);
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
        this.errorType = n;
        this.next = bl;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string);
        this.specialConstructor = false;
    }

    public void freeUnusedTokens() {
        int n = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (n >= this.expectedTokenSequences[i].length) continue;
                n = this.expectedTokenSequences[i].length;
            }
        }
        if (this.next) {
            ++n;
        }
        Token token = this.currentToken;
        for (int i = 0; i < n && token != null; ++i) {
            token.specialToken = null;
            token = token.next;
        }
        if (token != null) {
            token.next = null;
            token.specialToken = null;
        }
    }

    public Token getToken() {
        if (this.next) {
            return this.currentToken.next;
        }
        return this.currentToken;
    }

    public int getErrorType() {
        return this.errorType;
    }

    private String getEntcountered(int n) {
        String string = "";
        if (super.getMessage().length() > 0) {
            string = string + "\n";
        }
        string = string + "Encountered \"";
        Token token = this.getToken();
        for (int i = 0; i < n && token != null; ++i) {
            if (i != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + this.tokenImage[0];
                break;
            }
            string = string + this.add_escapes(token.image);
            token = token.next;
        }
        string = string + "\"";
        return string;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String string = "";
        int n = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (n < this.expectedTokenSequences[i].length) {
                    n = this.expectedTokenSequences[i].length;
                }
                for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                    string = string + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                }
                if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                    string = string + "...";
                }
                string = string + this.eol + "  ";
            }
        } else {
            n = 1;
        }
        String string2 = "";
        switch (this.errorType) {
            case 1001: 
            case 1002: 
            case 1020: {
                Token token = this.getToken();
                if (token != null) {
                    string2 = string2 + super.getMessage();
                    string2 = string2 + " at line " + token.beginLine + ", column " + token.beginColumn;
                    return string2;
                }
            }
            case 1102: 
            case 1811: 
            case 4010: {
                return super.getMessage();
            }
        }
        string2 = string2 + super.getMessage();
        string2 = string2 + this.getEntcountered(n);
        Token token = this.getToken();
        if (token == null) {
            token = this.currentToken;
        }
        string2 = string2 + " at line " + token.beginLine + ", column " + token.beginColumn + ": " + this.eol;
        if (this.expectedTokenSequences != null) {
            string2 = this.expectedTokenSequences.length == 1 ? string2 + "Was expecting: " + this.eol + "  " : string2 + "Was expecting one of: " + this.eol + "  ";
        }
        string2 = string2 + string;
        return string2;
    }

    public String[] getExpected() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int n = 0;
        if (this.expectedTokenSequences != null) {
            n = this.expectedTokenSequences.length;
        }
        String[] stringArray = new String[n];
        if (n == 0) {
            return stringArray;
        }
        stringArray[0] = "";
        for (int i = 0; i < n; ++i) {
            stringArray[i] = new String();
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                int n2 = i;
                stringArray[n2] = stringArray[n2] + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] == 0) continue;
            int n3 = i;
            stringArray[n3] = stringArray[n3] + "...";
        }
        return stringArray;
    }

    public String[] getExpectedImages() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int n = 0;
        if (this.expectedTokenSequences != null) {
            n = this.expectedTokenSequences.length;
        }
        String[] stringArray = new String[n];
        if (n == 0) {
            return stringArray;
        }
        stringArray[0] = "";
        for (int i = 0; i < n; ++i) {
            stringArray[i] = new String();
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                int n2 = i;
                stringArray[n2] = stringArray[n2] + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
        }
        return stringArray;
    }

    private int getMaxExpectedTokenSequenceLength() {
        int n = 0;
        if (this.expectedTokenSequences != null) {
            n = this.expectedTokenSequences.length;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (this.expectedTokenSequences[i].length <= n2) continue;
            n2 = this.expectedTokenSequences[i].length;
        }
        return n2;
    }

    public String[] getLastExpectedImages() {
        if (!this.specialConstructor) {
            return new String[0];
        }
        int n = 0;
        if (this.expectedTokenSequences != null) {
            n = this.expectedTokenSequences.length;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        if (n == 0) {
            return new String[0];
        }
        int n2 = this.getMaxExpectedTokenSequenceLength();
        for (int i = 0; i < n; ++i) {
            String string = "";
            if (this.expectedTokenSequences[i].length >= n2) {
                for (int j = n2 - 1; j < this.expectedTokenSequences[i].length; ++j) {
                    string = string + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
                }
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public String getFoundTokenImage() {
        switch (this.errorType) {
            case 1020: {
                return super.getMessage();
            }
        }
        String string = "";
        int n = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (n >= this.expectedTokenSequences[i].length) continue;
                n = this.expectedTokenSequences[i].length;
            }
        }
        Token token = this.getToken();
        for (int i = 0; i < n && token != null; ++i) {
            if (i != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + this.tokenImage[0];
                break;
            }
            string = string + token.image;
            token = token.next;
        }
        return string;
    }

    public String getFound() {
        switch (this.errorType) {
            case 1020: 
            case 1102: 
            case 4010: {
                return super.getMessage();
            }
        }
        String string = "";
        int n = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (n >= this.expectedTokenSequences[i].length) continue;
                n = this.expectedTokenSequences[i].length;
            }
        }
        Token token = this.getToken();
        for (int i = 0; i < n && token != null; ++i) {
            if (i != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + this.tokenImage[0];
                break;
            }
            string = string + this.add_escapes(token.image);
            token = token.next;
        }
        return string;
    }

    public int getLine() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token token = this.getToken();
        if (token == null) {
            token = this.currentToken;
        }
        return token.beginLine;
    }

    public Token getEndToken() {
        Token token = this.getLastToken();
        if (token == null) {
            token = this.getToken();
        }
        return token;
    }

    private Token getLastToken() {
        Token token;
        switch (this.errorType) {
            case 1020: {
                return this.getToken();
            }
        }
        int n = 0;
        if (this.expectedTokenSequences != null) {
            for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
                if (n >= this.expectedTokenSequences[i].length) continue;
                n = this.expectedTokenSequences[i].length;
            }
        }
        Token token2 = token = this.getToken();
        for (int i = 0; i < n && token != null && token.kind != 0; ++i) {
            token2 = token;
            token = token.next;
        }
        return token2;
    }

    public int getLastEndPosition() {
        Token token = this.getLastToken();
        return token.endPos;
    }

    public int getEndPosition() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token token = this.getToken();
        if (token == null) {
            token = this.currentToken;
        }
        return token.endPos;
    }

    public int getColumn() {
        if (!this.specialConstructor) {
            return 0;
        }
        Token token = this.getToken();
        if (token == null) {
            token = this.currentToken;
        }
        return token.beginColumn;
    }

    public int getEndLine() {
        if (!this.specialConstructor) {
            return 0;
        }
        return this.getEndToken().endLine;
    }

    public int getEndColumn() {
        if (!this.specialConstructor) {
            return 0;
        }
        return this.getEndToken().endColumn;
    }

    public String toString() {
        return this.getMessage();
    }

    protected String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof FileError) {
            FileError fileError = (FileError)object;
            return fileError.getErrorType() == this.getErrorType() && fileError.getEndPosition() == this.getEndPosition() && fileError.getToken() == fileError.getToken();
        }
        return false;
    }
}

