/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.Node;
import java.util.Stack;

class JJTSMIParserState {
    private Stack nodes = new Stack();
    private Stack marks = new Stack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;
    private boolean saveNext;
    private Node saveNode;

    JJTSMIParserState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    Node rootNode() {
        return (Node)this.nodes.elementAt(0);
    }

    void pushNode(Node node) {
        this.nodes.push(node);
        ++this.sp;
    }

    Node popNode() {
        if (--this.sp < this.mk) {
            this.mk = (Integer)this.marks.pop();
        }
        return (Node)this.nodes.pop();
    }

    Node peekNode() {
        return (Node)this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void clearNodeScope(Node node) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = (Integer)this.marks.pop();
    }

    void openNodeScope(Node node) {
        this.marks.push(new Integer(this.mk));
        this.mk = this.sp;
        node.jjtOpen();
        if (this.saveNext) {
            this.saveNext = false;
            this.saveNode = node;
        }
    }

    Node getSaveNode() {
        return this.saveNode;
    }

    void closeNodeScope(Node node, int n) {
        this.mk = (Integer)this.marks.pop();
        while (n-- > 0) {
            Node node2 = this.popNode();
            node2.jjtSetParent(node);
            node.jjtAddChild(node2, n);
        }
        node.jjtClose();
        this.pushNode(node);
        this.node_created = true;
        if (this.saveNode == node) {
            this.saveNode = null;
        }
    }

    void closeNodeScope(Node node, boolean bl) {
        if (bl) {
            int n = this.nodeArity();
            this.mk = (Integer)this.marks.pop();
            while (n-- > 0) {
                Node node2 = this.popNode();
                node2.jjtSetParent(node);
                node.jjtAddChild(node2, n);
            }
            node.jjtClose();
            this.pushNode(node);
            this.node_created = true;
            if (this.saveNode == node) {
                this.saveNode = null;
            }
        } else {
            this.mk = (Integer)this.marks.pop();
            this.node_created = false;
        }
    }

    void setSaveNext(boolean bl) {
        this.saveNext = bl;
    }
}

