/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.SMIAgentCapabilities;
import com.agentpp.smiparser.SMICompliance;
import com.agentpp.smiparser.SMIImportList;
import com.agentpp.smiparser.SMIMib;
import com.agentpp.smiparser.SMIModule;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParserVisitor;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SimpleNode;
import java.util.Vector;

public class FindImportsVisitor
implements SMIParserVisitor {
    private Vector result = new Vector();
    protected ModuleInfo currentModuleInfo = null;
    private SMIRepository smiRep;

    public FindImportsVisitor(SMIRepository sMIRepository) {
        this.smiRep = sMIRepository;
    }

    protected ModuleInfo readModule(SMIMib sMIMib) throws SMIParseException {
        return new ModuleInfo(sMIMib.getName());
    }

    public Object visit(SimpleNode simpleNode, Object object) throws SMIParseException {
        if (this.currentModuleInfo != null || simpleNode.getId() == -4) {
            switch (simpleNode.getId()) {
                case -4: {
                    this.smiRep.setScope(((SMIMib)simpleNode).getName(), null);
                    this.currentModuleInfo = this.readModule((SMIMib)simpleNode);
                    ((Vector)object).addElement(this.currentModuleInfo);
                    break;
                }
                case -3: {
                    String string = ((SMIModule)simpleNode).getLastUpdated();
                    if (string == null) break;
                    try {
                        this.currentModuleInfo.setLastUpdated(MIBModule.getDateFromUTC(string));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case -13: {
                    this.currentModuleInfo.addImport(((SMIImportList)simpleNode).getSource());
                    break;
                }
                case -9: {
                    SMIAgentCapabilities sMIAgentCapabilities = (SMIAgentCapabilities)simpleNode;
                    for (int i = 0; i < sMIAgentCapabilities.acModules.size(); ++i) {
                        MIBSupportedModule mIBSupportedModule = (MIBSupportedModule)sMIAgentCapabilities.acModules.get(i);
                        if (mIBSupportedModule.getSupports() == null || mIBSupportedModule.getSupports().length() <= 0) continue;
                        this.currentModuleInfo.addImport(mIBSupportedModule.getSupports());
                    }
                    break;
                }
                case -11: {
                    SMICompliance sMICompliance = (SMICompliance)simpleNode;
                    for (int i = 0; i < sMICompliance.modules.size(); ++i) {
                        MIBComplianceModule mIBComplianceModule = (MIBComplianceModule)sMICompliance.modules.get(i);
                        if (mIBComplianceModule.getModuleName() == null || mIBComplianceModule.getModuleName().length() <= 0) continue;
                        this.currentModuleInfo.addImport(mIBComplianceModule.getModuleName());
                    }
                    break;
                }
            }
        }
        simpleNode.childrenAccept(this, object);
        return object;
    }

    public Vector getResult() {
        return this.result;
    }
}

