/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi.examples;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IObjectType;
import com.agentpp.smi.SMIRepositoryManager;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DumpObjectTypes
implements RepositoryListener {
    private SMIRepositoryManager repMan;
    private File repositoryFile;

    public DumpObjectTypes(String string, String string2, String string3, String string4) {
        this.repMan = new SMIRepositoryManager(string, string2);
        try {
            this.repositoryFile = new File(string3);
            if (this.repositoryFile.isDirectory()) {
                this.repMan.open(this.repositoryFile);
            } else {
                this.repMan.addRepositoryListener(this);
            }
            IModule iModule = this.repMan.getModule(string4);
            Enumeration enumeration = iModule.objectsByOid().elements();
            while (enumeration.hasMoreElements()) {
                IObject iObject = (IObject)enumeration.nextElement();
                if (!(iObject instanceof IObjectType)) continue;
                IObjectType iObjectType = (IObjectType)iObject;
                System.out.println(iObjectType.getName() + " = " + iObjectType.getPrintableOid() + "; " + iObjectType.getAccess() + "; " + iObjectType.getStatus() + "; " + iObjectType.getSyntaxDef().getSyntax());
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage: DumpObjectTypes <license> <licenseKey> <repositoryPath> <moduleName>");
            System.exit(1);
        }
        DumpObjectTypes dumpObjectTypes = new DumpObjectTypes(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
    }

    public void writeModule(RepositoryEvent repositoryEvent) {
    }

    public void deleteModule(RepositoryEvent repositoryEvent) {
    }

    public void readModule(RepositoryEvent repositoryEvent) {
        try {
            ZipFile zipFile = this.repositoryFile.getPath().toUpperCase().endsWith(".JAR") ? new JarFile(this.repositoryFile) : new ZipFile(this.repositoryFile);
            ZipEntry zipEntry = zipFile.getEntry(repositoryEvent.getModuleName());
            repositoryEvent.setInputStream(zipFile.getInputStream(zipEntry));
        }
        catch (IOException iOException) {
            System.err.print("Could not open repository '" + this.repositoryFile.getPath() + "' to load MIB module: " + repositoryEvent.getModuleName());
            return;
        }
    }

    public String[] listModuleNames() {
        try {
            ZipFile zipFile = this.repositoryFile.getPath().toUpperCase().endsWith(".JAR") ? new JarFile(this.repositoryFile) : new ZipFile(this.repositoryFile);
            ArrayList<String> arrayList = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                arrayList.add(zipEntry.getName());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IOException iOException) {
            System.err.print("Could not open repository '" + this.repositoryFile.getPath() + "': " + iOException.getMessage());
            return null;
        }
    }
}

