/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi.examples;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smi.IModuleInfoSorter;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRepository;
import com.agentpp.smi.SMIRepository;
import com.agentpp.smi.SMIRepositoryManager;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.SMIParseException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DumpObjectNames
implements ImportModuleListener {
    private SMIRepositoryManager repMan;
    private String mibFileDir;
    private boolean useCache = false;
    private Hashtable moduleHash = new Hashtable();
    private Hashtable moduleFileNames = new Hashtable();
    private static int moduleID = 1;

    public DumpObjectNames(String string, String string2, String string3, String string4) {
        this.useCache = Boolean.valueOf(string4);
        this.repMan = new SMIRepositoryManager(string, string2);
        this.mibFileDir = string3;
    }

    public void run() {
        Object object;
        File file = new File(this.mibFileDir);
        Vector vector = DumpObjectNames.getSubtree(file);
        Vector<Object> vector2 = new Vector<Object>();
        Vector<File> vector3 = new Vector<File>();
        Object[] objectArray = vector.elements();
        while (objectArray.hasMoreElements()) {
            file = (File)objectArray.nextElement();
            try {
                object = this.repMan.getModuleInfo(file);
                for (int i = 0; i < ((Object)object).length; ++i) {
                    vector2.addElement(object[i]);
                    this.moduleFileNames.put(object[i].getModuleName(), file);
                }
                vector3.addElement(file);
            }
            catch (Exception exception) {
                System.err.println("Error in file " + file.getPath() + ": " + exception.toString());
            }
        }
        objectArray = new IModuleInfo[vector2.size()];
        vector2.copyInto(objectArray);
        object = new IModuleInfoSorter((IModuleInfo[])objectArray);
        if (!((IModuleInfoSorter)object).sort()) {
            System.err.println("Could not resolve all imports!");
        }
        objectArray = ((IModuleInfoSorter)object).getSortedList();
        SMIRepository sMIRepository = new SMIRepository();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                file = (File)this.moduleFileNames.get(objectArray[i].getModuleName());
                if (file == null) continue;
                FileInputStream fileInputStream = new FileInputStream(file);
                IModule[] iModuleArray = this.repMan.getModules(fileInputStream, this);
                fileInputStream.close();
                for (int j = 0; j < iModuleArray.length; ++j) {
                    if (this.useCache) {
                        this.moduleHash.put(iModuleArray[j].getModuleName(), iModuleArray[j]);
                    }
                    sMIRepository.addObject(iModuleArray[j]);
                    Enumeration enumeration = iModuleArray[j].objects();
                    while (enumeration.hasMoreElements()) {
                        sMIRepository.addObject((IObject)enumeration.nextElement());
                    }
                }
                sMIRepository.structureChanged();
                continue;
            }
            catch (SMIParseException sMIParseException) {
                System.out.println("Errors of " + objectArray[i].getModuleName() + ":");
                if (sMIParseException.getErrorList() != null && sMIParseException.getErrorList().size() > 0) {
                    for (int j = 0; j < sMIParseException.getErrorList().size(); ++j) {
                        SMIParseException sMIParseException2 = (SMIParseException)sMIParseException.getErrorList().get(j);
                        System.out.println("#" + (j + 1) + ": " + this.repMan.getErrorText(sMIParseException2));
                    }
                    continue;
                }
                System.out.println(this.repMan.getErrorText(sMIParseException));
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        DumpObjectNames.dumpRepository(sMIRepository);
    }

    private static void dumpRepository(IRepository iRepository) {
        Object object;
        try {
            object = iRepository.getObjectClassOID("sysDescr.0");
            System.out.println("Resolved OID 'sysDescr.0': class=" + ((Vector)object).elementAt(0) + ", instance suffix=" + ((Vector)object).elementAt(1));
        }
        catch (Exception exception) {
            System.out.println("MIB modules do not include sysDescr.0!");
        }
        object = iRepository.objects();
        while (object.hasMoreElements()) {
            IObject iObject = (IObject)object.nextElement();
            System.out.println(iObject.getName() + " = " + iObject.getPrintableOid());
        }
    }

    public Integer createModuleID(String string) {
        return new Integer(moduleID++);
    }

    public void freeModuleID(Integer n, String string) {
    }

    public void importModule(ImportModuleEvent importModuleEvent) {
        if (this.useCache) {
            IModule iModule = (IModule)this.moduleHash.get(importModuleEvent.getModuleName());
            if (iModule != null) {
                Vector vector = iModule.getObjectsVector();
                Object[] objectArray = new IObject[vector.size()];
                vector.copyInto(objectArray);
                importModuleEvent.setObjects((IObject[])objectArray);
            }
        } else {
            File file = (File)this.moduleFileNames.get(importModuleEvent.getModuleName());
            if (file != null) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    IModule[] iModuleArray = this.repMan.getModules(fileInputStream, this);
                    fileInputStream.close();
                    for (int i = 0; i < iModuleArray.length; ++i) {
                        if (!iModuleArray[i].getModuleName().equals(importModuleEvent.getModuleName())) continue;
                        Object[] objectArray = new IObject[iModuleArray[i].size()];
                        Vector vector = iModuleArray[i].getObjectsVector();
                        vector.copyInto(objectArray);
                        importModuleEvent.setObjects((IObject[])objectArray);
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static Vector getSubtree(File file) {
        if (file.isDirectory()) {
            int n;
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return !file.isDirectory();
                }
            });
            File[] fileArray2 = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            Vector<File> vector = new Vector<File>(fileArray.length, 10);
            for (n = 0; n < fileArray.length; ++n) {
                vector.addElement(fileArray[n]);
            }
            for (n = 0; n < fileArray2.length; ++n) {
                vector.addAll(DumpObjectNames.getSubtree(fileArray2[n]));
            }
            return vector;
        }
        return new Vector();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage: DumpObjectNames <license> <licenseKey> <mibFileDir> <useCache>");
            System.out.println("where: <useCache>   is \"true\" or \"false\"");
            System.out.println("       <mibFileDir> is a directory containing SMIv1/v2 MIB files.");
            System.exit(1);
        }
        DumpObjectNames dumpObjectNames = new DumpObjectNames(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        dumpObjectNames.run();
    }
}

