/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRepositoryManager;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.util.license.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public final class SMIRepositoryManager
implements IRepositoryManager,
RepositoryListener {
    private DefaultRepositoryManager repMan;
    private boolean readonly;
    private GregorianCalendar licenseExpiration;
    private byte licenseMode;
    private transient Vector repositoryListeners;

    public SMIRepositoryManager(String string, String string2) {
        block4: {
            this.repMan = new DefaultRepositoryManager();
            this.readonly = true;
            this.licenseExpiration = null;
            this.licenseMode = 0;
            try {
                byte[] byArray = Validate.fromHexString(string);
                if (this.validateLicense(byArray, string2.getBytes())) break block4;
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.err.println("Invalid license, aborting!");
                System.exit(1);
            }
            catch (Exception exception) {
                System.err.println("Invalid license, aborting!");
                System.exit(1);
            }
        }
        this.repMan.verbose = false;
        this.repMan.addRepositoryListener(this);
    }

    private boolean validateLicense(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Validate.decrypt(byArray, new String(byArray2).toCharArray());
        if (!(byArray3 != null && byArray3.length >= 7 && (byArray3[0] == 16 && byArray3[1] == 3 || byArray3[0] == 1 && byArray3[1] == 3 || byArray3[0] == 80 && byArray3[1] == 3 || byArray3[0] == 0 && byArray3[1] == 3))) {
            return false;
        }
        if (byArray3[0] != 1) {
            this.readonly = false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000 + byArray3[4], byArray3[5] - 1, byArray3[6]);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        if ((byArray3[4] != 0 || byArray3[5] != 0 || byArray3[6] != 0) && gregorianCalendar.getTime().before(gregorianCalendar2.getTime())) {
            return false;
        }
        this.licenseExpiration = byArray3[4] == 0 && byArray3[5] == 0 && byArray3[6] == 0 ? null : gregorianCalendar;
        this.licenseMode = byArray3[3];
        return true;
    }

    public void open(File file) throws IOException {
        this.repMan.open(file);
    }

    public IModuleInfo[] addModules(File file) throws SMIParseException {
        if (this.readonly) {
            return null;
        }
        return this.repMan.addModules(file);
    }

    public void addModule(IModule iModule) throws IOException {
        if (this.readonly) {
            return;
        }
        MIBModule mIBModule = iModule instanceof MIBModule ? (MIBModule)iModule : new MIBModule(iModule);
        this.repMan.saveModule(mIBModule);
    }

    public IModule[] getModules(InputStream inputStream, ImportModuleListener importModuleListener) throws SMIParseException {
        if (this.readonly) {
            return null;
        }
        MIBRepository mIBRepository = this.repMan.createRepository(inputStream, importModuleListener);
        IModule[] iModuleArray = new IModule[mIBRepository.moduleCount()];
        int n = 0;
        Iterator iterator = mIBRepository.modulesIterator();
        while (iterator.hasNext()) {
            IModule iModule;
            iModuleArray[n] = iModule = (IModule)iterator.next();
            ++n;
        }
        return iModuleArray;
    }

    public void checkModules(InputStream inputStream) throws SMIParseException {
        this.repMan.checkModules(inputStream);
    }

    public IModuleInfo[] checkModules(InputStream inputStream, boolean bl) throws SMIParseException {
        return this.repMan.checkModules(inputStream, bl);
    }

    public IModuleInfo[] getModuleInfo(File file) throws SMIParseException {
        return this.repMan.getModuleInfo(file);
    }

    public IModuleInfo[] getModuleInfo(InputStream inputStream, String string) throws SMIParseException {
        return this.repMan.getModuleInfo(inputStream, string);
    }

    public IModuleInfo[] getModuleInfos() throws IOException {
        return this.repMan.getModuleInfos();
    }

    public boolean removeModule(String string) throws IOException {
        if (this.readonly) {
            return false;
        }
        return this.repMan.removeModule(string);
    }

    public void initialize() throws IOException {
        if (!this.readonly) {
            this.repMan.initialize();
        }
    }

    public IModule[] getModules() throws IOException {
        return this.repMan.getModules();
    }

    public IModule getModule(String string) throws IOException {
        return this.repMan.getModule(string, true);
    }

    public String[] getModuleNames() throws IOException {
        return this.repMan.getModuleNames();
    }

    public IObject[] getObjects(String string) throws IOException {
        return this.repMan.getObjects(string);
    }

    public IObject[] getImportedObjects(String string) throws IOException {
        return this.repMan.getImportedObjects(string);
    }

    public IObject[] getImportedObjects(String string, Hashtable hashtable) throws IOException {
        return this.repMan.getImportedObjects(hashtable, string);
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public String getErrorText(SMIParseException sMIParseException) {
        return DefaultRepositoryManager.getErrorText(sMIParseException);
    }

    public String getErrorText(int n, String string) {
        return DefaultRepositoryManager.getErrorText(new SMIParseException(string, n));
    }

    public void setParserOptions(int n) {
        this.repMan.setOptions(n);
    }

    public int getParserOptions() {
        return this.repMan.getOptions();
    }

    public File getRepositoryDirectory() {
        return this.repMan.getRepositoryDirectory();
    }

    public synchronized void removeRepositoryListener(RepositoryListener repositoryListener) {
        if (this.repositoryListeners != null && this.repositoryListeners.contains(repositoryListener)) {
            Vector vector = (Vector)this.repositoryListeners.clone();
            vector.removeElement(repositoryListener);
            this.repositoryListeners = vector;
        }
    }

    public synchronized void addRepositoryListener(RepositoryListener repositoryListener) {
        Vector vector;
        Vector vector2 = vector = this.repositoryListeners == null ? new Vector(2) : (Vector)this.repositoryListeners.clone();
        if (!vector.contains(repositoryListener)) {
            vector.addElement(repositoryListener);
            this.repositoryListeners = vector;
        }
    }

    protected void fireWriteModule(RepositoryEvent repositoryEvent) {
        if (this.repositoryListeners != null) {
            Vector vector = this.repositoryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((RepositoryListener)vector.elementAt(i)).writeModule(repositoryEvent);
            }
        }
    }

    protected void fireReadModule(RepositoryEvent repositoryEvent) {
        if (this.repositoryListeners != null) {
            Vector vector = this.repositoryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((RepositoryListener)vector.elementAt(i)).readModule(repositoryEvent);
            }
        }
    }

    protected void fireDeleteModule(RepositoryEvent repositoryEvent) {
        if (this.repositoryListeners != null) {
            Vector vector = this.repositoryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((RepositoryListener)vector.elementAt(i)).deleteModule(repositoryEvent);
            }
        }
    }

    public void writeModule(RepositoryEvent repositoryEvent) {
        RepositoryEvent repositoryEvent2 = new RepositoryEvent(this, repositoryEvent.getModuleName());
        this.fireWriteModule(repositoryEvent2);
        repositoryEvent.setOutputStream(repositoryEvent2.getOutputStream());
    }

    public void readModule(RepositoryEvent repositoryEvent) {
        RepositoryEvent repositoryEvent2 = new RepositoryEvent(this, repositoryEvent.getModuleName());
        this.fireReadModule(repositoryEvent2);
        repositoryEvent.setInputStream(repositoryEvent2.getInputStream());
    }

    public void deleteModule(RepositoryEvent repositoryEvent) {
        RepositoryEvent repositoryEvent2 = new RepositoryEvent(this, repositoryEvent.getModuleName());
        this.fireDeleteModule(repositoryEvent2);
        repositoryEvent.setModuleDeleted(repositoryEvent2.isModuleDeleted());
    }

    public void setMaxErrors(int n) {
        this.repMan.setMaxErrors(n);
    }

    public int getMaxErrors() {
        return this.repMan.getMaxErrors();
    }

    public Integer createModuleID() throws IOException {
        return this.repMan.createModuleID();
    }

    public String[] listModuleNames() {
        try {
            return this.repMan.getModuleNames();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("Usage: SMIRepositoryManager <license> <key> <mibrepository-dir>");
            System.exit(1);
        }
        SMIRepositoryManager sMIRepositoryManager = new SMIRepositoryManager(stringArray[0], stringArray[1]);
        try {
            sMIRepositoryManager.open(new File(stringArray[2]));
            String[] stringArray2 = sMIRepositoryManager.listModuleNames();
            if (stringArray2 != null) {
                System.out.println("Modules in '" + stringArray[2] + "' are: " + Arrays.asList(stringArray2));
            } else {
                System.out.println("No MIB repository in '" + stringArray[2] + "'");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

