/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IObjectID;
import com.agentpp.smi.IObjectType;
import com.agentpp.smi.IRepository;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ITextualConvention;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class SMIRepository
implements IRepository {
    protected MIBRepository rep = new MIBRepository(false);

    public int size() {
        return this.rep.size();
    }

    public int moduleCount() {
        return this.rep.moduleCount();
    }

    public void addObject(IObject iObject) {
        this.rep.addObject(SMIRepository.makeObject(iObject));
    }

    private static ObjectID makeObjectID(IObjectID iObjectID) {
        if (iObjectID instanceof ObjectID) {
            return (ObjectID)iObjectID;
        }
        return new ObjectID(((Object)iObjectID).toString());
    }

    private static MIBObject makeObject(IObject iObject) {
        if (iObject instanceof MIBObject) {
            return (MIBObject)iObject;
        }
        throw new IllegalArgumentException("Only JASMI created instances of IObject are currently supported");
    }

    public String getObjectName(IObjectID iObjectID) {
        return this.rep.getObjectName(SMIRepository.makeObjectID(iObjectID));
    }

    public IObjectID getObjectID(String string) {
        return this.rep.getObjectID(string);
    }

    public IObjectID getObjectID(String string, String string2) {
        return this.rep.getObjectID(string, string2);
    }

    public IObject getObject(String string, String string2) {
        return this.rep.getObject(string, string2);
    }

    public Vector getChildren(String string) {
        return this.rep.getChildren(string);
    }

    public Vector getChildren(IObjectID iObjectID) {
        return this.rep.getChildren(SMIRepository.makeObjectID(iObjectID));
    }

    public Vector getChildren(IObject iObject) {
        return this.getChildren(SMIRepository.makeObject(iObject));
    }

    public Vector getDescendants(IObject iObject) {
        return this.rep.getDescendants(SMIRepository.makeObject(iObject));
    }

    public IObject getParent(IObject iObject) {
        return this.rep.getParent(SMIRepository.makeObject(iObject));
    }

    public IObject[] getObjectsByName(String string) {
        return this.rep.getObjectsByName(string);
    }

    public IObject[] getObjectsByOid(IObjectID iObjectID) {
        return this.rep.getObjectsByOid(SMIRepository.makeObjectID(iObjectID));
    }

    public void remove(IModule iModule) {
        this.rep.removeModule(iModule.getModuleName());
    }

    public void removeObject(IObject iObject) {
        this.rep.removeObject(SMIRepository.makeObject(iObject));
    }

    public boolean removeModule(String string) {
        return this.rep.removeModule(string);
    }

    public IModule getModule(String string) {
        return this.rep.getModule(string);
    }

    public IObject getObject(String string) {
        return this.rep.getObject(string);
    }

    public IObject getObject(IObjectID iObjectID) {
        return this.rep.getObject(SMIRepository.makeObjectID(iObjectID));
    }

    public Enumeration modules() {
        return this.rep.modules();
    }

    public Iterator modulesIterator() {
        return this.rep.modulesIterator();
    }

    public Enumeration getModulesSortedByName() {
        return this.rep.getModulesSortedByName();
    }

    public Vector getModuleNames() {
        return this.rep.getModuleNames();
    }

    public Enumeration objects() {
        return this.rep.objects();
    }

    public Enumeration objectsByName() {
        return this.rep.objectsByName();
    }

    public Iterator objectsOrderedByOccurance() {
        TreeMap<MIBObject, MIBObject> treeMap = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(128));
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            treeMap.put(mIBObject, mIBObject);
        }
        return treeMap.values().iterator();
    }

    public void structureChanged() {
        this.rep.structureChanged();
    }

    public String getPath(IObjectID iObjectID, boolean bl) {
        return this.rep.getPath(SMIRepository.makeObjectID(iObjectID), bl);
    }

    public Vector getNonOidObjects(boolean bl) {
        return this.rep.getNonOidObjects(bl);
    }

    public String printModule(String string) {
        return this.rep.printModule(string);
    }

    public IObjectID makeObjectID(String string) {
        ObjectID objectID = new ObjectID(string);
        if (!objectID.isValid()) {
            return this.rep.resolveOID(objectID);
        }
        return objectID;
    }

    public String getPath(String string, boolean bl) {
        IObjectID iObjectID = this.makeObjectID(string);
        if (iObjectID == null) {
            return null;
        }
        return this.getPath(string, bl);
    }

    public IObject getObjectByOID(String string) {
        ObjectID objectID = (ObjectID)this.makeObjectID(string);
        if (objectID == null) {
            return null;
        }
        return this.rep.getObject(objectID);
    }

    public IObject[] getObjectsByOid(String string) {
        ObjectID objectID = (ObjectID)this.makeObjectID(string);
        if (objectID == null) {
            return null;
        }
        return this.getObjectsByOid(objectID);
    }

    public ITextualConvention getEffectiveSyntax(ISyntax iSyntax) {
        if (iSyntax instanceof MIBSyntax) {
            return this.rep.getEffectiveSyntax((MIBSyntax)iSyntax);
        }
        return this.rep.getEffectiveSyntax(new MIBSyntax(iSyntax));
    }

    public Vector getObjectClassOID(String string) {
        ObjectID objectID = (ObjectID)this.makeObjectID(string);
        if (objectID == null) {
            throw new IllegalArgumentException("Invalid OID given: " + string);
        }
        try {
            Pair pair = this.rep.getSplittedObjectID(objectID);
            Vector<String> vector = new Vector<String>(2);
            vector.add(pair.first != null ? pair.first.toString() : null);
            vector.add(pair.second != null ? pair.second.toString() : null);
            return vector;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid OID given: " + string);
        }
    }

    public IObjectType getObjectClass(String string) {
        try {
            Vector vector = this.getObjectClassOID(string);
            MIBObjectType mIBObjectType = this.rep.getObjectType((ObjectID)vector.firstElement());
            return mIBObjectType;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

