/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class IModuleInfoSorter {
    private ModuleInfoSorter sorter = null;

    public IModuleInfoSorter(IModuleInfo[] iModuleInfoArray) {
        ModuleInfo[] moduleInfoArray = new ModuleInfo[iModuleInfoArray.length];
        for (int i = 0; i < iModuleInfoArray.length; ++i) {
            moduleInfoArray[i] = new ModuleInfo(iModuleInfoArray[i].getModuleName(), iModuleInfoArray[i].getImports());
        }
        this.sorter = new ModuleInfoSorter(moduleInfoArray);
        this.sorter.resetPool();
    }

    public boolean sort() {
        return this.sorter.sort();
    }

    public IModuleInfo[] getSortedList() {
        return this.sorter.getSortedList();
    }

    public IModuleInfo[] getFailedList() {
        return this.sorter.getFailedList();
    }

    public String[] getMissingModules() {
        return this.sorter.getMissingModules();
    }

    public void setPool(IModuleInfo[] iModuleInfoArray) {
        this.sorter.setPool((ModuleInfo[])iModuleInfoArray);
    }

    public void resetPool() {
        this.sorter.resetPool();
    }

    public static Vector sortModulesByImports(List list) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>(list.size() + 1);
        ModuleInfo[] moduleInfoArray = new ModuleInfo[list.size()];
        Hashtable<String, IModule> hashtable = new Hashtable<String, IModule>(moduleInfoArray.length);
        int n = 0;
        for (IModule iModule : list) {
            objectArray = new ModuleInfo(iModule.getModuleName(), iModule.getImportSources());
            objectArray.userObject = iModule;
            moduleInfoArray[n] = objectArray;
            hashtable.put(iModule.getModuleName(), iModule);
            ++n;
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < moduleInfoArray.length; ++i) {
            objectArray = moduleInfoArray[i].getImports();
            for (int j = 0; j < objectArray.length; ++j) {
                if (hashtable.get(objectArray[j]) != null) continue;
                vector2.add(new ModuleInfo((String)objectArray[j], new String[0]));
            }
        }
        ModuleInfoSorter moduleInfoSorter = new ModuleInfoSorter(moduleInfoArray);
        objectArray = new ModuleInfo[vector2.size()];
        vector2.toArray(objectArray);
        moduleInfoSorter.setPool((ModuleInfo[])objectArray);
        moduleInfoSorter.sort();
        ModuleInfo[] moduleInfoArray2 = moduleInfoSorter.getSortedList();
        for (int i = 0; i < moduleInfoArray2.length; ++i) {
            vector.add(moduleInfoArray2[i].userObject);
        }
        ModuleInfo[] moduleInfoArray3 = moduleInfoSorter.getFailedList();
        for (int i = 0; i < moduleInfoArray3.length; ++i) {
            vector.add(moduleInfoArray3[i].userObject);
        }
        return vector;
    }
}

