/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smi.IModule;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smiparser.LenientSMI2Java;
import com.agentpp.smiparser.ParseException;
import com.agentpp.smiparser.SMI2Java;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.TokenMgrError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class TextFileRepositoryManager
extends DefaultRepositoryManager {
    private boolean lenientParseMode = false;
    private int maxCacheEntries = 50;
    private Map repCache = new LinkedHashMap(){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() >= TextFileRepositoryManager.this.maxCacheEntries;
        }
    };

    protected MIBModule loadModuleFromFile(String string, boolean bl) throws IOException, ClassNotFoundException {
        MIBModule mIBModule;
        Object object;
        RepositoryEvent repositoryEvent = new RepositoryEvent(this, string);
        this.fireReadModule(repositoryEvent);
        InputStream inputStream = null;
        String string2 = string;
        boolean bl2 = true;
        if (repositoryEvent.getInputStream() == null) {
            if (repositoryEvent.isUseDefaults()) {
                object = new File(this.path.getPath(), string);
                if (((File)object).exists()) {
                    inputStream = new FileInputStream((File)object);
                } else {
                    object = this.getModuleFile(string);
                    inputStream = new FileInputStream((File)object);
                }
                if (inputStream != null) {
                    string2 = ((File)object).getPath();
                }
                if ((mIBModule = this.getModuleFromCache(string, ((File)object).lastModified())) != null) {
                    return mIBModule;
                }
            }
            if (inputStream == null) {
                bl2 = false;
                object = "modules/" + string + ".cmib";
                inputStream = IModule.class.getResourceAsStream((String)object);
                if (inputStream == null) {
                    throw new FileNotFoundException(string);
                }
            }
        } else {
            inputStream = repositoryEvent.getInputStream();
        }
        try {
            object = this.parse(inputStream, string2, this, this.lenientParseMode);
            mIBModule = ((MIBRepository)object).getModule(string);
            this.fireAfterReadModule(repositoryEvent);
            if (bl2) {
                this.repCache.put(mIBModule.getModuleName(), new RepositoryCacheEntry(null, mIBModule));
            }
            return mIBModule;
        }
        catch (SMIParseException sMIParseException) {
            throw new IOException(sMIParseException.getMessage());
        }
    }

    private MIBModule getModuleFromCache(String string, long l) {
        RepositoryCacheEntry repositoryCacheEntry = (RepositoryCacheEntry)this.repCache.get(string);
        if (repositoryCacheEntry != null) {
            if (repositoryCacheEntry.lastUpdate > l) {
                return (MIBModule)repositoryCacheEntry.module.getClone();
            }
            if (this.verbose) {
                System.out.println("MIB module '" + string + "' changed on disk");
            }
            this.repCache.remove(string);
        }
        return null;
    }

    private synchronized Integer getModuleID(String string, boolean bl) throws IOException {
        Properties properties = this.getModuleIndex();
        String string2 = properties.getProperty(string + ".id");
        if (string2 != null) {
            return new Integer(string2);
        }
        if (bl) {
            Integer n = this.createModuleID(string);
            properties.setProperty(string + ".id", "" + n);
            this.setModuleIndex(properties);
        }
        return null;
    }

    private MIBRepository parse(InputStream inputStream, String string, ImportModuleListener importModuleListener, boolean bl) throws SMIParseException {
        MIBRepository mIBRepository = null;
        if (this.verbose) {
            System.out.print("Loading MIB file [" + string + "]...");
        }
        SMIParser sMIParser = new SMIParser(inputStream);
        if (bl) {
            sMIParser.setLenient(1);
        }
        sMIParser.setMaxErrors(this.maxErrors);
        SMIRepository sMIRepository = null;
        try {
            sMIRepository = sMIParser.Input(string);
            sMIRepository.setImporter(importModuleListener);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            block25: {
                if (this.verbose) {
                    System.out.println(parseException.getMessage());
                    parseException.printStackTrace();
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (!this.verbose) break block25;
                    iOException.printStackTrace();
                }
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = new SMIParseException(parseException.getMessage(), parseException.errorType, parseException);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                System.out.println(throwable.getMessage());
                throwable.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(throwable.getMessage(), 50, (TokenMgrError)throwable);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throwable.printStackTrace();
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (sMIParser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = (SMIParseException)sMIParser.getErrors().get(0);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            mIBRepository = this.getRepository(sMIRepository, sMIParser.getErrors(), bl);
        }
        catch (SMIParseException sMIParseException) {
            if (this.verbose) {
                System.out.println(sMIParseException.getMessage());
                sMIParseException.printStackTrace();
                System.out.println(", failed.");
            }
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SMIParseException(throwable.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mIBRepository;
    }

    protected MIBRepository getRepository(SMIRepository sMIRepository, List list, boolean bl) throws SMIParseException {
        SMI2Java sMI2Java = bl ? new LenientSMI2Java(sMIRepository, this.options) : new SMI2Java(sMIRepository, this.options);
        sMI2Java.setErrors(list);
        sMI2Java.setMaxErrors(this.maxErrors);
        Vector vector = new Vector();
        try {
            sMIRepository.jjtAccept(sMI2Java, vector);
        }
        catch (Exception exception) {
            if (sMI2Java.getErrors().size() > 0) {
                SMIParseException sMIParseException = (SMIParseException)sMI2Java.getErrors().get(0);
                sMIParseException.setErrorList(sMI2Java.getErrors());
                throw sMIParseException;
            }
            exception.printStackTrace();
            throw new SMIParseException(exception.getMessage(), 0);
        }
        if (sMI2Java.getErrors().size() > 0) {
            SMIParseException sMIParseException = (SMIParseException)sMI2Java.getErrors().get(0);
            sMIParseException.setErrorList(sMI2Java.getErrors());
            throw sMIParseException;
        }
        MIBRepository mIBRepository = sMI2Java.getRepository();
        mIBRepository.structureChanged();
        if (bl) {
            Iterator iterator = mIBRepository.modulesIterator();
            while (iterator.hasNext()) {
                MIBModule mIBModule = (MIBModule)iterator.next();
                mIBModule.setParseMode(1);
            }
        }
        return mIBRepository;
    }

    protected File getModuleFile(String string) throws IOException {
        Properties properties = this.getModuleIndex();
        String string2 = properties.getProperty(string + ".path", string);
        return new File(string2);
    }

    private Properties getModuleIndex() throws IOException {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(this.path, "module-index.properties"));
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized boolean saveModulesFromRepository(MIBRepository mIBRepository) throws IOException {
        boolean bl = true;
        Properties properties = this.getModuleIndex();
        Iterator iterator = mIBRepository.modulesIterator();
        while (iterator.hasNext()) {
            MIBModule mIBModule = (MIBModule)iterator.next();
            RepositoryEvent repositoryEvent = new RepositoryEvent(this, mIBModule.getModuleName(), mIBModule);
            this.fireWriteModule(repositoryEvent);
            OutputStream outputStream = repositoryEvent.getOutputStream();
            File file = new File(this.path.getPath() + File.separatorChar + mIBModule.getModuleName());
            if (outputStream == null) {
                if (!repositoryEvent.isUseDefaults()) return false;
                String string = mIBModule.getFileName();
                if (string != null) {
                    file = new File(this.path.getPath(), new File(string).getName());
                }
                if (file.exists()) {
                    bl = false;
                }
                this.repCache.put(mIBModule.getModuleName(), new RepositoryCacheEntry(file, mIBModule));
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                outputStream = fileOutputStream;
            } else {
                this.repCache.put(mIBModule.getModuleName(), new RepositoryCacheEntry(file, mIBModule));
            }
            outputStream.write(mIBModule.toSMI(1, mIBRepository, MIBObject.getLineSeparator()).getBytes());
            outputStream.flush();
            outputStream.close();
            properties.setProperty(mIBModule.getModuleName() + ".file", file.getPath());
            properties.setProperty(mIBModule.getModuleName() + ".id", "" + mIBModule.getModuleID());
        }
        this.setModuleIndex(properties);
        return bl;
    }

    private void setModuleIndex(Properties properties) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.path, "module-index.properties"));
        properties.store(fileOutputStream, "Text MIB Repository - Last Update: " + new Date());
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    public String[] getModuleNames() throws IOException {
        String[] stringArray = super.getModuleNames();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        Properties properties = this.getModuleIndex();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            if (!string.endsWith(".file")) continue;
            String string2 = string.substring(0, string.length() - 5);
            File file = new File((String)entry.getValue());
            if (!file.exists() || !file.isFile()) continue;
            hashSet.add(string2);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public boolean isModuleAvailable(String string) {
        boolean bl = super.isModuleAvailable(string);
        if (!bl) {
            try {
                Properties properties = this.getModuleIndex();
                String string2 = properties.getProperty(string + ".file");
                if (string2 != null) {
                    File file = new File(string2);
                    return file.exists() && file.isFile();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void setLenientParseMode(boolean bl) {
        this.lenientParseMode = bl;
    }

    public boolean isLenientParseMode() {
        return this.lenientParseMode;
    }

    class RepositoryCacheEntry {
        private long lastUpdate;
        private MIBModule module;

        public RepositoryCacheEntry(File file, MIBModule mIBModule) {
            this.module = mIBModule;
            this.lastUpdate = System.currentTimeMillis();
        }
    }
}

