/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import java.util.Enumeration;

public class MIBRepositoryImporter
implements ImportModuleListener {
    private MIBRepository rep;
    private int maxModuleID = -1;
    private boolean cloneObjects = true;

    public MIBRepositoryImporter(MIBRepository mIBRepository) {
        this.rep = mIBRepository;
    }

    public MIBRepositoryImporter(MIBRepository mIBRepository, boolean bl) {
        this(mIBRepository);
        this.cloneObjects = bl;
    }

    public Integer createModuleID(String string) {
        MIBModule mIBModule = this.rep.getModule(string);
        if (mIBModule != null) {
            return mIBModule.getModuleID();
        }
        return new Integer(this.nextModuleID());
    }

    private synchronized int nextModuleID() {
        if (this.maxModuleID < 0) {
            Enumeration enumeration = this.rep.getModulesSortedByName();
            while (enumeration.hasMoreElements()) {
                MIBModule mIBModule = (MIBModule)enumeration.nextElement();
                Integer n = mIBModule.getModuleID();
                if (n == null || n <= this.maxModuleID) continue;
                this.maxModuleID = n;
            }
        }
        return ++this.maxModuleID;
    }

    public void freeModuleID(Integer n, String string) {
    }

    public void importModule(ImportModuleEvent importModuleEvent) {
        String string = importModuleEvent.getModuleName();
        MIBModule mIBModule = this.rep.getModule(string);
        if (mIBModule != null) {
            IObject[] iObjectArray = mIBModule.getObjects();
            if (this.cloneObjects) {
                for (int i = 0; i < iObjectArray.length; ++i) {
                    iObjectArray[i] = ((MIBObject)iObjectArray[i]).getClone();
                }
            }
            importModuleEvent.setObjects(iObjectArray);
        }
    }
}

