/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InMemoryRepository
implements RepositoryListener {
    private Map repository = new HashMap();

    public void deleteModule(RepositoryEvent repositoryEvent) {
        repositoryEvent.setModuleDeleted(this.repository.remove(repositoryEvent.getModuleName()) != null);
    }

    public void readModule(RepositoryEvent repositoryEvent) {
        ByteArray byteArray = (ByteArray)this.repository.get(repositoryEvent.getModuleName());
        if (byteArray == null) {
            repositoryEvent.setUseDefaults(false);
            return;
        }
        repositoryEvent.setInputStream(new ByteArrayInputStream(byteArray.bytes));
    }

    public void writeModule(RepositoryEvent repositoryEvent) {
        repositoryEvent.setOutputStream(new CacheOutputStream(repositoryEvent.getModuleName()));
    }

    public Set getModuleNames() {
        return this.repository.keySet();
    }

    public String[] listModuleNames() {
        return this.repository.keySet().toArray(new String[this.repository.size()]);
    }

    class CacheOutputStream
    extends ByteArrayOutputStream {
        private String moduleName;

        CacheOutputStream(String string) {
            this.moduleName = string;
        }

        public void close() throws IOException {
            super.close();
            byte[] byArray = super.toByteArray();
            InMemoryRepository.this.repository.put(this.moduleName, new ByteArray(byArray));
        }
    }

    private class ByteArray {
        byte[] bytes;

        ByteArray(byte[] byArray) {
            this.bytes = byArray;
        }
    }
}

