/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.repository.ProgressCallback;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ExtRepsitoryListener;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import com.agentpp.smiparser.FindImportsVisitor;
import com.agentpp.smiparser.LenientSMI2Java;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ParseException;
import com.agentpp.smiparser.SMI2Java;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIParserVisitor;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.TokenMgrError;
import com.objectspace.jgl.OrderedMap;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class DefaultRepositoryManager
implements RepositoryManager {
    public static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    protected static String resClassName = "com.agentpp.repository.DefaultRepositoryManagerRes";
    protected RepositoryManager rm = this;
    protected File path = null;
    protected static ResourceBundle res = null;
    public boolean verbose = false;
    protected int options = 4;
    private transient Vector repositoryListeners;
    private boolean importTableDependencies = false;
    private int initialModuleID = 0;
    public static final int DEFAULT_MODE = 0;
    public static final int LENIENT_MODE = 1;
    protected int maxErrors = 20;
    private static final int COMPRESSION_FLAG = -1;
    private static final int COMPRESSION_MODE_GZIP = 1;
    private boolean useCompression;
    private int maxCacheEntries = 20;
    private Map repCache = new LinkedHashMap(this.maxCacheEntries, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() >= DefaultRepositoryManager.this.maxCacheEntries;
        }
    };

    public DefaultRepositoryManager() {
        try {
            this.initialModuleID = Integer.parseInt(System.getProperty("com.agentpp.smi.initialModuleID", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    public void open(File file) throws IOException {
        this.repCache.clear();
        this.path = file;
        if (!this.path.exists() || !this.path.isDirectory()) {
            throw new IOException("Repository path is not a directory");
        }
    }

    public File getRepositoryDirectory() {
        return this.path;
    }

    public void close() throws IOException {
    }

    protected ModuleInfo[] updateRepository(SMIRepository sMIRepository, List list, boolean bl, String string) throws SMIParseException {
        ModuleInfo[] moduleInfoArray;
        SMI2Java sMI2Java = bl ? new LenientSMI2Java(sMIRepository, this.options) : new SMI2Java(sMIRepository, this.options);
        sMI2Java.setErrors(list);
        sMI2Java.setMaxErrors(this.maxErrors);
        Vector vector = new Vector();
        try {
            sMIRepository.jjtAccept(sMI2Java, vector);
        }
        catch (Exception exception) {
            if (sMI2Java.getErrors().size() > 0) {
                SMIParseException sMIParseException = (SMIParseException)sMI2Java.getErrors().get(0);
                sMIParseException.setErrorList(sMI2Java.getErrors());
                throw sMIParseException;
            }
            exception.printStackTrace();
            throw new SMIParseException(exception.getMessage(), 0);
        }
        if (sMI2Java.getErrors().size() > 0) {
            SMIParseException sMIParseException = (SMIParseException)sMI2Java.getErrors().get(0);
            sMIParseException.setErrorList(sMI2Java.getErrors());
            throw sMIParseException;
        }
        MIBRepository mIBRepository = sMI2Java.getRepository();
        mIBRepository.structureChanged();
        boolean bl2 = Boolean.getBoolean("com.agentpp.smi.storeMIBFileName");
        if (bl) {
            moduleInfoArray = mIBRepository.modulesIterator();
            while (moduleInfoArray.hasNext()) {
                MIBModule mIBModule = (MIBModule)moduleInfoArray.next();
                mIBModule.setParseMode(1);
                if (!bl2 || string == null) continue;
                mIBModule.setFileName(new File(string).getName());
            }
        } else if (bl2 && string != null) {
            moduleInfoArray = mIBRepository.modulesIterator();
            while (moduleInfoArray.hasNext()) {
                MIBModule mIBModule = (MIBModule)moduleInfoArray.next();
                mIBModule.setFileName(new File(string).getName());
            }
        }
        try {
            this.saveModulesFromRepository(mIBRepository);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SMIParseException("Could not write to repository: " + iOException.getMessage(), 20);
        }
        moduleInfoArray = new ModuleInfo[vector.size()];
        vector.toArray(moduleInfoArray);
        return moduleInfoArray;
    }

    private SMI2Java createVisitor(SMIRepository sMIRepository, List list, boolean bl) throws SMIParseException {
        SMI2Java sMI2Java = bl ? new LenientSMI2Java(sMIRepository, this.options) : new SMI2Java(sMIRepository, this.options);
        sMI2Java.setErrors(list);
        sMI2Java.setMaxErrors(this.maxErrors);
        return sMI2Java;
    }

    protected MIBRepository createRepository(SMIRepository sMIRepository, List list, boolean bl, boolean bl2) throws SMIParseException {
        SMI2Java sMI2Java = this.createVisitor(sMIRepository, list, bl);
        Vector vector = new Vector();
        sMIRepository.jjtAccept(sMI2Java, vector);
        MIBRepository mIBRepository = sMI2Java.getRepository();
        mIBRepository.freeUserObjects();
        mIBRepository.structureChanged();
        if (!bl2 && sMI2Java.getErrors().size() > this.maxErrors) {
            SMIParseException sMIParseException = (SMIParseException)sMI2Java.getErrors().get(0);
            sMIParseException.setErrorList(sMI2Java.getErrors());
            throw sMIParseException;
        }
        if (bl) {
            Iterator iterator = mIBRepository.modulesIterator();
            while (iterator.hasNext()) {
                MIBModule mIBModule = (MIBModule)iterator.next();
                mIBModule.setParseMode(1);
            }
        }
        return mIBRepository;
    }

    protected ModuleInfo[] getModuleInfo(SMIRepository sMIRepository) throws SMIParseException {
        FindImportsVisitor findImportsVisitor = new FindImportsVisitor(sMIRepository);
        Vector vector = new Vector();
        sMIRepository.jjtAccept(findImportsVisitor, vector);
        ModuleInfo[] moduleInfoArray = new ModuleInfo[vector.size()];
        vector.toArray(moduleInfoArray);
        return moduleInfoArray;
    }

    public synchronized void checkModules(InputStream inputStream) throws SMIParseException {
        this.checkModules(inputStream, false);
    }

    public synchronized ModuleInfo[] checkModules(InputStream inputStream, boolean bl) throws SMIParseException {
        SMIParser sMIParser = new SMIParser(inputStream);
        SMIRepository sMIRepository = null;
        if (bl) {
            sMIParser.setLenient(1);
        }
        sMIParser.setMaxErrors(this.maxErrors);
        try {
            sMIRepository = sMIParser.Input("");
            sMIRepository.setImporter(this);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = new SMIParseException(parseException.getMessage(), parseException.errorType, parseException);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                TokenMgrError tokenMgrError = (TokenMgrError)throwable;
                throw new SMIParseException(tokenMgrError.getMessage(), 50, tokenMgrError);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (sMIParser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = (SMIParseException)sMIParser.getErrors().get(0);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        SMI2Java sMI2Java = bl ? new LenientSMI2Java(sMIRepository, this.options) : new SMI2Java(sMIRepository, this.options);
        sMI2Java.setErrors(sMIParser.getErrors());
        sMI2Java.setMaxErrors(this.maxErrors);
        Vector vector = new Vector();
        sMIRepository.jjtAccept(sMI2Java, vector);
        if (sMI2Java.getErrors().size() > 0) {
            SMIParseException sMIParseException = (SMIParseException)sMI2Java.getErrors().get(0);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        return this.getModuleInfo(sMIRepository);
    }

    public ModuleInfo[] getModuleInfo(File file) throws SMIParseException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SMIParseException(file.getPath(), 10);
        }
        if (this.verbose) {
            System.out.print("Loading IMPORTS from file [" + file.getPath() + "]...");
        }
        return this.getModuleInfo(fileInputStream, file.getPath());
    }

    public ModuleInfo[] getModuleInfo(ZipFile zipFile) throws SMIParseException {
        try {
            Vector<ModuleInfo> vector = new Vector<ModuleInfo>();
            ModuleInfo[] moduleInfoArray = zipFile.entries();
            while (moduleInfoArray.hasMoreElements()) {
                Object[] objectArray;
                ModuleInfo[] moduleInfoArray2;
                ZipEntry zipEntry = moduleInfoArray.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                if (this.verbose) {
                    System.out.print("Loading IMPORTS from file [" + zipEntry.getName() + "]...");
                }
                try {
                    moduleInfoArray2 = this.getModuleInfo(inputStream, zipEntry.getName());
                }
                catch (SMIParseException sMIParseException) {
                    moduleInfoArray2 = new ModuleInfo[]{new ModuleInfo("invalid ")};
                    moduleInfoArray2[0].path = new File(zipEntry.getName());
                    objectArray = new Object[]{zipFile, zipEntry};
                    moduleInfoArray2[0].userObject = objectArray;
                }
                for (int i = 0; i < moduleInfoArray2.length; ++i) {
                    objectArray = new Object[]{zipFile, zipEntry};
                    moduleInfoArray2[i].userObject = objectArray;
                }
                vector.addAll(Arrays.asList(moduleInfoArray2));
            }
            moduleInfoArray = new ModuleInfo[vector.size()];
            vector.toArray(moduleInfoArray);
            return moduleInfoArray;
        }
        catch (IOException iOException) {
            throw new SMIParseException(iOException.getMessage(), 20);
        }
    }

    public ModuleInfo[] getModuleInfo(ZipInputStream moduleInfoArray) throws SMIParseException {
        try {
            ModuleInfo[] moduleInfoArray2;
            ZipEntry zipEntry;
            ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
            while ((zipEntry = moduleInfoArray.getNextEntry()) != null) {
                Object[] objectArray;
                ModuleInfo[] moduleInfoArray3;
                moduleInfoArray2 = moduleInfoArray;
                if (this.verbose) {
                    System.out.print("Loading IMPORTS from file [" + zipEntry.getName() + "]...");
                }
                try {
                    moduleInfoArray3 = this.getModuleInfo((InputStream)moduleInfoArray2, zipEntry.getName());
                }
                catch (SMIParseException sMIParseException) {
                    moduleInfoArray3 = new ModuleInfo[]{new ModuleInfo("invalid ")};
                    moduleInfoArray3[0].path = new File(zipEntry.getName());
                    objectArray = new Object[]{moduleInfoArray, zipEntry};
                    moduleInfoArray3[0].userObject = objectArray;
                }
                for (int i = 0; i < moduleInfoArray3.length; ++i) {
                    objectArray = new Object[]{moduleInfoArray, zipEntry};
                    moduleInfoArray3[i].userObject = objectArray;
                }
                arrayList.addAll(Arrays.asList(moduleInfoArray3));
            }
            moduleInfoArray2 = new ModuleInfo[arrayList.size()];
            arrayList.toArray(moduleInfoArray2);
            return moduleInfoArray2;
        }
        catch (IOException iOException) {
            throw new SMIParseException(iOException.getMessage(), 20);
        }
    }

    public ModuleInfo[] getModuleInfo(InputStream inputStream, String string) throws SMIParseException {
        ModuleInfo[] moduleInfoArray = null;
        SMIParser sMIParser = new SMIParser(inputStream);
        SMIRepository sMIRepository = null;
        try {
            sMIRepository = sMIParser.Input(string);
            sMIRepository.setImporter(this);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(parseException.getMessage(), parseException.errorType);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(throwable.getMessage(), 50, (TokenMgrError)throwable);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            moduleInfoArray = this.getModuleInfo(sMIRepository);
        }
        catch (SMIParseException sMIParseException) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SMIParseException(throwable.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < moduleInfoArray.length; ++i) {
            moduleInfoArray[i].path = new File(string);
        }
        return moduleInfoArray;
    }

    public synchronized MIBRepository createRepository(InputStream inputStream, ImportModuleListener importModuleListener) throws SMIParseException {
        return this.createRepository(inputStream, importModuleListener, false);
    }

    public synchronized MIBRepository createRepository(InputStream inputStream, ImportModuleListener importModuleListener, boolean bl) throws SMIParseException {
        MIBRepository mIBRepository = null;
        SMIParser sMIParser = new SMIParser(inputStream);
        sMIParser.setMaxErrors(bl ? Integer.MAX_VALUE : this.maxErrors);
        SMIRepository sMIRepository = null;
        try {
            sMIRepository = sMIParser.Input(inputStream.toString());
            sMIRepository.setImporter(importModuleListener);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = new SMIParseException(parseException.getMessage(), parseException.errorType, parseException);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(throwable.getMessage(), 50, (TokenMgrError)throwable);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            mIBRepository = this.createRepository(sMIRepository, sMIParser.getErrors(), false, bl);
        }
        catch (SMIParseException sMIParseException) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SMIParseException(throwable.getMessage(), 0);
        }
        if (!bl && sMIParser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = (SMIParseException)sMIParser.getErrors().get(0);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mIBRepository;
    }

    public ModuleInfo[] addModules(File file) throws SMIParseException {
        return this.addModules(file, this);
    }

    public synchronized ModuleInfo[] addModules(File file, ImportModuleListener importModuleListener) throws SMIParseException {
        try {
            return this.addModules(new FileInputStream(file), file.getPath(), importModuleListener);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SMIParseException(file.getPath(), 10);
        }
    }

    public ModuleInfo[] addModules(InputStream inputStream, String string) throws SMIParseException {
        return this.addModules(inputStream, string, this);
    }

    public synchronized ModuleInfo[] addModules(InputStream inputStream, String string, ImportModuleListener importModuleListener) throws SMIParseException {
        return this.parse(inputStream, string, importModuleListener, false);
    }

    private ModuleInfo[] parse(InputStream inputStream, String string, ImportModuleListener importModuleListener, boolean bl) throws SMIParseException {
        ModuleInfo[] moduleInfoArray = null;
        if (this.verbose) {
            System.out.print("Loading MIB file [" + string + "]...");
        }
        SMIParser sMIParser = new SMIParser(inputStream);
        if (bl) {
            sMIParser.setLenient(1);
        }
        sMIParser.setMaxErrors(this.maxErrors);
        SMIRepository sMIRepository = null;
        try {
            sMIRepository = sMIParser.Input(string);
            sMIRepository.setImporter(importModuleListener);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = new SMIParseException(parseException.getMessage(), parseException.errorType, parseException);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (throwable instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(throwable.getMessage(), 50, (TokenMgrError)throwable);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            throwable.printStackTrace();
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (sMIParser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException sMIParseException = (SMIParseException)sMIParser.getErrors().get(0);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            moduleInfoArray = this.updateRepository(sMIRepository, sMIParser.getErrors(), bl, string);
        }
        catch (SMIParseException sMIParseException) {
            if (this.verbose) {
                System.out.println(", failed.");
            }
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SMIParseException(throwable.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return moduleInfoArray;
    }

    public synchronized ModuleInfo[] addModulesLeniently(InputStream inputStream, String string) throws SMIParseException {
        return this.parse(inputStream, string, this, true);
    }

    public synchronized ModuleInfo[] addModulesLeniently(File file) throws SMIParseException {
        try {
            return this.parse(new FileInputStream(file), file.getPath(), this, true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SMIParseException(file.getPath(), 10);
        }
    }

    public void freeModuleID(Integer n, String string) {
        try {
            this.freeModuleID(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean removeModule(String string) throws IOException {
        Comparable comparable;
        block4: {
            try {
                comparable = this.loadModuleFromFile(string, true);
                if (comparable == null) break block4;
                RepositoryEvent repositoryEvent = new RepositoryEvent(this, string);
                this.fireDeleteModule(repositoryEvent);
                if (!repositoryEvent.isModuleDeleted()) {
                    if (repositoryEvent.isUseDefaults()) {
                        this.freeModuleID(((MIBObject)comparable).getModuleID(), string);
                        break block4;
                    }
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        comparable = new File(this.path.getPath() + File.separatorChar + string);
        return ((File)comparable).delete();
    }

    public Integer createModuleID(String string) {
        try {
            return this.createModuleID();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized Integer createModuleID() throws IOException {
        Integer n;
        Integer n2 = n = new Integer(this.initialModuleID);
        try {
            if (this.path != null) {
                Closeable closeable;
                Closeable closeable2;
                File file = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
                Vector vector = new Vector();
                if (file.exists()) {
                    closeable2 = new FileInputStream(file);
                    closeable = new ObjectInputStream((InputStream)closeable2);
                    n2 = (Integer)((ObjectInputStream)closeable).readObject();
                    vector = (Vector)((ObjectInputStream)closeable).readObject();
                    ((ObjectInputStream)closeable).close();
                }
                if (vector.size() > 0) {
                    n = (Integer)vector.firstElement();
                    vector.removeElementAt(0);
                } else {
                    if ((n2 = new Integer(n2 + 1)) < 0) {
                        n2 = new Integer(this.initialModuleID);
                    }
                    n = n2;
                }
                closeable2 = new FileOutputStream(file);
                closeable = new ObjectOutputStream((OutputStream)closeable2);
                ((ObjectOutputStream)closeable).writeObject(n2);
                ((ObjectOutputStream)closeable).writeObject(vector);
                ((ObjectOutputStream)closeable).flush();
                ((ObjectOutputStream)closeable).close();
            } else {
                n = new Integer(this.initialModuleID++);
            }
            return n;
        }
        catch (Exception exception) {
            throw new IOException("Could not create unique module id: " + exception.getMessage());
        }
    }

    public void freeModuleID(Integer n) throws IOException {
        if (n <= this.initialModuleID) {
            return;
        }
        try {
            if (this.path != null) {
                File file = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
                Integer n2 = new Integer(this.initialModuleID);
                Vector vector = new Vector();
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    n2 = (Integer)objectInputStream.readObject();
                    vector = (Vector)objectInputStream.readObject();
                    objectInputStream.close();
                    vector.addElement(n);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                    objectOutputStream.writeObject(n2);
                    objectOutputStream.writeObject(vector);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
            }
        }
        catch (Exception exception) {
            throw new IOException("Could not free module id: " + exception.getMessage());
        }
    }

    public MIBObject[] getImportedObjects(Hashtable hashtable, String string) throws IOException {
        return this.getImportedObjects(hashtable, string, false, false);
    }

    public MIBObject[] getImportedObjects(Map map, String string, boolean bl, boolean bl2) throws IOException {
        try {
            MIBModule mIBModule = this.loadModuleFromFile(string, true);
            map.put(mIBModule.getModuleName(), mIBModule.getModuleID());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (mIBModule.getImports() == null) {
                return new MIBObject[0];
            }
            if (bl) {
                arrayList.add(mIBModule);
            }
            for (int i = 0; i < mIBModule.getImports().length; ++i) {
                Object object;
                Object object22;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                for (int j = 0; j < mIBModule.getImports()[i].getImports().length; ++j) {
                    hashMap2.put(mIBModule.getImports()[i].getImports()[j], mIBModule.getImports()[i].getImports()[j]);
                }
                MIBObject[] mIBObjectArray = this.getObjects(mIBModule.getImports()[i].getSource());
                if (bl2 && mIBObjectArray != null && mIBObjectArray.length > 0) {
                    arrayList.add(mIBObjectArray[0]);
                }
                HashMap<String, MIBObject> hashMap3 = new HashMap<String, MIBObject>(mIBObjectArray.length + 10);
                for (int j = 0; j < mIBObjectArray.length; ++j) {
                    int n;
                    object22 = mIBObjectArray[j];
                    hashMap3.put(object22.getName(), (MIBObject)object22);
                    if (hashMap2.get(object22.getName()) == null && !(object22 instanceof MIBTextualConvention)) continue;
                    arrayList.add(object22);
                    if (!this.isImportTableDependencies() || !(object22 instanceof MIBObjectType) || !((MIBObjectType)(object = (MIBObjectType)object22)).isTable()) continue;
                    String[] stringArray = ((MIBObjectType)object).getIndexPart().getIndexPart();
                    for (n = 0; n < stringArray.length; ++n) {
                        hashMap.put(stringArray[n], stringArray[n]);
                    }
                    stringArray = ((MIBObjectType)object).getTableEntries();
                    for (n = 0; n < stringArray.length; ++n) {
                        hashMap.put(stringArray[n], stringArray[n]);
                    }
                }
                for (Object object22 : hashMap.keySet()) {
                    object = hashMap3.get(object22);
                    if (object == null) continue;
                    arrayList.add((MIBObject)object);
                }
                String string2 = mIBModule.getImports()[i].getSource();
                if (map.get(string2) != null) continue;
                map.put(string2, string2);
                object22 = this.getImportedObjects(map, string2, bl2, bl2);
                for (int j = 0; j < ((MIBObject[])object22).length; ++j) {
                    if (!(object22[j] instanceof MIBTextualConvention) && hashMap.get(object22[j].getName()) == null) continue;
                    arrayList.add(object22[j]);
                }
            }
            return arrayList.toArray(new MIBObject[arrayList.size()]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Incompatible repository format: " + classNotFoundException.getMessage());
        }
    }

    public MIBObject[] getImportedObjects(String string) throws IOException {
        return this.getImportedObjects(new Hashtable(), string);
    }

    public void saveModule(MIBModule mIBModule) throws IOException {
        mIBModule.setLastChange(new Date(System.currentTimeMillis()));
        MIBRepository mIBRepository = new MIBRepository(mIBModule.getObjects());
        this.saveModulesFromRepository(mIBRepository);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean saveModulesFromRepository(MIBRepository mIBRepository) throws IOException {
        boolean bl = true;
        Iterator iterator = mIBRepository.modulesIterator();
        while (iterator.hasNext()) {
            ObjectOutputStream objectOutputStream;
            OutputStream outputStream;
            Object object;
            MIBModule mIBModule = (MIBModule)iterator.next();
            RepositoryEvent repositoryEvent = new RepositoryEvent(this, mIBModule.getModuleName(), mIBModule);
            this.fireWriteModule(repositoryEvent);
            if (repositoryEvent.getOutputStream() == null) {
                if (!repositoryEvent.isUseDefaults()) return false;
                object = new File(this.path.getPath(), mIBModule.getModuleName());
                if (((File)object).exists()) {
                    bl = false;
                }
                outputStream = new FileOutputStream(((File)object).getPath());
                objectOutputStream = new ObjectOutputStream(outputStream);
            } else {
                objectOutputStream = new ObjectOutputStream(repositoryEvent.getOutputStream());
            }
            if (this.useCompression) {
                objectOutputStream.writeInt(-1);
                object = new GZIPOutputStream(objectOutputStream);
                outputStream = new ObjectOutputStream((OutputStream)object);
                DefaultRepositoryManager.writeObjects(mIBRepository, mIBModule, (ObjectOutputStream)outputStream);
                ((ObjectOutputStream)outputStream).flush();
                ((ObjectOutputStream)outputStream).close();
            } else {
                DefaultRepositoryManager.writeObjects(mIBRepository, mIBModule, objectOutputStream);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            this.repCache.put(mIBModule.getModuleName(), new RepositoryCacheEntry((MIBModule)mIBModule.getClone()));
        }
        return bl;
    }

    private static void writeObjects(MIBRepository mIBRepository, MIBModule mIBModule, ObjectOutputStream objectOutputStream) throws IOException {
        int n = mIBModule.size();
        if (mIBModule.getName() != null && mIBModule.objectsByName().get(mIBModule.getName()) == null) {
            ++n;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.writeObject(mIBModule);
        Enumeration enumeration = mIBModule.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (mIBObject instanceof MIBModule) continue;
            try {
                objectOutputStream.writeObject(mIBObject);
            }
            catch (Exception exception) {
                System.err.println("Failed to serialize object: " + mIBObject.toSMI(1, mIBModule.getSMIVersion(), mIBRepository, "\n"));
                throw new RuntimeException(exception);
            }
        }
    }

    protected MIBModule loadModuleFromFile(String string, boolean bl) throws IOException, ClassNotFoundException {
        Object object;
        RepositoryEvent repositoryEvent = new RepositoryEvent(this, string);
        this.fireReadModule(repositoryEvent);
        InputStream inputStream = null;
        boolean bl2 = true;
        if (repositoryEvent.getInputStream() == null) {
            if (repositoryEvent.isUseDefaults() && ((File)(object = new File(this.path.getPath(), string))).exists()) {
                MIBModule mIBModule = this.getModuleFromCache(string, ((File)object).lastModified());
                if (mIBModule != null) {
                    return mIBModule;
                }
                inputStream = new FileInputStream((File)object);
            }
            if (inputStream == null) {
                bl2 = false;
                object = "modules/" + string + ".cmib";
                inputStream = IModule.class.getResourceAsStream((String)object);
                if (inputStream == null) {
                    throw new FileNotFoundException(string);
                }
            }
        } else {
            inputStream = repositoryEvent.getInputStream();
        }
        object = new ObjectInputStream(inputStream);
        int n = ((ObjectInputStream)object).readInt();
        MIBModule mIBModule = null;
        if (n == -1) {
            GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)object);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            n = objectInputStream.readInt();
            mIBModule = this.readObjects(bl, objectInputStream, n);
        } else {
            mIBModule = this.readObjects(bl, (ObjectInputStream)object, n);
        }
        try {
            ((ObjectInputStream)object).close();
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        repositoryEvent = new RepositoryEvent(this, string, mIBModule);
        this.fireAfterReadModule(repositoryEvent);
        if (!bl && bl2) {
            this.repCache.put(string, new RepositoryCacheEntry(mIBModule));
        }
        return mIBModule;
    }

    public String[] getBuiltinModuleNames() {
        String string = "modules/builtin-modules.properties";
        InputStream inputStream = IModule.class.getResourceAsStream(string);
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                return properties.values().toArray(new String[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new String[0];
    }

    private MIBModule readObjects(boolean bl, ObjectInputStream objectInputStream, int n) throws ClassNotFoundException, IOException {
        MIBModule mIBModule = (MIBModule)objectInputStream.readObject();
        mIBModule.reinit();
        if (!bl) {
            for (int i = 0; i < n - 1; ++i) {
                try {
                    MIBObject mIBObject = (MIBObject)objectInputStream.readObject();
                    mIBModule.add(mIBObject);
                    continue;
                }
                catch (EOFException eOFException) {
                    if (i + 1 >= n - 1) continue;
                    System.err.println("MIB module " + mIBModule.getModuleName() + " should have had " + n + " MIB objects, but actually has only " + (i + 1));
                }
            }
        }
        return mIBModule;
    }

    public void initialize() throws IOException {
        String[] stringArray = this.path.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(this.path.getPath() + File.separator + stringArray[i]);
            file.delete();
        }
    }

    public ModuleInfo[] getModuleInfos() throws IOException {
        return this.getModuleInfos(null);
    }

    public ModuleInfo[] getModuleInfos(ProgressCallback progressCallback) throws IOException {
        MIBModule[] mIBModuleArray = this.getModules(true, progressCallback);
        if (mIBModuleArray == null) {
            return null;
        }
        ModuleInfo[] moduleInfoArray = new ModuleInfo[mIBModuleArray.length];
        for (int i = 0; i < mIBModuleArray.length; ++i) {
            moduleInfoArray[i] = new ModuleInfo(mIBModuleArray[i].getModuleName(), mIBModuleArray[i].getImportSources());
            String string = mIBModuleArray[i].getLastUpdated();
            if (string == null) continue;
            try {
                moduleInfoArray[i].setLastUpdated(MIBModule.getDateFromUTC(string));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return moduleInfoArray;
    }

    public MIBModule[] getModules(boolean bl, ProgressCallback progressCallback) throws IOException {
        String[] stringArray = null;
        if (this.repositoryListeners != null) {
            stringArray = this.fireListModules();
        }
        if ((stringArray == null || stringArray.length == 0) && this.path != null) {
            stringArray = this.getModuleNames();
        }
        OrderedMap orderedMap = new OrderedMap(LexicographicPredicate.instance);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (progressCallback != null && progressCallback.progressEvent(i, stringArray.length, stringArray[i])) {
                    return null;
                }
                MIBModule mIBModule = this.loadModuleFromFile(stringArray[i], bl);
                orderedMap.add(mIBModule.getModuleName(), mIBModule);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        MIBModule[] mIBModuleArray = new MIBModule[orderedMap.size()];
        int n = 0;
        Enumeration enumeration = orderedMap.elements();
        while (enumeration.hasMoreElements()) {
            mIBModuleArray[n] = (MIBModule)enumeration.nextElement();
            ++n;
        }
        return mIBModuleArray;
    }

    public MIBModule[] getModules() throws IOException {
        return this.getModules(true, null);
    }

    public MIBModule getModule(String string) throws IOException {
        try {
            return this.loadModuleFromFile(string, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public MIBModule getModule(String string, boolean bl) throws IOException {
        try {
            return this.loadModuleFromFile(string, !bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public MIBObject[] getObjects(String string) throws IOException {
        try {
            MIBModule mIBModule = this.loadModuleFromFile(string, false);
            MIBObject[] mIBObjectArray = new MIBObject[1 + mIBModule.size()];
            mIBObjectArray[0] = mIBModule;
            int n = 1;
            Enumeration enumeration = mIBModule.objects();
            while (enumeration.hasMoreElements()) {
                mIBObjectArray[n] = (MIBObject)enumeration.nextElement();
                ++n;
            }
            return mIBObjectArray;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("File format error while loading objects from " + string + ": " + classNotFoundException.getMessage());
        }
    }

    public String[] getModuleNames() throws IOException {
        String[] stringArray = this.path.list(new ModuleFileNameFilter());
        return stringArray;
    }

    public void setRepManForImports(RepositoryManager repositoryManager) {
        this.rm = repositoryManager;
    }

    private static String getErrorTextTemplate(int n) {
        String string;
        switch (n) {
            case 0: {
                string = res.getString("errUnknown");
                break;
            }
            case 1000: {
                string = res.getString("errParser");
                break;
            }
            case 1001: {
                string = res.getString("errParserDisplayHint");
                break;
            }
            case 1002: {
                string = res.getString("errParserUTCTime");
                break;
            }
            case 1100: {
                string = res.getString("errImportUnknown");
                break;
            }
            case 10: {
                string = res.getString("errFileOpenError");
                break;
            }
            case 1101: {
                string = res.getString("errImportCyclic");
                break;
            }
            case 1502: {
                string = res.getString("errUndefName");
                break;
            }
            case 1501: {
                string = res.getString("errUndefObject");
                break;
            }
            case 1500: {
                string = res.getString("errUndefSyntax");
                break;
            }
            case 1150: {
                string = res.getString("errModuleOrder");
                break;
            }
            case 1201: {
                string = res.getString("errInconsistentStatus");
                break;
            }
            case 1200: {
                string = res.getString("errInconsistentSyntax");
                break;
            }
            case 1202: {
                string = res.getString("errInconsistentAccess");
                break;
            }
            case 5000: {
                string = res.getString("errNotInGroup");
                break;
            }
            case 1700: {
                string = res.getString("errWrongType");
                break;
            }
            case 50: {
                string = res.getString("errLexical");
                break;
            }
            case 1810: {
                string = res.getString("errInvalidIndex");
                break;
            }
            case 1813: {
                string = res.getString("errInvalidImpliedLengthIndex");
                break;
            }
            case 1812: {
                string = res.getString("errInvalidIndexLength");
                break;
            }
            case 4010: {
                string = res.getString("errInvalidRange");
                break;
            }
            case 1850: {
                string = res.getString("errScalarIndex");
                break;
            }
            case 2000: {
                string = res.getString("errDuplicateRegistration");
                break;
            }
            case 2010: {
                string = res.getString("errIllegalRegistration");
                break;
            }
            case 1110: {
                string = res.getString("errWrongImport");
                break;
            }
            case 1111: {
                string = res.getString("errMissingImport");
                break;
            }
            case 1112: {
                string = res.getString("errInconsistentImport");
                break;
            }
            case 1113: {
                string = res.getString("errDuplicateImport");
                break;
            }
            case 1102: {
                string = res.getString("errDuplicateImportSource");
                break;
            }
            case 1114: {
                string = res.getString("errIllegalImport");
                break;
            }
            case 1820: {
                string = res.getString("errNegativeIndex");
                break;
            }
            case 1800: {
                string = res.getString("errInconsistentTable");
                break;
            }
            case 1801: {
                string = res.getString("errInconsistentTableDef");
                break;
            }
            case 5100: {
                string = res.getString("errNoAccessInGroup");
                break;
            }
            case 3000: {
                string = res.getString("errDefaultValueOutOfRange");
                break;
            }
            case 3001: {
                string = res.getString("errDefaultValueSizeOutOfRange");
                break;
            }
            case 3002: {
                string = res.getString("errDefaultValueInvalid");
                break;
            }
            case 3003: {
                string = res.getString("errDefaultValueIllegal");
                break;
            }
            case 4000: {
                string = res.getString("errInvalidSyntaxRefinement");
                break;
            }
            case 1050: {
                string = res.getString("errIllegalClause");
                break;
            }
            case 1851: {
                string = res.getString("errScalarWithIndex");
                break;
            }
            case 1600: {
                string = res.getString("errRefIsNotATable");
                break;
            }
            case 1210: {
                string = res.getString("errCondGroupIsAlsoManadatory");
                break;
            }
            case 1601: {
                string = res.getString("errRefIsNotAGroup");
                break;
            }
            case 1602: {
                string = res.getString("errRefIsNotObjectType");
                break;
            }
            case 1211: {
                string = res.getString("errVariationNotInGroup");
                break;
            }
            case 1212: {
                string = res.getString("errIllegalAccessForNotifyVariation");
                break;
            }
            case 1220: {
                string = res.getString("errCreationRequiresNotAllowed");
                break;
            }
            case 1221: {
                string = res.getString("errCreationRequiresReadCreateCols");
                break;
            }
            case 1010: {
                string = res.getString("errIdentifierTooLong");
                break;
            }
            case 1020: {
                string = res.getString("errDuplicateIdentifier");
                break;
            }
            case 1811: {
                string = res.getString("errMissingIndex");
                break;
            }
            case 4100: {
                string = res.getString("errInvalidSyntax4DisplayHint");
                break;
            }
            case 4101: {
                string = res.getString("errDisplayHintWrongType");
                break;
            }
            default: {
                string = res.getString("errUnknown");
            }
        }
        return string;
    }

    public static String getErrorText(SMIParseException sMIParseException) {
        return DefaultRepositoryManager.getErrorText(sMIParseException, true);
    }

    public static String getErrorText(SMIParseException sMIParseException, boolean bl) {
        Object object;
        Object[] objectArray;
        Object object2;
        if (res == null) {
            object2 = Locale.getDefault();
            res = ResourceBundle.getBundle(resClassName, new Locale(((Locale)object2).getLanguage(), ((Locale)object2).getCountry(), ((Locale)object2).getVariant()));
        }
        if ((object2 = sMIParseException.getMessage()) == null) {
            object2 = "";
        }
        String string = DefaultRepositoryManager.getErrorTextTemplate(sMIParseException.errorType);
        if (sMIParseException.objects == null) {
            objectArray = new Object[]{object2};
            if (sMIParseException.fileError instanceof SemanticError) {
                object = sMIParseException.fileError;
                objectArray = new Object[1 + object.getExpected().length];
                objectArray[0] = object.getFound() + " at line " + object.getLine() + ", column " + object.getColumn();
                for (int i = 0; i < object.getExpected().length; ++i) {
                    objectArray[i + 1] = object.getExpected()[i];
                }
            }
        } else {
            objectArray = new Object[sMIParseException.objects.size()];
            sMIParseException.objects.copyInto(objectArray);
            if (sMIParseException.fileError instanceof SemanticError) {
                object = sMIParseException.fileError;
                if (objectArray.length < 1) {
                    objectArray = new Object[]{object.getFound() + " at line " + object.getLine() + ", column " + object.getColumn()};
                }
            }
        }
        object = new DecimalFormat("0000").format(sMIParseException.errorType);
        String string2 = bl ? "[" + (String)object + "] " : "";
        string2 = string2 + MessageFormat.format(string, objectArray).toString();
        return string2;
    }

    public void setOptions(int n) {
        this.options = n;
    }

    public int getOptions() {
        return this.options;
    }

    public void importModule(ImportModuleEvent importModuleEvent) {
        try {
            IObject[] iObjectArray = this.getObjects(importModuleEvent.getModuleName());
            importModuleEvent.setObjects(iObjectArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isModuleAvailable(String string) {
        File file = new File(this.path, string);
        return file.exists() && file.isFile();
    }

    public synchronized void removeRepositoryListener(RepositoryListener repositoryListener) {
        if (this.repositoryListeners != null && this.repositoryListeners.contains(repositoryListener)) {
            Vector vector = (Vector)this.repositoryListeners.clone();
            vector.removeElement(repositoryListener);
            this.repositoryListeners = vector;
        }
    }

    public synchronized void addRepositoryListener(RepositoryListener repositoryListener) {
        Vector vector;
        Vector vector2 = vector = this.repositoryListeners == null ? new Vector(2) : (Vector)this.repositoryListeners.clone();
        if (!vector.contains(repositoryListener)) {
            vector.addElement(repositoryListener);
            this.repositoryListeners = vector;
        }
    }

    protected void fireWriteModule(RepositoryEvent repositoryEvent) {
        if (this.repositoryListeners != null) {
            Vector vector = this.repositoryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((RepositoryListener)vector.elementAt(i)).writeModule(repositoryEvent);
            }
        }
    }

    protected void fireReadModule(RepositoryEvent repositoryEvent) {
        if (this.repositoryListeners != null) {
            Vector vector = this.repositoryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((RepositoryListener)vector.elementAt(i)).readModule(repositoryEvent);
            }
        }
    }

    protected void fireAfterReadModule(RepositoryEvent repositoryEvent) {
        if (this.repositoryListeners != null) {
            Vector vector = this.repositoryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                RepositoryListener repositoryListener = (RepositoryListener)vector.get(i);
                if (!(repositoryListener instanceof ExtRepsitoryListener)) continue;
                ((ExtRepsitoryListener)repositoryListener).afterReadModule(repositoryEvent);
            }
        }
    }

    protected void fireDeleteModule(RepositoryEvent repositoryEvent) {
        if (this.repositoryListeners != null) {
            Vector vector = this.repositoryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((RepositoryListener)vector.elementAt(i)).deleteModule(repositoryEvent);
            }
        }
    }

    protected String[] fireListModules() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.repositoryListeners != null) {
            Vector vector = this.repositoryListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray = ((RepositoryListener)vector.get(i)).listModuleNames();
                if (stringArray == null) continue;
                arrayList.addAll(Arrays.asList(stringArray));
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setImportTableDependencies(boolean bl) {
        this.importTableDependencies = bl;
    }

    public void setMaxErrors(int n) {
        this.maxErrors = n;
    }

    public void setUseCompression(boolean bl) {
        this.useCompression = bl;
    }

    public boolean isImportTableDependencies() {
        return this.importTableDependencies;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public static void main(String[] stringArray) {
        DefaultRepositoryManager defaultRepositoryManager = new DefaultRepositoryManager();
        try {
            defaultRepositoryManager.open(new File(stringArray[0]));
            String[] stringArray2 = defaultRepositoryManager.verifyRepository(null);
            if (stringArray2.length == 0) {
                System.out.println("Repository '" + stringArray[0] + "' is OK.");
            } else {
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println("File '" + stringArray2[i] + "' is invalid.");
                }
                System.exit(1);
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to open repository: " + iOException.getMessage());
            System.exit(2);
        }
    }

    public MIBObject parseObject(String string, String string2, MIBModule mIBModule, boolean bl, int n) throws SMIParseException {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        boolean bl2;
        StringReader stringReader = new StringReader(string);
        SMIParser sMIParser = new SMIParser(stringReader);
        boolean bl3 = bl2 = n == 2;
        if (bl2) {
            sMIParser.setLenient(1);
        }
        sMIParser.setMaxErrors(this.maxErrors);
        SMIRepository sMIRepository = null;
        try {
            int n2;
            object = new HashSet<String>(mIBModule.size());
            serializable2 = null;
            Iterator iterator = mIBModule.objectsIterator();
            while (iterator.hasNext()) {
                serializable = (MIBObject)iterator.next();
                String string3 = ((MIBObject)serializable).getName();
                if (string2.equals(string3)) {
                    serializable2 = serializable;
                    continue;
                }
                object.add(string3);
            }
            int n3 = bl ? 4 : (n2 = mIBModule.getSMIVersion() == 1 ? 1 : 2);
            if (serializable2 instanceof MIBObjectType && ((MIBObjectType)serializable2).isTable()) {
                n2 |= 8;
            }
            sMIRepository = sMIParser.InputObject(n2, (Set)object);
            sMIRepository.addScope(mIBModule.getName());
            sMIRepository.setImporter(this);
            sMIRepository.createOids();
        }
        catch (ParseException parseException) {
            if (this.verbose) {
                parseException.printStackTrace();
            }
            SMIParseException sMIParseException = new SMIParseException(parseException.getMessage(), parseException.errorType, parseException);
            sMIParseException.setErrorList(sMIParser.getErrors());
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            if (this.verbose) {
                throwable.printStackTrace();
            }
            if (throwable instanceof TokenMgrError) {
                throw new SMIParseException(throwable.getMessage(), 50, (TokenMgrError)throwable);
            }
            throw new SMIParseException(throwable.getMessage(), 1000);
        }
        if (sMIParser.getErrors().size() >= this.maxErrors) {
            object = (SMIParseException)sMIParser.getErrors().get(0);
            ((SMIParseException)object).setErrorList(sMIParser.getErrors());
            throw object;
        }
        try {
            object = bl2 ? new LenientSMI2Java(sMIRepository, this.options) : new SMI2Java(sMIRepository, this.options){

                public void checkModule() {
                    this.smiRep.resolveSyntaxes();
                }
            };
            ((SMI2Java)object).setErrors(sMIParser.getErrors());
            ((SMI2Java)object).setMaxErrors(this.maxErrors);
            sMIRepository.setErrorHandler((SMIParseExceptionHandler)object);
            serializable2 = new HashSet(1);
            serializable2.add(string2);
            ((SMI2Java)object).setParseContext(mIBModule, (Set)((Object)serializable2));
            Vector vector = new Vector();
            sMIRepository.jjtAccept((SMIParserVisitor)object, vector);
            ((SMI2Java)object).checkModule();
            if (((SMI2Java)object).getErrors().size() > 0) {
                serializable = (SMIParseException)((SMI2Java)object).getErrors().get(0);
                ((SMIParseException)serializable).setErrorList(sMIParser.getErrors());
                throw serializable;
            }
            ((SMI2Java)object).getRepository().structureChanged();
            serializable = ((SMI2Java)object).getCurrentObject();
            return serializable;
        }
        catch (SMIParseException sMIParseException) {
            throw sMIParseException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SMIParseException(throwable.getMessage(), 0);
        }
    }

    public String[] verifyRepository(ProgressCallback progressCallback) {
        Object object;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        File file = new File(this.path.getPath() + File.separatorChar + "MODULE.IDS");
        Integer n = new Integer(this.initialModuleID);
        Vector vector = new Vector();
        try {
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                object = new ObjectInputStream(fileInputStream);
                n = (Integer)((ObjectInputStream)object).readObject();
                vector = (Vector)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
            }
        }
        catch (Exception exception) {
            linkedList.add(file.getPath());
        }
        boolean bl = false;
        try {
            object = this.getModuleNames();
            HashSet<Integer> hashSet = new HashSet<Integer>(((String[])object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2;
                block21: {
                    try {
                        if (progressCallback != null && progressCallback.progressEvent(i, ((Object)object).length, (String)object[i])) {
                            return null;
                        }
                        object2 = this.loadModuleFromFile((String)object[i], false);
                        if (((MIBObject)object2).getModuleID() > n) {
                            if (progressCallback == null) {
                                System.out.println("Warning: Module ID " + ((MIBObject)object2).getModuleID() + " of MIB file " + (String)object[i] + " is greater than next module ID " + n + " (will be corrected)");
                            }
                            n = ((MIBObject)object2).getModuleID();
                            bl = true;
                        }
                        if (vector.contains(((MIBObject)object2).getModuleID())) {
                            vector.remove(((MIBObject)object2).getModuleID());
                            bl = true;
                            if (progressCallback == null) {
                                System.out.println("Verification of " + (String)object[i] + " with ID " + ((MIBObject)object2).getModuleID() + " OK, but using using free ID (will be corrected)");
                            }
                        } else if (hashSet.contains(((MIBObject)object2).getModuleID())) {
                            linkedList.add(object[i]);
                            if (progressCallback == null) {
                                System.out.println("Verification of " + (String)object[i] + " failed, " + "because its module ID " + ((MIBObject)object2).getModuleID() + " is alread used by another MIB module (rebuild " + "of the MIB repository is needed)");
                            }
                        } else {
                            hashSet.add(((MIBObject)object2).getModuleID());
                            if (progressCallback == null) {
                                System.out.println("Verified " + (String)object[i] + " with ID " + ((MIBObject)object2).getModuleID());
                            }
                        }
                    }
                    catch (Exception exception) {
                        linkedList.add(object[i]);
                        if (progressCallback != null) break block21;
                        System.out.println("Verification of " + (String)object[i] + " failed: " + exception.getMessage());
                    }
                }
                if (!bl) continue;
                try {
                    object2 = new FileOutputStream(file);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object2);
                    objectOutputStream.writeObject(n);
                    objectOutputStream.writeObject(vector);
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    continue;
                }
                catch (Exception exception) {
                    if (progressCallback != null) continue;
                    System.err.println("Failed to adjust free module ID list: " + exception.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            if (progressCallback == null) {
                System.err.println("Failed to verify repository: " + iOException.getMessage());
            }
            return null;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public boolean refresh(MIBRepository mIBRepository, List list, List list2, boolean bl) {
        Vector vector = mIBRepository.getModuleNames();
        for (String string : vector) {
            MIBModule mIBModule = mIBRepository.getModule(string);
            if (mIBModule == null) continue;
            Date date = mIBModule.getLastChange();
            MIBModule mIBModule2 = null;
            try {
                mIBModule2 = this.loadModuleFromFile(string, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mIBModule2 == null) {
                if (list2 == null) continue;
                list2.add(string);
                if (bl) continue;
                mIBRepository.remove(mIBModule);
                continue;
            }
            if (mIBModule2 == null || !date.before(mIBModule2.getLastChange())) continue;
            list.add(string);
            if (bl) continue;
            mIBRepository.remove(mIBModule);
            try {
                mIBModule2 = null;
                mIBModule2 = this.loadModuleFromFile(string, false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (mIBModule2 == null) continue;
            mIBRepository.addObject(mIBModule2);
            mIBRepository.addAllObjects(mIBModule2.getObjects());
        }
        if (!bl && list.size() > 0) {
            mIBRepository.structureChanged();
        }
        return list.size() > 0 || list2 != null && list2.size() > 0;
    }

    private MIBModule getModuleFromCache(String string, long l) {
        RepositoryCacheEntry repositoryCacheEntry = (RepositoryCacheEntry)this.repCache.get(string);
        if (repositoryCacheEntry != null) {
            if (repositoryCacheEntry.lastUpdate >= l) {
                return (MIBModule)repositoryCacheEntry.module.getClone();
            }
            if (this.verbose) {
                System.out.println("MIB module '" + string + "' changed on disk");
            }
            this.repCache.remove(string);
        }
        return null;
    }

    static class RepositoryCacheEntry {
        private long lastUpdate;
        private MIBModule module;

        public RepositoryCacheEntry(MIBModule mIBModule) {
            this.module = mIBModule;
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    static class ModuleFileNameFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.indexOf(46) < 0;
        }
    }
}

