/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.notepad;

import com.agentpp.common.SearchReplacePanel;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.TableSorter;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.common.smi.editor.SmiEditorKit;
import com.agentpp.common.smi.print.SmiTextPrintable;
import com.agentpp.common.table.FlexListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.notepad.ElementTreePanel;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.util.ThreadPool;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowHtmlDialog;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class Notepad
extends JDialog
implements JCSelectListener {
    private static final String _$16961 = "agentpp.notepad.searchExpression";
    private static final String _$16962 = "agentpp.notepad.substitution";
    private static ResourceBundle _$16963;
    protected File file = new File("");
    private FlexListTable _$16964 = new FlexListTable();
    private JCVectorDataSource _$13714 = new JCVectorDataSource();
    private TableSorter _$16965;
    private JScrollPane _$16771;
    JFrame myFrame;
    String lastSearch = "";
    private MIBImporter _$13718 = null;
    private UserConfigFile _$6388 = new UserConfigFile();
    PatternMatcher matcher = new Perl5Matcher();
    PatternCompiler compiler = new Perl5Compiler();
    Pattern lastPattern;
    PatternMatcherInput input;
    MatchResult result;
    private boolean _$14002;
    private MIBModule _$16971;
    private JDialog _$16972;
    private ThreadPool _$16973;
    private CompletionLookupUpdater _$16975;
    private LinkedList _$16976 = new LinkedList();
    static final String[] COLUMN_NAMES;
    static final int COL_NR = 0;
    static final int COL_ERROR = 1;
    static final int COL_TEXT = 2;
    private static final String _$16981 = "Save selected errors...";
    private JEditorPane _$11941;
    private Hashtable _$8801;
    private Hashtable _$16988;
    private JMenuBar _$16989;
    private JToolBar _$16523;
    protected StatusBar status;
    private JFrame _$17025;
    protected ElementTreePanel elementTreePanel;
    protected FileDialog fileDialog;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String accelSuffix = "Accelerator";
    public static final String tipSuffix = "Tooltip";
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String saveAsAction = "saveAs";
    public static final String exitAction = "exit";
    public static final String printAction = "print";
    public static final String findAction = "find";
    public static final String importAction = "import";
    public static final String exportErrorsAction = "exportErrors";
    public static final String replaceAction = "replace";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction _$17047 = new UndoAction();
    private RedoAction _$17048 = new RedoAction();
    private ImportAction _$17092 = new ImportAction();
    private ExportSelectedErrorsAction _$17093 = new ExportSelectedErrorsAction("exportErrors", false);
    private Action[] _$11683 = new Action[]{new NewAction(), new OpenAction(), new SaveAction(), new SaveAsAction(), new ExitAction(), new FindAction(), new ReplaceAction(), this._$17092, this._$17093, new ImportAccurateAction(), new ImportLenientAction(), new CheckAccurateAction(), new CheckLenientAction(), new FindNextAction(), new PrintAction(), this._$17047, this._$17048};
    private int _$17063;
    private boolean _$16587;
    private int _$17107 = 8;

    public Notepad(JFrame frame) {
        super(frame);
        super.setDefaultCloseOperation(2);
        this.myFrame = frame;
        try {
            this._$6186();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TablePopupMenu menu = this._$16964.getPopupMenu();
        menu.addItem(_$16981, new ExportSelectedErrorsAction(_$16981, true));
        this._$16964.setPopupMenuEnabled(true);
    }

    public void setConfig(UserConfigFile config) {
        this._$6388 = config;
        SmiContext s = ((SmiEditorKit)this.getEditor().getEditorKit()).getStylePreferences();
        Vector v = SmiContext.getStyles(config);
        s.setSyntaxHighlighting(SmiContext.loadSyntaxHighlighting(config));
        s.setStyles(v);
    }

    public void setLookupEnabled(boolean lookupEnabled) {
        this._$14002 = lookupEnabled;
    }

    private void _$6186() {
        this.createErrorTable();
        this.getContentPane().setLayout(new BorderLayout());
        this._$11941 = this.createEditor();
        this._$11941.setFont(new Font("monospaced", 0, 12));
        this._$11941.getDocument().addUndoableEditListener(this.undoHandler);
        this._$8801 = new Hashtable();
        Action[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            this._$8801.put(a.getValue("Name"), a);
        }
        this._$16771 = new JScrollPane();
        JViewport port = this._$16771.getViewport();
        port.add(this._$11941);
        port.setScrollMode(1);
        this._$16988 = new Hashtable();
        this._$16989 = this.createMenubar();
        this.getContentPane().add("North", this._$16989);
        JSplitPane pane = new JSplitPane(0);
        JScrollPane statusScroller = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this._$16992());
        panel.add("Center", pane);
        pane.setBottomComponent(this._$16771);
        pane.setTopComponent(this._$16964);
        pane.setOneTouchExpandable(true);
        this.getContentPane().add("Center", panel);
        this.status = this.createStatusbar();
        this._$11941.addCaretListener(this.status);
        this.getContentPane().add("South", this.status);
        panel.setPreferredSize(new Dimension(600, 600));
        this.pack();
        pane.setDividerLocation(0.2);
    }

    public Notepad(JFrame f, File file) {
        this(f);
        this.loadFile(file, 1, 1, 0);
    }

    public Notepad(JFrame f, File file, String searchString) {
        this(f);
        this.loadFile(file, searchString);
    }

    public Notepad(JFrame f, File file, int row, int col) {
        this(f);
        this.loadFile(file, row, col, 0);
    }

    public Notepad(JFrame f, File file, int row, int col, int sel) {
        this(f);
        this.loadFile(file, row, col, sel);
    }

    public Notepad(JFrame f, String text, int row, int col, int sel) {
        this(f);
        this.loadString(text, row, col, sel);
    }

    public int getCaretPosition() {
        return this.getEditor().getCaretPosition();
    }

    public JDialog getDialog() {
        return this;
    }

    public boolean replace(Pattern pattern, String s) {
        int numSubs = 1;
        Perl5Substitution substitution = new Perl5Substitution(s);
        int r = -1;
        int start = -1;
        int stop = -1;
        block8: while (r != 1 && this.searchPattern(pattern)) {
            start = this.getEditor().getSelectionStart();
            stop = this.getEditor().getSelectionEnd();
            StringBuffer buf = new StringBuffer();
            String[] text = new String[]{"Replace?"};
            Object[] options = new String[]{"Yes", "Yes to All", "No", "Cancel"};
            r = JOptionPane.showOptionDialog(this.getDialog(), text, "Confirm Substitution", 1, 3, null, options, options[0]);
            switch (r) {
                case 0: {
                    break;
                }
                case 1: {
                    stop = ((SmiDocument)this._$11941.getDocument()).getEndPosition().getOffset();
                    numSubs = -1;
                    break;
                }
                case 2: {
                    continue block8;
                }
                case 3: {
                    return false;
                }
            }
            SmiDocument doc = (SmiDocument)this._$11941.getDocument();
            int length = stop - start;
            Segment seg = new Segment();
            try {
                doc.getText(start, length, seg);
            }
            catch (BadLocationException blex) {
                blex.printStackTrace();
            }
            this.input = new PatternMatcherInput(new String(seg.array, seg.offset, seg.count));
            Util.substitute(buf, this.matcher, pattern, (Substitution)substitution, this.input, numSubs);
            this.getEditor().setSelectionStart(start);
            this.getEditor().setSelectionEnd(stop);
            this.getEditor().replaceSelection(buf.toString());
            this.getEditor().setCaretPosition(start + buf.toString().length());
        }
        if (r == 0 || r == 1) {
            this.setCaretPosition(start);
        }
        return true;
    }

    public boolean searchPattern(Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        this.lastPattern = pattern;
        int start = 0;
        boolean startline = false;
        if (this.getEditor().getCaretPosition() > 0) {
            start = this.getEditor().getCaretPosition();
        }
        SmiDocument doc = (SmiDocument)this._$11941.getDocument();
        int length = doc.getEndPosition().getOffset() - start;
        Segment seg = new Segment();
        try {
            doc.getText(start, length, seg);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        this.input = new PatternMatcherInput(new String(seg.array, seg.offset, length));
        if (this.matcher.contains(this.input, pattern)) {
            int pos = this.input.getMatchBeginOffset() + start;
            int len = this.input.getMatchEndOffset() - this.input.getMatchBeginOffset();
            this._$11941.getCaret().setSelectionVisible(true);
            this._$11941.setCaretPosition(pos);
            this._$11941.moveCaretPosition(pos + len);
            return true;
        }
        this.status.setText("Search complete!");
        return false;
    }

    private Pattern _$17012(String s, boolean quite) {
        Pattern pattern;
        block2: {
            pattern = null;
            try {
                pattern = this.compiler.compile(s);
            }
            catch (MalformedPatternException e) {
                if (quite) break block2;
                JOptionPane.showMessageDialog(this.getDialog(), e.getMessage(), "Malformed Expression", 0);
            }
        }
        return pattern;
    }

    public boolean searchString(String s) {
        Pattern p = this._$17012(s, true);
        if (p != null) {
            return this.searchPattern(p);
        }
        return false;
    }

    public void setCaretPosition(int pos) {
        this.getEditor().setCaretPosition(pos);
    }

    public boolean setCaretPosition(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            this._$11941.setCaretPosition(smidoc.getLineStartOffset(row - 1) + col - 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    public void setSelectionLength(int sel) {
        this._$11941.getCaret().setSelectionVisible(true);
        int len = sel;
        while (true) {
            try {
                this._$11941.moveCaretPosition(this._$11941.getCaretPosition() + len);
            }
            catch (IllegalArgumentException iaex) {
                if (--len > 0) continue;
            }
            break;
        }
    }

    protected void loadFile(File file, int row, int col, int sel) {
        this.setEnabled(false);
        this.file = file;
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            oldDoc.remove(0, oldDoc.getLength());
        }
        catch (BadLocationException blex) {
            // empty catch block
        }
        FileLoader loader = new FileLoader(file, this._$11941.getDocument());
        loader.row = row;
        loader.col = col;
        loader.selection = sel;
        loader.start();
    }

    protected void loadString(String text, int row, int col, int sel) {
        this.setEnabled(false);
        this.file = null;
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            oldDoc.remove(0, oldDoc.getLength());
        }
        catch (BadLocationException blex) {
            // empty catch block
        }
        Document doc = this._$11941.getDocument();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException ex1) {
            // empty catch block
        }
        try {
            this.setCaretPosition(row, col);
            this.setSelectionLength(sel);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (this._$17025 != null) {
            this.elementTreePanel.setEditor(this.getEditor());
        }
        doc.addUndoableEditListener(this.undoHandler);
        this.status.removeAll();
        this.status.revalidate();
        this.resetUndoManager();
        this.setEnabled(true);
    }

    protected void loadFile(File file, String searchString) {
        this.setEnabled(false);
        this.file = file;
        Document oldDoc = this.getEditor().getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        if (this.elementTreePanel != null) {
            this.elementTreePanel.setEditor(null);
        }
        try {
            oldDoc.remove(0, oldDoc.getLength());
        }
        catch (BadLocationException blex) {
            // empty catch block
        }
        FileLoader loader = new FileLoader(file, this._$11941.getDocument());
        loader.search = searchString;
        loader.start();
    }

    public Action[] getActions() {
        return TextAction.augmentList(this._$11941.getActions(), this._$11683);
    }

    protected void createErrorTable() {
        this._$13714.setNumColumns(COLUMN_NAMES.length);
        this._$13714.setNumRows(0);
        this._$13714.setColumnLabels(COLUMN_NAMES);
        this._$16965 = new TableSorter(this._$16964, this._$13714);
        this._$16964.setDataSource(this._$13714);
        this._$16964.setPixelHeight(-997, 33001);
        this._$16964.setRowLabelDisplay(false);
        for (int i = 0; i < this._$13714.getNumColumns(); ++i) {
            this._$16964.setPixelWidth(i, 33001);
        }
        this._$16964.addSelectListener(this);
    }

    protected JEditorPane createEditor() {
        try {
            final JEditorPane editor = new JEditorPane();
            SmiEditorKit kit = new SmiEditorKit();
            editor.setEditorKit(kit);
            editor.setBackground(Color.white);
            editor.setFont(new Font("Courier", 0, 12));
            editor.setEditable(true);
            editor.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                    if (Notepad.this._$13718 != null && editor.isEditable() && (e.getModifiers() & 2) != 0) {
                        if (e.getKeyChar() == ' ') {
                            Notepad.this.codeCompletion();
                        } else if (e.getKeyCode() == 27 && Notepad.this._$16972 != null) {
                            Notepad.this._$17030();
                        }
                    }
                }
            });
            return editor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected JEditorPane getEditor() {
        return this._$11941;
    }

    protected Frame getFrame() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        String sstr;
        JMenuItem mi = new JMenuItem(this.getResourceString(cmd + labelSuffix));
        URL url = this.getResource(cmd + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        if ((sstr = this.getResourceString(cmd + accelSuffix)) != null) {
            mi.setAccelerator(KeyStroke.getKeyStroke(sstr));
        }
        if ((astr = this.getResourceString(cmd + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = this.getAction(astr);
        if (a != null) {
            mi.addActionListener(a);
            a.addPropertyChangeListener(this.createActionChangeListener(mi));
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        this._$16988.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this._$16988.get(cmd);
    }

    protected Action getAction(String cmd) {
        return (Action)this._$8801.get(cmd);
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = _$16963.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    protected Container getToolbar() {
        return this._$16523;
    }

    protected JMenuBar getMenubar() {
        return this._$16989;
    }

    protected StatusBar createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this._$17047.update();
        this._$17048.update();
    }

    private Component _$16992() {
        this._$16523 = new JToolBar();
        String[] toolKeys = this.tokenize(this.getResourceString("toolbar"));
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                this._$16523.add(Box.createHorizontalStrut(5));
                continue;
            }
            this._$16523.add(this.createTool(toolKeys[i]));
        }
        this._$16523.add(Box.createHorizontalGlue());
        ToolBarUtils.setMinimumButtonSize(this._$16523);
        return this._$16523;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected JButton createToolbarButton(String key) {
        Action a;
        URL url = this.getResource(key + imageSuffix);
        JButton b = new JButton((Icon)new ImageIcon(url)){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a = this.getAction(astr)) != null) {
            b.setActionCommand(astr);
            a.addPropertyChangeListener(this.createActionChangeListener(b));
            b.addActionListener(a);
            b.setEnabled(a.isEnabled());
        } else {
            b.setEnabled(false);
        }
        String tip = this.getResourceString(key + tipSuffix);
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(this.getResourceString("menubar"));
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(this.getResourceString(key));
        JMenu menu = new JMenu(this.getResourceString(key + labelSuffix));
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i]);
            menu.add(mi);
        }
        return menu;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b) {
        ActionChangedListener listener = new ActionChangedListener(b);
        this._$16976.add(listener);
        return listener;
    }

    protected PropertyChangeListener createActionChangeListener(JButton b) {
        ButtonActionChangedListener listener = new ButtonActionChangedListener(b);
        this._$16976.add(listener);
        return listener;
    }

    public void setImporter(MIBImporter newImporter) {
        this._$13718 = newImporter;
    }

    public MIBImporter getImporter() {
        return this._$13718;
    }

    public void setParserMode(int newParserMode) {
        this._$17063 = newParserMode;
    }

    public int getParserMode() {
        return this._$17063;
    }

    public void clearErrors() {
        this._$13714.setNumRows(0);
        this._$17093.setEnabled(false);
    }

    public void setError(SMIParseException pex) {
        this._$13714.setNumRows(0);
        int n = 0;
        if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
            int i = 0;
            for (SMIParseException lpex : pex.getErrorList()) {
                if (lpex == pex) {
                    n = i;
                }
                this.addRow(lpex);
                ++i;
            }
        } else {
            this.addRow(pex);
        }
        this._$16964.setRowSelection(n, n);
        this._$17093.setEnabled(this._$13714.getNumRows() > 0);
    }

    public boolean setSelectionEnd(int row, int col) {
        try {
            SmiDocument smidoc = (SmiDocument)this.getEditor().getDocument();
            int startPos = this._$11941.getCaret().getDot();
            int endPos = smidoc.getLineStartOffset(row - 1) + col - 1;
            this.setSelectionLength(endPos - startPos + 1);
        }
        catch (Exception ble) {
            return false;
        }
        return true;
    }

    protected void setCurrentErrorLocation(int rowIndex) {
        SMIParseException pex = (SMIParseException)this._$13714.getTableRowLabel(rowIndex);
        if (pex.hasLocationInfo()) {
            this.setCaretPosition(pex.fileError.getLine(), pex.fileError.getColumn());
            this.setSelectionEnd(pex.fileError.getEndLine(), pex.fileError.getEndColumn());
        } else if (pex.objects != null) {
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (!this.searchString(pex.objects.firstElement().toString())) {
                this.setCaretPosition(pos);
            }
        } else {
            StringTokenizer st = new StringTokenizer(pex.getMessage(), ", ");
            int pos = this.getCaretPosition();
            this.setCaretPosition(0);
            if (st.hasMoreTokens() && !this.searchString(st.nextToken())) {
                this.setCaretPosition(pos);
            }
        }
    }

    public void print() {
        SmiContext ctx = new SmiContext();
        ctx.setSyntaxHighlighting(true);
        ctx.setStyles(ctx.getDefaultStyles());
        SmiTextPrintable smiPrintable = new SmiTextPrintable((SmiDocument)this.getEditor().getDocument(), new Font("SansSerif", 0, 10), this._$6388.getBoolean("print.header", true) ? this.getTitle() : null, this._$6388.getBoolean("print.footer", true) ? this._$6388.get("print.footerText", "{0} -- page {1}") : null, this._$6388.getBoolean("print.colored", false), this._$6388.getBoolean("print.lineNumbers", true), ctx, this.getTabSize());
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setJobName(this.getTitle());
        PageFormat pf = new PageFormat();
        pj.pageDialog(pf);
        pj.setPrintable(smiPrintable, pf);
        try {
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (PrinterException ex) {
            System.out.println(ex);
        }
    }

    protected byte[] getDocumentBytes() {
        Segment s = new Segment();
        SmiDocument doc = (SmiDocument)this._$11941.getDocument();
        try {
            doc.getText(0, doc.getLength(), s);
        }
        catch (BadLocationException blex) {
            blex.printStackTrace();
        }
        return String.valueOf(s.array, 0, doc.getLength()).getBytes();
    }

    public void setTabSize(int tabSize) {
        this._$17107 = tabSize;
    }

    public int getTabSize() {
        return this._$17107;
    }

    public String getText() {
        SmiDocument doc = (SmiDocument)this._$11941.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
    }

    protected void addRow(SMIParseException pex) {
        Vector<Object> row = new Vector<Object>(COLUMN_NAMES.length);
        row.add(new Integer(this._$13714.getNumRows() + 1));
        row.add(new Integer(pex.errorType));
        row.add(DefaultRepositoryManager.getErrorText(pex, false).replace('\r', ' '));
        this._$13714.addRow(Integer.MAX_VALUE, pex, row);
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int row = TableUtils.getFirstSelectedRow(this._$16964);
        if (row >= 0) {
            this.setCurrentErrorLocation(row);
        }
    }

    public void dispose() {
        for (PropertyChangeListener l : this._$16976) {
            for (Action a : this._$8801.values()) {
                a.removePropertyChangeListener(l);
            }
        }
        this._$16976.clear();
        super.dispose();
    }

    public void setLookupModule(MIBModule lookup) {
        this._$16971 = lookup;
    }

    private static boolean _$17157(char c) {
        return Character.isWhitespace(c) || c == ',';
    }

    private SMIParseException _$17158(String text, int maxLength) {
        try {
            int size = Math.min(maxLength, this.getCaretPosition());
            for (int i = size - 1; i >= 0; --i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                size = i + 1;
                break;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(text.substring(0, size).getBytes());
            this._$13718.checkMIB(this, bis, 1);
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        catch (SMIParseException pex) {
            return pex;
        }
    }

    private void _$17030() {
        this._$16972.setVisible(false);
        this._$16972.dispose();
        this._$16972 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void codeCompletion() {
        if (!this._$14002) {
            return;
        }
        if (this._$16973 == null) {
            this._$16973 = ThreadPool.create("SMIEditorCodeCompletion", 1);
            this._$16975 = new CompletionLookupUpdater();
        }
        CompletionLookupUpdater completionLookupUpdater = this._$16975;
        synchronized (completionLookupUpdater) {
            this._$16973.execute(this._$16975);
            try {
                this._$16975.wait(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        String text = this.getText();
        int startPos = this.getCaretPosition();
        for (int i = startPos - 1; i >= 1; --i) {
            if (Notepad._$17157(text.charAt(i))) {
                this._$11941.setCaretPosition(i + 1);
                break;
            }
            if (i != 1) continue;
            this._$11941.setCaretPosition(1);
            break;
        }
        SMIParseException pex = this._$17158(text, this._$11941.getDocument().getLength());
        LinkedList<SMIParseException> completionsTokens = new LinkedList<SMIParseException>();
        if (pex != null) {
            if (pex.getErrorList() != null && pex.getErrorList().size() > 0) {
                int maxPos = 0;
                for (SMIParseException ip : pex.getErrorList()) {
                    if (!ip.hasLocationInfo()) continue;
                    if (ip.fileError.getLastEndPosition() > maxPos) {
                        completionsTokens.clear();
                        completionsTokens.add(ip);
                        maxPos = ip.fileError.getLastEndPosition();
                        continue;
                    }
                    if (ip.fileError.getLastEndPosition() != maxPos || ip.fileError.getFoundTokenImage().length() <= ((SMIParseException)completionsTokens.getLast()).fileError.getFoundTokenImage().length()) continue;
                    completionsTokens.add(ip);
                }
            }
            if (completionsTokens.size() == 0) {
                return;
            }
            for (int i = startPos; i < text.length(); ++i) {
                if (!Notepad._$17157(text.charAt(i))) continue;
                this._$11941.moveCaretPosition(i);
                break;
            }
            HashSet completions = new HashSet();
            for (SMIParseException p : completionsTokens) {
                String[] exp = p.fileError.getLastExpectedImages();
                for (int i = 0; i < exp.length; ++i) {
                    String s = exp[i];
                    StringTokenizer st = new StringTokenizer(s, "\"", true);
                    boolean lastWasQuote = false;
                    StringBuffer buf = new StringBuffer(s.length());
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("\"".equals(token)) {
                            if (!lastWasQuote) continue;
                            lastWasQuote = true;
                        } else {
                            lastWasQuote = false;
                        }
                        buf.append(token);
                    }
                    this._$17168(buf.toString(), completions);
                }
            }
            if (this._$16972 != null) {
                this._$16972.setVisible(false);
                this._$16972.dispose();
            }
            if (completions.isEmpty()) {
                return;
            }
            if (completions.size() == 1) {
                boolean addSpace = false;
                this._$17170((String)completions.iterator().next(), addSpace);
            } else {
                this._$16972 = new JDialog(this);
                this._$16972.setTitle("SMI Completion");
                Vector completionVector = new Vector(completions);
                Collections.sort(completionVector);
                this._$16972.getContentPane().setLayout(new BorderLayout(5, 5));
                JScrollPane spane = new JScrollPane(20, 31);
                JList completionSelection = new JList(completionVector){

                    public void setSelectedIndex(int selectionIndex) {
                        super.setSelectedIndex(selectionIndex);
                        super.ensureIndexIsVisible(selectionIndex);
                    }
                };
                completionSelection.setSelectedIndex(0);
                boolean addSpace = false;
                CodeCompletionListener ccl = new CodeCompletionListener(pex, this._$16972, completionSelection, addSpace);
                completionSelection.addMouseListener(ccl);
                completionSelection.addKeyListener(ccl);
                spane.getViewport().add(completionSelection);
                this._$16972.getContentPane().add((Component)spane, "Center");
                Rectangle pos = null;
                try {
                    pos = this._$11941.modelToView(this.getCaretPosition());
                    Point loc = pos.getLocation();
                    loc.translate(this._$11941.getLocationOnScreen().x, this._$11941.getLocationOnScreen().y + 12);
                    this._$16972.setLocation(loc);
                }
                catch (BadLocationException ex1) {
                    ex1.printStackTrace();
                }
                this._$16972.pack();
                this._$16972.setVisible(true);
            }
        }
    }

    private void _$17170(String replacement, boolean addSpace) {
        String r = addSpace ? " " : "";
        r = r + replacement;
        this._$11941.replaceSelection(r);
    }

    private static boolean _$17183(String s, int id) {
        return s.startsWith(SMIParserConstants.tokenImage[id]);
    }

    private void _$17168(String string, Set completions) {
        if (string.trim().length() == 0) {
            return;
        }
        if (this._$16975 != null && this._$16975.isDone() && this._$16971 != null) {
            if (Notepad._$17183(string, 107)) {
                completions.addAll(this._$16971.getLowerCaseNames());
                return;
            }
            if (Notepad._$17183(string, 106)) {
                completions.addAll(this._$16971.getUpperCaseNames());
                return;
            }
        } else {
            if (Notepad._$17183(string, 107)) {
                completions.add("lowerCaseName");
                return;
            }
            if (Notepad._$17183(string, 106)) {
                completions.add("UpperCaseName");
                return;
            }
        }
        if (Notepad._$17183(string, 8)) {
            completions.add("OBJECT IDENTIFIER");
        } else if (Notepad._$17183(string, 9)) {
            completions.add("OCTET STRING");
        } else if (Notepad._$17183(string, 11)) {
            completions.add("''h");
        } else if (Notepad._$17183(string, 10)) {
            completions.add("''b");
        } else if (Notepad._$17183(string, 16)) {
            completions.add("-1");
        } else if (Notepad._$17183(string, 15)) {
            completions.add("1");
        } else if (Notepad._$17183(string, 13)) {
            completions.add("\"\"");
        } else if (Notepad._$17183(string, 12)) {
            completions.add("\"\"");
        } else {
            completions.add(string);
        }
    }

    static {
        COLUMN_NAMES = new String[]{"Number", "Error", "Description"};
        try {
            _$16963 = ResourceBundle.getBundle("com.agentpp.notepad.Notepad", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("Notepad.properties not found");
        }
    }

    class ExportSelectedErrorsAction
    extends AbstractAction {
        private boolean _$17186;

        public ExportSelectedErrorsAction(String name, boolean selectedOnly) {
            super(name);
            this._$17186 = selectedOnly;
            this.setEnabled(selectedOnly);
        }

        public void actionPerformed(ActionEvent e) {
            int[] rows = TableUtils.getSelectedRows(Notepad.this._$16964);
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(0);
            if (fc.showSaveDialog(Notepad.this.myFrame) == 0) {
                Object[] options;
                int n;
                if (fc.getSelectedFile().exists() && (n = JOptionPane.showOptionDialog(Notepad.this.myFrame, "File already exists! Replace it?", "Confirm Replace", 0, 3, null, options = new Object[]{"Yes", "Cancel"}, options[1])) == 1) {
                    return;
                }
                try {
                    FileOutputStream fos = new FileOutputStream(fc.getSelectedFile());
                    StringBuffer buf = new StringBuffer();
                    TableDataModel data = Notepad.this._$16964.getDataSource();
                    Arrays.sort(rows);
                    for (int i = 0; i < data.getNumRows(); ++i) {
                        if (this._$17186 && Arrays.binarySearch(rows, i) < 0 || data.getTableDataItem(i, 0) instanceof String) continue;
                        buf.append(data.getTableDataItem(i, 0).toString());
                        buf.append(": ");
                        SMIParseException pex = (SMIParseException)data.getTableRowLabel(i);
                        buf.append(MIBObject.formatLines("\t", DefaultRepositoryManager.getErrorText(pex) + "."));
                        buf.append("\n\n");
                    }
                    fos.write(buf.toString().getBytes());
                    fos.close();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Notepad.this.myFrame, "Error writing report: " + ex.getMessage(), "File Error", 0);
                }
            }
        }
    }

    class CompletionLookupUpdater
    implements Runnable {
        private volatile boolean _$6481 = false;

        public synchronized void run() {
            this.notify();
            try {
                if (Notepad.this._$13718 != null) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(Notepad.this.getDocumentBytes());
                    try {
                        MIBModule[] modules = Notepad.this._$13718.parseMIBs(Notepad.this, bis, "", 2);
                        MIBModule m = null;
                        if (modules.length == 1) {
                            m = modules[0];
                        } else {
                            int maxPos = 0;
                            for (int i = 0; i < modules.length; ++i) {
                                int p = modules[i].getStartPosition();
                                if (p <= maxPos || p > Notepad.this.getCaretPosition()) continue;
                                m = modules[i];
                                maxPos = p;
                            }
                        }
                        Notepad.this._$16971 = m;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (SMIParseException pex) {
                        Notepad.this._$16971 = null;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this._$6481 = true;
            this.notify();
        }

        public synchronized boolean isDone() {
            return this._$6481;
        }
    }

    private class CodeCompletionListener
    implements MouseListener,
    KeyListener {
        private SMIParseException _$8698;
        private JDialog _$6370;
        private JList _$4281;
        private boolean _$17169;

        public CodeCompletionListener(SMIParseException pex, JDialog popup, JList list, boolean addSpace) {
            this._$8698 = pex;
            this._$6370 = popup;
            this._$4281 = list;
            this._$17169 = addSpace;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this._$6151();
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this._$6151();
            } else if (e.getKeyCode() == 27) {
                this._$6370.setVisible(false);
                this._$6370.dispose();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        private void _$6151() {
            String s = (String)this._$4281.getSelectedValue();
            if (s == null) {
                return;
            }
            Notepad.this._$17170(s, this._$17169);
            this._$6370.setVisible(false);
            this._$6370.dispose();
        }
    }

    class FileLoader
    extends Thread {
        public int row = 0;
        public int col = 0;
        public int selection = 0;
        public String search = null;
        Document doc;
        File f;

        FileLoader(File f, Document doc) {
            this.setPriority(4);
            this.f = f;
            this.doc = doc;
        }

        public void run() {
            try {
                int nch;
                Notepad.this.status.removeAll();
                JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum((int)this.f.length());
                Notepad.this.status.add(progress);
                Notepad.this.status.revalidate();
                FileReader in = new FileReader(this.f);
                char[] buff = new char[4096];
                String lastline = "";
                while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                    int el;
                    String s = new String(buff, 0, nch);
                    if (lastline.length() > 0) {
                        int nl = lastline.indexOf(10);
                        if (nl >= 0) {
                            String begin = lastline.substring(0, nl);
                            s = ShowHtmlDialog.replaceTabs(lastline + begin) + ShowHtmlDialog.replaceTabs(s.substring(nl));
                        } else {
                            s = ShowHtmlDialog.replaceTabs(s);
                        }
                    }
                    lastline = (el = (s = ShowHtmlDialog.replaceTabs(s)).lastIndexOf(10)) >= 0 ? s.substring(el + 1) : "";
                    this.doc.insertString(this.doc.getLength(), s, null);
                    progress.setValue(progress.getValue() + nch);
                }
                ((Reader)in).close();
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
            catch (BadLocationException e) {
                System.err.println(e.getMessage());
            }
            if (Notepad.this.elementTreePanel != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Notepad.this.elementTreePanel.setEditor(Notepad.this.getEditor());
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FileLoader.this.doc.addUndoableEditListener(Notepad.this.undoHandler);
                    Notepad.this.status.removeAll();
                    Notepad.this.status.revalidate();
                    Notepad.this.resetUndoManager();
                    Notepad.this.setEnabled(true);
                    Notepad.this._$11941.setEditable(true);
                    if (FileLoader.this.search != null) {
                        Notepad.this.searchString(FileLoader.this.search);
                    } else {
                        try {
                            Notepad.this.setCaretPosition(FileLoader.this.row, FileLoader.this.col);
                            Notepad.this.setSelectionLength(FileLoader.this.selection);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    class PrintAction
    extends AbstractAction {
        PrintAction() {
            super(Notepad.printAction);
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.print();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super(Notepad.exitAction);
        }

        public void actionPerformed(ActionEvent e) {
            if (Notepad.this._$16973 != null) {
                Notepad.this._$16973.stop();
                Notepad.this._$16973 = null;
            }
            Notepad.this.setVisible(false);
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        ShowElementTreeAction() {
            super(Notepad.showElementTreeAction);
        }

        ShowElementTreeAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            if (Notepad.this._$17025 == null) {
                try {
                    String title = _$16963.getString("ElementTreeFrameTitle");
                    Notepad.this._$17025 = new JFrame(title);
                }
                catch (MissingResourceException mre) {
                    Notepad.this._$17025 = new JFrame();
                }
                Notepad.this._$17025.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent weeee) {
                        Notepad.this._$17025.setVisible(false);
                    }
                });
                Container fContentPane = Notepad.this._$17025.getContentPane();
                fContentPane.setLayout(new BorderLayout());
                Notepad.this.elementTreePanel = new ElementTreePanel(Notepad.this.getEditor());
                fContentPane.add(Notepad.this.elementTreePanel);
                Notepad.this._$17025.pack();
            }
            Notepad.this._$17025.setVisible(true);
        }
    }

    class CheckAccurateAction
    extends AbstractAction {
        CheckAccurateAction() {
            super("CheckAccurate");
        }

        CheckAccurateAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            if (Notepad.this._$13718 != null) {
                try {
                    Notepad.this.clearErrors();
                    ByteArrayInputStream bis = new ByteArrayInputStream(Notepad.this.getDocumentBytes());
                    Notepad.this._$13718.checkMIB(Notepad.this, bis, 1);
                    bis.close();
                    JOptionPane.showMessageDialog(Notepad.this, "The MIB file passed the SMI standard syntax check successfully.", "SMI Syntax Check OK", 1);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SMIParseException pex) {
                    Notepad.this.setError(pex);
                    JOptionPane.showMessageDialog(Notepad.this, "The MIB file contains " + (pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1) + " syntax errors!", "Syntax Check Failed", 0);
                }
            }
        }
    }

    class CheckLenientAction
    extends AbstractAction {
        CheckLenientAction() {
            super("CheckLenient");
        }

        CheckLenientAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            if (Notepad.this._$13718 != null) {
                try {
                    Notepad.this.clearErrors();
                    ByteArrayInputStream bis = new ByteArrayInputStream(Notepad.this.getDocumentBytes());
                    Notepad.this._$13718.checkMIB(Notepad.this, bis, 2);
                    bis.close();
                    JOptionPane.showMessageDialog(Notepad.this, "The MIB file passed the lenient SMI syntax check successfully.", "Lenient SMI Syntax Check OK", 1);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SMIParseException pex) {
                    Notepad.this.setError(pex);
                    JOptionPane.showMessageDialog(Notepad.this, "The MIB file contains " + (pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1) + " syntax errors!", "Syntax Check Failed", 0);
                }
            }
        }
    }

    class ImportLenientAction
    extends AbstractAction {
        ImportLenientAction() {
            super("ImportLenient");
        }

        ImportLenientAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                fo.write(Notepad.this.getDocumentBytes());
                fo.close();
                if (Notepad.this._$13718 != null) {
                    try {
                        Notepad.this.clearErrors();
                        Notepad.this._$13718.importMIB(Notepad.this, Notepad.this.file, 2);
                        Notepad.this.setVisible(false);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (SMIParseException pex) {
                        Notepad.this.setError(pex);
                    }
                }
            }
            catch (IOException iox) {
                Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
            }
        }
    }

    class ImportAccurateAction
    extends AbstractAction {
        ImportAccurateAction() {
            super("ImportAccurate");
        }

        ImportAccurateAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                fo.write(Notepad.this.getDocumentBytes());
                fo.close();
                if (Notepad.this._$13718 != null) {
                    try {
                        Notepad.this.clearErrors();
                        Notepad.this._$13718.importMIB(Notepad.this, Notepad.this.file, 1);
                        Notepad.this.setVisible(false);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (SMIParseException pex) {
                        Notepad.this.setError(pex);
                    }
                }
            }
            catch (IOException iox) {
                Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
            }
        }
    }

    class ImportAction
    extends AbstractAction {
        ImportAction() {
            super("Import");
        }

        ImportAction(String nm) {
            super(nm);
        }

        public void update() {
            if (Notepad.this.undo.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (Notepad.this.file == null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(Notepad.this.getDocumentBytes());
                try {
                    Notepad.this._$13718.importMIB(Notepad.this, bis, "", Notepad.this._$17063);
                    bis.close();
                    Notepad.this.setVisible(false);
                    Notepad.this.clearErrors();
                }
                catch (IOException iox) {
                    iox.printStackTrace();
                }
                catch (SMIParseException pex) {
                    Notepad.this.setError(pex);
                }
            } else {
                try {
                    FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                    fo.write(Notepad.this.getDocumentBytes());
                    fo.close();
                    if (Notepad.this._$13718 != null) {
                        try {
                            Notepad.this._$13718.importMIB(Notepad.this, Notepad.this.file, Notepad.this._$17063);
                            Notepad.this.setVisible(false);
                            Notepad.this.clearErrors();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (SMIParseException pex) {
                            Notepad.this.setError(pex);
                        }
                    }
                }
                catch (IOException iox) {
                    Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
                }
            }
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super(Notepad.newAction);
        }

        NewAction(String nm) {
            super(nm);
        }

        public void actionPerformed(ActionEvent e) {
            Document oldDoc = Notepad.this.getEditor().getDocument();
            if (oldDoc != null) {
                oldDoc.removeUndoableEditListener(Notepad.this.undoHandler);
            }
            Notepad.this.getEditor().setDocument(new SmiDocument());
            Notepad.this.getEditor().getDocument().addUndoableEditListener(Notepad.this.undoHandler);
            Notepad.this.resetUndoManager();
        }
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
            super(Notepad.saveAsAction);
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = Notepad.this.getFrame();
            if (Notepad.this.fileDialog == null) {
                Notepad.this.fileDialog = new FileDialog(frame);
            }
            Notepad.this.fileDialog.setMode(1);
            Notepad.this.fileDialog.setDirectory(Notepad.this.file.getParent());
            Notepad.this.fileDialog.setFile(Notepad.this.file.getName());
            Notepad.this.fileDialog.setVisible(true);
            String fs = Notepad.this.fileDialog.getFile();
            if (fs == null) {
                return;
            }
            String directory = Notepad.this.fileDialog.getDirectory();
            Notepad.this.file = new File(directory, fs);
            try {
                FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                fo.write(Notepad.this.getDocumentBytes());
                fo.close();
                Notepad.this.status.setText("Saved '" + Notepad.this.file.getPath() + "'");
                Notepad.this.setTitle(Notepad.this.file.getName());
            }
            catch (IOException iox) {
                Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super(Notepad.saveAction);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                FileOutputStream fo = new FileOutputStream(Notepad.this.file);
                fo.write(Notepad.this.getDocumentBytes());
                fo.close();
                Notepad.this.status.setText("Saved '" + Notepad.this.file.getPath() + "'");
            }
            catch (IOException iox) {
                Notepad.this.status.setText("Could not save file '" + Notepad.this.file.getPath() + "'");
            }
        }
    }

    class FindNextAction
    extends AbstractAction {
        FindNextAction() {
            super("FindNext");
        }

        public void actionPerformed(ActionEvent e) {
            Notepad.this.searchPattern(Notepad.this.lastPattern);
        }
    }

    class ReplaceAction
    extends AbstractAction {
        ReplaceAction() {
            super("Replace");
        }

        public void actionPerformed(ActionEvent e) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(true);
            sp.setSearchExpressions(Notepad.this._$6388.getArray(Notepad._$16961));
            sp.setSubstitutionStrings(Notepad.this._$6388.getArray(Notepad._$16962));
            StandardDialog sd = new StandardDialog((Frame)Notepad.this.myFrame, "Replace", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(Notepad.this.myFrame);
            do {
                Pattern p;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p = Notepad.this._$17012(sp.getSearchExpression(), false)) == null) continue;
                Notepad.this._$6388.putArray(Notepad._$16961, sp.getSearchExpressions());
                Notepad.this._$6388.putArray(Notepad._$16962, sp.getSubstitutionStrings());
                Notepad.this.replace(p, sp.getSubstitutionString());
                break;
            } while (sd.getResult() == 0);
        }
    }

    class FindAction
    extends AbstractAction {
        FindAction() {
            super("Find");
        }

        private String _$17117() {
            if (Notepad.this.getEditor().getSelectedText() != null) {
                return Notepad.this.getEditor().getSelectedText();
            }
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            SearchReplacePanel sp = new SearchReplacePanel();
            sp.setReplaceEnabled(false);
            Vector v = Notepad.this._$6388.getArray(Notepad._$16961);
            if (this._$17117() != null) {
                v.insertElementAt(this._$17117(), 0);
            }
            sp.setSearchExpressions(v);
            StandardDialog sd = new StandardDialog((Frame)Notepad.this.myFrame, "Find", true, true);
            sd.setCenterPanel(sp);
            sd.setLocationRelativeTo(Notepad.this.myFrame);
            do {
                Pattern p;
                sp.selectAll();
                sd.setVisible(true);
                if (sd.getResult() != 0 || (p = Notepad.this._$17012(sp.getSearchExpression(), false)) == null) continue;
                Notepad.this._$6388.putArray(Notepad._$16961, sp.getSearchExpressions());
                Notepad.this.searchPattern(p);
                break;
            } while (sd.getResult() == 0);
        }
    }

    class OpenAction
    extends NewAction {
        OpenAction() {
            super(Notepad.openAction);
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = Notepad.this.getFrame();
            if (Notepad.this.fileDialog == null) {
                Notepad.this.fileDialog = new FileDialog(frame);
            }
            Notepad.this.fileDialog.setMode(0);
            Notepad.this.fileDialog.setVisible(true);
            String file = Notepad.this.fileDialog.getFile();
            if (file == null) {
                return;
            }
            String directory = Notepad.this.fileDialog.getDirectory();
            File f = new File(directory, file);
            if (f.exists()) {
                Notepad.this.setTitle(file);
                Notepad.this.loadFile(f, 0, 0, 0);
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Notepad.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.update();
            Notepad.this._$17047.update();
        }

        public void redo() {
            if (Notepad.this.undo.canRedo()) {
                try {
                    Notepad.this.undo.redo();
                }
                catch (CannotRedoException ex) {
                    System.out.println("Unable to redo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            Notepad.this._$17047.update();
            Notepad.this._$17092.update();
        }

        protected void update() {
            if (Notepad.this.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Notepad.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.update();
            Notepad.this._$17048.update();
        }

        protected void update() {
            if (Notepad.this.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", Notepad.this.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }

        public void undo() {
            if (Notepad.this.undo.canUndo()) {
                try {
                    Notepad.this.undo.undo();
                }
                catch (CannotUndoException ex) {
                    System.out.println("Unable to undo: " + ex);
                    ex.printStackTrace();
                }
            }
            this.update();
            Notepad.this._$17048.update();
            Notepad.this._$17092.update();
        }
    }

    class StatusBar
    extends JLabel
    implements CaretListener {
        public StatusBar() {
            super(" ");
            this.setLayout(new BoxLayout(this, 0));
        }

        public void caretUpdate(CaretEvent e) {
            int dot = e.getDot();
            SmiDocument smidoc = (SmiDocument)Notepad.this._$11941.getDocument();
            int line = smidoc.getLineOfOffset(dot) + 1;
            int col = dot + 1 - smidoc.getLineStartOffset(smidoc.getLineOfOffset(dot));
            this.setText(line + ":" + col);
            this.setToolTipText("Cursor is located at row " + line + ", column " + col);
        }

        public void paint(Graphics g) {
            super.paint(g);
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            Notepad.this.undo.addEdit(e.getEdit());
            Notepad.this._$17047.update();
            Notepad.this._$17048.update();
        }
    }

    private class ButtonActionChangedListener
    implements PropertyChangeListener {
        JButton button;

        ButtonActionChangedListener(JButton b) {
            this.button = b;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent e) {
        }
    }
}

