/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pdf;

import com.agentpp.common.font.FontStyle;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class MIBModule2PDF {
    private static final String _$26234 = "Comments";
    private static final String _$26235 = "Keywords";
    private static final String _$26236 = "Identifier";
    private static final String _$26237 = "Values";
    private static final String _$26238 = "Types";
    private static final String _$26239 = "Clauses";
    private static final String _$26240 = "Text";
    private static final int _$26241 = 160;
    private static final int _$26242 = 160;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final SimpleDateFormat _$26244 = new SimpleDateFormat("yyyy-MM-dd");
    private MIBRepository _$11429;
    private Vector _$16576;
    private int _$17107 = 8;
    private int _$26245 = 2;
    private int _$6472 = 160;
    private float _$26246 = 11.0f;
    private float _$26247 = 10.0f;
    private String _$14287 = "";
    private Rectangle _$23341;
    private Date _$26248;
    private Font _$23458 = FontFactory.getFont("Courier", this._$26247, 0);
    private Hashtable _$26251 = new Hashtable();
    private boolean _$26252;
    private boolean _$26253;
    private boolean _$26254 = true;
    private boolean _$26255 = true;
    private Vector _$26256 = new Vector();
    private int _$26257 = 0;
    private boolean _$26258;

    public MIBModule2PDF(MIBRepository rep, Vector fontStyles, int tabSize) {
        this._$11429 = rep;
        this._$16576 = fontStyles;
        this._$17107 = tabSize;
        this._$26259(fontStyles);
    }

    public void setFontSize(float fontSize) {
        this._$23458.setSize(fontSize);
    }

    private void _$26259(Vector fontStyles) {
        for (int i = 0; i < fontStyles.size(); ++i) {
            FontStyle style = (FontStyle)fontStyles.elementAt(i);
            int s = 0;
            if (style.isBold() && style.isItalic()) {
                s = 3;
            } else if (style.isBold()) {
                s = 1;
            } else if (style.isItalic()) {
                s = 2;
            }
            Font f = FontFactory.getFont(this._$23458.getFamilyname(), this._$23458.getSize(), s, style.getColor());
            this._$26251.put(style.getName(), f);
        }
    }

    private String _$24926(int num) {
        StringBuffer buf = new StringBuffer(num);
        for (int i = 0; i < num * this._$17107; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void writePDF(MIBModule m, OutputStream os, String creator, Rectangle pageSize) throws DocumentException {
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        this._$26248 = new Date();
        this._$26245 = m.getSMIVersion();
        this._$14287 = m.getModuleName();
        this._$23341 = pageSize;
        Document doc = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance(doc, os);
        doc.addAuthor(System.getProperty("user.name"));
        doc.addKeywords(m.getModuleName() + ", " + (m.getSMIVersion() == 1 ? "SMIv1" : "SMIv2") + ", " + "MIB specification");
        doc.addTitle(m.getModuleName());
        doc.addCreator(creator);
        this._$26271(m);
        MyPageEvents events = new MyPageEvents();
        writer.setPageEvent(events);
        doc.open();
        if (m.hasCopyrightComment()) {
            this._$26256.add(null);
            doc.add(new Paragraph(this._$26246, m.getCopyrightComment(), (Font)this._$26251.get(_$26234)));
        }
        doc.add(this._$26276("\n"));
        this._$26277(doc, m);
        if (m.hasCopyrightCommentEnd()) {
            this._$26256.add(null);
            doc.add(new Paragraph(this._$26246, m.getCopyrightCommentEnd(), (Font)this._$26251.get(_$26234)));
        }
        try {
            doc.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void _$26271(MIBModule m) {
        this._$26256 = new Vector(m.size() + 1);
        this._$26257 = 0;
    }

    private Chunk _$26278(String keyword) {
        return new Chunk(keyword, (Font)this._$26251.get(_$26235));
    }

    private Chunk _$26276(String text) {
        return new Chunk(text, this._$23458);
    }

    private Chunk _$14471(String text) {
        return new Chunk(text, (Font)this._$26251.get(_$26234));
    }

    private Chunk _$4948(String text) {
        return new Chunk(text, (Font)this._$26251.get(_$26240));
    }

    private Phrase _$4948(int ident, String lines) {
        String prefix = this._$24926(ident);
        if (lines == null) {
            return new Phrase(prefix + "\"\"", (Font)this._$26251.get(_$26240));
        }
        StringTokenizer st = new StringTokenizer(lines, "\n\r", true);
        Phrase p = new Phrase();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                p.add(this._$4948(s));
                continue;
            }
            if (s.equals("\r")) continue;
            p.add(this._$4948(prefix + s));
        }
        return p;
    }

    private Chunk _$26283(String text) {
        return new Chunk(text, (Font)this._$26251.get(_$26239));
    }

    private Chunk _$8517(String text) {
        return new Chunk(text, (Font)this._$26251.get(_$26238));
    }

    private Chunk _$63(String value) {
        return new Chunk(value, (Font)this._$26251.get(_$26237));
    }

    private Chunk _$19131(String value) {
        return new Chunk(value, (Font)this._$26251.get(_$26236));
    }

    private Chunk _$26284(String objectName) {
        Chunk chunk = new Chunk(objectName, (Font)this._$26251.get(_$26236));
        chunk.setLocalGoto(objectName);
        return chunk;
    }

    private void _$26287(Paragraph doc, MIBRange range) {
        if (range.getLower().equals(range.getUpper())) {
            doc.add(this._$63(range.getUpper().toString()));
        } else {
            doc.add(this._$63(range.getLower().toString()));
            doc.add(this._$26276(".."));
            doc.add(this._$63(range.getUpper().toString()));
        }
    }

    private void _$26288(Paragraph doc, MIBEnum enumeration) {
        doc.add(this._$19131(enumeration.getLabel()));
        doc.add(this._$26276("("));
        doc.add(this._$63(enumeration.getValue()));
        doc.add(this._$26276(")"));
    }

    private void _$23149(Paragraph doc, MIBSyntax syn) {
        switch (syn.getType()) {
            case 2: {
                doc.add(this._$26278("SEQUENCE OF "));
                doc.add(this._$63(syn.getSyntax()));
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (this._$11429.getObject(syn.getSyntax()) != null) {
                    doc.add(this._$26284(syn.getSyntax()));
                } else {
                    doc.add(this._$8517(syn.getSyntax()));
                }
                if (!syn.hasRanges()) break;
                MIBTextualConvention effective = this._$11429.getEffectiveSyntax(syn);
                MIBSyntax base = effective.getSyntax();
                if (base.getSyntax().equals(SMI.SMI_SYNTAX[1]) || base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    doc.add(this._$26276(" ("));
                    doc.add(this._$26278("SIZE"));
                }
                doc.add(this._$26276(" ("));
                Enumeration en = syn.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    this._$26287(doc, (MIBRange)en.nextElement());
                    if (!en.hasMoreElements()) continue;
                    doc.add(this._$26276(" | "));
                }
                doc.add(this._$26276(")"));
                if (!base.getSyntax().equals(SMI.SMI_SYNTAX[1]) && !base.getSyntax().equals(SMI.SMI_SYNTAX[12])) break;
                doc.add(this._$26276(")"));
            }
        }
        if (syn.hasEnums()) {
            doc.add(this._$26276(" {\n" + this._$24926(3)));
            int max = MIBObject.getMaxLength(syn.getEnumsVector().elements());
            Enumeration en = syn.getEnumsVector().elements();
            while (en.hasMoreElements()) {
                MIBEnum enumeration = (MIBEnum)en.nextElement();
                this._$26288(doc, enumeration);
                if (enumeration.hasComment()) {
                    if (en.hasMoreElements()) {
                        doc.add(this._$26276(","));
                    } else {
                        doc.add(this._$26276(" "));
                    }
                    String space = MIBObject.space(max - enumeration.toString().length() + 1);
                    doc.add(this._$26276(space));
                    String lines = enumeration.getComment();
                    String first = enumeration.getComment();
                    int suffix = lines.indexOf(10);
                    if (suffix < 0) {
                        lines = null;
                    } else {
                        first = lines.substring(0, suffix);
                        lines = lines.substring(suffix);
                    }
                    doc.add(this._$14471(this._$24926(1) + first));
                    if (lines != null) {
                        StringTokenizer st = new StringTokenizer(lines, "\n");
                        while (st.hasMoreTokens()) {
                            doc.add(this._$26276("\n" + this._$24926(4) + MIBObject.space(max)));
                            doc.add(this._$14471(st.nextToken()));
                        }
                    }
                    doc.add(this._$26276("\n" + this._$24926(3)));
                    continue;
                }
                if (en.hasMoreElements()) {
                    doc.add(this._$26276(",\n" + this._$24926(3)));
                    continue;
                }
                doc.add(this._$26276(" "));
            }
            doc.add(this._$26276("}"));
        }
    }

    private void _$26292(Paragraph doc, MIBObject o) {
        doc.add(this._$26276(this._$24926(1)));
        doc.add(this._$26283("STATUS      "));
        if (!o.hasStatus()) {
            doc.add(this._$26276("current"));
        } else {
            doc.add(this._$26276(o.getStatus()));
        }
        doc.add(this._$26276("\n" + this._$24926(1)));
        doc.add(this._$26283("DESCRIPTION"));
        if (!o.hasDescription()) {
            doc.add(this._$4948(" \"\"\n"));
        } else {
            doc.add(this._$26276("\n"));
            doc.add(this._$4948(2, o.getDescription()));
            doc.add(this._$26276("\n"));
        }
        if (o.hasReference()) {
            doc.add(this._$26276(this._$24926(1)));
            doc.add(this._$26283("REFERENCE"));
            doc.add(this._$4948(2, o.getReference()));
            doc.add(this._$26276("\n"));
        }
    }

    private void _$26293(Paragraph doc, ObjectID oid, MIBObject parent, String qualified) {
        try {
            int diff = oid.size();
            doc.add(this._$26276("{ "));
            if (parent != null) {
                diff = oid.size() - parent.getOid().size();
                if (qualified != null) {
                    doc.add(this._$26284(qualified + "." + parent.getName()));
                } else {
                    doc.add(this._$26284(parent.getName()));
                }
            }
            doc.add(this._$26276(" "));
            for (int i = oid.size() - diff; i < oid.size(); ++i) {
                String oname = null;
                if (i + 1 < oid.size()) {
                    this._$11429.getObjectName(oid.getPrefix(i + 1));
                }
                if (oname != null) {
                    doc.add(this._$19131(oname));
                    doc.add(this._$26276("("));
                    doc.add(this._$63(oid.getSubID(i)));
                    doc.add(this._$26276(")"));
                } else {
                    doc.add(this._$63(oid.getSubID(i)));
                }
                doc.add(this._$26276(" "));
            }
            doc.add(this._$26276("}"));
        }
        catch (ObjectIDFormatException ex) {
            doc.add(this._$26276("{ " + oid.toString() + " }"));
        }
    }

    private void _$26297(Paragraph doc, MIBObject o, MIBObject parent) {
        MIBObject[] parents = this._$11429.getObjectsByName(parent.getName());
        if (parents == null || parents.length <= 1) {
            this._$26293(doc, o.getOid(), parent, null);
        } else {
            String m = this._$11429.getModuleName(parent.getModuleID());
            if (m == null) {
                this._$26293(doc, o.getOid(), parent, null);
            } else {
                this._$26293(doc, o.getOid(), parent, m);
            }
        }
    }

    private void _$26299(Paragraph doc, MIBObject o) {
        if ((this._$6472 & 0x20) > 0) {
            if ((this._$6472 & 0x400) > 0) {
                doc.add(this._$14471(" -- " + o.getPrintableOid() + " --  "));
            } else {
                doc.add(this._$26276(this._$24926(1)));
                doc.add(this._$14471("-- " + o.getPrintableOid()));
                doc.add(this._$26276("\n"));
                doc.add(this._$26276(this._$24926(1)));
            }
        } else {
            doc.add(this._$26276(this._$24926(1)));
        }
        doc.add(this._$26278("::= "));
        MIBObject parent = this._$11429.getParent(o);
        if (parent == null) {
            doc.add(this._$26276(o.getOid().toSMI()));
        } else if (o instanceof MIBModule && parent.getModuleID() == o.getModuleID()) {
            while (parent != null && parent.getModuleID() == o.getModuleID()) {
                parent = this._$11429.getParent(parent);
            }
            if (parent == null) {
                this._$26293(doc, o.getOid(), parent, null);
            } else {
                this._$26297(doc, o, parent);
            }
        } else {
            this._$26297(doc, o, parent);
        }
    }

    private void _$26300(Paragraph doc, MIBIndexPart index) {
        if (index.getType() == 1) {
            doc.add(this._$26283("INDEX "));
        } else {
            doc.add(this._$26283("AUGMENTS "));
        }
        doc.add(this._$26276("{\n"));
        String[] ind = index.getIndexPart();
        Vector v = index.getIndexPartVector();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this._$26276(this._$24926(2)));
            if (index.isImplied() && !en.hasMoreElements()) {
                doc.add(this._$26278("IMPLIED "));
            }
            doc.add(this._$26284(element));
            if (en.hasMoreElements()) {
                doc.add(this._$26276(",\n"));
                continue;
            }
            doc.add(this._$26276("\n"));
        }
        doc.add(this._$26276(this._$24926(1) + "}\n"));
    }

    private void _$26302(Document doc, MIBObject o) throws DocumentException {
        Paragraph para = this._$26304(doc, o);
        if (o.getType() == 0 && o.hasStatus()) {
            para.add(this._$26278(" OBJECT-IDENTITY\n"));
            this._$26292(para, o);
        } else {
            para.add(this._$26278(" OBJECT IDENTIFIER"));
        }
        para.add(this._$26276("\n"));
        this._$26299(para, o);
        doc.add(para);
    }

    private void _$26305(Document doc, MIBObjectType ot) throws DocumentException {
        Paragraph p = this._$26304(doc, ot);
        p.add(this._$26278(" OBJECT-TYPE"));
        p.add(this._$26276("\n" + this._$24926(1)));
        p.add(this._$26283("SYNTAX      "));
        this._$23149(p, ot.getSyntax());
        p.add(this._$26276("\n"));
        if (ot.hasUnits()) {
            p.add(this._$26276(this._$24926(1)));
            p.add(this._$26283("UNITS       "));
            if (ot.getUnits().indexOf(10) > 0) {
                p.add(this._$26276("\n"));
                p.add(this._$4948(2, ot.getUnits()));
            } else {
                p.add(this._$4948(ot.getUnits()));
            }
            p.add(this._$26276("\n"));
        }
        p.add(this._$26276(this._$24926(1)));
        if (this._$26245 == 1) {
            p.add(this._$26283("ACCESS      "));
        } else {
            p.add(this._$26283("MAX-ACCESS  "));
        }
        p.add(this._$26276(ot.getAccess()));
        p.add(this._$26276("\n"));
        this._$26292(p, ot);
        if (ot.hasIndexPart()) {
            p.add(this._$26276(this._$24926(1)));
            this._$26300(p, ot.getIndexPart());
        }
        if (ot.hasDefaultValue()) {
            p.add(this._$26276(this._$24926(1)));
            p.add(this._$26283("DEFVAL      "));
            p.add(this._$26276("{ "));
            p.add(this._$63(ot.getDefaultValue()));
            p.add(this._$26276(" }\n"));
        }
        this._$26299(p, ot);
        if (this._$11429 != null && ot.isTable()) {
            p.add(this._$26276("\n\n"));
            p.add(this._$19131(ot.getSyntax().getSyntax()));
            p.add(this._$26276(" ::= "));
            p.add(this._$26278("SEQUENCE"));
            p.add(this._$26276(" {\n"));
            int max = MIBObject.getMaxLength(ot.getTableEntriesVector().elements());
            if (ot.getTableEntriesVector().size() == 0) {
                p.add(this._$26276(this._$24926(1) + "}\n"));
            }
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                p.add(this._$26276(this._$24926(2)));
                p.add(this._$26284(s));
                p.add(this._$26276(MIBObject.space(max - s.length() + 1)));
                MIBObjectType o = (MIBObjectType)this._$11429.getObject(s);
                if (o == null) continue;
                p.add(this._$19131(o.getSyntax().getSyntax()));
                if (en.hasMoreElements()) {
                    p.add(this._$26276(",\n"));
                    continue;
                }
                p.add(this._$26276("\n" + this._$24926(1) + "}\n"));
            }
            p.add(this._$26276("\n"));
        }
        doc.add(p);
    }

    private Paragraph _$26304(Document doc, MIBObject o) throws DocumentException {
        if (o.hasComment()) {
            this._$26256.add(null);
            doc.add(new Paragraph(this._$26246, this._$14471(o.getComment())));
        }
        Chunk chunk = new Chunk(o.getName(), (Font)this._$26251.get(_$26236));
        chunk.setLocalDestination(o.getName());
        this._$26256.add(o);
        Paragraph para = new Paragraph(this._$26246, "\n");
        para.add(chunk);
        para.setKeepTogether(this._$26252);
        return para;
    }

    private Phrase _$26308(int indent, Enumeration en, boolean link) {
        Phrase doc = new Phrase();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this._$26276(this._$24926(indent)));
            if (link) {
                doc.add(this._$26284(element));
            } else {
                doc.add(this._$19131(element));
            }
            if (en.hasMoreElements()) {
                doc.add(this._$26276(",\n"));
                continue;
            }
            doc.add(this._$26276("\n"));
        }
        return doc;
    }

    private void _$26310(Document doc, MIBNotifyType o) throws DocumentException {
        Paragraph p = this._$26304(doc, o);
        if (o.isV1Trap()) {
            p.add(this._$26278(" TRAP-TYPE"));
            p.add(this._$26276("\n" + this._$24926(1)));
            p.add(this._$26283("ENTERPRISE "));
            p.add(this._$26276(o.getEnterprise() + "\n"));
            if (o.hasVariables()) {
                p.add(this._$26276(this._$24926(1)));
                p.add(this._$26283("VARIABLES"));
                p.add(this._$26276(" {\n"));
                p.add(this._$26308(2, o.getVariablesVector().elements(), true));
                p.add(this._$26276(this._$24926(1) + "}\n"));
            }
            if (o.hasDescription()) {
                p.add(this._$26276("\n" + this._$24926(1)));
                p.add(this._$26283("DESCRIPTION "));
                p.add(this._$26276("\n"));
                if (!o.hasDescription()) {
                    p.add(this._$4948(" \"\"\n"));
                } else {
                    p.add(this._$26276("\n"));
                    p.add(this._$4948(2, o.getDescription()));
                    p.add(this._$26276("\n"));
                }
            }
        } else {
            p.add(this._$26283(" NOTIFICATION-TYPE"));
            p.add(this._$26276("\n"));
            if (o.hasVariables()) {
                p.add(this._$26276(this._$24926(1)));
                p.add(this._$26283("OBJECTS"));
                p.add(this._$26276(" {\n"));
                p.add(this._$26308(2, o.getVariablesVector().elements(), true));
                p.add(this._$26276(this._$24926(1) + "}\n"));
            }
            this._$26292(p, o);
        }
        if (o.isV1Trap()) {
            try {
                p.add(this._$26276(" ::= "));
                p.add(this._$63("" + o.getOid().getLastSubID()));
                p.add(this._$26276("\n"));
            }
            catch (ObjectIDFormatException oex) {}
        } else {
            this._$26299(p, o);
        }
        doc.add(p);
    }

    private void _$26316(Document doc, MIBGroup o) throws DocumentException {
        Paragraph p = this._$26304(doc, o);
        p.add(this._$26278(" " + SMI.ENTRY_TYPES[o.getType()]));
        p.add(this._$26276("\n"));
        if (o.getType() == 7) {
            p.add(this._$26276(this._$24926(1)));
            p.add(this._$26283("NOTIFICATIONS"));
            p.add(this._$26276(" {\n"));
        } else {
            p.add(this._$26276(this._$24926(1)));
            p.add(this._$26283("OBJECTS"));
            p.add(this._$26276(" {\n"));
        }
        p.add(this._$26308(2, o.getObjectsVector().elements(), true));
        p.add(this._$26276(this._$24926(1) + "}\n"));
        this._$26292(p, o);
        this._$26299(p, o);
        doc.add(p);
    }

    private void _$26317(Paragraph p, MIBVariation o) {
        p.add(this._$26276(this._$24926(1)));
        if (o instanceof MIBException) {
            p.add(this._$26283("OBJECT         "));
        } else {
            p.add(this._$26283("VARIATION      "));
        }
        p.add(this._$26276(o.getVariation()));
        if (o.hasSyntax()) {
            p.add(this._$26276("\n" + this._$24926(1) + "  "));
            p.add(this._$26283("SYNTAX       "));
            this._$23149(p, o.getSyntax());
        }
        if (o.hasWriteSyntax()) {
            p.add(this._$26276("\n" + this._$24926(1) + "  "));
            p.add(this._$26283("WRITE-SYNTAX "));
            this._$23149(p, o.getWriteSyntax());
        }
        if (o.hasAccess()) {
            p.add(this._$26276("\n" + this._$24926(1) + "  "));
            if (o instanceof MIBException) {
                p.add(this._$26283("MIN-ACCESS   "));
            } else {
                p.add(this._$26283("ACCESS       "));
            }
            p.add(this._$26276(o.getAccess()));
        }
        if (o.hasCreationRequires()) {
            p.add(this._$26276("\n" + this._$24926(1) + "  "));
            p.add(this._$26283("CREATION-REQUIRES"));
            p.add(this._$26276(" {\n"));
            p.add(this._$26308(3, o.getCreationRequiresVector().elements(), false));
            p.add(this._$26276(" }"));
        }
        if (o.hasDefaultValue()) {
            p.add(this._$26276("\n" + this._$24926(1) + "  "));
            p.add(this._$26283("DEFVAL       "));
            p.add(this._$26276(" { "));
            p.add(this._$26276(o.getDefval()));
            p.add(this._$26276(" }"));
        }
        p.add(this._$26276("\n" + this._$24926(1) + "  "));
        p.add(this._$26283("DESCRIPTION "));
        if (o.getDescription() != null) {
            p.add(this._$26276("\n"));
            p.add(this._$4948(2, o.getDescription()));
        } else {
            p.add(this._$4948("\"\""));
        }
        p.add(this._$26276("\n"));
    }

    private void _$26318(Paragraph p, MIBComplianceModule o) {
        p.add(this._$26276(this._$24926(1)));
        p.add(this._$26283("MODULE "));
        if (o.hasModuleName()) {
            p.add(this._$19131(o.getModuleName()));
        }
        p.add(this._$26276("\n"));
        if (o.hasMandatory()) {
            p.add(this._$26276(this._$24926(1)));
            p.add(this._$26283("MANDATORY-GROUPS"));
            p.add(this._$26276(" {\n"));
            p.add(this._$26308(3, o.getMandatoryVector().elements(), false));
            p.add(this._$26276(this._$24926(1) + "}\n"));
        }
        if (o.hasVariations()) {
            Enumeration en = o.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$26317(p, v);
            }
        }
    }

    private void _$26319(Document doc, MIBCompliance o) throws DocumentException {
        if (this._$26245 > 1) {
            Paragraph p = this._$26304(doc, o);
            p.add(this._$26278(" MODULE-COMPLIANCE"));
            p.add(this._$26276("\n"));
            this._$26292(p, o);
            Enumeration en = o.getModules().elements();
            while (en.hasMoreElements()) {
                this._$26318(p, (MIBComplianceModule)en.nextElement());
            }
            this._$26299(p, o);
            doc.add(p);
        }
    }

    private void _$26320(Paragraph p, MIBSupportedModule o) {
        p.add(this._$26276("\n\n" + this._$24926(1)));
        p.add(this._$26283("SUPPORTS "));
        p.add(this._$26276(o.getSupports()));
        p.add(this._$26276("\n" + this._$24926(1)));
        p.add(this._$26283("INCLUDES"));
        p.add(this._$26276(" {\n"));
        p.add(this._$26308(2, o.getIncludes().elements(), false));
        p.add(this._$26276(this._$24926(1) + "}\n"));
        if (o.hasVariations()) {
            Enumeration en = o.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$26317(p, v);
            }
        }
    }

    private void _$26321(Document doc, MIBAgentCaps o) throws DocumentException {
        if (this._$26245 > 1) {
            Paragraph p = this._$26304(doc, o);
            p.setKeepTogether(false);
            p.add(this._$26278(" AGENT-CAPABILITIES"));
            p.add(this._$26276("\n\n" + this._$24926(1)));
            p.add(this._$26283("PRODUCT-RELEASE"));
            p.add(this._$26276("\n"));
            p.add(this._$4948(2, o.getProductRelease()));
            p.add(this._$26276("\n"));
            this._$26292(p, o);
            Enumeration en = o.getModules().elements();
            while (en.hasMoreElements()) {
                this._$26320(p, (MIBSupportedModule)en.nextElement());
            }
            this._$26299(p, o);
            doc.add(p);
        }
    }

    private void _$26322(Document doc, MIBTextualConvention o) throws DocumentException {
        Paragraph p = this._$26304(doc, o);
        if (!o.hasStatus() || SMI.statusType(o.getStatus()) == 0) {
            p.add(this._$26276(" ::= "));
            this._$23149(p, o.getSyntax());
        } else {
            p.add(this._$26276(" ::= "));
            p.add(this._$26278("TEXTUAL-CONVENTION"));
            p.add(this._$26276("\n"));
            if (o.hasDisplayHint()) {
                p.add(this._$26276(this._$24926(1)));
                p.add(this._$26283("DISPLAY-HINT "));
                p.add(this._$4948(o.getDisplayHint()));
                p.add(this._$26276("\n"));
            }
            this._$26292(p, o);
            p.add(this._$26276(this._$24926(1)));
            p.add(this._$26283("SYNTAX      "));
            this._$23149(p, o.getSyntax());
        }
        doc.add(p);
    }

    private void writeObject(Document doc, MIBObject o) throws DocumentException {
        if (o instanceof MIBObjectType) {
            this._$26305(doc, (MIBObjectType)o);
        } else if (o instanceof MIBTextualConvention) {
            this._$26322(doc, (MIBTextualConvention)o);
        } else if (o instanceof MIBNotifyType) {
            this._$26310(doc, (MIBNotifyType)o);
        } else if (o instanceof MIBGroup) {
            this._$26316(doc, (MIBGroup)o);
        } else if (o instanceof MIBCompliance) {
            this._$26319(doc, (MIBCompliance)o);
        } else if (o instanceof MIBAgentCaps) {
            this._$26321(doc, (MIBAgentCaps)o);
        } else {
            this._$26302(doc, o);
        }
    }

    private void _$17338(Document doc, MIBModule m) throws DocumentException {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(this._$6472));
        Enumeration en = m.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o : orderedObjects.values()) {
            if (!(o instanceof MIBModule)) {
                this.writeObject(doc, o);
                continue;
            }
            if (!(o instanceof MIBModule) || m.getSMIVersion() != 1 || !o.getOid().isValid()) continue;
            this.writeObject(doc, o);
        }
    }

    private Chunk _$26324(String moduleName, String objectName) {
        Chunk anchor;
        if (moduleName != null) {
            anchor = new Chunk(moduleName + "." + objectName, (Font)this._$26251.get(_$26236));
            anchor.setLocalDestination(moduleName + "." + objectName);
        } else {
            anchor = new Chunk(objectName, (Font)this._$26251.get(_$26236));
            anchor.setLocalDestination(objectName);
        }
        return anchor;
    }

    private void _$26325(Paragraph doc, MIBImport imports) {
        Enumeration en = imports.getImportsVector().elements();
        while (en.hasMoreElements()) {
            doc.add(this._$26276(this._$24926(1)));
            String name = en.nextElement().toString();
            MIBObject[] o = this._$11429.getObjectsByName(name);
            if (o != null && o.length > 1) {
                doc.add(this._$26324(imports.getSource(), name));
            } else {
                doc.add(this._$26324(null, name));
            }
            if (!en.hasMoreElements()) continue;
            doc.add(this._$26276(",\n"));
        }
        doc.add(this._$26276("\n" + this._$24926(2)));
        doc.add(this._$26278("FROM "));
        doc.add(this._$19131(imports.getSource()));
        if (imports.hasComment()) {
            doc.add(this._$26276(this._$24926(2)));
            doc.add(this._$14471(imports.getComment()));
        }
    }

    private void _$26326(Document doc, MIBModule o) throws DocumentException {
        if (this._$26245 > 1 && o.getOid().size() > 0) {
            String d;
            Paragraph p = this._$26304(doc, o);
            p.add(this._$26278(" MODULE-IDENTITY"));
            p.add(this._$26276("\n" + this._$24926(1)));
            p.add(this._$26283("LAST-UPDATED "));
            p.add(this._$4948(o.getLastUpdated()));
            if ((this._$6472 & 0x20) > 0 && (d = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(o.getLastUpdated()))) != null) {
                p.add(this._$26276(this._$24926(1)));
                p.add(this._$14471("-- " + d));
            }
            p.add(this._$26276("\n" + this._$24926(1)));
            p.add(this._$26283("ORGANIZATION "));
            p.add(this._$4948(o.getOrganization()));
            p.add(this._$26276("\n" + this._$24926(1)));
            p.add(this._$26283("CONTACT-INFO"));
            p.add(this._$26276("\n"));
            p.add(this._$4948(2, o.getContactInfo()));
            p.add(this._$26276("\n" + this._$24926(1)));
            p.add(this._$26283("DESCRIPTION"));
            p.add(this._$26276("\n"));
            p.add(this._$4948(2, o.getDescription()));
            p.add(this._$26276("\n"));
            if (o.hasRevisions()) {
                Enumeration en = o.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    String d2;
                    MIBRevision r = (MIBRevision)en.nextElement();
                    p.add(this._$26276("\n" + this._$24926(1)));
                    p.add(this._$26283("REVISION "));
                    p.add(this._$4948(r.getRevision()));
                    if ((this._$6472 & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(r.getRevision()))) != null) {
                        p.add(this._$26276(this._$24926(1)));
                        p.add(this._$14471("-- " + d2));
                    }
                    p.add(this._$26276("\n" + this._$24926(1)));
                    p.add(this._$26283("DESCRIPTION"));
                    p.add(this._$26276("\n"));
                    p.add(this._$4948(2, r.getDescription()));
                    p.add(this._$26276("\n"));
                }
            }
            this._$26299(p, o);
            doc.add(p);
        }
    }

    private void _$26277(Document doc, MIBModule m) throws DocumentException {
        this._$26256.add(m.getModuleName());
        Paragraph top = new Paragraph(this._$26246, this._$26276(m.getModuleName()));
        top.add(this._$26278(" DEFINITIONS ::= BEGIN"));
        top.add(this._$26276("\n\n"));
        doc.add(top);
        if (m.hasImports()) {
            this._$26256.add("IMPORTS");
            Paragraph p = new Paragraph(this._$26246, "IMPORTS\n", (Font)this._$26251.get(_$26235));
            Enumeration en = m.getImportsVector().elements();
            while (en.hasMoreElements()) {
                MIBImport mi = (MIBImport)en.nextElement();
                this._$26325(p, mi);
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                p.add(this._$26276("\n"));
            }
            p.add(this._$26276(";"));
            doc.add(p);
        }
        this._$26326(doc, m);
        this._$17338(doc, m);
        doc.add(this._$26276("\n"));
        this._$26256.add("END");
        doc.add(new Paragraph("END", (Font)this._$26251.get(_$26235)));
    }

    public void setDefaultFont(Font defaultFont) {
        this._$23458 = defaultFont;
    }

    public Font getDefaultFont() {
        return this._$23458;
    }

    public void setLeading(float leading) {
        this._$26246 = leading;
    }

    public void setKeepTogether(boolean keepTogether) {
        this._$26252 = keepTogether;
    }

    public boolean isKeepTogether() {
        return this._$26252;
    }

    public void setDisplayPageNumbers(boolean displayPageNumbers) {
        this._$26253 = displayPageNumbers;
    }

    public boolean isDisplayPageNumbers() {
        return this._$26253;
    }

    public void setOutlineAsTree(boolean outlineTree) {
        this._$26254 = outlineTree;
        if (outlineTree) {
            this._$6472 = 160;
        }
    }

    public boolean isOutlineAsTree() {
        return this._$26254;
    }

    public void setShowBookmarks(boolean showBookmarks) {
        this._$26255 = showBookmarks;
    }

    public boolean isShowBookmarks() {
        return this._$26255;
    }

    public void setDisplayCurrentDate(boolean displayCurrentDate) {
        this._$26258 = displayCurrentDate;
    }

    public void setMode(int mode) {
        this._$6472 = mode;
    }

    public boolean isDisplayCurrentDate() {
        return this._$26258;
    }

    public int getMode() {
        return this._$6472;
    }

    class MyPageEvents
    extends PdfPageEventHelper {
        PdfContentByte cb;
        PdfTemplate template;
        BaseFont bf = null;

        MyPageEvents() {
        }

        public void onParagraph(PdfWriter writer, Document document, float position) {
            try {
                PdfContentByte cb = writer.getDirectContent();
                PdfOutline root = null;
                String title = null;
                if (MIBModule2PDF.this._$26256.elementAt(MIBModule2PDF.this._$26257) == null) {
                    MIBModule2PDF.this._$26257++;
                    return;
                }
                MIBObject o = null;
                if (MIBModule2PDF.this._$26256.elementAt(MIBModule2PDF.this._$26257) instanceof MIBObject) {
                    o = (MIBObject)MIBModule2PDF.this._$26256.elementAt(MIBModule2PDF.this._$26257);
                    title = o.getName();
                    MIBObject parent = MIBModule2PDF.this._$11429.getParent(o);
                    if (parent != null) {
                        root = (PdfOutline)parent.userObject;
                    }
                } else {
                    title = MIBModule2PDF.this._$26256.elementAt(MIBModule2PDF.this._$26257).toString();
                }
                if (!MIBModule2PDF.this._$26254 || root == null) {
                    root = cb.getRootOutline().getKids().size() > 0 ? (PdfOutline)cb.getRootOutline().getKids().get(0) : cb.getRootOutline();
                }
                PdfDestination destination = new PdfDestination(2, position);
                PdfOutline outline = new PdfOutline(root, destination, title);
                if (o != null) {
                    o.userObject = outline;
                }
                MIBModule2PDF.this._$26257++;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            try {
                this.bf = BaseFont.createFont("Courier", "Cp1252", false);
                this.cb = writer.getDirectContent();
                this.template = this.cb.createTemplate(50.0f, 50.0f);
            }
            catch (DocumentException de) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onEndPage(PdfWriter writer, Document document) {
            if (!MIBModule2PDF.this._$26253) {
                return;
            }
            int pageN = writer.getPageNumber();
            String text = "Page " + pageN + " of     ";
            float lenNum = this.bf.getWidthPoint("8888", 8.0f);
            float len = this.bf.getWidthPoint(text, 8.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(MIBModule2PDF.this._$23341.getWidth() - 30.0f - len, 30.0f);
            this.cb.showText(text);
            this.cb.endText();
            this.cb.addTemplate(this.template, MIBModule2PDF.this._$23341.getWidth() - 30.0f - lenNum, 30.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(30.0f, 30.0f);
            this.cb.showText(MIBModule2PDF.this._$14287);
            this.cb.endText();
            if (MIBModule2PDF.this._$26258) {
                this.cb.beginText();
                this.cb.setFontAndSize(this.bf, 8.0f);
                String date = _$26244.format(MIBModule2PDF.this._$26248);
                len = this.bf.getWidthPoint(date, 8.0f);
                this.cb.setTextMatrix(MIBModule2PDF.this._$23341.getWidth() / 2.0f - len / 2.0f, 30.0f);
                this.cb.showText(date);
                this.cb.endText();
            }
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            this.template.beginText();
            this.template.setFontAndSize(this.bf, 8.0f);
            this.template.showText(String.valueOf(writer.getPageNumber() - 1));
            this.template.endText();
        }
    }
}

