/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.smi.IObjectID;
import com.agentpp.smi.ext.SMIObjectID;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class ObjectID
implements Serializable,
SMIObjectID,
Comparable {
    public static final long serialVersionUID = 1000L;
    protected String oid;
    protected int hash = -1;
    protected int size = -1;
    protected long[] subIDs = null;

    public ObjectID() {
        this.oid = "";
        this.size = 0;
        this.hash = 0;
    }

    public ObjectID(String string) {
        this.set(string);
    }

    public ObjectID(ObjectID objectID) {
        this.oid = objectID.oid;
        if (objectID.subIDs != null) {
            this.subIDs = new long[objectID.subIDs.length];
            System.arraycopy(objectID.subIDs, 0, this.subIDs, 0, objectID.subIDs.length);
            this.size = this.subIDs.length;
            this.hash = objectID.hash;
        }
    }

    public ObjectID(IObjectID iObjectID) {
        this(((Object)iObjectID).toString());
    }

    public ObjectID(long[] lArray) {
        this.subIDs = lArray;
        this.oid = ObjectID.fromLongArray(lArray);
        this.size = lArray.length;
    }

    public ObjectID(int[] nArray) {
        this.subIDs = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.subIDs[i] = 0xFFFFFFFFFFFFFFFFL & (long)nArray[i];
        }
        this.oid = ObjectID.fromLongArray(this.subIDs);
        this.size = nArray.length;
    }

    public String get() {
        return this.oid;
    }

    public void set(String string) {
        this.oid = string == null ? "" : string;
        this.hashCode();
        this.size = -1;
        this.subIDs = null;
    }

    public int size() {
        if (this.size == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
            this.size = stringTokenizer.countTokens();
        }
        return this.size;
    }

    private void needLongArray() throws ObjectIDFormatException {
        if (this.subIDs == null) {
            this.subIDs = ObjectID.toLongArray(this.oid);
            this.size = this.subIDs.length;
        }
    }

    public void append(long l) throws ObjectIDFormatException {
        this.needLongArray();
        if (this.subIDs != null) {
            long[] lArray = new long[++this.size];
            System.arraycopy(this.subIDs, 0, lArray, 0, this.size - 1);
            lArray[this.size - 1] = l;
            this.subIDs = lArray;
        }
        this.oid = this.oid.length() == 0 ? "" + l : this.oid + "." + l;
    }

    public void append(ObjectID objectID) {
        if (objectID == null || objectID.size() == 0) {
            return;
        }
        if (this.subIDs != null && objectID.subIDs != null) {
            long[] lArray = new long[this.size + objectID.subIDs.length];
            System.arraycopy(this.subIDs, 0, lArray, 0, this.subIDs.length);
            System.arraycopy(objectID.subIDs, 0, lArray, this.subIDs.length, objectID.subIDs.length);
            this.subIDs = lArray;
            this.size = lArray.length;
        }
        this.oid = this.oid.length() == 0 ? objectID.oid : this.oid + "." + objectID.oid;
    }

    public ObjectID getPrefix(int n) throws ObjectIDFormatException {
        if (n <= 0) {
            return new ObjectID();
        }
        this.needLongArray();
        long[] lArray = new long[n];
        System.arraycopy(this.subIDs, 0, lArray, 0, n);
        return new ObjectID(lArray);
    }

    public ObjectID getSuffix(int n) throws ObjectIDFormatException {
        this.needLongArray();
        if (this.subIDs.length - n <= 0) {
            return new ObjectID();
        }
        long[] lArray = new long[n];
        System.arraycopy(this.subIDs, this.subIDs.length - n, lArray, 0, n);
        return new ObjectID(lArray);
    }

    public void setSubID(int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        if (n >= stringArray.length) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n && i < stringArray.length; ++i) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(".");
        }
        stringBuffer.append(string);
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(".");
            stringBuffer.append(stringTokenizer.nextToken());
        }
        this.oid = stringBuffer.toString();
    }

    public void setSubID(int n, long l) {
        if (this.subIDs != null) {
            this.subIDs[n] = l;
            this.oid = ObjectID.fromLongArray(this.subIDs);
        } else {
            this.setSubID(n, "" + l);
        }
    }

    public String getSubID(int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        if (n >= stringTokenizer.countTokens()) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            stringTokenizer.nextToken();
        }
        return stringTokenizer.nextToken();
    }

    public long getSubIDAsLong(int n) throws ObjectIDFormatException {
        this.needLongArray();
        return this.subIDs[n];
    }

    public static String fromArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public static String fromArrayToSMI(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String fromLongArray(long[] lArray) {
        StringBuffer stringBuffer = new StringBuffer(lArray.length * 3);
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(lArray[i]);
            if (i + 1 >= lArray.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public long[] toLongArray() throws ObjectIDFormatException {
        return ObjectID.toLongArray(this.oid);
    }

    public long[] getLongArray() {
        try {
            return this.toLongArray();
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return null;
        }
    }

    public static String[] toArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static long[] toLongArray(String string) throws ObjectIDFormatException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        int n = stringTokenizer.countTokens();
        long[] lArray = new long[n];
        n = 0;
        StringBuffer stringBuffer = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (stringBuffer == null && ((String)object).startsWith("'")) {
                stringBuffer = new StringBuffer();
                object = ((String)object).substring(1);
            }
            if (stringBuffer != null && ((String)object).endsWith("'")) {
                stringBuffer.append(((String)object).substring(0, ((String)object).length() - 1));
                ObjectID objectID = ObjectID.asOID(stringBuffer.toString());
                long[] lArray2 = lArray;
                lArray = new long[stringTokenizer.countTokens() + lArray2.length + objectID.size()];
                System.arraycopy(lArray2, 0, lArray, 0, n);
                System.arraycopy(objectID.getLongArray(), 0, lArray, n, objectID.size());
                n += objectID.size();
                stringBuffer = null;
                continue;
            }
            if (stringBuffer != null) {
                stringBuffer.append((String)object);
                continue;
            }
            if (".".equals(object)) continue;
            try {
                lArray[n++] = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ObjectIDFormatException();
            }
        }
        if (n < lArray.length) {
            object = lArray;
            lArray = new long[n];
            System.arraycopy(object, 0, lArray, 0, n);
        }
        return lArray;
    }

    public static String trim(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(0, n);
        }
        return "";
    }

    public static ObjectID trim(ObjectID objectID) {
        int n = objectID.toString().lastIndexOf(46);
        if (n >= 0) {
            return new ObjectID(objectID.toString().substring(0, n));
        }
        return new ObjectID();
    }

    public IObjectID trim() {
        return ObjectID.trim(this);
    }

    public static String toNumSeq(String string) {
        String string2 = new String(string);
        return string2.replace('.', '0');
    }

    public long getLastSubID() throws ObjectIDFormatException {
        this.needLongArray();
        return this.subIDs[this.subIDs.length - 1];
    }

    public static String getLastSubID(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static ObjectID getLastSubID(ObjectID objectID) {
        int n = objectID.toString().lastIndexOf(".");
        if (n >= 0) {
            return new ObjectID(objectID.toString().substring(n + 1));
        }
        return objectID;
    }

    public static long longHashCode(String string) throws ObjectIDFormatException {
        BigInteger bigInteger;
        String string2 = ObjectID.toNumSeq(string);
        if (string2.length() == 0) {
            return 0L;
        }
        try {
            bigInteger = new BigInteger(ObjectID.toNumSeq(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ObjectIDFormatException();
        }
        return bigInteger.mod(BigInteger.valueOf(Long.MAX_VALUE)).longValue();
    }

    public static int intHashCode(String string) throws ObjectIDFormatException {
        BigInteger bigInteger;
        String string2 = ObjectID.toNumSeq(string);
        if (string2.length() == 0) {
            return 0;
        }
        try {
            bigInteger = new BigInteger(ObjectID.toNumSeq(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ObjectIDFormatException();
        }
        return bigInteger.mod(BigInteger.valueOf(Integer.MAX_VALUE)).intValue();
    }

    public int hashCode() {
        if (this.hash >= 0) {
            return this.hash;
        }
        try {
            this.hash = ObjectID.intHashCode(this.oid);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return 0;
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectID) {
            return this.oid.equals(((ObjectID)object).oid);
        }
        return false;
    }

    public boolean isLessThan(ObjectID objectID) throws ObjectIDFormatException {
        this.needLongArray();
        objectID.needLongArray();
        int n = this.subIDs.length > objectID.subIDs.length ? objectID.subIDs.length : this.subIDs.length;
        for (int i = 0; i < n; ++i) {
            if (this.subIDs[i] == objectID.subIDs[i]) continue;
            return this.subIDs[i] < objectID.subIDs[i];
        }
        return this.subIDs.length < objectID.subIDs.length;
    }

    public boolean isLessThan(IObjectID iObjectID) {
        try {
            return this.isLessThan((ObjectID)iObjectID);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEmpty() {
        return this.oid.length() == 0 || this.oid.equals(".");
    }

    public boolean isParentOf(IObjectID iObjectID) {
        return iObjectID.size() - 1 == this.size() && ((Object)iObjectID).toString().startsWith(this.oid + ".");
    }

    public boolean isRootOf(IObjectID iObjectID) {
        return ((Object)iObjectID).toString().startsWith(this.oid + ".");
    }

    public boolean isDescendantOf(IObjectID iObjectID, int n) {
        return iObjectID.size() + n == this.size() && this.oid.startsWith(((Object)iObjectID).toString() + ".");
    }

    public boolean isChildOf(IObjectID iObjectID) {
        return this.isDescendantOf(iObjectID, 1);
    }

    public static boolean compare(ObjectID objectID, ObjectID objectID2) {
        return ObjectIDPredicate.instance.execute(objectID, objectID2);
    }

    public int compareTo(Object object) {
        if (object instanceof ObjectID) {
            if (this.oid.equals(((ObjectID)object).oid)) {
                return 0;
            }
            if (ObjectID.compare(this, (ObjectID)object)) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public ObjectID nextPeer() throws ObjectIDFormatException {
        return this.nextPeer(1);
    }

    public ObjectID nextPeer(int n) throws ObjectIDFormatException {
        this.needLongArray();
        long[] lArray = new long[this.subIDs.length];
        System.arraycopy(this.subIDs, 0, lArray, 0, this.subIDs.length);
        lArray[this.subIDs.length - 1] = lArray[this.subIDs.length - 1] + (long)n;
        return new ObjectID(lArray);
    }

    public boolean isValid() {
        if (this.oid == null || this.oid.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < this.oid.length(); ++i) {
            if (Character.isDigit(this.oid.charAt(i)) || this.oid.charAt(i) == '.') continue;
            if (this.oid.indexOf(39) >= 0) {
                try {
                    this.needLongArray();
                    return true;
                }
                catch (ObjectIDFormatException objectIDFormatException) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public String getFirstUnresolvedSubId() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.length() <= 0 || Character.isDigit(string.charAt(0))) continue;
            return string;
        }
        return null;
    }

    public ObjectID getValidPrefix() {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        Vector<Long> vector = new Vector<Long>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            for (int i = 0; i < ((String)object).length() && Character.isDigit(((String)object).charAt(i)); ++i) {
            }
            try {
                long l = Long.parseLong((String)object);
                vector.addElement(new Long(l));
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
        }
        object = new long[vector.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Long)vector.elementAt(i);
        }
        return new ObjectID((long[])object);
    }

    public String toSMI() {
        StringBuffer stringBuffer = new StringBuffer("{");
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(" " + stringTokenizer.nextToken() + " ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toSMI(String string) {
        StringBuffer stringBuffer = new StringBuffer("{ ");
        stringBuffer.append(string + " ");
        stringBuffer.append(this.oid.substring(this.oid.lastIndexOf(".") + 1));
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public String toSMI(MIBRepository mIBRepository, int n, MIBObject mIBObject, String string) {
        try {
            this.needLongArray();
            int n2 = this.size - mIBObject.getOid().size();
            StringBuffer stringBuffer = new StringBuffer("{ ");
            if (string != null) {
                MIBObject.addObjectLink(n, stringBuffer, string + "." + mIBObject.getName());
            } else {
                MIBObject.addObjectLink(n, stringBuffer, mIBObject.getName());
            }
            stringBuffer.append(' ');
            for (int i = this.size - n2; i < this.size; ++i) {
                String string2 = null;
                if (i + 1 < this.size) {
                    mIBRepository.getObjectName(this.getPrefix(i + 1));
                }
                if (string2 != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append('(');
                    stringBuffer.append(this.subIDs[i]);
                    stringBuffer.append(')');
                } else {
                    stringBuffer.append(this.subIDs[i]);
                }
                stringBuffer.append(' ');
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return "{ " + this.oid + " }";
        }
    }

    public String toSMI(int n, MIBObject mIBObject, String string) {
        try {
            this.needLongArray();
            int n2 = this.size - mIBObject.getOid().size();
            StringBuffer stringBuffer = new StringBuffer("{ ");
            if (string != null) {
                MIBObject.addObjectLink(n, stringBuffer, string + "." + mIBObject.getName());
            } else {
                MIBObject.addObjectLink(n, stringBuffer, mIBObject.getName());
            }
            stringBuffer.append(' ');
            for (int i = this.size - n2; i < this.size; ++i) {
                stringBuffer.append(this.subIDs[i]);
                stringBuffer.append(' ');
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return "{ " + this.oid + " }";
        }
    }

    public String toString() {
        return this.oid;
    }

    public static boolean isIdentifier(String string) {
        if (string.length() <= 0 || !Character.isLetter(string.charAt(0)) || string.indexOf("--") >= 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isLetterOrDigit(cArray[i]) || i < cArray.length && cArray[i] == '-') continue;
            return false;
        }
        return true;
    }

    public static ObjectID asOID(String string) {
        long[] lArray = new long[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            lArray[i] = string.charAt(i) & 0xFF;
        }
        return new ObjectID(lArray);
    }

    public static ObjectID asOID(byte[] byArray) {
        long[] lArray = new long[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            lArray[i] = byArray[i] & 0xFF;
        }
        return new ObjectID(lArray);
    }

    public String asString() throws ObjectIDFormatException {
        this.needLongArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.subIDs.length; ++i) {
            stringBuffer.append((char)this.subIDs[i]);
        }
        return stringBuffer.toString();
    }

    public byte[] asByteArray() throws ObjectIDFormatException {
        this.needLongArray();
        byte[] byArray = new byte[this.subIDs.length];
        for (int i = 0; i < this.subIDs.length; ++i) {
            byArray[i] = (byte)this.subIDs[i];
        }
        return byArray;
    }

    public int[] asIntArray() throws ObjectIDFormatException {
        this.needLongArray();
        int[] nArray = new int[this.subIDs.length];
        for (int i = 0; i < this.subIDs.length; ++i) {
            nArray[i] = (int)this.subIDs[i] & 0xFFFFFFFF;
        }
        return nArray;
    }

    public boolean isPeerOf(ObjectID objectID) {
        if (this.size() == objectID.size()) {
            if (this.size <= 1) {
                return true;
            }
            for (int i = 0; i < this.size - 1; ++i) {
                if (this.subIDs[i] == objectID.subIDs[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List getSubIdentifiers() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.oid, ".");
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens() + 1);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    public String getLastSubIdentifier() {
        if (this.subIDs != null) {
            try {
                return "" + this.getLastSubID();
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.size() > 0) {
            return ObjectID.getLastSubID(this.oid);
        }
        return null;
    }
}

