/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smi.ext.SMIVariation;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBVariation
implements Serializable,
SMIVariation {
    public static final long serialVersionUID = 1000L;
    private MIBSyntax syntax = null;
    private MIBSyntax writeSyntax = null;
    private String variation = null;
    private String access = null;
    private Vector creationRequires = new Vector();
    private String defval = null;
    private String description = null;
    private transient Object userObject = null;

    public MIBVariation() {
    }

    public MIBVariation(String string, String string2) {
        this.variation = string;
        this.description = string2;
    }

    public MIBVariation(MIBVariation mIBVariation) {
        this.variation = mIBVariation.variation;
        if (mIBVariation.hasSyntax()) {
            this.syntax = new MIBSyntax(mIBVariation.syntax);
        }
        if (mIBVariation.hasWriteSyntax()) {
            this.writeSyntax = new MIBSyntax(mIBVariation.writeSyntax);
        }
        if (mIBVariation.hasAccess()) {
            this.access = new String(mIBVariation.access);
        }
        if (mIBVariation.hasDefaultValue()) {
            this.defval = new String(mIBVariation.defval);
        }
        if (mIBVariation.hasCreationRequires()) {
            Enumeration enumeration = mIBVariation.creationRequires.elements();
            while (enumeration.hasMoreElements()) {
                this.creationRequires.addElement(enumeration.nextElement());
            }
        }
        this.description = mIBVariation.description;
    }

    public MIBSyntax getSyntax() {
        return this.syntax;
    }

    public ISyntax getSyntaxDef() {
        return this.syntax;
    }

    public ISyntax getWriteSyntaxDef() {
        return this.writeSyntax;
    }

    public boolean hasSyntax() {
        return this.syntax != null;
    }

    public boolean hasWriteSyntax() {
        return this.writeSyntax != null;
    }

    public boolean hasAccess() {
        return this.access != null;
    }

    public boolean hasDefaultValue() {
        return this.defval != null;
    }

    public void setSyntaxDef(SMISyntax sMISyntax) {
        this.syntax = (MIBSyntax)sMISyntax;
    }

    public void setSyntax(MIBSyntax mIBSyntax) {
        this.syntax = mIBSyntax;
    }

    public void setWriteSyntax(MIBSyntax mIBSyntax) {
        this.writeSyntax = mIBSyntax;
    }

    public void setWriteSyntaxDef(SMISyntax sMISyntax) {
        this.writeSyntax = (MIBSyntax)sMISyntax;
    }

    public MIBSyntax getWriteSyntax() {
        return this.writeSyntax;
    }

    public void setVariation(String string) {
        this.variation = string;
    }

    public String getVariation() {
        return this.variation;
    }

    public void setAccess(String string) {
        this.access = string;
    }

    public String getAccess() {
        return this.access;
    }

    public boolean hasCreationRequires() {
        return this.creationRequires != null && this.creationRequires.size() > 0;
    }

    public void setCreationRequires(String[] stringArray) {
        this.creationRequires = new Vector<String>(Arrays.asList(stringArray));
    }

    public void setCreationRequires(Vector vector) {
        this.creationRequires = vector;
    }

    public Vector getCreationRequiresVector() {
        return this.creationRequires;
    }

    public String[] getCreationRequires() {
        Object[] objectArray = new String[this.creationRequires.size()];
        this.creationRequires.copyInto(objectArray);
        return objectArray;
    }

    public void setDefval(String string) {
        this.defval = string;
    }

    public String getDefval() {
        return this.defval;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toSMI(int n, MIBRepository mIBRepository, MIBVariation mIBVariation, String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(string + "\t");
        MIBObject.addKeyWord(n, stringBuffer, "VARIATION ");
        MIBObject.addString(n, stringBuffer, this.variation, mIBVariation == null ? null : mIBVariation.variation);
        if (this.syntax != null) {
            stringBuffer.append(string);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(n, stringBuffer, "SYNTAX   ");
            object = null;
            if (mIBVariation != null) {
                object = mIBVariation.syntax != null ? mIBVariation.syntax : new MIBSyntax();
            }
            stringBuffer.append(this.syntax.toSMI(n, mIBRepository, (MIBSyntax)object, string));
        }
        if (this.writeSyntax != null) {
            stringBuffer.append(string);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(n, stringBuffer, "WRITE-SYNTAX ");
            object = null;
            if (mIBVariation != null) {
                object = mIBVariation.writeSyntax != null ? mIBVariation.writeSyntax : new MIBSyntax();
            }
            stringBuffer.append(this.writeSyntax.toSMI(n, mIBRepository, (MIBSyntax)object, string));
        }
        if (this.access != null) {
            stringBuffer.append(string);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(n, stringBuffer, "ACCESS ");
            object = null;
            if (mIBVariation != null) {
                object = mIBVariation.access != null ? mIBVariation.access : "";
            }
            MIBObject.addString(n, stringBuffer, this.access, (String)object);
            stringBuffer.append(string);
        }
        if (this.creationRequires != null && this.creationRequires.size() > 0) {
            stringBuffer.append(string);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(n, stringBuffer, "CREATION-REQUIRES");
            stringBuffer.append(" {");
            stringBuffer.append(string);
            object = null;
            if (mIBVariation != null) {
                object = mIBVariation.creationRequires != null && mIBVariation.creationRequires.size() > 0 ? MIBObject.formatObjectRefs(n, "\t\t\t", mIBVariation.creationRequires.elements(), string) : "";
            }
            MIBObject.addString(n, stringBuffer, MIBObject.formatObjectRefs(n, "\t\t\t", this.creationRequires.elements(), string), (String)object);
            stringBuffer.append(" }");
        }
        if (this.defval != null) {
            stringBuffer.append(string);
            stringBuffer.append("\t  ");
            MIBObject.addKeyWord(n, stringBuffer, "DEFVAL");
            stringBuffer.append(" { ");
            object = null;
            if (mIBVariation != null) {
                object = mIBVariation.defval != null ? mIBVariation.defval : "";
            }
            MIBObject.addString(n, stringBuffer, this.defval, (String)object);
            stringBuffer.append(" }");
        }
        stringBuffer.append(string);
        stringBuffer.append("\t  ");
        MIBObject.addKeyWord(n, stringBuffer, "DESCRIPTION");
        if (this.description != null) {
            stringBuffer.append(string);
            object = null;
            if (mIBVariation != null) {
                object = mIBVariation.description != null && mIBVariation.description.length() > 0 ? MIBObject.formatLines("\t\t", mIBVariation.description) : "";
            }
            MIBObject.addText(string, n, stringBuffer, MIBObject.formatLines("\t\t", this.description), (String)object);
        } else {
            MIBObject.addText(string, n, stringBuffer, "\"\"");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.variation;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public boolean equals(Object object) {
        if (object instanceof MIBVariation) {
            MIBVariation mIBVariation = (MIBVariation)object;
            return MIBObject.saveCompare(this.syntax, mIBVariation.syntax) && MIBObject.saveCompare(this.writeSyntax, mIBVariation.writeSyntax) && MIBObject.saveCompare(this.variation, mIBVariation.variation) && MIBObject.saveCompare(this.access, mIBVariation.access) && MIBObject.saveCompare(this.creationRequires, mIBVariation.creationRequires) && MIBObject.saveCompare(this.defval, mIBVariation.defval) && MIBObject.saveCompare(this.description, mIBVariation.description);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        if (this.hasSyntax()) {
            this.syntax.userObject = null;
        }
        if (this.hasWriteSyntax()) {
            this.writeSyntax.userObject = null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.access = SMI.getCommonIdentifier(this.access);
    }
}

