/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smi.IEnum;
import com.agentpp.smi.IRange;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMIEnum;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIRange;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MIBSyntax
implements Serializable,
SMISyntax {
    public static final long serialVersionUID = 1000L;
    protected String syntax;
    protected int type;
    protected Vector ranges = null;
    protected Vector enums = null;
    public transient Object userObject;

    public MIBSyntax() {
        this.syntax = null;
        this.type = 0;
    }

    public MIBSyntax(String string, int n) {
        this.syntax = string;
        this.type = n;
    }

    public MIBSyntax(ISyntax iSyntax) {
        this.syntax = new String(iSyntax.getSyntax());
        this.type = iSyntax.getType();
        if (iSyntax.hasEnums()) {
            this.setEnums((MIBEnum[])iSyntax.getEnums());
        }
        if (iSyntax.hasRanges()) {
            this.setRanges((MIBRange[])iSyntax.getRanges());
        }
    }

    public final String getSyntax() {
        return this.syntax;
    }

    public final void setSyntax(String string) {
        this.syntax = string;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final boolean hasRanges() {
        return this.ranges != null && this.ranges.size() > 0;
    }

    public final void addRange(MIBRange mIBRange) {
        if (this.ranges == null) {
            this.ranges = new Vector(5);
        }
        this.ranges.addElement(mIBRange);
    }

    public IRange[] getRanges() {
        if (this.ranges == null) {
            return null;
        }
        Object[] objectArray = new MIBRange[this.ranges.size()];
        this.ranges.copyInto(objectArray);
        return objectArray;
    }

    public void setRanges(MIBRange[] mIBRangeArray) {
        this.ranges = MIBRepository.buildVector(mIBRangeArray);
    }

    public void setRanges(SMIRange[] sMIRangeArray) {
        this.ranges = MIBRepository.buildVector(sMIRangeArray);
    }

    public final void setRangesVector(Vector vector) {
        this.ranges = vector;
    }

    public final Vector getRangesVector() {
        return this.ranges;
    }

    public final boolean containsRange(MIBRange mIBRange) {
        if (!this.hasRanges()) {
            return false;
        }
        return this.ranges.contains(mIBRange);
    }

    public final boolean isRestrictiveRange(MIBRange mIBRange) {
        if (!this.hasRanges()) {
            return true;
        }
        long l = Long.MIN_VALUE;
        long l2 = Long.MAX_VALUE;
        Enumeration enumeration = this.ranges.elements();
        while (enumeration.hasMoreElements()) {
            MIBRange mIBRange2 = (MIBRange)enumeration.nextElement();
            if (mIBRange2.getLowerValue() <= mIBRange.getLowerValue() && mIBRange2.getUpperValue() >= mIBRange.getUpperValue()) {
                return true;
            }
            if (mIBRange2.getLowerValue() < l2) {
                l2 = mIBRange2.getLowerValue();
            }
            if (mIBRange2.getUpperValue() <= l) continue;
            l = mIBRange2.getUpperValue();
        }
        return mIBRange.getLowerValue() > l2 || mIBRange.getUpperValue() < l;
    }

    public final boolean isRestrictiveOrSubset(Vector vector) {
        if (!this.hasRanges()) {
            return true;
        }
        if (vector == null) {
            return false;
        }
        Vector vector2 = (Vector)this.ranges.clone();
        Vector vector3 = new Vector(vector2.size() + 1);
        Vector vector4 = new Vector(vector.size() + 1);
        MIBRange.normalizeRanges(vector2, vector3);
        MIBRange.normalizeRanges(vector, vector4);
        return MIBRange.compareRanges(vector3, vector4) >= 0;
    }

    public final long getMinOfEnums() {
        if (!this.hasEnums()) {
            return Long.MIN_VALUE;
        }
        long l = Long.MAX_VALUE;
        Enumeration enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = (MIBEnum)enumeration.nextElement();
            if (mIBEnum.getLongValue() >= l) continue;
            l = mIBEnum.getLongValue();
        }
        return l;
    }

    public final long getMaxOfEnums() {
        if (!this.hasEnums()) {
            return Long.MIN_VALUE;
        }
        long l = Long.MIN_VALUE;
        Enumeration enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = (MIBEnum)enumeration.nextElement();
            if (mIBEnum.getLongValue() <= l) continue;
            l = mIBEnum.getLongValue();
        }
        return l;
    }

    public final long getMinOfRanges() {
        if (!this.hasRanges()) {
            return Long.MIN_VALUE;
        }
        long l = Long.MAX_VALUE;
        Enumeration enumeration = this.ranges.elements();
        while (enumeration.hasMoreElements()) {
            MIBRange mIBRange = (MIBRange)enumeration.nextElement();
            if (mIBRange.getLowerValue() >= l) continue;
            l = mIBRange.getLowerValue();
        }
        return l;
    }

    public final long getMaxOfRanges() {
        if (!this.hasRanges()) {
            return Long.MAX_VALUE;
        }
        long l = Long.MIN_VALUE;
        Enumeration enumeration = this.ranges.elements();
        while (enumeration.hasMoreElements()) {
            MIBRange mIBRange = (MIBRange)enumeration.nextElement();
            if (mIBRange.getLowerValue() <= l) continue;
            l = mIBRange.getUpperValue();
        }
        return l;
    }

    public boolean isIncludedInRanges(long l) {
        if (this.hasRanges()) {
            for (int i = 0; i < this.ranges.size(); ++i) {
                MIBRange mIBRange = (MIBRange)this.ranges.get(i);
                if (l < mIBRange.getLowerValue() || l > mIBRange.getUpperValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public final boolean hasEnums() {
        return this.enums != null && this.enums.size() > 0;
    }

    public final void addEnum(MIBEnum mIBEnum) {
        if (this.enums == null) {
            this.enums = new Vector(5);
        }
        this.enums.addElement(mIBEnum);
    }

    public IEnum[] getEnums() {
        if (this.enums == null) {
            return null;
        }
        Object[] objectArray = new MIBEnum[this.enums.size()];
        this.enums.copyInto(objectArray);
        return objectArray;
    }

    public final void setEnums(MIBEnum[] mIBEnumArray) {
        this.enums = MIBRepository.buildVector(mIBEnumArray);
    }

    public final void setEnums(SMIEnum[] sMIEnumArray) {
        this.enums = MIBRepository.buildVector(sMIEnumArray);
    }

    public final void setEnumsVector(Vector vector) {
        this.enums = vector;
    }

    public final Vector getEnumsVector() {
        return this.enums;
    }

    public byte[] getBitsEnum(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}, ");
        long l = this.getMaxOfEnums();
        byte[] byArray = new byte[l >= 0L ? (int)(l / 8L) + 1 : 0];
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            boolean bl = false;
            Enumeration enumeration = this.enums.elements();
            while (enumeration.hasMoreElements()) {
                MIBEnum mIBEnum = (MIBEnum)enumeration.nextElement();
                if (!mIBEnum.getLabel().equals(string2)) continue;
                bl = true;
                try {
                    int n = (int)Long.parseLong(mIBEnum.getValue());
                    if (n / 8 >= byArray.length) {
                        byte[] byArray2 = byArray;
                        byArray = new byte[n / 8 + 1];
                        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                    }
                    int n2 = n / 8;
                    byArray[n2] = (byte)(byArray[n2] | 1 << 7 - n % 8);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            if (bl) continue;
            return null;
        }
        return byArray;
    }

    public String getBitsEnum(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append('{');
        boolean bl = true;
        for (int i = 0; i < byArray.length * 8; ++i) {
            if ((byArray[i / 8] & 1 << 7 - i % 8) <= 0) continue;
            String string = this.getLabel(i);
            if (!bl) {
                stringBuffer.append(',');
            }
            bl = false;
            if (string != null) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("" + i);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public final int getEnumValue(String string) {
        Enumeration enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = (MIBEnum)enumeration.nextElement();
            if (!mIBEnum.getLabel().equals(string) && !mIBEnum.toString().equals(string)) continue;
            return Integer.parseInt(mIBEnum.getValue());
        }
        return Integer.MIN_VALUE;
    }

    public String getEnum(String string) {
        if (this.syntax.equals(SMI.SMI_SYNTAX[12])) {
            byte[] byArray = this.getBitsEnum(string);
            if (byArray == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray.length; ++i) {
                String string2 = Integer.toHexString(byArray[i] & 0xFF);
                for (int j = 0; j < 2 - string2.length(); ++j) {
                    string2 = "0" + string2;
                }
                stringBuffer.append("\\x" + string2);
            }
            return stringBuffer.toString();
        }
        Enumeration enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = (MIBEnum)enumeration.nextElement();
            if (!mIBEnum.getLabel().equals(string)) continue;
            return mIBEnum.getValue();
        }
        return null;
    }

    public final String getLabel(long l) {
        MIBEnum mIBEnum = this.getEnum(l);
        if (mIBEnum == null) {
            return null;
        }
        return mIBEnum.getLabel();
    }

    public final MIBEnum getEnum(long l) {
        Enumeration enumeration = this.enums.elements();
        while (enumeration.hasMoreElements()) {
            MIBEnum mIBEnum = (MIBEnum)enumeration.nextElement();
            if (mIBEnum.getLongValue() != l) continue;
            return mIBEnum;
        }
        return null;
    }

    protected final String getSMIv2Syntax() {
        if (this.syntax.equals(SMI.SMI_SYNTAX[0]) && !this.hasEnums()) {
            return SMI.SMI_SYNTAX[8];
        }
        if (this.syntax.equals(SMI.SMI_SYNTAX[3])) {
            return SMI.SMI_SYNTAX[5];
        }
        if (this.syntax.equals(SMI.SMI_SYNTAX[4])) {
            return SMI.SMI_SYNTAX[7];
        }
        return this.syntax;
    }

    public String toSMI(int n, MIBRepository mIBRepository, MIBSyntax mIBSyntax, String string) {
        Serializable serializable;
        Enumeration enumeration;
        Enumeration enumeration2;
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 2: {
                MIBObject.addKeyWord(n, stringBuffer, "SEQUENCE OF ");
                MIBObject.addString(n, stringBuffer, this.syntax, mIBSyntax == null ? null : mIBSyntax.syntax);
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (n == 8) {
                    stringBuffer.append(this.getSMIv2Syntax());
                } else if (mIBRepository != null) {
                    if (mIBRepository.getObject(this.syntax) != null) {
                        MIBObject.addObjectLink(n, stringBuffer, this.syntax, mIBSyntax == null ? null : mIBSyntax.syntax);
                    } else {
                        MIBObject.addString(n, stringBuffer, this.syntax, mIBSyntax == null ? null : mIBSyntax.syntax);
                    }
                } else {
                    MIBObject.addString(n, stringBuffer, this.syntax, mIBSyntax == null ? null : mIBSyntax.syntax);
                }
                if ((n & 1) <= 0 && (n & 2) <= 0 || !this.hasRanges()) break;
                enumeration2 = null;
                if (mIBRepository != null) {
                    enumeration2 = mIBRepository.resolveTC(this.syntax);
                }
                if (enumeration2 == null) {
                    enumeration2 = this;
                }
                if (((MIBSyntax)((Object)enumeration2)).getSyntax().equals(SMI.SMI_SYNTAX[1]) || ((MIBSyntax)((Object)enumeration2)).getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    stringBuffer.append(" (");
                    MIBObject.addKeyWord(n, stringBuffer, "SIZE");
                }
                stringBuffer.append(" (");
                Enumeration enumeration3 = null;
                if (mIBSyntax != null) {
                    enumeration3 = mIBSyntax.hasRanges() ? mIBSyntax.ranges.elements() : new Vector().elements();
                }
                enumeration = this.ranges.elements();
                while (enumeration.hasMoreElements()) {
                    serializable = null;
                    if (enumeration3 != null) {
                        serializable = enumeration3.hasMoreElements() ? (MIBRange)enumeration3.nextElement() : new MIBRange(0L, -1L);
                    }
                    MIBObject.addString(n, stringBuffer, ((MIBRange)enumeration.nextElement()).toSMI(n), serializable == null ? null : ((MIBRange)serializable).toSMI(n));
                    if (!enumeration.hasMoreElements()) continue;
                    stringBuffer.append(" | ");
                }
                stringBuffer.append(")");
                if (!((MIBSyntax)((Object)enumeration2)).getSyntax().equals(SMI.SMI_SYNTAX[1]) && !((MIBSyntax)((Object)enumeration2)).getSyntax().equals(SMI.SMI_SYNTAX[12])) break;
                stringBuffer.append(")");
            }
        }
        if (this.hasEnums()) {
            stringBuffer.append(" {");
            stringBuffer.append(string);
            stringBuffer.append("\t\t\t");
            enumeration2 = null;
            if (mIBSyntax != null) {
                enumeration2 = mIBSyntax.hasEnums() ? mIBSyntax.enums.elements() : new Vector().elements();
            }
            int n2 = MIBObject.getMaxLength(this.enums.elements());
            enumeration = this.enums.elements();
            while (enumeration.hasMoreElements()) {
                serializable = null;
                if (enumeration2 != null) {
                    serializable = enumeration2.hasMoreElements() ? (MIBEnum)enumeration2.nextElement() : new MIBEnum("", "0");
                }
                MIBEnum mIBEnum = (MIBEnum)enumeration.nextElement();
                MIBObject.addString(n, stringBuffer, mIBEnum.toSMI(n), serializable == null ? null : ((MIBEnum)serializable).toSMI(n));
                if (mIBEnum.hasComment()) {
                    if (enumeration.hasMoreElements()) {
                        stringBuffer.append(",");
                    }
                    String string2 = MIBObject.space(n2 - mIBEnum.toString().length() + 1);
                    stringBuffer.append(string2);
                    String string3 = mIBEnum.getComment();
                    String string4 = mIBEnum.getComment();
                    int n3 = string3.indexOf("\n");
                    if (n3 < 0) {
                        string3 = null;
                    } else {
                        string4 = string3.substring(0, n3);
                        string3 = string3.substring(n3);
                    }
                    MIBObject.addComment(n, stringBuffer, "\t" + string4, string);
                    if (string3 != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n", true);
                        while (stringTokenizer.hasMoreTokens()) {
                            String string5 = stringTokenizer.nextToken();
                            int n4 = "\n".indexOf(string5);
                            if (n4 >= 0) continue;
                            if ((n & 2) > 0) {
                                stringBuffer.append("\n");
                            } else {
                                stringBuffer.append(string);
                            }
                            stringBuffer.append("\t\t\t\t" + MIBObject.space(n2));
                            MIBObject.addComment(n, stringBuffer, string5, string);
                        }
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("\t\t\t");
                    continue;
                }
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(",");
                    stringBuffer.append(string);
                    stringBuffer.append("\t\t\t");
                    continue;
                }
                stringBuffer.append(' ');
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public boolean isRestrictiveSyntax(MIBRepository mIBRepository) {
        if (this.getType() != 3) {
            return true;
        }
        MIBObject mIBObject = mIBRepository.getObject(this.getSyntax());
        if (!(mIBObject instanceof MIBTextualConvention)) {
            return false;
        }
        MIBTextualConvention mIBTextualConvention = (MIBTextualConvention)mIBObject;
        if (this.hasRanges() && !mIBTextualConvention.getSyntax().isRestrictiveOrSubset(this.getRangesVector())) {
            return false;
        }
        if (this.hasEnums() && mIBTextualConvention.getSyntax().hasEnums()) {
            if (this.getEnumsVector().size() > mIBTextualConvention.getSyntax().getEnumsVector().size()) {
                return false;
            }
            for (MIBEnum mIBEnum : this.getEnumsVector()) {
                MIBEnum mIBEnum2 = mIBTextualConvention.getSyntax().getEnum(mIBEnum.getLongValue());
                if (mIBEnum2 != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRestrictiveSyntax(MIBRepository mIBRepository, MIBSyntax mIBSyntax) {
        block6: {
            MIBTextualConvention mIBTextualConvention;
            block5: {
                mIBTextualConvention = mIBRepository.getEffectiveSyntax(this);
                MIBTextualConvention mIBTextualConvention2 = mIBRepository.getEffectiveSyntax(mIBSyntax);
                if (!mIBTextualConvention2.getSyntax().getSyntax().equals(mIBTextualConvention.getSyntax().getSyntax()) || mIBTextualConvention2.getSyntax().hasEnums() != mIBTextualConvention.getSyntax().hasEnums() && mIBTextualConvention.getSyntax().hasEnums() || mIBTextualConvention2.getSyntax().hasRanges() != mIBTextualConvention.getSyntax().hasRanges() && mIBTextualConvention.getSyntax().hasRanges()) {
                    return false;
                }
                if (!mIBSyntax.hasRanges()) break block5;
                for (int i = 0; i < mIBSyntax.getRangesVector().size(); ++i) {
                    MIBRange mIBRange = (MIBRange)mIBSyntax.getRangesVector().get(i);
                    if (mIBTextualConvention.getSyntax().isRestrictiveRange(mIBRange)) continue;
                    return false;
                }
                break block6;
            }
            if (!mIBSyntax.hasEnums()) break block6;
            if (!mIBTextualConvention.getSyntax().hasEnums()) {
                return false;
            }
            if (mIBSyntax.getEnumsVector().size() > mIBTextualConvention.getSyntax().getEnumsVector().size()) {
                return false;
            }
            for (MIBEnum mIBEnum : mIBSyntax.getEnumsVector()) {
                MIBEnum mIBEnum2 = mIBTextualConvention.getSyntax().getEnum(mIBEnum.getLongValue());
                if (mIBEnum2 != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof MIBSyntax) {
            MIBSyntax mIBSyntax = (MIBSyntax)object;
            return MIBObject.saveCompare(this.syntax, mIBSyntax.syntax) && this.type == mIBSyntax.type && MIBObject.saveCompare(this.enums, mIBSyntax.enums) && MIBObject.saveCompare(this.ranges, mIBSyntax.ranges);
        }
        return false;
    }

    public int hashCode() {
        return this.syntax.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.syntax = SMI.getCommonIdentifier(this.syntax);
    }
}

