/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.ext.SMIImplementationSpec;
import com.agentpp.smi.ext.SMIVariation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBSupportedModule
implements Serializable,
SMIImplementationSpec {
    public static final long serialVersionUID = 1000L;
    protected String supports = null;
    protected Vector includes = new Vector();
    protected Vector variations = new Vector();
    protected transient Object userObject;

    public MIBSupportedModule() {
    }

    public MIBSupportedModule(String string) {
        this.supports = string;
    }

    public MIBSupportedModule(MIBSupportedModule mIBSupportedModule) {
        if (mIBSupportedModule.supports != null) {
            this.supports = new String(mIBSupportedModule.supports);
        }
        Enumeration enumeration = mIBSupportedModule.includes.elements();
        while (enumeration.hasMoreElements()) {
            this.includes.addElement(new String(enumeration.nextElement().toString()));
        }
        enumeration = mIBSupportedModule.variations.elements();
        while (enumeration.hasMoreElements()) {
            this.variations.addElement(new MIBVariation((MIBVariation)enumeration.nextElement()));
        }
    }

    public String getSupports() {
        return this.supports;
    }

    public void setSupports(String string) {
        this.supports = string;
    }

    public final void setIncludes(Vector vector) {
        this.includes = vector;
    }

    public final Vector getIncludes() {
        return this.includes;
    }

    public final String[] getIncludedGroups() {
        Object[] objectArray = new String[this.includes.size()];
        this.includes.copyInto(objectArray);
        return objectArray;
    }

    public final void setIncludedGroups(String[] stringArray) {
        this.includes = new Vector<String>(Arrays.asList(stringArray));
    }

    public final boolean hasVariations() {
        return this.variations.size() > 0;
    }

    public final void setVariations(Vector vector) {
        this.variations = vector;
    }

    public final Vector getVariationsVector() {
        return this.variations;
    }

    public final void setVariations(SMIVariation[] sMIVariationArray) {
        this.variations = new Vector<SMIVariation>(Arrays.asList(sMIVariationArray));
    }

    public final IVariation[] getVariations() {
        Object[] objectArray = new MIBVariation[this.variations.size()];
        this.variations.copyInto(objectArray);
        return objectArray;
    }

    public String toSMI(int n, MIBRepository mIBRepository, MIBSupportedModule mIBSupportedModule, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append("\t");
        MIBObject.addKeyWord(n, stringBuffer, "SUPPORTS ");
        MIBObject.addString(n, stringBuffer, this.supports, mIBSupportedModule == null ? null : mIBSupportedModule.supports);
        stringBuffer.append(string);
        stringBuffer.append("\t");
        MIBObject.addKeyWord(n, stringBuffer, "INCLUDES");
        stringBuffer.append(" {");
        stringBuffer.append(string);
        MIBObject.addString(n, stringBuffer, MIBObject.formatObjectRefs(n, "\t\t", this.includes.elements(), string), mIBSupportedModule == null ? null : MIBObject.formatObjectRefs(n, "\t\t", mIBSupportedModule.includes.elements(), string));
        stringBuffer.append(" }");
        stringBuffer.append(string);
        if (this.variations.size() > 0) {
            Enumeration enumeration = null;
            if (mIBSupportedModule != null) {
                enumeration = mIBSupportedModule.variations != null && mIBSupportedModule.variations.size() > 0 ? mIBSupportedModule.variations.elements() : new Vector().elements();
            }
            Enumeration enumeration2 = this.variations.elements();
            while (enumeration2.hasMoreElements()) {
                MIBVariation mIBVariation = (MIBVariation)enumeration2.nextElement();
                MIBVariation mIBVariation2 = null;
                if (enumeration != null) {
                    mIBVariation2 = enumeration.hasMoreElements() ? (MIBVariation)enumeration.nextElement() : new MIBVariation();
                }
                stringBuffer.append(mIBVariation.toSMI(n, mIBRepository, mIBVariation2, string));
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.supports;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public boolean equals(Object object) {
        if (object instanceof MIBSupportedModule) {
            MIBSupportedModule mIBSupportedModule = (MIBSupportedModule)object;
            return MIBObject.saveCompare(this.supports, mIBSupportedModule.supports) && MIBObject.saveCompare(this.includes, mIBSupportedModule.includes) && MIBObject.saveCompare(this.variations, mIBSupportedModule.variations);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        for (MIBVariation mIBVariation : this.variations) {
            mIBVariation.freeUserObjects();
        }
    }
}

