/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.smi.INotificationType;
import com.agentpp.smi.IObject;
import com.agentpp.smi.ISyntax;
import com.agentpp.smiparser.SMI;
import com.agentpp.util.EnumerationIterator;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class MIBRepository
implements Serializable {
    public static final long serialVersionUID = 100L;
    private transient HashMap modules = null;
    private transient HashMap moduleIDs = null;
    private transient HashMap importedModuleIDs = null;
    private transient OrderedMap onames = null;
    private transient OrderedMap oids = null;
    private transient Vector listenerList;

    public MIBRepository() {
        this.init(false);
    }

    public MIBRepository(boolean bl) {
        this.init(bl);
    }

    public MIBRepository(MIBObject[] mIBObjectArray) {
        this.init(false);
        this.addAllObjects(mIBObjectArray);
    }

    public Object clone() {
        MIBRepository mIBRepository = new MIBRepository();
        mIBRepository.oids = (OrderedMap)this.oids.clone();
        mIBRepository.onames = (OrderedMap)this.onames.clone();
        mIBRepository.modules = (HashMap)this.modules.clone();
        mIBRepository.moduleIDs = (HashMap)this.moduleIDs.clone();
        mIBRepository.importedModuleIDs = (HashMap)this.importedModuleIDs.clone();
        return mIBRepository;
    }

    private void init(boolean bl) {
        this.listenerList = new Vector(5);
        this.oids = new OrderedMap(ObjectIDPredicate.instance, true);
        this.onames = new OrderedMap(LexicographicPredicate.instance, true);
        this.modules = new HashMap(150);
        this.moduleIDs = new HashMap(150);
        this.importedModuleIDs = new HashMap(100);
        if (bl) {
            this.addIETFObjectIDs();
        }
        this.structureChanged();
    }

    public int size() {
        return this.oids.size();
    }

    public int moduleCount() {
        return this.modules.size();
    }

    protected void addIETFObjectIDs() {
        for (int i = 0; i < SMI.rootOids.length; ++i) {
            MIBObject mIBObject = new MIBObject(new ObjectID(SMI.rootOids[i][1]), SMI.rootOids[i][0]);
            this.oids.add(mIBObject.getOid(), mIBObject);
            this.onames.add(mIBObject.getName(), mIBObject);
        }
    }

    private void addModule(MIBModule mIBModule) {
        this.modules.put(mIBModule.getModuleName(), mIBModule);
        this.moduleIDs.put(mIBModule.getModuleID(), mIBModule);
    }

    public synchronized void addObject(MIBObject mIBObject) {
        this.removeObject(mIBObject.getModuleID(), mIBObject);
        if (mIBObject.getOid().size() > 0) {
            this.oids.add(mIBObject.getOid(), mIBObject);
        }
        this.onames.add(mIBObject.getName(), mIBObject);
        if (mIBObject instanceof MIBModule) {
            this.addModule((MIBModule)mIBObject);
            ((MIBModule)mIBObject).add(mIBObject);
        } else {
            MIBModule mIBModule = (MIBModule)this.moduleIDs.get(mIBObject.getModuleID());
            if (mIBModule != null) {
                mIBModule.add(mIBObject);
            }
        }
    }

    public void addAllObjects(MIBObject[] mIBObjectArray) {
        for (int i = 0; i < mIBObjectArray.length; ++i) {
            this.addObject(mIBObjectArray[i]);
        }
        this.structureChanged();
    }

    public String getObjectName(ObjectID objectID) {
        MIBObject mIBObject = (MIBObject)this.oids.get(objectID);
        if (mIBObject != null) {
            return mIBObject.getName();
        }
        return null;
    }

    public String getUniqueObjectName(MIBObject mIBObject) {
        MIBObject[] mIBObjectArray = this.getObjectsByName(mIBObject.getName());
        if (mIBObjectArray == null || mIBObjectArray.length <= 1) {
            return mIBObject.getName();
        }
        String string = this.getModuleName(mIBObject.getModuleID());
        if (string == null) {
            return mIBObject.getName();
        }
        return string + "." + mIBObject.getName();
    }

    public ObjectID getObjectID(String string) {
        MIBObject mIBObject = (MIBObject)this.onames.get(string);
        if (mIBObject != null) {
            return mIBObject.getOid();
        }
        return null;
    }

    public ObjectID getObjectID(String string, String string2) {
        MIBModule mIBModule = this.getModule(string);
        if (mIBModule == null) {
            return null;
        }
        MIBObject mIBObject = mIBModule.getObjectByName(string2);
        if (mIBObject != null) {
            return mIBObject.getOid();
        }
        return null;
    }

    public MIBObject getObject(String string, String string2) {
        MIBModule mIBModule = this.getModule(string);
        if (mIBModule == null) {
            MIBObject[] mIBObjectArray = this.getObjectsByName(string2);
            for (int i = 0; i < mIBObjectArray.length; ++i) {
                if (!string.equals(this.getModuleName(mIBObjectArray[i].getModuleID()))) continue;
                return mIBObjectArray[i];
            }
            return null;
        }
        return mIBModule.getObjectByName(string2);
    }

    public MIBObject getScopedObject(String string, String string2) {
        if (string2.length() == 0) {
            return null;
        }
        if (Character.isUpperCase(string2.charAt(0)) && string2.indexOf(46) > 0) {
            return this.getObject(string2);
        }
        MIBModule mIBModule = this.getModule(string);
        if (mIBModule == null) {
            MIBObject[] mIBObjectArray = this.getObjectsByName(string2);
            for (int i = 0; i < mIBObjectArray.length; ++i) {
                if (!string.equals(this.getModuleName(mIBObjectArray[i].getModuleID()))) continue;
                return mIBObjectArray[i];
            }
            return null;
        }
        String string3 = mIBModule.getImportSource(string2);
        if (string3 != null) {
            return this.getObject(string3, string2);
        }
        return mIBModule.getObjectByName(string2);
    }

    public Vector getChildren(String string) {
        MIBObject mIBObject = (MIBObject)this.onames.get(string);
        if (mIBObject == null) {
            return null;
        }
        return this.getChildren(mIBObject);
    }

    public Vector getChildren(ObjectID objectID) {
        return this.getChildren(objectID, true);
    }

    public Vector getChildren(ObjectID objectID, boolean bl) {
        Vector<MIBObject> vector = new Vector<MIBObject>();
        OrderedMapIterator orderedMapIterator = this.oids.find(objectID);
        if (orderedMapIterator.atEnd()) {
            return vector;
        }
        MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
        if (!mIBObject.getOid().equals(objectID)) {
            return vector;
        }
        orderedMapIterator.advance();
        while (!orderedMapIterator.atEnd()) {
            block7: {
                MIBObject mIBObject2;
                block9: {
                    MIBObject mIBObject3;
                    block8: {
                        mIBObject2 = (MIBObject)((Pair)orderedMapIterator.get()).second;
                        if (mIBObject2.getOid().equals(objectID) || bl && vector.size() > 0 && mIBObject2.getOid().equals(((MIBObject)vector.lastElement()).getOid())) break block7;
                        if (!mIBObject2.getOid().isChildOf(objectID)) break block8;
                        vector.addElement(mIBObject2);
                        break block9;
                    }
                    if (!objectID.isRootOf(mIBObject2.getOid())) break block9;
                    if (vector.size() > 0 && (mIBObject3 = (MIBObject)vector.lastElement()).getOid().isRootOf(mIBObject2.getOid())) break block7;
                    vector.addElement(mIBObject2);
                }
                if (!objectID.isRootOf(mIBObject2.getOid())) {
                    return vector;
                }
            }
            orderedMapIterator.advance();
        }
        return vector;
    }

    public Vector getChildren(MIBObject mIBObject) {
        return this.getChildren(mIBObject.getOid());
    }

    public void removeChildren(MIBObject mIBObject) {
        Vector vector = this.getChildren(mIBObject);
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject2 = (MIBObject)enumeration.nextElement();
            this.removeObject(mIBObject2);
        }
    }

    public Vector getDescendants(MIBObject mIBObject) {
        Vector<MIBObject> vector = new Vector<MIBObject>(10, 10);
        Vector vector2 = this.getChildren(mIBObject);
        if (vector2 == null) {
            return vector;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject2 = (MIBObject)enumeration.nextElement();
            vector.addElement(mIBObject2);
            Vector vector3 = this.getDescendants(mIBObject2);
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                vector.addElement((MIBObject)enumeration2.nextElement());
            }
        }
        return vector;
    }

    public boolean hasDescendants(MIBObject mIBObject) {
        if (mIBObject.getOid() == null) {
            return false;
        }
        ObjectID objectID = mIBObject.getOid();
        OrderedMapIterator orderedMapIterator = this.oids.find(objectID);
        if (orderedMapIterator.atEnd()) {
            return false;
        }
        MIBObject mIBObject2 = (MIBObject)((Pair)orderedMapIterator.get()).second;
        if (!mIBObject2.getOid().equals(objectID)) {
            return false;
        }
        orderedMapIterator.advance();
        while (!orderedMapIterator.atEnd()) {
            MIBObject mIBObject3 = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject3.getOid().equals(objectID)) {
                if (mIBObject3.getOid().isChildOf(objectID)) {
                    return true;
                }
                if (objectID.isRootOf(mIBObject3.getOid())) {
                    return true;
                }
                if (!objectID.isRootOf(mIBObject3.getOid())) {
                    return false;
                }
            }
            orderedMapIterator.advance();
        }
        return false;
    }

    public MIBObject getParent(String string) {
        MIBObject mIBObject = (MIBObject)this.onames.get(string);
        if (mIBObject == null) {
            return null;
        }
        return this.getParent(mIBObject);
    }

    public MIBObject getParent(MIBObject mIBObject) {
        if (this.oids.find(mIBObject.getOid()) == null || mIBObject.getOid().size() == 0) {
            return null;
        }
        ObjectID objectID = ObjectID.trim(mIBObject.getOid());
        MIBObject mIBObject2 = null;
        while (mIBObject2 == null && objectID.size() >= 1) {
            mIBObject2 = (MIBObject)this.oids.get(objectID);
            objectID = ObjectID.trim(objectID);
        }
        return mIBObject2;
    }

    public Pair getSplittedObjectID(ObjectID objectID) throws ObjectIDFormatException {
        Pair pair = new Pair();
        OrderedMapIterator orderedMapIterator = this.oids.lowerBound(objectID);
        if (orderedMapIterator.atEnd()) {
            return new Pair(objectID, new ObjectID());
        }
        if (((Pair)orderedMapIterator.get()).first.equals(objectID)) {
            pair.first = objectID;
            pair.second = new ObjectID();
            return pair;
        }
        orderedMapIterator.retreat();
        if (orderedMapIterator.atBegin() || orderedMapIterator.get() == null) {
            return new Pair(objectID, new ObjectID());
        }
        MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
        if (!mIBObject.getOid().isRootOf(objectID)) {
            pair.first = objectID;
            pair.second = new ObjectID();
            return pair;
        }
        pair.first = mIBObject.getOid();
        pair.second = objectID.getSuffix(objectID.size() - mIBObject.getOid().size());
        return pair;
    }

    public ObjectID[] getIndexObjectIDs(ObjectID objectID) {
        try {
            Pair pair = this.getSplittedObjectID(objectID);
            ObjectID objectID2 = ObjectID.trim((ObjectID)pair.first);
            ObjectID objectID3 = (ObjectID)pair.second;
            MIBObjectType mIBObjectType = (MIBObjectType)this.getObject(objectID2);
            if (mIBObjectType == null || !mIBObjectType.hasIndexPart()) {
                return null;
            }
            IndexStruct[] indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(this);
            return this.getIndexObjectIDs(objectID3, indexStructArray);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return null;
        }
    }

    public ObjectID[] getIndexObjectIDs(ObjectID objectID, IndexStruct[] indexStructArray) {
        try {
            ObjectID[] objectIDArray = new ObjectID[indexStructArray.length];
            for (int i = 0; i < indexStructArray.length; ++i) {
                if (indexStructArray[i].impliedLength) {
                    objectIDArray[i] = objectID;
                    break;
                }
                objectIDArray[i] = !indexStructArray[i].impliedLength && indexStructArray[i].minLength != indexStructArray[i].maxLength ? objectID.getPrefix((int)objectID.getSubIDAsLong(0) + 1) : objectID.getPrefix(indexStructArray[i].maxLength);
                objectID = objectID.getSuffix(objectID.size() - objectIDArray[i].size());
            }
            return objectIDArray;
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public MIBObject[] getObjectsByName(String string) {
        MIBObject[] mIBObjectArray = new MIBObject[this.onames.count(string)];
        if (mIBObjectArray.length == 0) {
            return mIBObjectArray;
        }
        OrderedMapIterator orderedMapIterator = this.onames.lowerBound(string);
        for (int i = 0; !orderedMapIterator.atEnd() && i < mIBObjectArray.length; ++i) {
            mIBObjectArray[i] = (MIBObject)((Pair)orderedMapIterator.get()).second;
            orderedMapIterator.advance();
        }
        return mIBObjectArray;
    }

    public MIBObject[] getObjectsByNamePrefix(String string, int n) {
        MIBObject mIBObject;
        ArrayList<MIBObject> arrayList = new ArrayList<MIBObject>();
        OrderedMapIterator orderedMapIterator = this.onames.lowerBound(string);
        for (int i = 0; !orderedMapIterator.atEnd() && (n > 0 || i < n) && (mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second).getName().startsWith(string); ++i) {
            arrayList.add(mIBObject);
            orderedMapIterator.advance();
        }
        return arrayList.toArray(new MIBObject[arrayList.size()]);
    }

    public MIBObject[] getObjectsByOid(ObjectID objectID) {
        MIBObject[] mIBObjectArray = new MIBObject[this.oids.count(objectID)];
        if (mIBObjectArray.length == 0) {
            return mIBObjectArray;
        }
        OrderedMapIterator orderedMapIterator = this.oids.lowerBound(objectID);
        for (int i = 0; !orderedMapIterator.atEnd() && i < mIBObjectArray.length; ++i) {
            mIBObjectArray[i] = (MIBObject)((Pair)orderedMapIterator.get()).second;
            orderedMapIterator.advance();
        }
        return mIBObjectArray;
    }

    public synchronized void remove(MIBModule mIBModule) {
        MIBObject mIBObject;
        this.modules.remove(mIBModule.getModuleName());
        this.moduleIDs.remove(mIBModule.getModuleID());
        OrderedMapIterator orderedMapIterator = this.oids.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && mIBObject.getModuleID().equals(mIBModule.getModuleID())) {
                this.oids.remove(orderedMapIterator);
                orderedMapIterator = this.oids.lowerBound(mIBObject.getOid());
                continue;
            }
            orderedMapIterator.advance();
        }
        orderedMapIterator = this.onames.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && mIBObject.getModuleID().equals(mIBModule.getModuleID())) {
                this.onames.remove(orderedMapIterator);
                orderedMapIterator = this.onames.lowerBound(mIBObject.getName());
                continue;
            }
            orderedMapIterator.advance();
        }
    }

    public void removeObject(Object object, MIBObject mIBObject) {
        MIBObject mIBObject2;
        Object object2;
        if (object != null && (object2 = (MIBModule)this.moduleIDs.get(object)) != null) {
            ((MIBModule)object2).remove(mIBObject);
        }
        if (mIBObject.getOid().size() > 0) {
            object2 = this.oids.lowerBound(mIBObject.getOid());
            while (!((OrderedMapIterator)object2).atEnd() && (mIBObject2 = (MIBObject)((Pair)((OrderedMapIterator)object2).get()).second).getOid().equals(mIBObject.getOid())) {
                if (mIBObject2.getModuleID().equals(object) && mIBObject2.getName().equals(mIBObject.getName())) {
                    this.oids.remove((Enumeration)object2);
                    break;
                }
                ((OrderedMapIterator)object2).advance();
            }
        }
        object2 = this.onames.lowerBound(mIBObject.getName());
        while (!((OrderedMapIterator)object2).atEnd() && (mIBObject2 = (MIBObject)((Pair)((OrderedMapIterator)object2).get()).second).getName().equals(mIBObject.getName())) {
            if (mIBObject2.getModuleID().equals(object) && (mIBObject.getOid() == null && mIBObject2.getOid() == null || mIBObject.getOid() != null && mIBObject.getOid().equals(mIBObject2.getOid()))) {
                this.onames.remove((Enumeration)object2);
                break;
            }
            ((OrderedMapIterator)object2).advance();
        }
    }

    public void removeObject(MIBObject mIBObject) {
        if (mIBObject.getModuleID() != null) {
            this.removeObject(mIBObject.getModuleID(), mIBObject);
        } else {
            this.oids.remove(mIBObject.getOid());
            this.onames.remove(mIBObject.getName());
        }
    }

    public synchronized boolean removeModule(String string) {
        MIBModule mIBModule = (MIBModule)this.modules.get(string);
        if (mIBModule != null) {
            this.remove(mIBModule);
            return true;
        }
        return false;
    }

    public MIBModule getModule(String string) {
        return (MIBModule)this.modules.get(string);
    }

    public MIBModule getModule(Object object) {
        return (MIBModule)this.moduleIDs.get(object);
    }

    public MIBObject getObject(String string) {
        String[] stringArray = MIBRepository.splitObjectName(string);
        if (stringArray[0] != null) {
            return this.getObject(stringArray[0], stringArray[1]);
        }
        return (MIBObject)this.onames.get(stringArray[1]);
    }

    private static String[] splitObjectName(String string) {
        if (string != null && string.length() > 2 && Character.isUpperCase(string.charAt(0)) && string.indexOf(46) > 0) {
            String string2 = string.substring(0, string.indexOf(46));
            String string3 = string.substring(string.indexOf(46) + 1);
            return new String[]{string2, string3};
        }
        return new String[]{null, string};
    }

    public MIBObject getObject(ObjectID objectID) {
        return (MIBObject)this.oids.get(objectID);
    }

    public Enumeration modules() {
        return new EnumerationIterator(this.modules.values().iterator());
    }

    public Iterator modulesIterator() {
        return this.modules.values().iterator();
    }

    public Enumeration getModulesSortedByName() {
        OrderedMap orderedMap = new OrderedMap(LexicographicPredicate.instance);
        Enumeration enumeration = this.modules();
        while (enumeration.hasMoreElements()) {
            MIBModule mIBModule = (MIBModule)enumeration.nextElement();
            orderedMap.put(mIBModule.getModuleName(), mIBModule);
        }
        return orderedMap.elements();
    }

    public Vector getModuleNames() {
        Vector<String> vector = new Vector<String>(this.modules.size() + 1);
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            vector.add(((MIBModule)iterator.next()).getModuleName());
        }
        return vector;
    }

    public Enumeration objects() {
        return this.oids.elements();
    }

    public Enumeration objectsByName() {
        return this.onames.elements();
    }

    public OrderedMapIterator find(ObjectID objectID) {
        return this.oids.find(objectID);
    }

    public OrderedMapIterator firstOID() {
        return this.oids.begin();
    }

    private void addToModule(MIBObject mIBObject) throws ObjectIDFormatException {
        MIBObjectType mIBObjectType;
        MIBModule mIBModule = (MIBModule)this.moduleIDs.get(mIBObject.getModuleID());
        if (mIBModule != null) {
            mIBModule.add(mIBObject);
        }
        if (mIBObject instanceof MIBObjectType && (mIBObjectType = (MIBObjectType)mIBObject).isTable()) {
            Object[] objectArray = mIBObjectType.getTableEntries();
            Arrays.sort(objectArray);
            Vector vector = this.getChildren(mIBObject);
            for (MIBObject mIBObject2 : vector) {
                MIBObjectType mIBObjectType2;
                if (!(mIBObject2 instanceof MIBObjectType)) continue;
                mIBObjectType2.setColumnarObject(Arrays.binarySearch(objectArray, (mIBObjectType2 = (MIBObjectType)mIBObject2).getName()) >= 0);
            }
        }
    }

    public synchronized void structureChanged() {
        Object object;
        Object object2 = this.oids.elements();
        while (object2.hasMoreElements()) {
            object = (MIBObject)object2.nextElement();
            try {
                this.addToModule((MIBObject)object);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.out.println("Repository: could not add object " + ((MIBObject)object).getName() + " because of invalid oid " + ((MIBObject)object).getOid().toString() + ".");
            }
        }
        object2 = new MIBObject();
        object = this.onames.elements();
        while (object.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)object.nextElement();
            if (!(mIBObject instanceof MIBTextualConvention) && !mIBObject.getClass().equals(object2.getClass())) continue;
            try {
                this.addToModule(mIBObject);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.out.println("Repository: could not add object " + mIBObject.getName() + " because of invalid oid " + mIBObject.getOid().toString() + ".");
            }
        }
    }

    public String getPath(ObjectID objectID, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (objectID == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(objectID.toString(), ".", false);
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(".");
                stringBuffer2.append(".");
            }
            String string = stringTokenizer.nextToken();
            stringBuffer.append(string);
            String string2 = this.getObjectName(new ObjectID(stringBuffer.toString()));
            if (string2 == null) {
                stringBuffer2.append(string);
                continue;
            }
            if (bl) {
                stringBuffer2.append(string2);
                stringBuffer2.append('(');
                stringBuffer2.append(string);
                stringBuffer2.append(')');
                continue;
            }
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }

    public String getPath(ObjectID objectID) {
        return this.getPath(objectID, false);
    }

    public String getPathSuffix(ObjectID objectID) {
        return this.getPathSuffix(objectID, false);
    }

    public String getPathSuffix(ObjectID objectID, boolean bl) {
        MIBObject mIBObject;
        Object object;
        MIBObject[] mIBObjectArray;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (objectID == null) {
            return "";
        }
        Object object2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(objectID.toString(), ".", false);
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(".");
                stringBuffer2.append(".");
            }
            mIBObjectArray = stringTokenizer.nextToken();
            stringBuffer.append((String)mIBObjectArray);
            object = new ObjectID(stringBuffer.toString());
            String string = this.getObjectName((ObjectID)object);
            if (string == null) {
                stringBuffer2.append((String)mIBObjectArray);
                continue;
            }
            stringBuffer2 = new StringBuffer(string);
            object2 = object;
        }
        if (bl && object2 != null && (mIBObject = this.getObject((ObjectID)object2)) != null && (mIBObjectArray = this.getObjectsByName(mIBObject.getName())) != null && mIBObjectArray.length > 1 && (object = this.getModuleName(mIBObject.getModuleID())) != null) {
            stringBuffer2 = new StringBuffer((String)object + "." + stringBuffer2.toString());
        }
        return stringBuffer2.toString();
    }

    public static MIBRepository loadFromFile(File file) {
        MIBRepository mIBRepository = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            mIBRepository = new MIBRepository();
            int n = objectInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                MIBObject mIBObject = (MIBObject)objectInputStream.readObject();
                if (mIBObject instanceof MIBModule) {
                    ((MIBModule)mIBObject).reinit();
                }
                mIBRepository.addObject(mIBObject);
            }
            objectInputStream.close();
            mIBRepository.structureChanged();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("MIB repository " + file + " not found.");
        }
        catch (StreamCorruptedException streamCorruptedException) {
            System.out.println("MIB repository " + file + " corrupted.");
        }
        catch (IOException iOException) {
            System.out.println("IO error while reading MIB repository " + file + ".");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Class not found (" + classNotFoundException.getMessage() + ") while reading MIB repository " + file + ".");
        }
        return mIBRepository;
    }

    public static boolean saveToFile(MIBRepository mIBRepository, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            Vector vector = mIBRepository.getTextualConventions();
            objectOutputStream.writeInt(mIBRepository.oids.size() + vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                objectOutputStream.writeObject(enumeration.nextElement());
            }
            enumeration = mIBRepository.oids.elements();
            while (enumeration.hasMoreElements()) {
                objectOutputStream.writeObject(enumeration.nextElement());
            }
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
        return true;
    }

    public Vector getTextualConventions() {
        return this.getNonOidObjects(true);
    }

    public Vector getNonOidObjects(boolean bl) {
        Vector<MIBObject> vector = new Vector<MIBObject>(this.onames.size() / 50, 50);
        Enumeration enumeration = this.onames.elements();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if ((bl || mIBObject.getOid().size() != 0) && !(mIBObject instanceof MIBTextualConvention)) continue;
            vector.addElement(mIBObject);
        }
        return vector;
    }

    public MIBSyntax resolveTC(String string) {
        MIBObject mIBObject;
        MIBSyntax mIBSyntax = null;
        while ((mIBObject = (MIBObject)this.onames.get(string)) != null) {
            if (mIBObject instanceof MIBTextualConvention) {
                MIBTextualConvention mIBTextualConvention = (MIBTextualConvention)mIBObject;
                if (mIBTextualConvention.getSyntax().getType() == 3) {
                    mIBSyntax = mIBTextualConvention.getSyntax();
                    string = mIBTextualConvention.getSyntax().getSyntax();
                    continue;
                }
                return mIBTextualConvention.getSyntax();
            }
            return mIBSyntax;
        }
        return mIBSyntax;
    }

    public ObjectID resolveOID(ObjectID objectID) {
        String string = objectID.getFirstUnresolvedSubId();
        if (string == null) {
            return objectID;
        }
        ObjectID objectID2 = this.getObjectID(string);
        if (objectID2 != null) {
            int n = objectID.toString().indexOf(string) + string.length();
            String string2 = objectID2.toString();
            if (n >= 0 && n < objectID.toString().length()) {
                string2 = string2 + objectID.toString().substring(n);
            }
            return new ObjectID(string2);
        }
        return null;
    }

    public MIBSyntax getBaseSyntax(MIBSyntax mIBSyntax) {
        MIBSyntax mIBSyntax2 = mIBSyntax;
        if (mIBSyntax2.getType() == 3) {
            try {
                MIBTextualConvention mIBTextualConvention = (MIBTextualConvention)this.getObject(mIBSyntax2.getSyntax());
                if (mIBTextualConvention != null) {
                    mIBSyntax2 = mIBTextualConvention.getSyntax();
                }
            }
            catch (ClassCastException classCastException) {
                return mIBSyntax2;
            }
        }
        return mIBSyntax2;
    }

    private MIBObject getBestObject(String string) {
        Range range = this.onames.equalRange(string);
        if (range == null || range.begin.atEnd()) {
            return null;
        }
        MIBObject mIBObject = null;
        MIBObject mIBObject2 = null;
        while (range.begin.hasMoreElements()) {
            if (((Pair)range.begin.get()).first.equals(string)) {
                MIBObject mIBObject3 = (MIBObject)((Pair)range.begin.get()).second;
                MIBModule mIBModule = this.getModule(mIBObject3.getModuleID());
                if (mIBModule != null && mIBModule.getSMIVersion() > 1) {
                    mIBObject = mIBObject3;
                    break;
                }
                mIBObject2 = mIBObject3;
            }
            range.begin.advance();
        }
        return mIBObject != null ? mIBObject : mIBObject2;
    }

    public MIBTextualConvention getEffectiveSyntax(MIBSyntax mIBSyntax) {
        return this.getEffectiveSyntax((ISyntax)mIBSyntax);
    }

    public MIBTextualConvention getEffectiveSyntax(ISyntax iSyntax) {
        MIBObject mIBObject;
        MIBSyntax mIBSyntax = new MIBSyntax();
        ISyntax iSyntax2 = iSyntax;
        MIBTextualConvention mIBTextualConvention = new MIBTextualConvention();
        if (iSyntax.hasEnums()) {
            mIBSyntax.setEnums((MIBEnum[])iSyntax2.getEnums());
        }
        if (iSyntax.hasRanges()) {
            mIBSyntax.setRanges((MIBRange[])iSyntax2.getRanges());
        }
        mIBTextualConvention.setSyntax(mIBSyntax);
        while ((mIBObject = this.getBestObject(iSyntax2.getSyntax())) != null) {
            if (mIBObject instanceof MIBTextualConvention) {
                Serializable serializable;
                Enumeration enumeration;
                MIBTextualConvention mIBTextualConvention2 = (MIBTextualConvention)mIBObject;
                if (mIBTextualConvention.getName() == null) {
                    mIBTextualConvention.setName(mIBTextualConvention2.getName());
                }
                if (mIBTextualConvention2.hasDisplayHint()) {
                    mIBTextualConvention.setDisplayHint(mIBTextualConvention2.getDisplayHint());
                }
                if (mIBTextualConvention2.getSyntax().hasEnums()) {
                    enumeration = mIBTextualConvention2.getSyntax().getEnumsVector().elements();
                    while (enumeration.hasMoreElements()) {
                        serializable = (MIBEnum)enumeration.nextElement();
                        if (!mIBSyntax.hasEnums()) {
                            mIBSyntax.addEnum(new MIBEnum((MIBEnum)serializable));
                            continue;
                        }
                        mIBSyntax.getEnumsVector().removeElement(serializable);
                        mIBSyntax.addEnum(new MIBEnum((MIBEnum)serializable));
                    }
                } else if (mIBTextualConvention2.getSyntax().hasRanges()) {
                    enumeration = mIBTextualConvention2.getSyntax().getRangesVector().elements();
                    while (enumeration.hasMoreElements()) {
                        serializable = (MIBRange)enumeration.nextElement();
                        if (mIBSyntax.containsRange((MIBRange)serializable) || !mIBSyntax.isRestrictiveRange((MIBRange)serializable)) continue;
                        mIBSyntax.addRange((MIBRange)serializable);
                    }
                }
                if (mIBTextualConvention2.getSyntax().getType() == 3) {
                    iSyntax2 = mIBTextualConvention2.getSyntax();
                    continue;
                }
                mIBSyntax.setSyntax(mIBTextualConvention2.getSyntax().getSyntax());
                mIBSyntax.setType(mIBTextualConvention2.getSyntax().getType());
                return mIBTextualConvention;
            }
            return mIBTextualConvention;
        }
        mIBSyntax.setSyntax(iSyntax2.getSyntax());
        mIBSyntax.setType(iSyntax2.getType());
        return mIBTextualConvention;
    }

    public boolean isReferencedBy(String string, MIBModule mIBModule, MIBComplianceModule mIBComplianceModule) {
        MIBGroup mIBGroup;
        IObject iObject;
        String[] stringArray = MIBRepository.splitObjectName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string2 != null && (mIBModule.getModuleName() != null ? !string2.equals(mIBModule.getModuleName()) : !string2.equals(mIBModule.getModuleName()))) {
            return false;
        }
        MIBModule mIBModule2 = mIBModule;
        if (mIBComplianceModule.hasMandatory()) {
            for (Object object : mIBComplianceModule.getMandatoryVector()) {
                iObject = mIBModule2.getObject((String)object);
                if (!(iObject instanceof MIBGroup) || !(mIBGroup = (MIBGroup)iObject).contains(string3)) continue;
                return true;
            }
        }
        if (mIBComplianceModule.hasVariations()) {
            for (Object object : mIBComplianceModule.getVariationsVector()) {
                if (!(object instanceof MIBCondGroup) || !((iObject = mIBModule2.getObject(((MIBVariation)object).getVariation())) instanceof MIBGroup) || !(mIBGroup = (MIBGroup)iObject).contains(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public String printModule(String string) {
        MIBModule mIBModule = this.getModule(string);
        if (mIBModule == null) {
            return "";
        }
        return mIBModule.toSMI(1, this, MIBObject.getLineSeparator());
    }

    public static Vector buildVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length > 0 ? objectArray.length : 1);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.add(objectArray[i]);
        }
        return vector;
    }

    public static String buildStringEnumeration(Enumeration enumeration, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(string + enumeration.nextElement().toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",\n");
        }
        return stringBuffer.toString();
    }

    public static String buildStringEnumeration(Enumeration enumeration) {
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append((String)enumeration.nextElement());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public void renameModule(MIBModule mIBModule, String string) {
        this.modules.remove(mIBModule.getModuleName());
        mIBModule.setModuleName(string);
        this.modules.put(string, mIBModule);
    }

    public void renameObject(MIBObject mIBObject, ObjectID objectID, String string) {
        Object object;
        Object object2;
        if (!mIBObject.getName().equals(string)) {
            if (mIBObject.getModuleID() != null) {
                object2 = (MIBModule)this.moduleIDs.get(mIBObject.getModuleID());
                if (object2 != null) {
                    ((MIBModule)object2).remove(mIBObject);
                    if (!mIBObject.getName().equals(string)) {
                        ((MIBModule)object2).changeObjectReferences(mIBObject.getName(), string);
                    }
                }
                object = this.onames.begin();
                while (((OrderedMapIterator)object).hasMoreElements()) {
                    MIBObject mIBObject2 = (MIBObject)((Pair)((OrderedMapIterator)object).get()).second;
                    if (mIBObject2.equals(mIBObject)) {
                        this.onames.remove((Enumeration)object);
                        break;
                    }
                    ((OrderedMapIterator)object).advance();
                }
            }
            mIBObject.setName(string);
            this.onames.add(string, mIBObject);
        }
        if (!mIBObject.getOid().equals(objectID)) {
            object2 = this.oids.begin();
            while (((OrderedMapIterator)object2).hasMoreElements()) {
                object = (MIBObject)((Pair)((OrderedMapIterator)object2).get()).second;
                if (object == mIBObject) {
                    this.oids.remove((Enumeration)object2);
                    break;
                }
                ((OrderedMapIterator)object2).advance();
            }
            mIBObject.setOid(objectID);
            this.oids.add(objectID, mIBObject);
        }
    }

    public Vector getColumnarObjectsOfTable(MIBModule mIBModule, MIBObjectType mIBObjectType, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        if (mIBObjectType == null || !mIBObjectType.isTable()) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        if (mIBModule == null) {
            return null;
        }
        if (bl) {
            Object object3;
            object2 = mIBObjectType;
            if (mIBObjectType.getIndexPart().isAugment()) {
                int n;
                object = this.getObjectsByName(mIBObjectType.getIndexPart().getIndexPart()[0]);
                object3 = null;
                for (n = 0; n < ((Object)object).length; ++n) {
                    if (!((MIBObject)object[n]).getModuleID().equals(mIBObjectType.getModuleID())) continue;
                    object3 = object[n];
                    break;
                }
                if (object3 == null) {
                    for (n = 0; n < ((Object)object).length; ++n) {
                        String string = this.getModuleName(((MIBObject)object[n]).getModuleID());
                        if (string == null || !mIBModule.imports(((MIBObject)object[n]).getName(), string)) continue;
                        object3 = object[n];
                        break;
                    }
                } else if (((Object)object).length == 1) {
                    object3 = object[0];
                }
                object2 = (MIBObjectType)object3;
            }
            if (object2 != null && ((MIBObjectType)object2).hasIndexPart()) {
                object = ((MIBObjectType)object2).getIndexPart().getIndexPartVector().elements();
                while (object.hasMoreElements()) {
                    object3 = this.getObjectsByName((String)object.nextElement());
                    MIBObject mIBObject = null;
                    if (((MIBObject[])object3).length > 1) {
                        int n;
                        for (n = 0; n < ((MIBObject[])object3).length; ++n) {
                            if (!object3[n].getModuleID().equals(mIBObjectType.getModuleID())) continue;
                            mIBObject = object3[n];
                            break;
                        }
                        if (mIBObject == null) {
                            for (n = 0; n < ((MIBObject[])object3).length; ++n) {
                                MIBModule mIBModule2 = this.getModule(object3[n].getModuleID());
                                if (mIBModule2 == null || !mIBModule.imports(object3[n].getName(), mIBModule2.getModuleName())) continue;
                                mIBObject = object3[n];
                                break;
                            }
                        }
                    } else if (((MIBObject[])object3).length == 1) {
                        mIBObject = object3[0];
                    }
                    if (mIBObject == null) continue;
                    vector.addElement(mIBObject);
                }
            } else {
                return null;
            }
        }
        if (bl2) {
            object2 = mIBObjectType.getTableEntriesVector().elements();
            while (object2.hasMoreElements()) {
                object = (MIBObjectType)this.getObject(mIBModule.getModuleName(), (String)object2.nextElement());
                if (object == null || SMI.accessType(((MIBObjectType)object).getAccess()) == 0) continue;
                vector.add(object);
            }
        }
        return vector;
    }

    public Vector getColumnarObjectsOfTable(MIBObjectType mIBObjectType, boolean bl, boolean bl2) {
        MIBModule mIBModule = this.getModule(mIBObjectType.getModuleID());
        return this.getColumnarObjectsOfTable(mIBModule, mIBObjectType, bl, bl2);
    }

    public List getNotificatioObjects(INotificationType iNotificationType) {
        MIBModule mIBModule = this.getModule(iNotificationType.getModuleID());
        return this.getNotificatioObjects(mIBModule, iNotificationType);
    }

    public List getNotificatioObjects(MIBModule mIBModule, INotificationType iNotificationType) {
        ArrayList<MIBObject> arrayList = new ArrayList<MIBObject>();
        Iterator iterator = iNotificationType.getVariablesVector().iterator();
        while (iterator.hasNext()) {
            MIBObject[] mIBObjectArray = this.getObjectsByName((String)iterator.next());
            MIBObject mIBObject = null;
            if (mIBObjectArray.length > 1) {
                int n;
                for (n = 0; n < mIBObjectArray.length; ++n) {
                    if (!mIBObjectArray[n].getModuleID().equals(iNotificationType.getModuleID())) continue;
                    mIBObject = mIBObjectArray[n];
                    break;
                }
                if (mIBObject == null) {
                    for (n = 0; n < mIBObjectArray.length; ++n) {
                        MIBModule mIBModule2 = this.getModule(mIBObjectArray[n].getModuleID());
                        if (mIBModule2 == null || !mIBModule.imports(mIBObjectArray[n].getName(), mIBModule2.getModuleName())) continue;
                        mIBObject = mIBObjectArray[n];
                        break;
                    }
                }
            } else if (mIBObjectArray.length == 1) {
                mIBObject = mIBObjectArray[0];
            }
            if (mIBObject != null) {
                arrayList.add(mIBObject);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public Vector getAugmentingTables(MIBObjectType mIBObjectType) {
        MIBModule mIBModule = this.getModule(mIBObjectType.getModuleID());
        Vector<MIBObjectType> vector = new Vector<MIBObjectType>();
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObjectType mIBObjectType2;
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (!(mIBObject instanceof MIBObjectType) || !(mIBObjectType2 = (MIBObjectType)mIBObject).isTable() || !mIBObjectType2.hasIndexPart() || !mIBObjectType2.getIndexPart().isAugment() || !mIBObjectType2.getIndexPart().getIndexPart()[0].equals(mIBObjectType.getName())) continue;
            MIBModule mIBModule2 = this.getModule(mIBObjectType2.getModuleID());
            if (mIBModule != null && mIBModule2 != null) {
                if (!mIBModule2.getModuleID().equals(mIBModule.getModuleID()) && !mIBModule2.imports(mIBObjectType.getName(), mIBModule.getModuleName())) continue;
                vector.addElement(mIBObjectType2);
                continue;
            }
            vector.addElement(mIBObjectType2);
        }
        return vector;
    }

    public boolean isExpandingIndex(MIBIndexPart mIBIndexPart, MIBIndexPart mIBIndexPart2) {
        if (mIBIndexPart == null || mIBIndexPart2 == null) {
            return false;
        }
        Vector vector = mIBIndexPart.getIndexPartVector();
        Vector vector2 = mIBIndexPart2.getIndexPartVector();
        if (vector2.size() < vector.size()) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i).equals(vector2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public Vector getParentTables(MIBObjectType mIBObjectType) {
        MIBModule mIBModule = this.getModule(mIBObjectType.getModuleID());
        Vector<MIBObjectType> vector = new Vector<MIBObjectType>();
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (!(mIBObject instanceof MIBObjectType)) continue;
            MIBObjectType mIBObjectType2 = (MIBObjectType)mIBObject;
            if (mIBObjectType2.isTable() && mIBObjectType2.hasIndexPart() && mIBObjectType2.getIndexPart().isAugment() && mIBObjectType2.getIndexPart().getIndexPart()[0].equals(mIBObjectType.getName())) {
                MIBModule mIBModule2 = this.getModule(mIBObjectType2.getModuleID());
                if (mIBModule != null && mIBModule2 != null) {
                    if (!mIBModule2.getModuleID().equals(mIBModule.getModuleID()) && !mIBModule2.imports(mIBObjectType.getName(), mIBModule.getModuleName())) continue;
                    vector.addElement(mIBObjectType2);
                    continue;
                }
                vector.addElement(mIBObjectType2);
                continue;
            }
            if (!mIBObjectType2.isTable() || !mIBObjectType2.hasIndexPart() || mIBObjectType2.getName().equals(mIBObjectType.getName()) || !this.isExpandingIndex(mIBObjectType2.getIndexPart(), mIBObjectType.getIndexPart())) continue;
            vector.addElement(mIBObjectType2);
        }
        return vector;
    }

    public MIBObjectType getObjectType(ObjectID objectID) {
        try {
            Pair pair = this.getSplittedObjectID(objectID);
            if (pair == null) {
                return null;
            }
            ObjectID objectID2 = (ObjectID)pair.first;
            MIBObject mIBObject = this.getObject(objectID2);
            if (mIBObject instanceof MIBObjectType) {
                return (MIBObjectType)mIBObject;
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            // empty catch block
        }
        return null;
    }

    public MIBObjectType getTableEntry(MIBObject mIBObject) {
        if (mIBObject instanceof MIBObjectType) {
            MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
            if (mIBObjectType.isTable()) {
                return mIBObjectType;
            }
            Vector vector = this.getChildren(mIBObjectType);
            if (vector.size() == 0) {
                return null;
            }
            MIBObject mIBObject2 = (MIBObject)vector.firstElement();
            if (mIBObject2 instanceof MIBObjectType && ((MIBObjectType)mIBObject2).isTable()) {
                return (MIBObjectType)mIBObject2;
            }
        }
        return null;
    }

    public MIBObject getNextObject(ObjectID objectID) {
        OrderedMapIterator orderedMapIterator = this.oids.lowerBound(objectID);
        while (!orderedMapIterator.atEnd()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(objectID)) {
                return mIBObject;
            }
            orderedMapIterator.advance();
        }
        return null;
    }

    public MIBObject getPrevObject(ObjectID objectID) {
        MIBObject mIBObject;
        OrderedMapIterator orderedMapIterator = this.oids.upperBound(objectID);
        while (!(orderedMapIterator.atBegin() || orderedMapIterator.get() != null && (mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second).getOid().equals(objectID))) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atEnd() && !orderedMapIterator.atBegin()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(objectID)) {
                return mIBObject;
            }
            orderedMapIterator.retreat();
        }
        return null;
    }

    public MIBObject getNextSibblingObject(ObjectID objectID) {
        OrderedMapIterator orderedMapIterator = this.oids.lowerBound(objectID);
        while (!orderedMapIterator.atEnd()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(objectID) && mIBObject.getOid().isPeerOf(objectID)) {
                return mIBObject;
            }
            orderedMapIterator.advance();
        }
        return null;
    }

    public MIBObject getPrevSibblingObject(ObjectID objectID) {
        MIBObject mIBObject;
        OrderedMapIterator orderedMapIterator = this.oids.upperBound(objectID);
        if (!orderedMapIterator.atBegin() && orderedMapIterator.atEnd()) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atBegin() && !(mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second).getOid().equals(objectID)) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atBegin()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(objectID) && mIBObject.getOid().isPeerOf(objectID)) {
                return mIBObject;
            }
            orderedMapIterator.retreat();
        }
        return null;
    }

    private static Map inverse(Map map) {
        HashMap hashMap = new HashMap(map.size());
        for (Object k : map.keySet()) {
            hashMap.put(map.get(k), k);
        }
        return hashMap;
    }

    public Map getImportedModuleIDs() {
        return this.importedModuleIDs;
    }

    public Map addImportedModuleIDsInverse(Map map) {
        Map map2 = MIBRepository.inverse(map);
        this.addImportedModuleIDs(map2);
        return map2;
    }

    public void removeImportedModuleID(Object object) {
        this.importedModuleIDs.remove(object);
    }

    public void addImportedModuleIDs(Map map) {
        this.importedModuleIDs.putAll(map);
    }

    public String getModuleName(Object object) {
        Object v = this.moduleIDs.get(object);
        if (v != null) {
            return ((MIBModule)v).getModuleName();
        }
        return (String)this.importedModuleIDs.get(object);
    }

    public void freeUserObjects() {
        Enumeration enumeration = this.objectsByName();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            mIBObject.freeUserObjects();
        }
    }
}

