/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.smi.ext.SMIRange;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;

public class MIBRange
implements Serializable,
SMIRange,
Comparable {
    public static final long serialVersionUID = 1000L;
    protected Long lower = null;
    protected Long upper = null;

    public MIBRange() {
    }

    public MIBRange(long l, long l2) {
        this.lower = new Long(l);
        this.upper = new Long(l2);
    }

    public MIBRange(String string, String string2) {
        this.lower = new Long(SMI.parseLongConstant(string));
        this.upper = new Long(SMI.parseLongConstant(string2));
    }

    public Long getLower() {
        return this.lower;
    }

    public Long getUpper() {
        return this.upper;
    }

    public void setLower(long l) {
        this.lower = new Long(l);
    }

    public void setUpper(long l) {
        this.upper = new Long(l);
    }

    public void setLowerValue(long l) {
        this.lower = new Long(l);
    }

    public void setUpperValue(long l) {
        this.upper = new Long(l);
    }

    public long getLowerValue() {
        return this.lower;
    }

    public long getUpperValue() {
        return this.upper;
    }

    public String toSMI(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lower.equals(this.upper)) {
            MIBObject.addNum(n, stringBuffer, this.upper);
        } else {
            MIBObject.addNum(n, stringBuffer, this.lower);
            stringBuffer.append("..");
            MIBObject.addNum(n, stringBuffer, this.upper);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toSMI(1);
    }

    public boolean equals(Object object) {
        if (object instanceof MIBRange) {
            return this.lower.equals(((MIBRange)object).lower) && this.upper.equals(((MIBRange)object).upper);
        }
        return false;
    }

    public static boolean normalizeRanges(Vector vector, Vector vector2) {
        boolean bl = true;
        for (MIBRange mIBRange : vector) {
            boolean bl2 = true;
            for (MIBRange mIBRange2 : vector2) {
                if (mIBRange2.getLowerValue() > mIBRange.getLowerValue() || mIBRange2.getUpperValue() < mIBRange.getUpperValue()) {
                    if (mIBRange2.getUpperValue() < mIBRange.getLowerValue() || mIBRange2.getLowerValue() > mIBRange.getUpperValue()) continue;
                    mIBRange2.setLowerValue(Math.min(mIBRange2.getLowerValue(), mIBRange.getLowerValue()));
                    mIBRange2.setUpperValue(Math.min(mIBRange2.getUpperValue(), mIBRange.getUpperValue()));
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            }
            if (bl2) {
                vector2.add(new MIBRange(mIBRange.getLowerValue(), mIBRange.getUpperValue()));
                continue;
            }
            bl = false;
        }
        return bl;
    }

    public static int compareRanges(Vector vector, Vector vector2) {
        if (vector.size() == 0 && vector2.size() > 0) {
            return 1;
        }
        if (vector.size() > 0 && vector2.size() == 0) {
            return -1;
        }
        Collections.sort(vector);
        Collections.sort(vector2);
        for (int i = 0; i < Math.min(vector.size(), vector2.size()); ++i) {
            MIBRange mIBRange = (MIBRange)vector.get(i);
            MIBRange mIBRange2 = (MIBRange)vector2.get(i);
            if (mIBRange.getLowerValue() > mIBRange2.getLowerValue()) {
                return -1;
            }
            if (mIBRange.getLowerValue() < mIBRange2.getLowerValue()) {
                return 1;
            }
            if (mIBRange.getUpperValue() > mIBRange2.getUpperValue()) {
                return 1;
            }
            if (mIBRange.getLowerValue() >= mIBRange2.getLowerValue()) continue;
            return -1;
        }
        return vector.size() - vector2.size();
    }

    public int compareTo(Object object) {
        MIBRange mIBRange = (MIBRange)object;
        if (this.getLowerValue() == mIBRange.getLowerValue()) {
            return 0;
        }
        if (this.getLowerValue() > mIBRange.getLowerValue()) {
            return 1;
        }
        return -1;
    }
}

