/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IIndexPart;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMIIndexPart;
import com.agentpp.smi.ext.SMIObjectType;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class MIBObjectType
extends MIBObject
implements Serializable,
SMIObjectType {
    public static final long serialVersionUID = 1000L;
    protected String access = null;
    protected String defValue = null;
    protected MIBSyntax syntax = null;
    protected String units = null;
    protected MIBIndexPart indexPart = null;
    protected Vector entries = null;
    protected boolean columnarObject = false;

    public MIBObjectType() {
        this.columnarObject = false;
    }

    public MIBObjectType(ObjectID objectID, String string, Integer n) {
        super(objectID, string, n);
        this.columnarObject = false;
    }

    public MIBObjectType(MIBObjectType mIBObjectType) {
        super(mIBObjectType);
        this.access = new String(mIBObjectType.access);
        if (mIBObjectType.hasDefaultValue()) {
            this.defValue = new String(mIBObjectType.defValue);
        }
        this.syntax = new MIBSyntax(mIBObjectType.getSyntax());
        if (mIBObjectType.hasUnits()) {
            this.units = new String(mIBObjectType.units);
        }
        if (mIBObjectType.hasIndexPart()) {
            this.indexPart = new MIBIndexPart(mIBObjectType.indexPart);
        }
        if (mIBObjectType.isTable()) {
            this.setTableEntries(mIBObjectType.getTableEntries());
        }
        this.columnarObject = mIBObjectType.columnarObject;
    }

    public MIBObject getClone() {
        return new MIBObjectType(this);
    }

    public final String getTypeString() {
        return SMI.ENTRY_TYPES[1];
    }

    public final int getType() {
        return 1;
    }

    public final String getSubTypeString() {
        if (this.isScalar()) {
            return "Scalar";
        }
        if (this.isTable()) {
            return "TableEntry";
        }
        if (this.isColumnarObject()) {
            return "Column";
        }
        if (this.getSyntax() != null && this.getSyntax().getType() == 2) {
            return "Table";
        }
        return "Scalar";
    }

    public final void setAccess(String string) {
        this.access = string;
    }

    public final String getAccess() {
        return this.access;
    }

    public final void setSyntax(MIBSyntax mIBSyntax) {
        this.syntax = mIBSyntax;
    }

    public final void setSyntax(SMISyntax sMISyntax) {
        this.syntax = (MIBSyntax)sMISyntax;
    }

    public final MIBSyntax getSyntax() {
        return this.syntax;
    }

    public ISyntax getSyntaxDef() {
        return this.syntax;
    }

    public final boolean hasDefaultValue() {
        return this.defValue != null;
    }

    public final String getDefaultValue() {
        return this.defValue;
    }

    public Object getDefaultValueAsObject(MIBRepository mIBRepository) {
        try {
            if (!this.hasDefaultValue()) {
                return null;
            }
            MIBSyntax mIBSyntax = mIBRepository.getEffectiveSyntax(this.syntax).getSyntax();
            if (mIBSyntax.hasEnums()) {
                String string = mIBSyntax.getEnum(this.getDefaultValue());
                if (string == null) {
                    return null;
                }
                if (!mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    return new Long(SMI.parseLongConstant(string));
                }
                return string;
            }
            if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("Integer32") || mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32") || mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32") || mIBSyntax.getSyntax().equals("Counter64") || mIBSyntax.getSyntax().equals("TimeTicks")) {
                return new Long(SMI.parseLongConstant(this.defValue));
            }
            if (mIBSyntax.getSyntax().equals("IpAddress")) {
                byte[] byArray = SMI.stringConstantToByteArray(this.defValue);
                if (byArray == null) {
                    return "0.0.0.0";
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < 4 && i < byArray.length; ++i) {
                    stringBuffer.append(byArray[i]);
                    if (i >= 3) continue;
                    stringBuffer.append(".");
                }
                return stringBuffer.toString();
            }
            if (mIBSyntax.getSyntax().equals("NetworkAddress") || mIBSyntax.getSyntax().equals("Opaque") || mIBSyntax.getSyntax().startsWith("OCTET STRING")) {
                return SMI.parseStringConstant(this.defValue);
            }
            if (mIBSyntax.getSyntax().equals("OBJECT-IDENTITY") || mIBSyntax.getSyntax().equals("OBJECT IDENTIFIER")) {
                if (this.defValue.indexOf(123) >= 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer("{ }");
                    StringBuffer stringBuffer = new StringBuffer();
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer.append(stringTokenizer.nextToken());
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        stringBuffer.append('.');
                    }
                    return new ObjectID(stringBuffer.toString());
                }
                ObjectID objectID = mIBRepository.getObjectID(this.defValue);
                if (objectID != null) {
                    return objectID;
                }
                return new ObjectID();
            }
            return this.defValue;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Object getDefaultValue(MIBRepository mIBRepository, MIBSyntax mIBSyntax, String string) {
        if (string == null) {
            return null;
        }
        try {
            MIBSyntax mIBSyntax2 = mIBRepository.getEffectiveSyntax(mIBSyntax).getSyntax();
            if (mIBSyntax2.hasEnums()) {
                if (mIBSyntax2.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    return mIBSyntax2.getBitsEnum(string);
                }
                String string2 = mIBSyntax2.getEnum(string);
                if (string2 == null) {
                    return null;
                }
                return new Long(SMI.parseLongConstant(string2));
            }
            if (mIBSyntax2.getSyntax().equals("INTEGER") || mIBSyntax2.getSyntax().equals("Integer32") || mIBSyntax2.getSyntax().equals("Counter") || mIBSyntax2.getSyntax().equals("Counter32") || mIBSyntax2.getSyntax().equals("UInteger32") || mIBSyntax2.getSyntax().equals("Unsigned32") || mIBSyntax2.getSyntax().equals("Gauge") || mIBSyntax2.getSyntax().equals("Gauge32") || mIBSyntax2.getSyntax().equals("Counter64") || mIBSyntax2.getSyntax().equals("TimeTicks")) {
                return new Long(SMI.parseLongConstant(string));
            }
            if (mIBSyntax2.getSyntax().equals("IpAddress") || mIBSyntax2.getSyntax().equals("NetworkAddress") || mIBSyntax2.getSyntax().equals("Opaque") || mIBSyntax2.getSyntax().startsWith("OCTET STRING")) {
                return SMI.stringConstantToByteArray(string);
            }
            if (mIBSyntax2.getSyntax().equals("OBJECT-IDENTITY") || mIBSyntax2.getSyntax().equals("OBJECT IDENTIFIER")) {
                if (string.indexOf(123) >= 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer("{ }");
                    StringBuffer stringBuffer = new StringBuffer();
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer.append(stringTokenizer.nextToken());
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        stringBuffer.append('.');
                    }
                    return new ObjectID(stringBuffer.toString());
                }
                ObjectID objectID = mIBRepository.getObjectID(string);
                return objectID;
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Object getDefaultValue(MIBRepository mIBRepository) {
        return MIBObjectType.getDefaultValue(mIBRepository, this.getSyntax(), this.getDefaultValue());
    }

    public final void setDefaultValue(String string) {
        this.defValue = string;
    }

    public final boolean hasIndexPart() {
        return this.indexPart != null;
    }

    public final MIBIndexPart getIndexPart() {
        return this.indexPart;
    }

    public IIndexPart getIndex() {
        return this.getIndexPart();
    }

    public final void setIndexPart(MIBIndexPart mIBIndexPart) {
        this.indexPart = mIBIndexPart;
    }

    public final void setIndexPart(SMIIndexPart sMIIndexPart) {
        this.indexPart = (MIBIndexPart)sMIIndexPart;
    }

    public final boolean isTable() {
        return this.entries != null && this.entries.size() > 0;
    }

    public final boolean isTableSequence() {
        return this.syntax != null && this.syntax.getType() == 2;
    }

    public void addTableEntry(String string) {
        if (this.entries == null) {
            new Vector(5);
        }
        this.entries.addElement(string);
    }

    public final void setTableEntriesVector(Vector vector) {
        this.entries = vector;
    }

    public final void setTableEntries(String[] stringArray) {
        this.entries = MIBRepository.buildVector(stringArray);
    }

    public final Vector getTableEntriesVector() {
        return this.entries;
    }

    public String[] getTableEntries() {
        if (this.entries == null) {
            return null;
        }
        Object[] objectArray = new String[this.entries.size()];
        this.entries.copyInto(objectArray);
        return objectArray;
    }

    public boolean renameTableEntry(String string, String string2) {
        String string3;
        int n = this.getTableEntriesVector().indexOf(string);
        if (n < 0) {
            return false;
        }
        this.getTableEntriesVector().set(n, string2);
        n = this.getIndexPart().getIndexPartVector().indexOf(string);
        if (n >= 0) {
            this.getIndexPart().getIndexPartVector().set(n, string2);
        }
        if ((string3 = this.getName()).length() > 0) {
            this.getSyntax().setSyntax(string3.substring(0, 1).toUpperCase() + string3.substring(1));
        }
        return true;
    }

    public final String getTableEntry(int n) {
        return (String)this.entries.elementAt(n);
    }

    public final int getTableLength() {
        return this.entries.size();
    }

    public final void setColumnarObject(boolean bl) {
        this.columnarObject = bl;
    }

    public final boolean isColumnarObject() {
        return this.columnarObject;
    }

    public final void setUnits(String string) {
        this.units = string;
    }

    public final String getUnits() {
        return this.units;
    }

    public final boolean hasUnits() {
        return this.units != null;
    }

    public String toSMI(int n, int n2, MIBRepository mIBRepository, String string) {
        String string2;
        MIBObjectType mIBObjectType = (MIBObjectType)this.comparable(n);
        StringBuffer stringBuffer = new StringBuffer();
        MIBObjectType.addNavigationLinks(this, n, stringBuffer, mIBRepository, string);
        if (this.hasComment()) {
            MIBObjectType.addComment(n, stringBuffer, this.asn1Comment, string);
            stringBuffer.append(string);
        }
        MIBObjectType.addObjectRef(null, n, stringBuffer, this.name, mIBObjectType == null ? null : mIBObjectType.name);
        MIBObjectType.addKeyWord(n, stringBuffer, " OBJECT-TYPE");
        stringBuffer.append(string);
        stringBuffer.append("\t");
        MIBObjectType.addKeyWord(n, stringBuffer, "SYNTAX  ");
        if (this.syntax != null) {
            stringBuffer.append(this.syntax.toSMI(n, mIBRepository, mIBObjectType == null ? null : mIBObjectType.syntax, string));
        }
        if (n != 16 && this.hasUnits()) {
            stringBuffer.append('\t');
            MIBObjectType.addKeyWord(n, stringBuffer, "UNITS");
            stringBuffer.append(string);
            string2 = null;
            if (mIBObjectType != null) {
                string2 = mIBObjectType.hasUnits() ? mIBObjectType.units : "";
            }
            MIBObjectType.addText(string, n, stringBuffer, MIBObjectType.formatLines("\t\t", this.units), string2 == null ? null : MIBObjectType.formatLines("\t\t", string2));
            stringBuffer.append(string);
        }
        if (n2 == 1) {
            stringBuffer.append('\t');
            MIBObjectType.addKeyWord(n, stringBuffer, "ACCESS  ");
            MIBObjectType.addString(n, stringBuffer, this.access, mIBObjectType == null ? null : mIBObjectType.access);
            stringBuffer.append(string);
        } else {
            stringBuffer.append('\t');
            MIBObjectType.addKeyWord(n, stringBuffer, "MAX-ACCESS ");
            MIBObjectType.addString(n, stringBuffer, this.access, mIBObjectType == null ? null : mIBObjectType.access);
            stringBuffer.append(string);
        }
        stringBuffer.append(this.getSMIDefBegin(n, string));
        if (this.indexPart != null) {
            stringBuffer.append('\t');
            string2 = null;
            if (mIBObjectType != null) {
                string2 = mIBObjectType.hasIndexPart() ? mIBObjectType.getIndexPart().toSMI(n, string) : "";
            }
            MIBObject.addString(n, stringBuffer, this.indexPart.toSMI(n, string), string2);
        }
        if (((n & 1) > 0 || (n & 2) > 0) && this.defValue != null) {
            stringBuffer.append('\t');
            MIBObjectType.addKeyWord(n, stringBuffer, "DEFVAL ");
            stringBuffer.append("{ ");
            string2 = null;
            if (mIBObjectType != null) {
                string2 = mIBObjectType.hasDefaultValue() ? mIBObjectType.getDefaultValue() : "";
            }
            MIBObjectType.addString(n, stringBuffer, this.defValue, string2);
            stringBuffer.append(" }");
            stringBuffer.append(string);
        }
        stringBuffer.append(this.getSMIDefEnd(n, mIBRepository, this.asn1CommentInline, string));
        stringBuffer.append(string);
        if (mIBRepository != null && this.entries != null) {
            stringBuffer.append(string);
            stringBuffer.append(this.syntax.getSyntax());
            stringBuffer.append(" ::= ");
            MIBObjectType.addKeyWord(n, stringBuffer, "SEQUENCE");
            stringBuffer.append(" {");
            stringBuffer.append(string);
            int n3 = MIBObjectType.getMaxLength(this.entries.elements());
            Enumeration enumeration = null;
            if (mIBObjectType != null) {
                enumeration = mIBObjectType.isTable() ? mIBObjectType.entries.elements() : new Vector().elements();
            }
            if (this.entries.size() == 0) {
                stringBuffer.append(" }");
            }
            stringBuffer.append(string);
            Enumeration enumeration2 = this.entries.elements();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                String string4 = null;
                if (enumeration != null) {
                    string4 = enumeration.hasMoreElements() ? (String)enumeration.nextElement() : "";
                }
                stringBuffer.append("\t");
                MIBObjectType.addObjectLink(n, stringBuffer, string3, string4);
                stringBuffer.append(MIBObjectType.space(n3 - string3.length() + 1));
                MIBObjectType mIBObjectType2 = (MIBObjectType)mIBRepository.getObject(string3);
                if (mIBObjectType2 == null) {
                    stringBuffer.append("?");
                    if (enumeration2.hasMoreElements()) {
                        stringBuffer.append(",");
                        stringBuffer.append(string);
                        continue;
                    }
                    stringBuffer.append(" }");
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append(mIBObjectType2.getSyntax().getSyntax());
                if (enumeration2.hasMoreElements()) {
                    stringBuffer.append(",");
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append(" }");
                stringBuffer.append(string);
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean isScalar() {
        return !this.isTable() && !this.isColumnarObject() && SMI.isAccessible(this.getAccess());
    }

    public boolean isStructural() {
        return !this.isTable() && !this.isColumnarObject() && !this.isScalar();
    }

    public boolean equals(Object object) {
        if (object instanceof MIBObjectType && super.equals(object)) {
            MIBObjectType mIBObjectType = (MIBObjectType)object;
            return MIBObjectType.saveCompare(this.syntax, mIBObjectType.syntax) && MIBObjectType.saveCompare(this.access, mIBObjectType.access) && MIBObjectType.saveCompare(this.defValue, mIBObjectType.defValue) && MIBObjectType.saveCompare(this.entries, mIBObjectType.entries) && MIBObjectType.saveCompare(this.indexPart, mIBObjectType.indexPart);
        }
        return false;
    }

    public void freeUserObjects() {
        super.freeUserObjects();
        if (this.syntax != null) {
            this.syntax.userObject = null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.access = SMI.getCommonIdentifier(this.access);
    }
}

