/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBTextualConvention;
import java.util.Comparator;

public class MIBObjectOrderComparator
implements Comparator {
    private static final int[] OBJECT_ORDER = new int[]{1, 1, 2, 2, 0, 1, 3, 4, 5, 6, 1};
    private int mode;

    public MIBObjectOrderComparator(int n) {
        this.mode = n;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof MIBObject && object2 instanceof MIBObject) {
            int n;
            MIBObject mIBObject = (MIBObject)object;
            MIBObject mIBObject2 = (MIBObject)object2;
            if ((this.mode & 0x80) > 0 && mIBObject.hasSequenceID() && mIBObject2.hasSequenceID() && (n = mIBObject.getSequenceID().compareTo(mIBObject2.getSequenceID())) != 0) {
                return n;
            }
            if (mIBObject instanceof MIBTextualConvention && mIBObject2 instanceof MIBTextualConvention) {
                return mIBObject.getName().compareTo(mIBObject2.getName());
            }
            if (mIBObject instanceof MIBTextualConvention) {
                return -1;
            }
            if (mIBObject2 instanceof MIBTextualConvention) {
                return 1;
            }
            if ((this.mode & 0x100) > 0) {
                int n2;
                n = OBJECT_ORDER[mIBObject.getType()];
                if (n < (n2 = OBJECT_ORDER[mIBObject2.getType()])) {
                    return -1;
                }
                if (n == n2) {
                    return mIBObject.getOid().compareTo(mIBObject2.getOid());
                }
                return 1;
            }
            return mIBObject.getOid().compareTo(mIBObject2.getOid());
        }
        return -1;
    }
}

