/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.CompareResult;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IObjectID;
import com.agentpp.smi.ext.SMIObject;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class MIBObject
implements Serializable,
SMIObject {
    public static final long serialVersionUID = 1000L;
    public String name = null;
    protected String descr = null;
    protected String reference = null;
    protected String status = null;
    protected ObjectID oid = null;
    public Integer moduleID = new Integer(-1);
    public transient Object userObject = null;
    private int type = 10;
    protected String asn1Comment = null;
    protected int released = 0;
    protected Integer sequenceID = null;
    protected int id;
    protected String asn1CommentInline;
    protected static String lineSeparator = System.getProperty("line.separator", "\n");
    protected static int nextID = MIBObject.nextID();

    public MIBObject() {
        this.oid = new ObjectID();
    }

    public static final String getLineSeparator() {
        return lineSeparator;
    }

    protected static synchronized int nextID() {
        return nextID++;
    }

    public MIBObject(IObject iObject) {
        if (iObject.getObjectID() != null) {
            this.oid = new ObjectID(iObject.getPrintableOid());
        }
        this.name = iObject.getName();
        if (iObject.hasDescription()) {
            this.descr = iObject.getDescription();
        }
        if (iObject.hasReference()) {
            this.reference = iObject.getReference();
        }
        if (iObject.hasStatus()) {
            this.status = iObject.getStatus();
        }
        this.moduleID = new Integer(iObject.getModuleID());
        if (iObject instanceof MIBObject) {
            MIBObject mIBObject = (MIBObject)iObject;
            if (mIBObject.userObject != null) {
                this.userObject = mIBObject.userObject;
            }
            this.released = mIBObject.released;
            this.sequenceID = mIBObject.sequenceID;
            this.id = mIBObject.id;
        }
        this.type = iObject.getType();
        this.asn1Comment = iObject.getComment();
        this.asn1CommentInline = iObject.getInlineComment();
    }

    public MIBObject(String string) {
        this(new ObjectID(), string, new Integer(-1));
    }

    public MIBObject(Object object) {
        this(new ObjectID(), null, new Integer(-1));
    }

    public MIBObject(ObjectID objectID, String string) {
        this(objectID, string, new Integer(-1));
    }

    public MIBObject(String string, Integer n) {
        this(new ObjectID(), string, n);
    }

    public MIBObject(ObjectID objectID, String string, Integer n) {
        this.moduleID = n;
        this.oid = objectID;
        this.name = string;
        this.type = 10;
    }

    public int compareTo(Object object) {
        MIBObject mIBObject = (MIBObject)object;
        if (this.getOid() != null) {
            return this.getOid().compareTo(mIBObject.getOid());
        }
        return this.getName().compareTo(mIBObject.getName());
    }

    public MIBObject getClone() {
        return new MIBObject(this);
    }

    public IObject getDeepClone() {
        return this.getClone();
    }

    public String getTypeString() {
        return SMI.ENTRY_TYPES[this.type];
    }

    public int getType() {
        return this.type;
    }

    public void setStatus(String string) {
        this.status = string;
        if (this.status != null && this.status.length() > 0) {
            this.type = 0;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public final Integer getModuleID() {
        return this.moduleID;
    }

    public final void setModuleID(Integer n) {
        this.moduleID = n;
    }

    public final boolean hasValidModuleID() {
        return this.moduleID >= 0;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.descr = string;
    }

    public String getDescription() {
        return this.descr;
    }

    public void setDescrAsChars(Character[] characterArray) {
        if (characterArray != null) {
            char[] cArray = new char[characterArray.length];
            for (int i = 0; i < characterArray.length; ++i) {
                cArray[i] = characterArray[i].charValue();
            }
            this.descr = new String(cArray);
        } else {
            this.descr = null;
        }
    }

    public final boolean hasDescription() {
        return this.descr != null;
    }

    public final boolean hasReference() {
        return this.reference != null;
    }

    public Character[] getDescrAsChars() {
        if (this.descr == null) {
            return null;
        }
        char[] cArray = new char[this.descr.length()];
        this.descr.getChars(0, this.descr.length(), cArray, 0);
        Character[] characterArray = new Character[cArray.length];
        for (int i = 0; i < characterArray.length; ++i) {
            characterArray[i] = new Character(cArray[i]);
        }
        return characterArray;
    }

    public final void setReference(String string) {
        this.reference = string;
    }

    public final String getReference() {
        return this.reference;
    }

    public final void setOid(ObjectID objectID) {
        this.oid = objectID;
    }

    public final void setOid(String string) {
        this.oid = new ObjectID(string);
    }

    public final ObjectID getOid() {
        return this.oid;
    }

    public final IObjectID getObjectID() {
        return this.oid;
    }

    public final String getPrintableOid() {
        return this.oid.toString();
    }

    public final Integer getSequenceID() {
        return this.sequenceID;
    }

    public final boolean hasSequenceID() {
        return this.sequenceID != null;
    }

    public final void setSequenceID(Integer n) {
        this.sequenceID = n;
    }

    protected String getSMIDefBegin(int n, String string) {
        MIBObject mIBObject = this.comparable(n);
        StringBuffer stringBuffer = new StringBuffer("\t");
        MIBObject.addKeyWord(n, stringBuffer, "STATUS  ");
        if (this.status == null || this.status.length() == 0) {
            stringBuffer.append("current");
        } else if (n == 8) {
            stringBuffer.append(SMI.convertStatusToSMIv2(this.status));
        } else {
            if (mIBObject != null && mIBObject.status != null && !mIBObject.status.equals(this.status)) {
                stringBuffer.append("<u>");
            }
            stringBuffer.append(this.status);
            if (mIBObject != null && mIBObject.status != null && !mIBObject.status.equals(this.status)) {
                stringBuffer.append("</u>");
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("\t");
        MIBObject.addKeyWord(n, stringBuffer, "DESCRIPTION");
        if (this.descr == null) {
            stringBuffer.append(" \"\"" + string);
        } else {
            stringBuffer.append(string);
            MIBObject.addText(string, n, stringBuffer, MIBObject.formatLines("\t\t", this.descr), mIBObject == null ? null : MIBObject.formatLines("\t\t", mIBObject.descr));
            stringBuffer.append(string);
        }
        if (this.reference != null) {
            stringBuffer.append("\t");
            MIBObject.addKeyWord(n, stringBuffer, "REFERENCE");
            stringBuffer.append(string);
            MIBObject.addText(string, n, stringBuffer, MIBObject.formatLines("\t\t", this.reference), mIBObject == null ? null : mIBObject.reference);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static int minWhiteSpacePrefix(String string, boolean bl) {
        int n = Integer.MAX_VALUE;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        if (stringTokenizer.hasMoreTokens() && !bl) {
            stringTokenizer.nextToken();
        }
        block0: while (n > 0 && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < string2.length() && i < n; ++i) {
                if (Character.isWhitespace(string2.charAt(i))) continue;
                n = i;
                continue block0;
            }
        }
        return n;
    }

    public static String trimLines(String string) {
        string = MIBObject.getUnquotedString(string);
        int n = MIBObject.minWhiteSpacePrefix(string, false);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((string2 = MIBObject.addStringWithInternalLineSeparation(stringBuffer, string2, stringTokenizer)) == null) continue;
            if (!bl) {
                string2 = MIBObject.cutTrailingWhiteSpaces(string2);
            }
            if (bl) {
                stringBuffer.append(string2.trim());
                bl = false;
                continue;
            }
            if (string2.length() > n) {
                stringBuffer.append(string2.substring(n));
                continue;
            }
            stringBuffer.append(string2);
        }
        return MIBObject.getQuotedString(stringBuffer.toString());
    }

    protected static String cutTrailingWhiteSpaces(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(0, i + 1);
        }
        return "";
    }

    public static String formatLines(String string, String string2) {
        if (string2 == null) {
            return string + "\"\"";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("\n")) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string + string3);
        }
        return stringBuffer.toString();
    }

    public static String formatObjectRefs(int n, String string, Enumeration enumeration, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement().toString();
            stringBuffer.append(string);
            if ((n & 4) > 0) {
                stringBuffer.append("<a href=\"#" + string3 + "\">" + string3 + "</a>");
            } else {
                stringBuffer.append(string3);
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected String getSMIDefEnd(int n, MIBRepository mIBRepository, String string, String string2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasInlineComment()) {
            if (this.getType() == 10 && (n & 0x20) <= 0) {
                stringBuffer.append(string2);
            }
            MIBObject.addComment(n, stringBuffer, MIBObject.formatLines("\t", string.trim()), string2);
            stringBuffer.append(string2);
        }
        if ((n & 0x20) > 0) {
            object = "-- " + this.getPrintableOid();
            if ((n & 0x400) <= 0) {
                if (!this.hasInlineComment() || !string.trim().endsWith((String)object)) {
                    stringBuffer.append('\t');
                    MIBObject.addComment(n, stringBuffer, (String)object, string2);
                    stringBuffer.append(string2);
                    stringBuffer.append('\t');
                }
            } else if (!this.hasInlineComment() || !string.trim().endsWith((String)object) && !string.trim().endsWith((String)object + " --")) {
                object = (String)object + " --";
                MIBObject.addComment(n, stringBuffer, (String)object + " ", string2);
                stringBuffer.append(' ');
            }
        } else {
            stringBuffer.append("\t");
        }
        MIBObject.addKeyWord(n, stringBuffer, "::= ");
        object = mIBRepository.getParent(this);
        if (object == null) {
            stringBuffer.append(this.getOid().toSMI());
        } else if (this instanceof MIBModule && ((MIBObject)object).getModuleID() == this.getModuleID()) {
            while (object != null && ((MIBObject)object).getModuleID() == this.getModuleID()) {
                object = mIBRepository.getParent((MIBObject)object);
            }
            if (object == null) {
                stringBuffer.append(this.getOid().toSMI());
            } else {
                stringBuffer.append(this.genSMIOidDef(n, (MIBObject)object, mIBRepository));
            }
        } else {
            stringBuffer.append(this.genSMIOidDef(n, (MIBObject)object, mIBRepository));
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private String genSMIOidDef(int n, MIBObject mIBObject, MIBRepository mIBRepository) {
        MIBObject[] mIBObjectArray = mIBRepository.getObjectsByName(mIBObject.getName());
        if (mIBObjectArray == null || mIBObjectArray.length <= 1) {
            return this.getOid().toSMI(mIBRepository, n, mIBObject, null);
        }
        String string = mIBRepository.getModuleName(mIBObject.getModuleID());
        if (string == null) {
            return this.getOid().toSMI(mIBRepository, n, mIBObject, null);
        }
        return this.getOid().toSMI(mIBRepository, n, mIBObject, string);
    }

    public static void addString(int n, StringBuffer stringBuffer, String string, String string2) {
        if ((n & 2) > 0) {
            if (string2 != null && !string2.equals(string)) {
                stringBuffer.append("<u>");
            }
            stringBuffer.append(string);
            if (string2 != null && !string2.equals(string)) {
                stringBuffer.append("</u>");
            }
        } else {
            stringBuffer.append(string);
        }
    }

    public String getNavigationLink(int n, MIBRepository mIBRepository, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        MIBObject.addNavigationLinks(this, n, stringBuffer, mIBRepository, string);
        return stringBuffer.toString();
    }

    private static String needsFullQualification(MIBRepository mIBRepository, MIBObject mIBObject) {
        if (mIBRepository.getObjectsByName(mIBObject.getName()).length > 1) {
            return mIBRepository.getModuleName(mIBObject.getModuleID());
        }
        return null;
    }

    public static void addNavigationLinks(MIBObject mIBObject, int n, StringBuffer stringBuffer, MIBRepository mIBRepository, String string) {
        if ((n & 0x200) > 0) {
            Object object;
            Object object2;
            Object object3;
            StringBuffer stringBuffer2 = new StringBuffer();
            MIBObject mIBObject2 = mIBRepository.getParent(mIBObject);
            if (mIBObject2 != null) {
                stringBuffer2.append("-- ");
                stringBuffer2.append("Parent:   ");
                object3 = MIBObject.needsFullQualification(mIBRepository, mIBObject2);
                if (object3 != null) {
                    MIBObject.addObjectLink(n, stringBuffer2, (String)object3 + "." + mIBObject2.getName());
                } else {
                    MIBObject.addObjectLink(n, stringBuffer2, mIBObject2.getName());
                }
                stringBuffer2.append(string);
            }
            if ((object3 = mIBRepository.getPrevObject(mIBObject.getOid())) != null) {
                stringBuffer2.append("-- Previous: ");
                object2 = MIBObject.needsFullQualification(mIBRepository, (MIBObject)object3);
                if (object2 != null) {
                    MIBObject.addObjectLink(n, stringBuffer2, (String)object2 + "." + ((MIBObject)object3).getName());
                } else {
                    MIBObject.addObjectLink(n, stringBuffer2, ((MIBObject)object3).getName());
                }
                object = mIBRepository.getPrevSibblingObject(mIBObject.getOid());
                if (object != null && !((MIBObject)object).getName().equals(((MIBObject)object3).getName())) {
                    stringBuffer2.append(" - Sibbling: ");
                    object2 = MIBObject.needsFullQualification(mIBRepository, (MIBObject)object);
                    if (object2 != null) {
                        MIBObject.addObjectLink(n, stringBuffer2, (String)object2 + "." + ((MIBObject)object).getName());
                    } else {
                        MIBObject.addObjectLink(n, stringBuffer2, ((MIBObject)object).getName());
                    }
                }
                stringBuffer2.append(string);
            }
            if ((object2 = mIBRepository.getNextObject(mIBObject.getOid())) != null) {
                stringBuffer2.append("-- Next:     ");
                object = MIBObject.needsFullQualification(mIBRepository, (MIBObject)object2);
                if (object != null) {
                    MIBObject.addObjectLink(n, stringBuffer2, (String)object + "." + ((MIBObject)object2).getName());
                } else {
                    MIBObject.addObjectLink(n, stringBuffer2, ((MIBObject)object2).getName());
                }
                MIBObject mIBObject3 = mIBRepository.getNextSibblingObject(mIBObject.getOid());
                if (mIBObject3 != null && !mIBObject3.getName().equals(((MIBObject)object2).getName())) {
                    stringBuffer2.append(" - Sibbling: ");
                    object = MIBObject.needsFullQualification(mIBRepository, mIBObject3);
                    if (object != null) {
                        MIBObject.addObjectLink(n, stringBuffer2, (String)object + "." + mIBObject3.getName());
                    } else {
                        MIBObject.addObjectLink(n, stringBuffer2, mIBObject3.getName());
                    }
                }
                stringBuffer2.append(string);
            }
            stringBuffer.append(string);
            MIBObject.addComment(n, stringBuffer, stringBuffer2.toString(), string);
            stringBuffer.append(string);
        }
    }

    public String toSMI(int n, int n2, MIBRepository mIBRepository, String string) {
        MIBObject mIBObject = this.comparable(n);
        StringBuffer stringBuffer = new StringBuffer();
        MIBObject.addNavigationLinks(this, n, stringBuffer, mIBRepository, string);
        if (this.hasComment()) {
            MIBObject.addComment(n, stringBuffer, this.asn1Comment, string);
            stringBuffer.append(string);
        }
        MIBObject.addObjectRef(null, n, stringBuffer, this.name, mIBObject == null ? null : mIBObject.name);
        if (this.type == 0 && this.status != null) {
            MIBObject.addKeyWord(n, stringBuffer, " OBJECT-IDENTITY");
            stringBuffer.append(string);
            stringBuffer.append(this.getSMIDefBegin(n, string));
        } else {
            MIBObject.addKeyWord(n, stringBuffer, " OBJECT IDENTIFIER ");
            if ((n & 0x20) > 0) {
                stringBuffer.append(string);
            }
        }
        stringBuffer.append(this.getSMIDefEnd(n, mIBRepository, this.asn1CommentInline, string));
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getName();
    }

    public void setComment(String string) {
        this.asn1Comment = string;
    }

    public void setInlineComment(String string) {
        this.asn1CommentInline = string;
    }

    public String getComment() {
        return this.asn1Comment;
    }

    public String getInlineComment() {
        return this.asn1CommentInline;
    }

    public boolean hasComment() {
        return this.asn1Comment != null;
    }

    public boolean hasInlineComment() {
        return this.asn1CommentInline != null;
    }

    public int getReleased() {
        return this.released;
    }

    public boolean isReleased() {
        return this.released > 0;
    }

    public void setReleased(int n) {
        this.released = n;
    }

    public static String getUnquotedString(String string) {
        if (string == null || string.equals("\"\"")) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
        if (stringTokenizer.hasMoreTokens()) {
            return stringTokenizer.nextToken();
        }
        return string;
    }

    public static String getQuotedString(String string) {
        return MIBObject.getQuotedString(string, true);
    }

    private static String addStringWithInternalLineSeparation(StringBuffer stringBuffer, String string, StringTokenizer stringTokenizer) {
        int n = "\r\n".indexOf(string);
        if (n >= 0) {
            stringBuffer.append("\n");
            String string2 = null;
            for (int i = n; i < "\r\n".length() && stringTokenizer.hasMoreTokens(); ++i) {
                string = stringTokenizer.nextToken();
                n = "\r\n".indexOf(string);
                if (n > i) {
                    n = i;
                    string = null;
                    continue;
                }
                if (n < 0) {
                    string2 = string;
                    break;
                }
                if (n == i) {
                    stringBuffer.append("\n");
                    return null;
                }
                string = null;
            }
            return string;
        }
        return string;
    }

    public static String getQuotedString(String string, boolean bl) {
        if (string.length() == 0) {
            if (bl) {
                return null;
            }
            return "\"\"";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\"');
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((string2 = MIBObject.addStringWithInternalLineSeparation(stringBuffer, string2, stringTokenizer)) == null) continue;
            stringBuffer.append(string2.replace('\"', '\''));
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static void addText(String string, int n, StringBuffer stringBuffer, String string2) {
        MIBObject.addText(string, n, stringBuffer, string2, null);
    }

    public static void addText(String string, int n, StringBuffer stringBuffer, String string2, String string3) {
        if ((n & 2) > 0) {
            boolean bl = false;
            if (string3 != null && !string3.equals(string2)) {
                bl = true;
                stringBuffer.append("<u>");
            }
            int n2 = 0;
            stringBuffer.append("<I><font color=\"#666699\">");
            if (string2 != null) {
                stringBuffer.append(string2.substring(n2));
            }
            stringBuffer.append("</font></I>");
            if (bl) {
                stringBuffer.append("</u>");
            }
        } else {
            MIBObject.addLines(stringBuffer, string2, string);
        }
    }

    public static void addObjectRef(String string, int n, StringBuffer stringBuffer, String string2) {
        MIBObject.addObjectRef(string, n, stringBuffer, string2, null);
    }

    public static void addObjectRef(String string, int n, StringBuffer stringBuffer, String string2, String string3) {
        boolean bl = false;
        if (string3 != null && (n & 2) > 0 && !string2.equals(string3)) {
            bl = true;
            stringBuffer.append("<u>");
        }
        if ((n & 4) > 0) {
            if (string != null) {
                stringBuffer.append("<a name=\"" + string + "." + string2 + "\">" + string2 + "</a>");
            } else {
                stringBuffer.append("<a name=\"" + string2 + "\">" + string2 + "</a>");
            }
        } else {
            stringBuffer.append(string2);
        }
        if (bl) {
            stringBuffer.append("</u>");
        }
    }

    public static void addObjectLink(int n, StringBuffer stringBuffer, String string) {
        MIBObject.addObjectLink(n, stringBuffer, string, null);
    }

    public static void addObjectLink(int n, StringBuffer stringBuffer, String string, String string2) {
        boolean bl = false;
        if (string2 != null && (n & 2) > 0 && !string.equals(string2)) {
            bl = true;
            stringBuffer.append("<u>");
        }
        if ((n & 4) > 0) {
            stringBuffer.append("<a href=\"#" + string + "\">" + string + "</a>");
        } else {
            stringBuffer.append(string);
        }
        if (bl) {
            stringBuffer.append("</u>");
        }
    }

    private static void addLines(StringBuffer stringBuffer, String string, String string2) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("\n")) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string3);
        }
    }

    public static void addComment(int n, StringBuffer stringBuffer, String string, String string2) {
        if ((n & 2) > 0) {
            stringBuffer.append("<font color=\"#408080\">");
            stringBuffer.append(string);
            stringBuffer.append("</font>");
        } else {
            MIBObject.addLines(stringBuffer, string, string2);
        }
    }

    public static void addKeyWord(int n, StringBuffer stringBuffer, String string) {
        if ((n & 2) > 0) {
            stringBuffer.append("<strong>");
            stringBuffer.append(string);
            stringBuffer.append("</strong>");
        } else {
            stringBuffer.append(string);
        }
    }

    public static void addNum(int n, StringBuffer stringBuffer, String string) {
        MIBObject.addNum(n, stringBuffer, string, null);
    }

    public static void addNum(int n, StringBuffer stringBuffer, String string, String string2) {
        if ((n & 2) > 0) {
            if (string2 != null && !string.equals(string2)) {
                stringBuffer.append("<u>");
            }
            stringBuffer.append("<font color=\"#999999\">");
            stringBuffer.append(string);
            stringBuffer.append("</font>");
            if (string2 != null && !string.equals(string2)) {
                stringBuffer.append("</u>");
            }
        } else {
            stringBuffer.append(string);
        }
    }

    public static void addNum(int n, StringBuffer stringBuffer, long l) {
        MIBObject.addNum(n, stringBuffer, "" + l);
    }

    public static int getMaxLength(Enumeration enumeration) {
        int n = 0;
        while (enumeration.hasMoreElements()) {
            int n2 = enumeration.nextElement().toString().length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static String getFlatString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, MIBObject.getLineSeparator() + "\t", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (MIBObject.getLineSeparator().indexOf(string2) >= 0) {
                stringBuffer.append(" ");
                continue;
            }
            if (string2.equals("\t")) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String space(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    public static void beginDiff(int n, StringBuffer stringBuffer) {
        stringBuffer.append("<strike>");
    }

    public static void endDiff(int n, StringBuffer stringBuffer) {
        stringBuffer.append("</strike>");
    }

    protected MIBObject comparable(int n) {
        if ((n & 2) > 0 && this.userObject != null && this.userObject instanceof CompareResult && ((CompareResult)this.userObject).other != null && ((CompareResult)this.userObject).other.getClass().equals(this.getClass())) {
            return ((CompareResult)this.userObject).other;
        }
        return null;
    }

    public boolean isStructural() {
        return this.getType() != 0;
    }

    public static String makeASN1Comment(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("\n") && !string2.trim().startsWith("--")) {
                stringBuffer.append("--");
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof MIBObject) {
            MIBObject mIBObject = (MIBObject)object;
            return MIBObject.saveCompare(this.moduleID, mIBObject.moduleID) && MIBObject.saveCompare(this.oid, mIBObject.oid) && MIBObject.saveCompare(this.name, mIBObject.name) && MIBObject.saveCompare(this.status, mIBObject.status) && MIBObject.saveCompare(this.descr, mIBObject.descr) && MIBObject.saveCompare(this.reference, mIBObject.reference);
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    protected static final boolean saveCompare(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    public int getID() {
        return this.id;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.id = MIBObject.nextID();
        this.status = SMI.getCommonIdentifier(this.status);
    }

    public void freeUserObjects() {
        this.userObject = null;
    }
}

