/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smi.ext.SMINotificationType;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MIBNotifyType
extends MIBObject
implements Serializable,
SMINotificationType {
    public static final long serialVersionUID = 1000L;
    protected String enterprise;
    protected Vector variables = null;
    public static final int ID = 3;
    protected int trapType = 3;

    public MIBNotifyType() {
        this(3);
    }

    public MIBNotifyType(int n) {
        this.trapType = n == 2 ? 2 : 3;
        this.enterprise = null;
    }

    public MIBNotifyType(ObjectID objectID, String string, Integer n, int n2) {
        super(objectID, string, n);
        this.trapType = n2 == 2 ? 2 : 3;
    }

    public MIBNotifyType(MIBNotifyType mIBNotifyType) {
        super(mIBNotifyType);
        this.enterprise = mIBNotifyType.enterprise;
        if (mIBNotifyType.hasVariables()) {
            Enumeration enumeration = mIBNotifyType.variables.elements();
            while (enumeration.hasMoreElements()) {
                this.addVariable((String)enumeration.nextElement());
            }
        }
        this.trapType = mIBNotifyType.trapType;
    }

    public MIBObject getClone() {
        return new MIBNotifyType(this);
    }

    public final String getTypeString() {
        return SMI.ENTRY_TYPES[this.trapType];
    }

    public final int getType() {
        return this.trapType;
    }

    public final boolean isV1Trap() {
        return this.trapType == 2;
    }

    public final int getTrapType() {
        return this.trapType;
    }

    public final void setTrapType(int n) {
        this.trapType = n;
    }

    public boolean hasVariables() {
        return this.variables != null && this.variables.size() > 0;
    }

    public void setVariables(String[] stringArray) {
        this.variables = MIBRepository.buildVector(stringArray);
    }

    public void addVariable(String string) {
        if (this.variables == null) {
            this.variables = new Vector(5);
        }
        this.variables.addElement(string);
    }

    public String[] getVariables() {
        if (this.variables == null) {
            return null;
        }
        Object[] objectArray = new String[this.variables.size()];
        this.variables.copyInto(objectArray);
        return objectArray;
    }

    public final void setVariablesVector(Vector vector) {
        this.variables = vector;
    }

    public final Vector getVariablesVector() {
        return this.variables;
    }

    public final String getEnterprise() {
        return this.enterprise;
    }

    public final void setEnterprise(String string) {
        this.enterprise = string;
    }

    public String getVariableList() {
        if (!this.hasVariables()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String toSMI(int n, int n2, MIBRepository mIBRepository, String string) {
        MIBNotifyType mIBNotifyType = (MIBNotifyType)this.comparable(n);
        StringBuffer stringBuffer = new StringBuffer(string);
        MIBNotifyType.addNavigationLinks(this, n, stringBuffer, mIBRepository, string);
        if (this.hasComment()) {
            MIBNotifyType.addComment(n, stringBuffer, this.asn1Comment, string);
            stringBuffer.append(string);
        }
        MIBNotifyType.addObjectRef(null, n, stringBuffer, this.name, mIBNotifyType == null ? null : mIBNotifyType.name);
        if (this.isV1Trap() && n != 8 || n == 16) {
            String string2;
            MIBNotifyType.addKeyWord(n, stringBuffer, " TRAP-TYPE");
            stringBuffer.append(string + "\t");
            MIBNotifyType.addKeyWord(n, stringBuffer, "ENTERPRISE ");
            MIBObject.addString(n, stringBuffer, this.enterprise, mIBNotifyType == null ? null : mIBNotifyType.enterprise);
            stringBuffer.append(string);
            if (this.hasVariables()) {
                stringBuffer.append('\t');
                MIBNotifyType.addKeyWord(n, stringBuffer, "VARIABLES");
                stringBuffer.append(" {" + string);
                string2 = null;
                if (mIBNotifyType != null) {
                    string2 = mIBNotifyType.hasVariables() ? MIBObject.formatObjectRefs(n, "\t\t", mIBNotifyType.getVariablesVector().elements(), string) : "";
                }
                MIBObject.addString(n, stringBuffer, MIBObject.formatObjectRefs(n, "\t\t", this.getVariablesVector().elements(), string), string2);
                stringBuffer.append("}");
                stringBuffer.append(string);
            }
            if (this.descr != null) {
                stringBuffer.append('\t');
                MIBNotifyType.addKeyWord(n, stringBuffer, "DESCRIPTION ");
                stringBuffer.append(string);
                string2 = null;
                if (mIBNotifyType != null) {
                    string2 = mIBNotifyType.descr != null ? MIBObject.formatLines("\t\t", mIBNotifyType.descr) : "";
                }
                MIBNotifyType.addText(string, n, stringBuffer, MIBObject.formatLines("\t\t", this.descr), string2);
                stringBuffer.append(string);
            }
        } else {
            MIBNotifyType.addKeyWord(n, stringBuffer, " NOTIFICATION-TYPE");
            stringBuffer.append(string);
            if (this.hasVariables()) {
                stringBuffer.append('\t');
                MIBNotifyType.addKeyWord(n, stringBuffer, "OBJECTS");
                stringBuffer.append(" {");
                stringBuffer.append(string);
                String string3 = null;
                if (mIBNotifyType != null) {
                    string3 = mIBNotifyType.hasVariables() ? MIBObject.formatObjectRefs(n, "\t\t", mIBNotifyType.getVariablesVector().elements(), string) : "";
                }
                MIBObject.addString(n, stringBuffer, MIBObject.formatObjectRefs(n, "\t\t", this.getVariablesVector().elements(), string), string3);
                stringBuffer.append("}");
                stringBuffer.append(string);
            }
            stringBuffer.append(this.getSMIDefBegin(n, string));
        }
        if (this.isV1Trap() && n != 8 || n == 16) {
            try {
                stringBuffer.append(" ::= ");
                stringBuffer.append(this.oid.getLastSubID());
                stringBuffer.append(string);
            }
            catch (ObjectIDFormatException objectIDFormatException) {}
        } else {
            stringBuffer.append(this.getSMIDefEnd(n, mIBRepository, this.asn1CommentInline, string));
        }
        return stringBuffer.toString();
    }

    public boolean isStructural() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof MIBNotifyType && super.equals(object)) {
            MIBNotifyType mIBNotifyType = (MIBNotifyType)object;
            return MIBNotifyType.saveCompare(this.variables, mIBNotifyType.variables) && MIBNotifyType.saveCompare(this.enterprise, mIBNotifyType.enterprise) && this.trapType == mIBNotifyType.trapType;
        }
        return false;
    }
}

