/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.smi.IImport;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRevision;
import com.agentpp.smi.ext.SMIModule;
import com.agentpp.smiparser.SMI;
import com.agentpp.util.EnumerationIterator;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.Pair;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;

public class MIBModule
extends MIBObject
implements Serializable,
SMIModule {
    public static final long serialVersionUID = 1000L;
    protected String pathName = null;
    protected String moduleName;
    protected Vector revisions = null;
    protected Vector imports = null;
    protected String organization;
    protected String lastUpdated;
    protected String contactInfo;
    protected Date lastChange = null;
    protected int smiVersion = 1;
    protected String copyrightComment;
    protected String copyrightCommentEnd;
    protected transient Map objects = null;
    protected int parseMode = 0;
    protected transient int startPosition = 0;
    private static final String[] STANDARD_MIBS = new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-CONF", "RFC1155-SMI", "RFC1215"};

    public MIBModule() {
        this.objects = new Hashtable();
    }

    public MIBModule(String string, Integer n) {
        this.objects = new Hashtable();
        this.moduleName = string;
        this.moduleID = n;
    }

    public MIBModule(ObjectID objectID, String string) {
        super(objectID, string);
        this.objects = new Hashtable();
    }

    public MIBModule(IModule iModule) {
        super(iModule);
        Object object;
        this.moduleName = iModule.getModuleName();
        this.revisions = new Vector<IRevision>(Arrays.asList(iModule.getRevisions()));
        if (iModule.hasImports()) {
            object = iModule.getImports();
            for (int i = 0; i < ((IImport[])object).length; ++i) {
                this.addImport(new MIBImport(object[i].getSource(), new Vector<String>(Arrays.asList(object[i].getImports())), object[i].getComment()));
            }
        }
        this.organization = iModule.getOrganization();
        this.lastChange = new Date();
        this.lastUpdated = iModule.getLastUpdated();
        this.contactInfo = iModule.getContactInfo();
        this.smiVersion = iModule.getSMIVersion();
        this.moduleID = iModule.getModuleID();
        this.copyrightComment = iModule.getCopyrightComment();
        this.copyrightCommentEnd = iModule.getCopyrightCommentEnd();
        this.objects = new Hashtable();
        object = iModule.objects();
        while (object.hasMoreElements()) {
            IObject iObject = (IObject)object.nextElement();
            this.objects.put(iObject.getName(), iObject);
        }
        if (this.objects.containsKey(iModule.getName())) {
            this.objects.remove(iModule.getName());
            this.add(this);
        }
    }

    public MIBModule(MIBModule mIBModule) {
        super(mIBModule);
        this.pathName = mIBModule.pathName;
        this.moduleName = mIBModule.moduleName;
        this.revisions = mIBModule.revisions;
        if (mIBModule.hasImports()) {
            Enumeration enumeration = mIBModule.imports.elements();
            while (enumeration.hasMoreElements()) {
                this.addImport(new MIBImport((MIBImport)enumeration.nextElement()));
            }
        }
        this.organization = mIBModule.organization;
        this.lastChange = new Date(mIBModule.lastChange.getTime());
        this.lastUpdated = mIBModule.lastUpdated;
        this.contactInfo = mIBModule.contactInfo;
        this.smiVersion = mIBModule.smiVersion;
        this.moduleID = mIBModule.moduleID;
        this.copyrightComment = mIBModule.copyrightComment;
        this.copyrightCommentEnd = mIBModule.copyrightCommentEnd;
        this.objects = new HashMap(mIBModule.objects);
        if (this.objects.containsKey(mIBModule.getName())) {
            this.objects.remove(mIBModule.getName());
            this.add(this);
        }
    }

    public MIBObject getClone() {
        return new MIBModule(this);
    }

    public int compareTo(Object object) {
        MIBObject mIBObject = (MIBObject)object;
        if (mIBObject instanceof MIBModule) {
            return this.getModuleName().compareTo(((MIBModule)mIBObject).getModuleName());
        }
        return super.compareTo(object);
    }

    public int size() {
        return this.objects.size();
    }

    public String getTypeString() {
        return SMI.ENTRY_TYPES[5];
    }

    public void reinit() {
        this.objects = new Hashtable();
    }

    public void add(MIBObject mIBObject) {
        this.objects.put(mIBObject.getName(), mIBObject);
    }

    public boolean remove(MIBObject mIBObject) {
        return this.objects.remove(mIBObject.getName()) != null;
    }

    public MIBObject get(ObjectID objectID) {
        for (MIBObject mIBObject : this.objects.values()) {
            if (!mIBObject.getOid().equals(objectID)) continue;
            return mIBObject;
        }
        return null;
    }

    public IObject getObject(String string) {
        return this.getObjectByName(string);
    }

    public IObject getObjectByOID(String string) {
        return this.get(new ObjectID(string));
    }

    public MIBObject getObjectByName(String string) {
        return (MIBObject)this.objects.get(string);
    }

    public int hashCode() {
        return this.moduleID.hashCode();
    }

    public Enumeration objects() {
        return new EnumerationIterator(this.objects.values().iterator());
    }

    public Iterator objectsIterator() {
        return this.objects.values().iterator();
    }

    public OrderedMap objectsByOid() {
        return this.objectsByOid(false);
    }

    public OrderedMap objectsByOid(boolean bl) {
        Iterator iterator = this.objects.values().iterator();
        OrderedMap orderedMap = new OrderedMap(ObjectIDPredicate.instance, bl);
        while (iterator.hasNext()) {
            MIBObject mIBObject = (MIBObject)iterator.next();
            if (mIBObject.getOid().isEmpty()) continue;
            orderedMap.put(mIBObject.getOid(), mIBObject);
        }
        return orderedMap;
    }

    public OrderedMap objectsByName() {
        Iterator iterator = this.objects.values().iterator();
        OrderedMap orderedMap = new OrderedMap(new LexicographicPredicate());
        while (iterator.hasNext()) {
            MIBObject mIBObject = (MIBObject)iterator.next();
            orderedMap.put(mIBObject.getName(), mIBObject);
        }
        return orderedMap;
    }

    public Vector getObjectsVector() {
        Vector vector = new Vector(this.objects.size());
        vector.addAll(this.objects.values());
        return vector;
    }

    public MIBObject[] getObjects() {
        Vector vector = this.getObjectsVector();
        Object[] objectArray = new MIBObject[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setObjectsVector(Vector vector) {
        this.objects = new Hashtable(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            this.add(mIBObject);
        }
    }

    public void setModuleName(String string) {
        this.moduleName = string;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setFileName(String string) {
        this.pathName = string;
    }

    public String getFileName() {
        return this.pathName;
    }

    public void addImport(MIBImport mIBImport) {
        if (this.imports == null) {
            this.imports = new Vector(5);
        }
        this.imports.addElement(mIBImport);
    }

    public IImport[] getImports() {
        if (this.imports == null) {
            return null;
        }
        Object[] objectArray = new MIBImport[this.imports.size()];
        this.imports.copyInto(objectArray);
        return objectArray;
    }

    public boolean imports(String string) {
        if (!this.hasImports()) {
            return false;
        }
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = (MIBImport)enumeration.nextElement();
            if (!mIBImport.imports(string)) continue;
            return true;
        }
        return false;
    }

    public boolean imports(String string, String string2) {
        if (!this.hasImports()) {
            return false;
        }
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = (MIBImport)enumeration.nextElement();
            if (!mIBImport.imports(string) || !mIBImport.getSource().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public String[] getImportSources() {
        if (this.imports == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.imports.size()];
        int n = 0;
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = ((MIBImport)enumeration.nextElement()).getSource();
            ++n;
        }
        return stringArray;
    }

    public boolean importsFrom(String string) {
        if (this.imports == null) {
            return false;
        }
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equals(((MIBImport)enumeration.nextElement()).getSource())) continue;
            return true;
        }
        return false;
    }

    public void setImports(MIBImport[] mIBImportArray) {
        this.imports = MIBRepository.buildVector(mIBImportArray);
    }

    public void setImportsVector(Vector vector) {
        this.imports = vector;
    }

    public Vector getImportsVector() {
        return this.imports;
    }

    public boolean hasImports() {
        return this.imports != null && this.imports.size() > 0;
    }

    public String toString() {
        return this.moduleName;
    }

    public boolean isUsedSyntax(MIBTextualConvention mIBTextualConvention) {
        for (MIBObject mIBObject : this.objects.values()) {
            MIBObject mIBObject2;
            if (!(mIBObject instanceof MIBObjectType ? ((MIBObjectType)(mIBObject2 = (MIBObjectType)mIBObject)).getSyntax().getSyntax().equals(mIBTextualConvention.getName()) : mIBObject instanceof MIBTextualConvention && ((MIBTextualConvention)(mIBObject2 = (MIBTextualConvention)mIBObject)).getSyntax().getSyntax().equals(mIBTextualConvention.getName()))) continue;
            return true;
        }
        return false;
    }

    public boolean isUsedSyntax(String string) {
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject;
            MIBObject mIBObject2 = (MIBObject)enumeration.nextElement();
            if (mIBObject2.getTypeString().equals(string) || mIBObject2 instanceof MIBObjectType && ((MIBObjectType)mIBObject2).getSyntax().getSyntax().equals(string) || mIBObject2 instanceof MIBTextualConvention && ((MIBTextualConvention)mIBObject2).getSyntax().getSyntax().equals(string)) {
                return true;
            }
            if (!(mIBObject2 instanceof MIBObjectType ? ((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject2)).getSyntax().getSyntax().equals(string) : mIBObject2 instanceof MIBTextualConvention && ((MIBTextualConvention)(mIBObject = (MIBTextualConvention)mIBObject2)).getSyntax().getSyntax().equals(string))) continue;
            return true;
        }
        return false;
    }

    public String toSMI(int n, int n2, MIBRepository mIBRepository, String string) {
        MIBModule mIBModule = (MIBModule)this.comparable(n);
        StringBuffer stringBuffer = new StringBuffer();
        MIBModule.addNavigationLinks(this, n, stringBuffer, mIBRepository, string);
        if (this.hasComment()) {
            MIBModule.addComment(n, stringBuffer, this.asn1Comment, string);
            stringBuffer.append(string);
        }
        if (this.smiVersion > 1 && this.oid.size() > 0 || n == 8) {
            Enumeration enumeration;
            MIBModule.addObjectRef(null, n, stringBuffer, this.name, mIBModule == null ? null : mIBModule.name);
            MIBModule.addKeyWord(n, stringBuffer, " MODULE-IDENTITY");
            stringBuffer.append(string);
            stringBuffer.append("\t");
            MIBModule.addKeyWord(n, stringBuffer, "LAST-UPDATED ");
            if (n == 8) {
                MIBModule.addText(string, n, stringBuffer, "\"\"");
            } else {
                MIBModule.addText(string, n, stringBuffer, this.lastUpdated, mIBModule == null ? null : mIBModule.lastUpdated);
                if ((n & 0x20) > 0 && (enumeration = MIBModule.getTimeFromUTC(MIBModule.getUnquotedString(this.lastUpdated))) != null) {
                    stringBuffer.append("\t");
                    MIBModule.addComment(n, stringBuffer, "-- " + (String)((Object)enumeration), string);
                }
            }
            stringBuffer.append(string);
            stringBuffer.append("\t");
            MIBModule.addKeyWord(n, stringBuffer, "ORGANIZATION ");
            if (n == 8) {
                MIBModule.addText(string, n, stringBuffer, "\"\"");
            } else {
                MIBModule.addText(string, n, stringBuffer, this.organization, mIBModule == null ? null : mIBModule.organization);
            }
            stringBuffer.append(string);
            stringBuffer.append("\t");
            MIBModule.addKeyWord(n, stringBuffer, "CONTACT-INFO");
            stringBuffer.append(string);
            if (n == 8) {
                stringBuffer.append("\t\t");
                MIBModule.addText(string, n, stringBuffer, "\"\"");
            } else {
                MIBModule.addText(string, n, stringBuffer, MIBModule.formatLines("\t\t", this.contactInfo), mIBModule == null ? null : MIBModule.formatLines("\t\t", mIBModule.contactInfo));
            }
            stringBuffer.append(string);
            stringBuffer.append("\t");
            MIBModule.addKeyWord(n, stringBuffer, "DESCRIPTION");
            stringBuffer.append(string);
            if (n == 8) {
                stringBuffer.append("\t\t");
                MIBModule.addText(string, n, stringBuffer, "\"\"");
            } else {
                MIBModule.addText(string, n, stringBuffer, MIBModule.formatLines("\t\t", this.descr), mIBModule == null ? null : MIBModule.formatLines("\t\t", mIBModule.descr));
            }
            stringBuffer.append(string);
            if (this.hasRevisions()) {
                enumeration = null;
                if (mIBModule != null) {
                    enumeration = mIBModule.hasRevisions() ? mIBModule.revisions.elements() : new Vector().elements();
                }
                Enumeration enumeration2 = this.revisions.elements();
                while (enumeration2.hasMoreElements()) {
                    MIBRevision mIBRevision = null;
                    if (enumeration != null) {
                        mIBRevision = enumeration.hasMoreElements() ? (MIBRevision)enumeration.nextElement() : new MIBRevision("", "");
                    }
                    stringBuffer.append(((MIBRevision)enumeration2.nextElement()).toSMI(n, mIBRevision, string));
                }
            }
            stringBuffer.append(this.getSMIDefEnd(n, mIBRepository, this.asn1CommentInline, string));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public Pair toSMI(int n, MIBRepository mIBRepository, int n2, String string) {
        Serializable serializable;
        Enumeration enumeration;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(65535);
        if (this.hasCopyrightComment()) {
            MIBModule.addComment(n, stringBuffer, this.copyrightComment, string);
            stringBuffer.append(string);
        }
        stringBuffer.append(this.getModuleName());
        if (stringBuffer.length() >= n2) {
            return new Pair(this, new Integer(0));
        }
        MIBModule.addKeyWord(n, stringBuffer, " DEFINITIONS ::= BEGIN");
        stringBuffer.append(string);
        stringBuffer.append(string);
        if (stringBuffer.length() >= n2) {
            return new Pair(this, new Integer(0));
        }
        if (this.hasImports()) {
            MIBModule.addKeyWord(n, stringBuffer, "IMPORTS");
            enumeration = this.imports.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(string);
                serializable = (MIBImport)enumeration.nextElement();
                stringBuffer.append(((MIBImport)serializable).toSMI(mIBRepository, n, string));
                if (enumeration.hasMoreElements() || !((MIBImport)serializable).hasComment()) continue;
                stringBuffer.append(string);
            }
            stringBuffer.append(";");
            stringBuffer.append(string);
            stringBuffer.append(string);
        }
        n3 = stringBuffer.length();
        stringBuffer.append(this.toSMI(n, this.smiVersion, mIBRepository, string));
        if (stringBuffer.length() >= n2) {
            return new Pair(this, new Integer(n3));
        }
        enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            serializable = (MIBObject)enumeration.nextElement();
            if (!(serializable instanceof MIBTextualConvention)) continue;
            stringBuffer.append(string);
            n3 = stringBuffer.length();
            stringBuffer.append(((MIBObject)serializable).toSMI(n, this.smiVersion, mIBRepository, string));
            if (stringBuffer.length() < n2) continue;
            return new Pair(serializable, new Integer(n3));
        }
        enumeration = this.objectsByOid().elements();
        while (enumeration.hasMoreElements()) {
            serializable = (MIBObject)enumeration.nextElement();
            if (!(serializable instanceof MIBModule) && !(serializable instanceof MIBTextualConvention)) {
                stringBuffer.append(string);
                n3 = stringBuffer.length();
                stringBuffer.append(((MIBObject)serializable).toSMI(n, this.smiVersion, mIBRepository, string));
                if (stringBuffer.length() < n2) continue;
                return new Pair(serializable, new Integer(n3));
            }
            if (!(serializable instanceof MIBModule) || this.smiVersion != 1 || !((MIBObject)serializable).getOid().isValid()) continue;
            stringBuffer.append(string);
            n3 = stringBuffer.length();
            stringBuffer.append(super.toSMI(n, this.smiVersion, mIBRepository, string));
            if (stringBuffer.length() < n2) continue;
            return new Pair(this, new Integer(n3));
        }
        stringBuffer.append(string);
        MIBModule.addKeyWord(n, stringBuffer, "END");
        stringBuffer.append(string);
        return null;
    }

    public Collection objectsOrderedByOccurance() {
        TreeMap<MIBObject, MIBObject> treeMap = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(128));
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            treeMap.put(mIBObject, mIBObject);
        }
        return treeMap.values();
    }

    private void objectsToSMI(int n, StringBuffer stringBuffer, MIBRepository mIBRepository, String string) {
        TreeMap<MIBObject, MIBObject> treeMap = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(n));
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            treeMap.put(mIBObject, mIBObject);
        }
        for (MIBObject mIBObject : treeMap.values()) {
            if (!(mIBObject instanceof MIBModule)) {
                stringBuffer.append(string);
                stringBuffer.append(mIBObject.toSMI(n, this.smiVersion, mIBRepository, string));
                if (mIBObject instanceof MIBTextualConvention || mIBObject == null) continue;
                MIBObject[] mIBObjectArray = mIBRepository.getObjectsByOid(mIBObject.getOid());
                for (int i = 0; i < mIBObjectArray.length; ++i) {
                    if (mIBObject == mIBObjectArray[i] || !mIBObject.getModuleID().equals(mIBObjectArray[i].getModuleID())) continue;
                    stringBuffer.append(string);
                    stringBuffer.append(mIBObjectArray[i].toSMI(n, this.smiVersion, mIBRepository, string));
                }
                continue;
            }
            if (!(mIBObject instanceof MIBModule) || this.smiVersion != 1 || !mIBObject.getOid().isValid()) continue;
            stringBuffer.append(string);
            stringBuffer.append(super.toSMI(n, this.smiVersion, mIBRepository, string));
        }
    }

    public String toSMI(int n, MIBRepository mIBRepository, String string) {
        return this.toSMI(n, mIBRepository, string, "Object Definitions");
    }

    public String toSMI(int n, MIBRepository mIBRepository, String string, String string2) {
        Serializable serializable;
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer(65535);
        if (this.hasCopyrightComment()) {
            MIBModule.addComment(n, stringBuffer, this.copyrightComment, string);
            stringBuffer.append(string);
        }
        stringBuffer.append(this.getModuleName());
        MIBModule.addKeyWord(n, stringBuffer, " DEFINITIONS ::= BEGIN");
        stringBuffer.append(string);
        stringBuffer.append(string);
        if (this.hasImports()) {
            MIBModule.addKeyWord(n, stringBuffer, "IMPORTS");
            enumeration = this.imports.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(string);
                serializable = (MIBImport)enumeration.nextElement();
                stringBuffer.append(((MIBImport)serializable).toSMI(mIBRepository, n, string));
                if (enumeration.hasMoreElements() || !((MIBImport)serializable).hasComment()) continue;
                stringBuffer.append(string);
            }
            stringBuffer.append(";");
            stringBuffer.append(string);
            stringBuffer.append(string);
        }
        stringBuffer.append(this.toSMI(n, this.smiVersion, mIBRepository, string));
        if ((n & 0x40) == 0) {
            if ((n & 0x180) > 0) {
                this.objectsToSMI(n, stringBuffer, mIBRepository, string);
            } else {
                enumeration = this.objects();
                while (enumeration.hasMoreElements()) {
                    serializable = (MIBObject)enumeration.nextElement();
                    if (!(serializable instanceof MIBTextualConvention)) continue;
                    stringBuffer.append(string);
                    stringBuffer.append(((MIBObject)serializable).toSMI(n, this.smiVersion, mIBRepository, string));
                }
                enumeration = this.objectsByOid().elements();
                while (enumeration.hasMoreElements()) {
                    serializable = (MIBObject)enumeration.nextElement();
                    if (!(serializable instanceof MIBModule) && !(serializable instanceof MIBTextualConvention)) {
                        stringBuffer.append(string);
                        stringBuffer.append(((MIBObject)serializable).toSMI(n, this.smiVersion, mIBRepository, string));
                        MIBObject[] mIBObjectArray = mIBRepository.getObjectsByOid(((MIBObject)serializable).getOid());
                        for (int i = 0; i < mIBObjectArray.length; ++i) {
                            if (serializable == mIBObjectArray[i] || !((MIBObject)serializable).getModuleID().equals(mIBObjectArray[i].getModuleID())) continue;
                            stringBuffer.append(string);
                            stringBuffer.append(mIBObjectArray[i].toSMI(n, this.smiVersion, mIBRepository, string));
                        }
                        continue;
                    }
                    if (!(serializable instanceof MIBModule) || this.smiVersion != 1 || !((MIBObject)serializable).getOid().isValid()) continue;
                    stringBuffer.append(string);
                    stringBuffer.append(super.toSMI(n, this.smiVersion, mIBRepository, string));
                }
            }
        } else {
            MIBModule.addComment(n, stringBuffer, "-- " + string + "-- " + string2 + string + "-- " + string, string);
        }
        stringBuffer.append(string);
        MIBModule.addKeyWord(n, stringBuffer, "END");
        stringBuffer.append(string);
        if (this.hasCopyrightCommentEnd()) {
            MIBModule.addComment(n, stringBuffer, this.copyrightCommentEnd, string);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setOrganization(String string) {
        this.organization = string;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setLastUpdated(String string) {
        this.lastUpdated = string;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public void setContactInfo(String string) {
        this.contactInfo = string;
    }

    public String getContactInfo() {
        return this.contactInfo;
    }

    public void setSMIVersion(int n) {
        this.smiVersion = n;
    }

    public int getSMIVersion() {
        return this.smiVersion;
    }

    public void addRevision(MIBRevision mIBRevision) {
        if (this.revisions == null) {
            this.revisions = new Vector(2);
        }
        this.revisions.addElement(mIBRevision);
    }

    public void setRevisions(MIBRevision[] mIBRevisionArray) {
        this.revisions = MIBRepository.buildVector(mIBRevisionArray);
    }

    public boolean hasCopyrightComment() {
        return this.copyrightComment != null && this.copyrightComment.length() > 0;
    }

    public void setCopyrightComment(String string) {
        this.copyrightComment = string;
    }

    public String getCopyrightCommentEnd() {
        return this.copyrightCommentEnd;
    }

    public boolean hasCopyrightCommentEnd() {
        return this.copyrightCommentEnd != null && this.copyrightCommentEnd.length() > 0;
    }

    public void setCopyrightCommentEnd(String string) {
        this.copyrightCommentEnd = string;
    }

    public String getCopyrightComment() {
        return this.copyrightComment;
    }

    public IRevision[] getRevisions() {
        if (this.revisions == null) {
            return null;
        }
        Object[] objectArray = new MIBRevision[this.revisions.size()];
        this.revisions.copyInto(objectArray);
        return objectArray;
    }

    public void setRevisionsVector(Vector vector) {
        this.revisions = vector;
    }

    public Vector getRevisionsVector() {
        return this.revisions;
    }

    public boolean hasRevisions() {
        return this.revisions != null && this.revisions.size() > 0;
    }

    public Date getLastChange() {
        return this.lastChange;
    }

    public int getParseMode() {
        return this.parseMode;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setLastChange(Date date) {
        this.lastChange = date;
    }

    public void setParseMode(int n) {
        this.parseMode = n;
    }

    public void setStartPosition(int n) {
        this.startPosition = n;
    }

    public boolean isInitialized() {
        return this.objects != null;
    }

    public Vector getTextualConventions() {
        Vector<MIBObject> vector = new Vector<MIBObject>(this.objects.size() / 50, 10);
        for (MIBObject mIBObject : this.objects.values()) {
            if (!(mIBObject instanceof MIBTextualConvention)) continue;
            vector.add(mIBObject);
        }
        return vector;
    }

    public boolean isValid() {
        boolean bl;
        boolean bl2 = bl = this.smiVersion == 1;
        if (bl) {
            return true;
        }
        if (this.getOid() == null || this.getOid().size() == 0) {
            return false;
        }
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (!(mIBObject instanceof MIBModule) || !mIBObject.equals(this)) continue;
            bl = true;
        }
        return bl;
    }

    public String getImportSource(String string) {
        if (!this.hasImports()) {
            return null;
        }
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = (MIBImport)enumeration.nextElement();
            if (!mIBImport.imports(string)) continue;
            return mIBImport.getSource();
        }
        return null;
    }

    public Vector getImportSources(String string) {
        if (!this.hasImports()) {
            return new Vector(1);
        }
        Vector<String> vector = new Vector<String>(2);
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = (MIBImport)enumeration.nextElement();
            if (!mIBImport.imports(string)) continue;
            vector.add(mIBImport.getSource());
        }
        return vector;
    }

    public MIBImport getImports(String string) {
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = (MIBImport)enumeration.nextElement();
            if (!mIBImport.getSource().equals(string)) continue;
            return mIBImport;
        }
        return null;
    }

    public void releaseChangedObjects(int n) {
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (mIBObject.isReleased()) continue;
            mIBObject.setReleased(n);
        }
    }

    public void unreleaseObjects(int n) {
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if (mIBObject.getReleased() < n) continue;
            mIBObject.setReleased(0);
        }
    }

    public static Date getDateFromUTC(String string) {
        int n = 0;
        if (string.length() == 11 || string.length() == 13) {
            int n2 = 2;
            if (string.length() == 13) {
                n2 = 4;
            } else {
                n = 1900;
            }
            int n3 = Integer.parseInt(string.substring(n2, n2 + 2)) - 1;
            int n4 = Integer.parseInt(string.substring(n2 + 2, n2 + 4));
            int n5 = Integer.parseInt(string.substring(n2 + 4, n2 + 6));
            int n6 = Integer.parseInt(string.substring(n2 + 6, n2 + 8));
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n += Integer.parseInt(string.substring(0, n2)), n3, n4, n5, n6);
            return gregorianCalendar.getTime();
        }
        return null;
    }

    public static String getTimeFromUTC(String string) {
        Date date = MIBModule.getDateFromUTC(string);
        if (date != null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
            return dateFormat.format(date);
        }
        return null;
    }

    public void changeObjectReferences(String string, String string2) {
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            Object object;
            int n;
            Object object2;
            MIBObject mIBObject;
            MIBObject mIBObject2 = (MIBObject)enumeration.nextElement();
            if (mIBObject2 instanceof MIBGroup) {
                mIBObject = (MIBGroup)mIBObject2;
                for (int i = 0; i < ((MIBGroup)mIBObject).getObjectsVector().size(); ++i) {
                    object2 = (String)((MIBGroup)mIBObject).getObjectsVector().elementAt(i);
                    if (!((String)object2).equals(string)) continue;
                    ((MIBGroup)mIBObject).getObjectsVector().setElementAt(string2, i);
                }
                continue;
            }
            if (mIBObject2 instanceof MIBNotifyType) {
                mIBObject = (MIBNotifyType)mIBObject2;
                if (!((MIBNotifyType)mIBObject).hasVariables()) continue;
                for (int i = 0; i < ((MIBNotifyType)mIBObject).getVariablesVector().size(); ++i) {
                    object2 = (String)((MIBNotifyType)mIBObject).getVariablesVector().get(i);
                    if (!((String)object2).equals(string)) continue;
                    ((MIBNotifyType)mIBObject).getVariablesVector().setElementAt(string2, i);
                }
                continue;
            }
            if (mIBObject2 instanceof MIBObjectType) {
                mIBObject = (MIBObjectType)mIBObject2;
                if (((MIBObjectType)mIBObject).isTable()) {
                    for (int i = 0; i < ((MIBObjectType)mIBObject).getTableEntriesVector().size(); ++i) {
                        object2 = (String)((MIBObjectType)mIBObject).getTableEntriesVector().get(i);
                        if (!((String)object2).equals(string)) continue;
                        ((MIBObjectType)mIBObject).getTableEntriesVector().setElementAt(string2, i);
                    }
                }
                if (!((MIBObjectType)mIBObject).hasIndexPart()) continue;
                for (int i = 0; i < ((MIBObjectType)mIBObject).getIndexPart().getIndexPartVector().size(); ++i) {
                    object2 = (String)((MIBObjectType)mIBObject).getIndexPart().getIndexPartVector().get(i);
                    if (!((String)object2).equals(string)) continue;
                    ((MIBObjectType)mIBObject).getIndexPart().getIndexPartVector().setElementAt(string2, i);
                }
                continue;
            }
            if (mIBObject2 instanceof MIBAgentCaps) {
                mIBObject = (MIBAgentCaps)mIBObject2;
                Enumeration enumeration2 = ((MIBAgentCaps)mIBObject).getModules().elements();
                while (enumeration2.hasMoreElements()) {
                    object2 = (MIBSupportedModule)enumeration2.nextElement();
                    for (n = 0; n < ((MIBSupportedModule)object2).includes.size(); ++n) {
                        object = (String)((MIBSupportedModule)object2).includes.elementAt(n);
                        if (!((String)object).equals(string)) continue;
                        ((MIBSupportedModule)object2).includes.setElementAt(string2, n);
                    }
                    if (!((MIBSupportedModule)object2).hasVariations()) continue;
                    for (n = 0; n < ((MIBSupportedModule)object2).getVariationsVector().size(); ++n) {
                        object = (MIBVariation)((MIBSupportedModule)object2).getVariationsVector().elementAt(n);
                        if (!((MIBVariation)object).getVariation().equals(string)) continue;
                        ((MIBVariation)object).setVariation(string2);
                    }
                }
                continue;
            }
            if (!(mIBObject2 instanceof MIBCompliance)) continue;
            mIBObject = (MIBCompliance)mIBObject2;
            Enumeration enumeration3 = ((MIBCompliance)mIBObject).getModules().elements();
            while (enumeration3.hasMoreElements()) {
                object2 = (MIBComplianceModule)enumeration3.nextElement();
                if (((MIBComplianceModule)object2).hasMandatory()) {
                    for (n = 0; n < ((MIBComplianceModule)object2).getMandatoryVector().size(); ++n) {
                        object = (String)((MIBComplianceModule)object2).getMandatoryVector().elementAt(n);
                        if (!((String)object).equals(string)) continue;
                        ((MIBComplianceModule)object2).getMandatoryVector().setElementAt(string2, n);
                    }
                }
                if (!((MIBComplianceModule)object2).hasVariations()) continue;
                for (n = 0; n < ((MIBComplianceModule)object2).getVariationsVector().size(); ++n) {
                    object = (MIBVariation)((MIBComplianceModule)object2).getVariationsVector().elementAt(n);
                    if (((MIBVariation)object).getVariation() == null || !((MIBVariation)object).getVariation().equals(string)) continue;
                    ((MIBVariation)object).setVariation(string2);
                }
            }
        }
    }

    public void convertToSMIv1(MIBRepository mIBRepository) {
        MIBObject mIBObject;
        if (this.getSMIVersion() == 1) {
            return;
        }
        this.setSMIVersion(1);
        MIBObject mIBObject2 = new MIBObject(this.getOid(), this.getName(), this.getModuleID());
        this.add(mIBObject2);
        mIBRepository.removeObject(this);
        this.oid = new ObjectID();
        mIBRepository.addObject(this);
        mIBRepository.addObject(mIBObject2);
        mIBRepository.structureChanged();
        Vector<MIBObject> vector = new Vector<MIBObject>();
        Enumeration enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            Object object;
            Comparable comparable;
            mIBObject = (MIBObject)enumeration.nextElement();
            if (mIBObject.getStatus() != null && mIBObject.getStatus().equals(SMI.STATUS[5])) {
                mIBObject.setStatus(SMI.STATUS[1]);
            }
            MIBSyntax mIBSyntax = null;
            if (mIBObject instanceof MIBObjectType) {
                comparable = (MIBObjectType)mIBObject;
                if (((MIBObjectType)comparable).hasIndexPart() && ((MIBObjectType)comparable).getIndexPart().isAugment() && (object = mIBRepository.getObject(((MIBObjectType)comparable).getIndexPart().getIndexPart()[0])) != null && object instanceof MIBObjectType) {
                    ((MIBObjectType)comparable).setIndexPart(new MIBIndexPart(((MIBObjectType)object).getIndexPart()));
                }
                ((MIBObjectType)comparable).setUnits(null);
                if (((MIBObjectType)comparable).getAccess().equals(SMI.ACCESS[3])) {
                    ((MIBObjectType)comparable).setAccess(SMI.ACCESS[2]);
                }
                mIBSyntax = ((MIBObjectType)comparable).getSyntax();
            }
            if (mIBObject instanceof MIBTextualConvention) {
                mIBSyntax = ((MIBTextualConvention)mIBObject).getSyntax();
                ((MIBTextualConvention)mIBObject).setStatus(null);
            }
            if (mIBSyntax != null) {
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[5]) || mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[6])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[3]);
                }
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[7])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[4]);
                }
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[13])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[4]);
                }
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[8])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[0]);
                }
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[1]);
                    if (mIBSyntax.hasEnums()) {
                        MIBObjectType mIBObjectType;
                        comparable = new StringBuffer();
                        object = mIBSyntax.getEnumsVector().elements();
                        while (object.hasMoreElements()) {
                            ((StringBuffer)comparable).append("-- " + object.nextElement().toString() + "\n");
                        }
                        object = "";
                        if (mIBObject.hasComment()) {
                            object = mIBObject.getComment();
                        }
                        mIBObject.setComment((String)object + "\n" + "-- BITS: " + "\n" + ((StringBuffer)comparable).toString());
                        if (mIBObject instanceof MIBObjectType && (mIBObjectType = (MIBObjectType)mIBObject).hasDefaultValue()) {
                            byte[] byArray = mIBSyntax.getBitsEnum(mIBObjectType.getDefaultValue());
                            StringBuffer stringBuffer = new StringBuffer("'");
                            if (byArray != null) {
                                for (int i = 0; i < byArray.length; ++i) {
                                    stringBuffer.append(Integer.toHexString(byArray[i]));
                                }
                            }
                            stringBuffer.append("'h");
                            mIBObjectType.setDefaultValue(stringBuffer.toString());
                        }
                        mIBSyntax.setEnumsVector(null);
                    }
                }
            }
            if (mIBObject instanceof MIBNotifyType) {
                ((MIBNotifyType)mIBObject).setTrapType(2);
                try {
                    comparable = mIBRepository.getObject(mIBObject.getOid().getPrefix(mIBObject.getOid().size() - 2));
                    if (comparable != null) {
                        ((MIBNotifyType)mIBObject).setEnterprise(((MIBObject)comparable).getName());
                    } else {
                        ((MIBNotifyType)mIBObject).setEnterprise(mIBObject.getOid().getPrefix(mIBObject.getOid().size() - 2).toString());
                    }
                }
                catch (ObjectIDFormatException objectIDFormatException) {
                    // empty catch block
                }
            }
            if (!(mIBObject instanceof MIBGroup) && !(mIBObject instanceof MIBCompliance) && !(mIBObject instanceof MIBAgentCaps)) continue;
            vector.addElement(mIBObject);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            mIBObject = (MIBObject)enumeration.nextElement();
            mIBRepository.removeObject(mIBObject);
            this.remove(mIBObject);
        }
        this.autoImportSMIMacros();
    }

    private void autoImportSMIMacros() {
        int n;
        Object object;
        int n2;
        for (n2 = 0; n2 < STANDARD_MIBS.length; ++n2) {
            if (!this.getModuleName().equals(STANDARD_MIBS[n2])) continue;
            return;
        }
        n2 = this.getSMIVersion();
        Enumeration enumeration = this.getImportsVector().elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = (MIBImport)enumeration.nextElement();
            for (int i = 0; i < mIBImport.getImportsVector().size(); ++i) {
                object = (String)mIBImport.getImportsVector().elementAt(i);
                if (SMI.getKeyWordType(1, (String)object) >= 0) {
                    mIBImport.getImportsVector().remove(i);
                    --i;
                    continue;
                }
                if (SMI.getKeyWordType(2, (String)object) < 0) continue;
                mIBImport.getImportsVector().remove(i);
                --i;
            }
        }
        for (n = 0; n < SMI.smiConstructs[n2 - 1].length; ++n) {
            block4: for (int i = 0; i < SMI.smiConstructs[n2 - 1][n].length; ++i) {
                Enumeration enumeration2 = this.objects();
                while (enumeration2.hasMoreElements()) {
                    object = (MIBObject)enumeration2.nextElement();
                    if (!((MIBObject)object).getTypeString().equals(SMI.smiConstructs[n2 - 1][n][i]) && (!(object instanceof MIBObjectType) || !((MIBObjectType)object).getSyntax().getSyntax().equals(SMI.smiConstructs[n2 - 1][n][i])) && (!(object instanceof MIBTextualConvention) || !((MIBTextualConvention)object).getSyntax().getSyntax().equals(SMI.smiConstructs[n2 - 1][n][i]))) continue;
                    MIBImport mIBImport = this.getImports(SMI.smiMIBs[n2 - 1][n]);
                    if (mIBImport == null) {
                        mIBImport = new MIBImport(SMI.smiMIBs[n2 - 1][n]);
                        this.getImportsVector().add(mIBImport);
                    }
                    mIBImport.addImport(SMI.smiConstructs[n2 - 1][n][i]);
                    continue block4;
                }
            }
        }
        for (n = 0; n < this.getImportsVector().size(); ++n) {
            MIBImport mIBImport = (MIBImport)this.getImportsVector().elementAt(n);
            if (mIBImport.getImportsVector().size() != 0) continue;
            this.getImportsVector().remove(n);
            --n;
        }
    }

    public Collection getLowerCaseNames() {
        Serializable serializable;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.imports != null) {
            for (int i = 0; i < this.imports.size(); ++i) {
                serializable = (MIBImport)this.imports.get(i);
                String[] stringArray = ((MIBImport)serializable).getImports();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (stringArray[j].length() <= 0 || !Character.isLowerCase(stringArray[j].charAt(0))) continue;
                    hashSet.add(stringArray[j]);
                }
            }
        }
        Iterator iterator = this.objectsIterator();
        while (iterator.hasNext()) {
            serializable = (MIBObject)iterator.next();
            if (((MIBObject)serializable).getName().length() <= 0 || !Character.isLowerCase(((MIBObject)serializable).getName().charAt(0))) continue;
            hashSet.add(((MIBObject)serializable).getName());
        }
        return hashSet;
    }

    public Collection getUpperCaseNames() {
        Serializable serializable;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.imports != null) {
            for (int i = 0; i < this.imports.size(); ++i) {
                serializable = (MIBImport)this.imports.get(i);
                String[] stringArray = ((MIBImport)serializable).getImports();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (stringArray[j].length() <= 0 || !Character.isUpperCase(stringArray[j].charAt(0))) continue;
                    hashSet.add(stringArray[j]);
                }
            }
        }
        Iterator iterator = this.objectsIterator();
        while (iterator.hasNext()) {
            serializable = (MIBObject)iterator.next();
            if (((MIBObject)serializable).getName().length() <= 0 || !Character.isUpperCase(((MIBObject)serializable).getName().charAt(0))) continue;
            hashSet.add(((MIBObject)serializable).getName());
        }
        return hashSet;
    }

    private static int getTimezoneOffsetGMT() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = TimeZone.getDefault().getOffset(1, gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), gregorianCalendar.get(7), gregorianCalendar.get(14));
        return n;
    }

    public static String getUTCTime(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        String string = simpleDateFormat.format(new Date(l - (long)MIBModule.getTimezoneOffsetGMT()));
        string = string + "Z";
        return string;
    }
}

