/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smi.ext.SMIIndexPart;
import java.io.Serializable;
import java.util.Vector;

public class MIBIndexPart
implements Serializable,
SMIIndexPart {
    public static final long serialVersionUID = 1000L;
    protected Vector indecies = new Vector(1);
    protected int type = 1;
    protected boolean implied = false;
    public static final int INDEX = 1;
    public static final int AUGMENT = 2;

    public MIBIndexPart() {
        this.setType(1);
    }

    public MIBIndexPart(int n) {
        this.setType(n);
    }

    public MIBIndexPart(int n, Vector vector) {
        this.setType(n);
        this.indecies = vector;
    }

    public MIBIndexPart(MIBIndexPart mIBIndexPart) {
        this.setIndexPart(mIBIndexPart.getIndexPart());
        this.implied = mIBIndexPart.implied;
        this.type = mIBIndexPart.type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isAugment() {
        return this.type == 2;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void addIndexPart(String string) {
        if (this.indecies == null) {
            this.indecies = new Vector(3);
        }
        this.indecies.addElement(string);
    }

    public void setIndexPart(String[] stringArray) {
        this.indecies = MIBRepository.buildVector(stringArray);
    }

    public String[] getIndexObjects() {
        return this.getIndexPart();
    }

    public String[] getIndexPart() {
        if (this.indecies == null) {
            return null;
        }
        Object[] objectArray = new String[this.indecies.size()];
        this.indecies.copyInto(objectArray);
        return objectArray;
    }

    public Vector getIndexPartVector() {
        return this.indecies;
    }

    public void setIndexPartVector(Vector vector) {
        this.indecies = vector;
    }

    public boolean isImplied() {
        return this.implied;
    }

    public void setImplied(boolean bl) {
        this.implied = bl;
    }

    public boolean getImplied() {
        return this.isImplied();
    }

    public String toSMI(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getType() == 1) {
            MIBObject.addKeyWord(n, stringBuffer, "INDEX ");
        } else {
            MIBObject.addKeyWord(n, stringBuffer, "AUGMENTS ");
        }
        stringBuffer.append("{");
        stringBuffer.append(string);
        String[] stringArray = this.getIndexPart();
        Vector vector = (Vector)this.indecies.clone();
        if (this.implied) {
            vector.removeElementAt(vector.size() - 1);
        }
        stringBuffer.append(MIBObject.formatObjectRefs(n, "\t\t", vector.elements(), string));
        if (this.implied) {
            if (vector.size() > 0) {
                stringBuffer.append(",");
                stringBuffer.append(string);
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append("\t\t");
            MIBObject.addKeyWord(n, stringBuffer, "IMPLIED ");
            stringBuffer.append(this.indecies.elementAt(this.indecies.size() - 1).toString());
        }
        stringBuffer.append(" }");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toSMI(1, "\n");
    }

    public IndexStruct[] getIndexStruct(MIBRepository mIBRepository) {
        Object object;
        boolean bl = this.isImplied();
        String[] stringArray = this.getIndexPart();
        if (this.getType() == 2) {
            object = (MIBObjectType)mIBRepository.getObject(stringArray[0]);
            stringArray = ((MIBObjectType)object).getIndexPart().getIndexPart();
            bl = ((MIBObjectType)object).getIndexPart().isImplied();
        }
        object = new IndexStruct[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            MIBObjectType mIBObjectType = (MIBObjectType)mIBRepository.getObject(stringArray[i]);
            if (mIBObjectType == null || mIBObjectType.getSyntax() == null) {
                return null;
            }
            MIBTextualConvention mIBTextualConvention = mIBRepository.getEffectiveSyntax(mIBObjectType.getSyntax());
            MIBSyntax mIBSyntax = mIBTextualConvention.getSyntax();
            if (mIBSyntax == null) {
                mIBSyntax = mIBObjectType.getSyntax();
            }
            if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("TruthValue") || mIBSyntax.getSyntax().equals("Integer32") || mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32") || mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32") || mIBSyntax.getSyntax().equals("TimeTicks") || mIBSyntax.getSyntax().equals("TimeStamp")) {
                object[i] = new IndexStruct(stringArray[i], 0, false, 1, 1);
                ++n;
                continue;
            }
            if (mIBSyntax.getSyntax().equals("IpAddress")) {
                object[i] = new IndexStruct(stringArray[i], 5, false, 4, 4);
                n += 4;
                continue;
            }
            if (mIBSyntax.getSyntax().equals("NetworkAddress")) {
                object[i] = new IndexStruct(stringArray[i], 12, false, 5, 5);
                n += 5;
                continue;
            }
            if (mIBSyntax.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                object[i] = new IndexStruct(stringArray[i], 3, bl && i + 1 == stringArray.length, 2, 128 - n);
                continue;
            }
            if (mIBSyntax.getSyntax().startsWith("OCTET") || mIBSyntax.getSyntax().startsWith("BITS") || mIBSyntax.getSyntax().startsWith("Opaque")) {
                if (mIBSyntax.hasRanges() && mIBSyntax.getRanges().length == 1) {
                    try {
                        int n2 = mIBSyntax.getRanges()[0].getLower().intValue();
                        int n3 = mIBSyntax.getRanges()[0].getUpper().intValue();
                        n += n2;
                        if (bl && i + 1 == stringArray.length) {
                            object[i] = new IndexStruct(stringArray[i], 1, true, n2, Math.min(n3, 128 - n));
                            continue;
                        }
                        object[i] = new IndexStruct(stringArray[i], 1, false, n2, Math.min(n3, 128 - n));
                    }
                    catch (NumberFormatException numberFormatException) {
                        object[i] = null;
                    }
                    continue;
                }
                object[i] = new IndexStruct(stringArray[i], 1, bl && i + 1 == stringArray.length, 0, 128 - n);
                continue;
            }
            if (!mIBSyntax.getSyntax().equals("Counter64")) continue;
        }
        return object;
    }
}

