/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.smi.ext.SMIImport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MIBImport
implements Serializable,
SMIImport {
    public static final long serialVersionUID = 1000L;
    protected Vector imports = null;
    protected String source = null;
    protected String comment = null;

    public MIBImport() {
    }

    public MIBImport(String string) {
        this.source = string;
    }

    public MIBImport(String string, Vector vector) {
        this.source = string;
        this.imports = vector;
    }

    public MIBImport(String string, Vector vector, String string2) {
        this(string, vector);
        this.comment = string2;
    }

    public MIBImport(MIBImport mIBImport) {
        this.source = mIBImport.source;
        this.comment = mIBImport.comment;
        Enumeration enumeration = mIBImport.imports.elements();
        while (enumeration.hasMoreElements()) {
            this.addImport((String)enumeration.nextElement());
        }
    }

    public void setSource(String string) {
        this.source = string;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getSource() {
        return this.source;
    }

    public String getComment() {
        return this.comment;
    }

    public void setImports(String[] stringArray) {
        this.imports = MIBRepository.buildVector(stringArray);
    }

    public String[] getImports() {
        if (this.imports == null) {
            return null;
        }
        Object[] objectArray = new String[this.imports.size()];
        this.imports.copyInto(objectArray);
        return objectArray;
    }

    public void addImport(String string) {
        if (this.imports == null) {
            this.imports = new Vector(5);
        }
        this.imports.addElement(string);
    }

    public void setImportsVector(Vector vector) {
        this.imports = vector;
    }

    public Vector getImportsVector() {
        return this.imports;
    }

    public boolean imports(String string) {
        return this.imports.contains(string);
    }

    public String toSMI(MIBRepository mIBRepository, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\t");
            String string2 = enumeration.nextElement().toString();
            MIBObject[] mIBObjectArray = mIBRepository.getObjectsByName(string2);
            if (mIBObjectArray != null && mIBObjectArray.length > 1) {
                MIBObject.addObjectRef(this.source, n, stringBuffer, string2);
            } else {
                MIBObject.addObjectRef(null, n, stringBuffer, string2);
            }
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
            stringBuffer.append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("\t\t");
        MIBObject.addKeyWord(n, stringBuffer, "FROM ");
        stringBuffer.append(this.source);
        if (this.hasComment()) {
            stringBuffer.append("\t\t");
            MIBObject.addComment(n, stringBuffer, this.getComment(), string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.source;
    }

    public boolean equals(Object object) {
        if (object instanceof MIBImport) {
            MIBImport mIBImport = (MIBImport)object;
            return (this.source == null ? mIBImport.getSource() == null : this.source.equals(mIBImport.getSource())) && (this.getImportsVector() == null ? mIBImport.getImportsVector() == null : this.getImportsVector().equals(mIBImport.getImportsVector())) && (!this.hasComment() ? !mIBImport.hasComment() : this.getComment().equals(mIBImport.getComment()));
        }
        return false;
    }

    public int hashCode() {
        if (this.source != null) {
            return this.source.hashCode();
        }
        return super.hashCode();
    }
}

