/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.ext.SMIGroup;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MIBGroup
extends MIBObject
implements Serializable,
SMIGroup {
    public static final long serialVersionUID = 1000L;
    protected Vector objects = new Vector();
    public static final int ID = 6;
    protected int groupType = 6;

    public MIBGroup() {
        this.groupType = 6;
    }

    public MIBGroup(int n) {
        this.groupType = n == 6 ? 6 : 7;
    }

    public MIBGroup(ObjectID objectID, String string, Integer n, int n2) {
        super(objectID, string, n);
        this.groupType = n2 == 6 ? 6 : 7;
    }

    public MIBGroup(MIBGroup mIBGroup) {
        super(mIBGroup);
        this.groupType = mIBGroup.groupType;
        if (mIBGroup.objects != null) {
            Enumeration enumeration = mIBGroup.objects.elements();
            while (enumeration.hasMoreElements()) {
                this.objects.addElement(enumeration.nextElement());
            }
        }
    }

    public MIBObject getClone() {
        return new MIBGroup(this);
    }

    public final String getTypeString() {
        return SMI.ENTRY_TYPES[this.groupType];
    }

    public final boolean isObjectGroup() {
        return this.groupType == 6;
    }

    public final boolean isNotificationGroup() {
        return this.groupType != 6;
    }

    public final boolean contains(String string) {
        return this.objects.contains(string);
    }

    public final int getType() {
        return this.groupType;
    }

    public final void setType(int n) {
        this.groupType = n;
    }

    public final void setObjects(String[] stringArray) {
        this.objects = MIBRepository.buildVector(stringArray);
    }

    public void addObject(String string) {
        if (this.objects == null) {
            this.objects = new Vector(5);
        }
        this.objects.addElement(string);
    }

    public String[] getObjects() {
        if (this.objects == null) {
            return null;
        }
        Object[] objectArray = new String[this.objects.size()];
        this.objects.copyInto(objectArray);
        return objectArray;
    }

    public Vector getObjectsVector() {
        return this.objects;
    }

    public void setObjectsVector(Vector vector) {
        this.objects = vector;
    }

    public String toSMI(int n, int n2, MIBRepository mIBRepository, String string) {
        MIBGroup mIBGroup = (MIBGroup)this.comparable(n);
        StringBuffer stringBuffer = new StringBuffer();
        MIBGroup.addNavigationLinks(this, n, stringBuffer, mIBRepository, string);
        if (this.hasComment()) {
            MIBGroup.addComment(n, stringBuffer, this.asn1Comment, string);
            stringBuffer.append(string);
        }
        MIBGroup.addObjectRef(null, n, stringBuffer, this.name);
        stringBuffer.append(' ');
        MIBGroup.addKeyWord(n, stringBuffer, SMI.ENTRY_TYPES[this.groupType]);
        stringBuffer.append(string);
        if (this.groupType == 7) {
            stringBuffer.append('\t');
            MIBGroup.addKeyWord(n, stringBuffer, "NOTIFICATIONS");
            stringBuffer.append(" {");
            stringBuffer.append(string);
        } else {
            stringBuffer.append('\t');
            MIBGroup.addKeyWord(n, stringBuffer, "OBJECTS");
            stringBuffer.append(" {");
            stringBuffer.append(string);
        }
        MIBObject.addString(n, stringBuffer, MIBObject.formatObjectRefs(n, "\t\t", this.objects.elements(), string), mIBGroup == null ? null : MIBObject.formatObjectRefs(n, "\t\t", mIBGroup.objects.elements(), string));
        if (this.objects.size() == 0) {
            stringBuffer.append("\t}");
        } else {
            stringBuffer.append(" }");
        }
        stringBuffer.append(string);
        stringBuffer.append(this.getSMIDefBegin(n, string));
        stringBuffer.append(this.getSMIDefEnd(n, mIBRepository, this.asn1CommentInline, string));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof MIBGroup && super.equals(object)) {
            MIBGroup mIBGroup = (MIBGroup)object;
            return this.groupType == mIBGroup.groupType && MIBGroup.saveCompare(this.objects, mIBGroup.objects);
        }
        return false;
    }
}

