/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.smi.ext.SMIEnum;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;

public class MIBEnum
implements Serializable,
SMIEnum {
    public static final long serialVersionUID = 1000L;
    protected String label = null;
    protected String value = null;
    protected String comment = null;

    public MIBEnum() {
        this.label = null;
        this.value = null;
    }

    public MIBEnum(String string, String string2) {
        this.label = string;
        this.value = string2;
    }

    public MIBEnum(String string, String string2, String string3) {
        this.label = string;
        this.value = string2;
        this.comment = string3;
    }

    public MIBEnum(MIBEnum mIBEnum) {
        this.label = mIBEnum.label;
        this.value = mIBEnum.value;
        this.comment = mIBEnum.comment;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelWithoutHyphen() {
        return this.label.replace('-', '_');
    }

    public String getValue() {
        return this.value;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public long getLongValue() {
        try {
            return SMI.parseLongConstant(this.value);
        }
        catch (Exception exception) {
            return Long.MIN_VALUE;
        }
    }

    public boolean hasValidValue() {
        try {
            SMI.parseLongConstant(this.value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toSMI(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.label);
        stringBuffer.append('(');
        MIBObject.addNum(n, stringBuffer, this.value);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof MIBEnum) {
            return this.getLongValue() == ((MIBEnum)object).getLongValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getLongValue();
    }

    public String toString() {
        return this.label + "(" + this.value + ")";
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }
}

