/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.ext.SMIRequirementsSpec;
import com.agentpp.smi.ext.SMIVariation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBComplianceModule
implements Serializable,
SMIRequirementsSpec {
    public static final long serialVersionUID = 1000L;
    protected String moduleName = null;
    protected Vector mandatory = null;
    protected Vector variations = new Vector();
    protected transient Object userObject = null;

    public MIBComplianceModule() {
    }

    public MIBComplianceModule(String string) {
        this.moduleName = string;
    }

    public MIBComplianceModule(MIBComplianceModule mIBComplianceModule) {
        Enumeration enumeration;
        if (mIBComplianceModule.moduleName != null) {
            this.moduleName = new String(mIBComplianceModule.moduleName);
        }
        if (mIBComplianceModule.hasMandatory()) {
            this.mandatory = new Vector();
            enumeration = mIBComplianceModule.mandatory.elements();
            while (enumeration.hasMoreElements()) {
                this.mandatory.addElement(new String(enumeration.nextElement().toString()));
            }
        }
        if (mIBComplianceModule.hasVariations()) {
            enumeration = mIBComplianceModule.variations.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof MIBCondGroup) {
                    this.variations.addElement(new MIBCondGroup((MIBCondGroup)e));
                }
                if (!(e instanceof MIBException)) continue;
                this.variations.addElement(new MIBException((MIBException)e));
            }
        }
    }

    public boolean hasMandatory() {
        return this.mandatory != null && this.mandatory.size() > 0;
    }

    public Vector getMandatoryVector() {
        return this.mandatory;
    }

    public String[] getMandatory() {
        Object[] objectArray = new String[this.mandatory.size()];
        this.mandatory.copyInto(objectArray);
        return objectArray;
    }

    public final void setMandatory(String[] stringArray) {
        this.mandatory = new Vector<String>(Arrays.asList(stringArray));
    }

    public final void setMandatory(Vector vector) {
        this.mandatory = vector;
    }

    public boolean hasVariations() {
        return this.variations != null && this.variations.size() > 0;
    }

    public final void setVariations(SMIVariation[] sMIVariationArray) {
        this.variations = new Vector<SMIVariation>(Arrays.asList(sMIVariationArray));
    }

    public final void setVariations(Vector vector) {
        this.variations = vector;
    }

    public final Vector getVariationsVector() {
        return this.variations;
    }

    public final IVariation[] getVariations() {
        Object[] objectArray = new MIBVariation[this.variations.size()];
        this.variations.copyInto(objectArray);
        return objectArray;
    }

    public final boolean hasModuleName() {
        return this.moduleName != null && this.moduleName.length() > 0;
    }

    public final String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(String string) {
        this.moduleName = string;
    }

    public String toSMI(int n, MIBRepository mIBRepository, MIBComplianceModule mIBComplianceModule, String string) {
        Enumeration enumeration;
        StringBuffer stringBuffer = new StringBuffer(string + "\t");
        MIBObject.addKeyWord(n, stringBuffer, "MODULE ");
        if (this.hasModuleName()) {
            enumeration = null;
            if (mIBComplianceModule != null) {
                enumeration = mIBComplianceModule.hasModuleName() ? mIBComplianceModule.moduleName : "";
            }
            MIBObject.addString(n, stringBuffer, this.moduleName, (String)((Object)enumeration));
        }
        stringBuffer.append(string);
        if (this.hasMandatory()) {
            stringBuffer.append('\t');
            MIBObject.addKeyWord(n, stringBuffer, "MANDATORY-GROUPS");
            stringBuffer.append(" {");
            stringBuffer.append(string);
            enumeration = null;
            if (mIBComplianceModule != null) {
                enumeration = mIBComplianceModule.hasMandatory() ? MIBObject.formatObjectRefs(n, "\t\t\t", mIBComplianceModule.mandatory.elements(), string) : "";
            }
            MIBObject.addString(n, stringBuffer, MIBObject.formatObjectRefs(n, "\t\t\t", this.mandatory.elements(), string), (String)((Object)enumeration));
            stringBuffer.append(" }");
            stringBuffer.append(string);
        }
        if (this.variations.size() > 0) {
            enumeration = null;
            if (mIBComplianceModule != null) {
                enumeration = mIBComplianceModule.variations != null && mIBComplianceModule.variations.size() > 0 ? mIBComplianceModule.variations.elements() : new Vector().elements();
            }
            Enumeration enumeration2 = this.variations.elements();
            while (enumeration2.hasMoreElements()) {
                MIBVariation mIBVariation = (MIBVariation)enumeration2.nextElement();
                MIBVariation mIBVariation2 = null;
                if (enumeration != null) {
                    mIBVariation2 = enumeration.hasMoreElements() ? (MIBVariation)enumeration.nextElement() : new MIBVariation();
                }
                stringBuffer.append(mIBVariation.toSMI(n, mIBRepository, mIBVariation2, string));
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.moduleName;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public boolean equals(Object object) {
        if (object instanceof MIBComplianceModule) {
            MIBComplianceModule mIBComplianceModule = (MIBComplianceModule)object;
            return MIBObject.saveCompare(this.mandatory, mIBComplianceModule.mandatory) && MIBObject.saveCompare(this.moduleName, mIBComplianceModule.moduleName) && MIBObject.saveCompare(this.variations, mIBComplianceModule.variations);
        }
        return false;
    }

    public void freeUserObjects() {
        this.userObject = null;
        if (this.hasVariations()) {
            for (MIBVariation mIBVariation : this.variations) {
                mIBVariation.freeUserObjects();
            }
        }
    }
}

