/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.tree;

import com.agentpp.common.tree.DumpMIBTree;
import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MIBInstance;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.snmp.ValueConverter;
import java.io.OutputStream;
import java.util.Vector;

public class DumpMIBInstanceTree
extends DumpMIBTree {
    protected MIBRepository rep;

    public DumpMIBInstanceTree(OutputStream outputStream, MIBRepository mIBRepository) {
        super(outputStream);
        this.rep = mIBRepository;
    }

    protected String printOtherObject(Object object) {
        String string = null;
        if (object instanceof MIBInstance) {
            MIBInstance mIBInstance = (MIBInstance)object;
            try {
                ObjectID objectID = new ObjectID(mIBInstance.getOid().toString()).getSuffix(mIBInstance.getOid().size() - mIBInstance.getObjectClass().getOid().size());
                if (mIBInstance.getObjectClass() != null) {
                    MIBObject mIBObject = this.rep.getParent(mIBInstance.getObjectClass());
                    if (mIBObject != null && mIBObject instanceof MIBObjectType && ((MIBObjectType)mIBObject).isTable()) {
                        string = "[";
                        MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
                        if (mIBObjectType.getIndexPart().isAugment()) {
                            mIBObjectType = (MIBObjectType)this.rep.getObject(mIBObjectType.getIndexPart().getIndexPart()[0]);
                        }
                        IndexStruct[] indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(this.rep);
                        ObjectID[] objectIDArray = this.rep.getIndexObjectIDs(objectID, indexStructArray);
                        ValueConverter[] valueConverterArray = this.getIndexValueConverter(mIBObjectType);
                        string = string + IndexConverter.getIndexString(valueConverterArray, indexStructArray, objectIDArray);
                        string = string + "] " + mIBInstance.toString();
                    } else {
                        string = "[" + objectID.toString() + "] " + mIBInstance.toString();
                    }
                } else {
                    string = "[" + objectID.toString() + "] " + mIBInstance.toString();
                }
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                string = "[?] " + mIBInstance.getValue();
            }
        }
        return string;
    }

    protected ValueConverter[] getIndexValueConverter(MIBObjectType mIBObjectType) {
        if (!mIBObjectType.isTable()) {
            return null;
        }
        Vector vector = this.rep.getColumnarObjectsOfTable(mIBObjectType, true, false);
        if (mIBObjectType.userObject instanceof ValueConverter[]) {
            return (ValueConverter[])mIBObjectType.userObject;
        }
        ValueConverter[] valueConverterArray = new ValueConverter[vector.size()];
        for (int i = 0; i < valueConverterArray.length; ++i) {
            MIBObjectType mIBObjectType2 = (MIBObjectType)vector.elementAt(i);
            MIBTextualConvention mIBTextualConvention = this.rep.getEffectiveSyntax(mIBObjectType2.getSyntax());
            valueConverterArray[i] = new ValueConverter(mIBObjectType2, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        mIBObjectType.userObject = valueConverterArray;
        return valueConverterArray;
    }
}

