/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.traps;

import com.agentpp.common.ChangeManager;
import com.agentpp.common.StandardDialog;
import com.agentpp.common.StatusBar;
import com.agentpp.common.TableSorter;
import com.agentpp.common.images.ToolBarUtils;
import com.agentpp.common.net.HostnameResolver;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.BrowsePanel;
import com.agentpp.explorer.MultiVariablePanel;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.explorer.monitor.MonitorConfigPanel;
import com.agentpp.explorer.traps.PrioritiesPanel;
import com.agentpp.explorer.traps.TrapProxy;
import com.agentpp.explorer.traps.TrapSelector;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.event.MIBObjectListener;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.renderers.JCLabelCellRenderer;
import com.klg.jclass.table.DataViewModel;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.objectspace.jgl.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.log4j.Level;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class TrapReceiverDialog
extends JPanel
implements CommandResponder,
JCCellDisplayListener,
JCSelectListener {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private float _$30398 = 0.0f;
    private long _$30399 = Long.MAX_VALUE;
    private float _$18928 = 2000.0f;
    private float _$30400 = 2.0f;
    Border border1;
    private JCEditableVectorDataSource _$4260 = new JCEditableVectorDataSource();
    private static SimpleDateFormat _$30401 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final String[] _$30402 = new String[]{"Acknowlegded", "Notification ID", "Originator", "Destination", "System Up Time", "Security Name", "Version", "Context", "Context Engine ID", "Variable Bindings"};
    static final int COL_VBS = 9;
    static final int COL_ACK = 0;
    static final int COL_NOTIFICATION_ID = 1;
    static final int COL_ORIGINATOR = 2;
    static final int COL_DESTINATION = 3;
    static final int COL_SYS_UPTIME = 4;
    static final int COL_SEC_NAME = 5;
    static final int COL_VERSION = 6;
    static final int COL_CONTEXT = 7;
    static final int COL_CONTEXT_ENGINE_ID = 8;
    private boolean _$29665;
    private TrapProxy _$18901;
    private MIBRepository _$18643;
    private TableSorter _$18933;
    BorderLayout borderLayout4 = new BorderLayout();
    private ChangeManager _$29661 = new ChangeManager();
    private JFrame _$18902;
    private int _$30403 = 0;
    Border border2;
    TitledBorder titledBorder1;
    Border border3;
    JSplitPane jSplitPane1 = new JSplitPane();
    BrowsePanel browsePanel = new BrowsePanel();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    JCTable table = new ExtendedListTable(){

        public String getToolTipText(MouseEvent mouseEvent) {
            JCCellPosition jCCellPosition = this.XYToCell(mouseEvent.getX(), mouseEvent.getY());
            if (jCCellPosition.column == -1 && jCCellPosition.row >= 0) {
                return TrapReceiverDialog.this._$18942(jCCellPosition.row).toString();
            }
            if (jCCellPosition.column < 0 || jCCellPosition.row < 0) {
                return null;
            }
            int n = jCCellPosition.row;
            int n2 = jCCellPosition.column;
            Object object = TrapReceiverDialog.this._$4260.getTableDataItem(n, n2);
            if (object == null) {
                return null;
            }
            return object.toString();
        }
    };
    JToggleButton jToggleButtonHistory = new JToggleButton();
    JButton jButtonDelete = new JButton();
    JButton jButtonAck = new JButton();
    JToolBar jToolBar = new JToolBar();
    JButton jButtonUndo = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jButtonRedo = new JButton();
    JPanel jPanelNorth = new JPanel();
    JToolBar jToolBarStatus = new JToolBar();
    JLabel statusBar = new JLabel();
    JToggleButton jToggleButtonPause = new JToggleButton();
    private Vector _$30411 = new Vector(100, 50);
    private JButton _$30412 = new JButton();
    private UserConfigFile _$4288;
    private JButton _$29533 = new JButton();
    private JCCellStyle _$30413;
    private JCCellStyle _$30414;
    private JCCellStyle _$30415;
    private JCCellStyle _$4629;
    private Map _$30416 = Collections.synchronizedMap(new Hashtable());
    private HostnameResolver _$30136;
    private StatusBar _$4364;
    private boolean _$30417;
    private boolean _$30418;

    public TrapReceiverDialog(TrapProxy trapProxy, MIBRepository mIBRepository, JFrame jFrame, UserConfigFile userConfigFile) {
        this._$18901 = trapProxy;
        this._$18643 = mIBRepository;
        this._$18902 = jFrame;
        this._$4288 = userConfigFile;
        this.browsePanel = new BrowsePanel(mIBRepository);
        this.browsePanel.setNumRows(5);
        this._$4260.setNumRows(0);
        this._$4260.setNumColumns(_$30402.length);
        for (int i = 0; i < _$30402.length; ++i) {
            this._$4260.setColumnLabel(i, _$30402[i]);
        }
        this._$4260.addRow(Integer.MAX_VALUE, null, null);
        this.table.setDataSource(this._$4260);
        this._$18933 = new TableSorter(this.table, this._$4260);
        this.table.setRowHidden(0, true);
        this.table.setColumnHidden(_$30402.length - 1, true);
        this.table.setFrozenRows(0);
        this.table.setColumnLabelDisplay(true);
        this.table.setRowLabelDisplay(true);
        this.table.setCharWidth(-997, -999);
        this.table.setCharWidth(-1, 13);
        this.table.setResizeEven(false);
        this.table.setVariableEstimateCount(10);
        this.table.setVisibleRows(20);
        this.table.setAutoScroll(1);
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this._$4629 = new JCCellStyle(this.table.getDefaultCellStyle());
        this._$4629.setEditable(false);
        JCCellStyle jCCellStyle = new JCCellStyle(this._$4629);
        jCCellStyle.setBackground(new Color(220, 220, 220));
        jCCellStyle.setCellRenderer(new TrapOIDRenderer());
        this.table.setCellStyle(-997, 1, jCCellStyle);
        this.table.setPixelWidth(1, 33002);
        JCCellStyle jCCellStyle2 = new JCCellStyle(this._$4629);
        jCCellStyle2.setBackground(Color.white);
        this._$30414 = new JCCellStyle(this._$4629);
        this._$30413 = new JCCellStyle(this._$4629);
        this._$30415 = new JCCellStyle(this._$4629);
        this._$30414.setBackground(Color.orange);
        this._$30413.setBackground(Color.yellow);
        this._$30415.setBackground(Color.red);
        for (int i = 2; i < _$30402.length - 1; ++i) {
            this.table.setCellStyle(-997, i, jCCellStyle2);
            this.table.setPixelWidth(i, 33002);
        }
        this.table.setFrozenColumns(1);
        this.table.setColumnHidden(0, true);
        this.table.addCellDisplayListener(this);
        this.table.addSelectListener(this);
        this.table.setSelectionPolicy(2);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateButtons();
        this._$30136 = new HostnameResolver(this._$30416);
        this._$30136.start();
        trapProxy.setHostnameResolver(this._$30136);
        this.updateConfig();
    }

    public TrapReceiverDialog() {
        this(null, null, null, null);
    }

    public void init() {
        this.browsePanel.clear();
        this.table.traverse(this._$4260.getNumRows() - 1, 0, false, false);
    }

    private Level _$18942(int n) {
        ObjectID objectID = (ObjectID)this._$4260.getTableDataItem(n, 1);
        return this._$18901.getLoggingLevel((ObjectID)objectID).level;
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getCellData() != null && jCCellDisplayEvent.getRow() > 0) {
            if (!this._$29665 && jCCellDisplayEvent.getCellData() instanceof ObjectID) {
                ObjectID objectID = (ObjectID)jCCellDisplayEvent.getCellData();
                String string = this._$18643.getObjectName(objectID);
                if (string == null) {
                    string = this._$18643.getPathSuffix(objectID);
                }
                if (string != null) {
                    jCCellDisplayEvent.setDisplayData(string);
                }
            } else if (jCCellDisplayEvent.getCellData() instanceof Date) {
                String string = _$30401.format((Date)jCCellDisplayEvent.getCellData());
                jCCellDisplayEvent.setDisplayData(string);
            } else if (jCCellDisplayEvent.getColumn() == 2) {
                String[] stringArray = HostnameResolver.getHostParts(jCCellDisplayEvent.getCellData().toString());
                String string = (String)this._$30416.get(stringArray[0]);
                if (string == null) {
                    this._$30136.add(stringArray[0]);
                } else {
                    jCCellDisplayEvent.setDisplayData(string + stringArray[1]);
                }
            }
        }
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.border2 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border2, "Variables");
        this.border3 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(this.borderLayout4);
        this.browsePanel.setBorder(this.border3);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/History16.gif");
        this.jToggleButtonHistory.setIcon(new ImageIcon(uRL));
        this.jToggleButtonHistory.setToolTipText("Show notification history");
        this.jToggleButtonHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jToggleButtonHistory_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Remove16.gif");
        this.jButtonDelete.setIcon(new ImageIcon(uRL));
        this.jButtonDelete.setToolTipText("Delete selected notifications");
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonDelete_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Import16.gif");
        this.jButtonAck.setIcon(new ImageIcon(uRL));
        this.jButtonAck.setToolTipText("Acknowledge notification and store it in alarm history");
        this.jButtonAck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonAck_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Undo16.gif");
        this.jButtonUndo.setIcon(new ImageIcon(uRL));
        this.jButtonUndo.setToolTipText("Undo last change");
        this.jButtonUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonUndo_actionPerformed(actionEvent);
            }
        });
        this.flowLayout1.setAlignment(0);
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Redo16.gif");
        this.jButtonRedo.setIcon(new ImageIcon(uRL));
        this.jButtonRedo.setToolTipText("Redo last change");
        this.jButtonRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonRedo_actionPerformed(actionEvent);
            }
        });
        this.jPanelNorth.setLayout(this.flowLayout1);
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/media/Pause16.gif");
        this.jToggleButtonPause.setIcon(new ImageIcon(uRL));
        this.jToggleButtonPause.setToolTipText("Pause auto scrolling");
        this.jToggleButtonPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jToggleButtonPause_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/SaveAs16.gif");
        this._$30412.setToolTipText("Save selected traps as PDUs");
        this._$30412.setIcon(new ImageIcon(uRL));
        this._$30412.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonSaveAsPDU_actionPerformed(actionEvent);
            }
        });
        uRL = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Properties16.gif");
        this._$29533.setToolTipText("Set priorities dependent on trap OIDs");
        this._$29533.setIcon(new ImageIcon(uRL));
        this._$29533.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrapReceiverDialog.this.jButtonPreferences_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.browsePanel, "bottom");
        this.jSplitPane1.add((Component)this.table, "top");
        this.add((Component)this.jPanelNorth, "North");
        this.jPanelNorth.add((Component)this.jToolBar, null);
        this.jToolBar.add((Component)this.jButtonAck, null);
        this.jToolBar.add((Component)this._$30412, null);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.jButtonDelete, null);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.jButtonRedo, null);
        this.jToolBar.add((Component)this.jButtonUndo, null);
        this.jToolBar.add((Component)this._$29533, null);
        this.jToolBar.addSeparator();
        this.jToolBar.add((Component)this.jToggleButtonHistory, null);
        this.jToolBar.setName("Trap Receiver Tool Bar");
        this.jPanelNorth.add((Component)this.jToolBarStatus, null);
        this.jToolBarStatus.add((Component)this.jToggleButtonPause, null);
        this.jToolBarStatus.addSeparator();
        this.jToolBarStatus.add((Component)this.statusBar, null);
        this.jToolBarStatus.setName("Trap Receiver Status");
        ToolBarUtils.setMinimumButtonSize(this.jToolBarStatus);
        ToolBarUtils.setMinimumButtonSize(this.jToolBar);
        this.jSplitPane1.setDividerLocation(150);
    }

    public JCEditableVectorDataSource getModel() {
        return this._$4260;
    }

    public void setModel(JCEditableVectorDataSource jCEditableVectorDataSource) {
        this.table.resetSortedRows();
        this._$4260 = jCEditableVectorDataSource;
        this._$4260.setColumnLabels(_$30402);
        this.table.setDataSource(this._$4260);
        this._$18933 = new TableSorter(this.table, this._$4260);
        this.jToggleButtonHistory_actionPerformed(new ActionEvent(this, 0, null));
        this._$18933.sort();
        this._$30429();
    }

    public DataViewModel getTableDataView() {
        return this.table.getDataView();
    }

    private static IpAddress _$18988(VariableBinding[] variableBindingArray) {
        for (int i = 0; i < variableBindingArray.length; ++i) {
            if (!variableBindingArray[i].getOid().equals(SnmpConstants.snmpTrapAddress) || variableBindingArray[i].getSyntax() != 64) continue;
            return (IpAddress)variableBindingArray[i].getVariable();
        }
        return null;
    }

    public static TimeTicks getTimestamp(VariableBinding[] variableBindingArray) {
        for (int i = 0; i < 2 && i < variableBindingArray.length; ++i) {
            if (!variableBindingArray[i].getOid().equals(SnmpConstants.sysUpTime)) continue;
            Variable variable = variableBindingArray[i].getVariable();
            if (variable instanceof TimeTicks) {
                return (TimeTicks)variable;
            }
            return null;
        }
        return null;
    }

    public static OID getTrapOID(PDU pDU) {
        if (pDU instanceof PDUv1) {
            return TrapReceiverDialog.getTrapOID((PDUv1)pDU);
        }
        VariableBinding[] variableBindingArray = pDU.toArray();
        if (variableBindingArray == null) {
            return null;
        }
        return TrapReceiverDialog.getTrapOID(variableBindingArray);
    }

    public static OID getTrapOID(VariableBinding[] variableBindingArray) {
        for (int i = 0; i < 2 && i < variableBindingArray.length; ++i) {
            if (!variableBindingArray[i].getOid().equals(SnmpConstants.snmpTrapOID)) continue;
            Variable variable = variableBindingArray[i].getVariable();
            if (variable instanceof OID) {
                return (OID)variable;
            }
            return null;
        }
        return null;
    }

    public static OID getTrapOID(PDUv1 pDUv1) {
        OID oID;
        if (pDUv1.getGenericTrap() != 6) {
            oID = new OID("1.3.6.1.6.3.1.1.5");
            oID.append(pDUv1.getGenericTrap() + 1);
        } else {
            oID = new OID(pDUv1.getEnterprise().toString());
            oID.append(0);
            oID.append(pDUv1.getSpecificTrap());
        }
        return oID;
    }

    private Color _$30432(ObjectID objectID) {
        Level level = this._$18901.getLoggingLevel((ObjectID)objectID).level;
        switch (level.toInt()) {
            case 40000: {
                return Color.orange;
            }
            case 30000: {
                return Color.yellow;
            }
            case 50000: {
                return Color.red;
            }
        }
        return null;
    }

    public synchronized void processPdu(CommandResponderEvent commandResponderEvent) {
        OID oID;
        TimeTicks timeTicks;
        Object object;
        PDU pDU = commandResponderEvent.getPDU();
        VariableBinding[] variableBindingArray = pDU.getVariableBindings().toArray(new VariableBinding[0]);
        String string = commandResponderEvent.getSource() instanceof TrapSelector ? ((TrapSelector)commandResponderEvent.getSource()).getSourceAddress() : (commandResponderEvent.getSource() instanceof MonitorConfigPanel ? "MIB Explorer" : "unknown");
        if (commandResponderEvent.getPDU() instanceof PDUv1) {
            object = (VariableBinding[])pDU;
            timeTicks = new TimeTicks(((PDUv1)object).getTimestamp());
            oID = TrapReceiverDialog.getTrapOID((PDUv1)object);
        } else {
            oID = TrapReceiverDialog.getTrapOID(variableBindingArray);
            timeTicks = TrapReceiverDialog.getTimestamp(variableBindingArray);
            if (oID != null && timeTicks != null) {
                object = new VariableBinding[variableBindingArray.length - 2];
                System.arraycopy(variableBindingArray, 2, object, 0, variableBindingArray.length - 2);
                variableBindingArray = object;
            } else {
                SnmpLogger.cTrapRcv.error("SNMPv2c/v3 trap encoding error: missing sysUpTime or trapOID variable binding");
                return;
            }
        }
        if (!this.jToggleButtonPause.isSelected()) {
            this.table.resetSortedRows();
        }
        object = new Vector(_$30402.length);
        ((Vector)object).addElement(new Boolean(false));
        ((Vector)object).addElement(new ObjectID(oID.toString()));
        if (pDU instanceof PDUv1) {
            ((Vector)object).addElement(((PDUv1)pDU).getAgentAddress().toString());
        } else if (commandResponderEvent.getPeerAddress() != null) {
            ((Vector)object).addElement(commandResponderEvent.getPeerAddress().toString());
        } else {
            ((Vector)object).addElement(((MonitorConfigPanel)commandResponderEvent.getSource()).getTitle());
        }
        ((Vector)object).addElement(string);
        ((Vector)object).addElement(timeTicks);
        ((Vector)object).addElement(new OctetString(commandResponderEvent.getSecurityName()));
        ((Vector)object).addElement(GenTarget.getVersionString(commandResponderEvent.getMessageProcessingModel()));
        if (commandResponderEvent.getMessageProcessingModel() == 3) {
            ((Vector)object).addElement(new OctetString(((ScopedPDU)pDU).getContextName()));
            ((Vector)object).addElement(new OctetString(((ScopedPDU)pDU).getContextEngineID()).toHexString());
        } else {
            ((Vector)object).addElement(new OctetString());
            ((Vector)object).addElement("");
        }
        Vector<VariableBinding> vector = new Vector<VariableBinding>(variableBindingArray.length + 1);
        for (int i = 0; i < variableBindingArray.length; ++i) {
            vector.addElement(variableBindingArray[i]);
        }
        ((Vector)object).addElement(vector);
        ++this._$30403;
        if (!this.jToggleButtonPause.isSelected()) {
            this._$4260.addRow(Integer.MAX_VALUE, new Date(), (Vector)object);
            this._$18933.sort();
            this.table.traverse(this._$4260.getNumRows() - 1, 0, false, false);
        } else {
            this._$30411.addElement(new Pair(new Date(), object));
        }
        this._$30436();
        this._$30429();
    }

    public void setDisplayOID(boolean bl) {
        this._$29665 = bl;
    }

    public boolean isDisplayOID() {
        return this._$29665;
    }

    public void undo() {
        this.table.cancelEdit(true);
        this._$29661.undo();
        this.updateButtons();
    }

    public void redo() {
        this.table.cancelEdit(true);
        this._$29661.redo();
        this.updateButtons();
    }

    void jButtonAck_actionPerformed(ActionEvent actionEvent) {
        Collection collection = this.table.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (int i = 0; i < jCCellRangeArray.length; ++i) {
            TableUtils.setRangeAfterCopy(jCCellRangeArray[i]);
            if (jCCellRangeArray[i].start_row >= this._$4260.getNumRows()) continue;
            for (int j = jCCellRangeArray[i].start_row; j <= jCCellRangeArray[i].end_row; ++j) {
                if (this.table.isRowHidden(j)) continue;
                this.table.setRowHidden(j, true);
                --this._$30403;
                boolean bl = (Boolean)this.table.getDataView().getTableDataItem(j, 0);
                this.table.getDataView().setTableDataItem(new Boolean(!bl), j, 0);
                this._$29661.addEdit(new HistoryEdit(j));
            }
        }
        this.table.clearSelection();
        this.updateButtons();
    }

    public void updateButtons() {
        this.jButtonUndo.setEnabled(this._$29661.canUndo());
        this.jButtonRedo.setEnabled(this._$29661.canRedo());
        this.jButtonAck.setEnabled(!this.jToggleButtonHistory.isSelected() && TableUtils.getFirstSelectedRow(this.table) >= 0);
        this._$30429();
    }

    private void _$30429() {
        int n = this._$30411.size();
        int n2 = this._$4260.getNumRows() - 1 + n;
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(this._$30403);
        stringBuffer.append(" New | ");
        stringBuffer.append(n2 - this._$30403);
        stringBuffer.append(" Acknowledged | ");
        stringBuffer.append(n);
        stringBuffer.append(" Hidden | ");
        stringBuffer.append(n2);
        stringBuffer.append(" Total");
        this.statusBar.setText(stringBuffer.toString());
        if (this._$4364 != null) {
            this._$4364.setMessage("Traps (" + this._$30403 + " New)");
        }
    }

    private void _$30436() {
        if (this._$30400 == 0.0f || this.isPaused()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this._$30399 <= 0L) {
            this._$30398 = 0.0f;
            this._$30399 = l;
        } else {
            long l2 = l - this._$30399;
            this._$30398 -= (float)l2 / this._$18928 * this._$30400;
            this._$30398 += 1.0f;
            if (this._$30398 < 0.0f) {
                this._$30398 = 0.0f;
            }
            this._$30399 = l;
        }
        if (this._$30398 > this._$30400) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TrapReceiverDialog.this.jToggleButtonPause.setSelected(true);
                }
            });
        }
    }

    void jButtonDelete_actionPerformed(ActionEvent actionEvent) {
        Collection collection = this.table.getSelectedCells();
        if (collection == null) {
            return;
        }
        JCCellRange[] jCCellRangeArray = new JCCellRange[collection.size()];
        collection.toArray(jCCellRangeArray);
        for (int i = 0; i < jCCellRangeArray.length; ++i) {
            Object object;
            int n;
            TableUtils.setRangeAfterCopy(jCCellRangeArray[i]);
            if (jCCellRangeArray[i].start_row >= this._$4260.getNumRows()) continue;
            Vector vector = new Vector();
            for (n = jCCellRangeArray[i].start_row; n <= jCCellRangeArray[i].end_row; ++n) {
                object = new Vector<Object>();
                ((Vector)object).addElement(this._$4260.getTableRowLabel(n));
                for (int j = 0; j <= this._$4260.getNumColumns(); ++j) {
                    ((Vector)object).addElement(this._$4260.getTableDataItem(n, j));
                }
                vector.addElement(object);
            }
            this._$4260.deleteRows(jCCellRangeArray[i].start_row, jCCellRangeArray[i].end_row - jCCellRangeArray[i].start_row + 1);
            n = jCCellRangeArray[i].start_row;
            object = vector.elements();
            while (object.hasMoreElements()) {
                Vector vector2 = (Vector)object.nextElement();
                Object e = vector2.firstElement();
                vector2.removeElementAt(0);
                this._$29661.addEdit(new RowAddEdit(n, false, e, vector2));
                boolean bl = (Boolean)vector2.firstElement();
                if (bl) continue;
                --this._$30403;
            }
        }
        this.table.clearSelection();
        this.updateButtons();
    }

    void jButtonUndo_actionPerformed(ActionEvent actionEvent) {
        this.undo();
    }

    void jButtonRedo_actionPerformed(ActionEvent actionEvent) {
        this.redo();
    }

    void jToggleButtonHistory_actionPerformed(ActionEvent actionEvent) {
        this._$30403 = 0;
        boolean bl = this.jToggleButtonHistory.isSelected();
        for (int i = 1; i < this._$4260.getNumRows(); ++i) {
            boolean bl2 = (Boolean)this._$4260.getTableDataItem(i, 0);
            if (!bl2) {
                ++this._$30403;
            }
            this.table.setRowHidden(i, bl2 != bl);
        }
        this.updateButtons();
        this.browsePanel.clear();
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        int n = jCSelectEvent.getStartRow();
        this.browsePanel.clear();
        Object object = this._$4260.getTableDataItem(n, 9);
        if (!(object instanceof Vector)) {
            return;
        }
        Vector vector = (Vector)object;
        Object[] objectArray = new VariableBinding[vector.size()];
        vector.copyInto(objectArray);
        vector = this.browsePanel.makeRow(null, (VariableBinding[])objectArray);
        String string = _$30401.format((Date)this._$4260.getTableRowLabel(n));
        this.browsePanel.set(vector, 0, 0);
        this.updateButtons();
    }

    public void setDividerLocation(int n) {
        this.jSplitPane1.setDividerLocation(n);
    }

    public int getDividerLocation() {
        return this.jSplitPane1.getDividerLocation();
    }

    public boolean isPaused() {
        return this.jToggleButtonPause.isSelected();
    }

    synchronized void jToggleButtonPause_actionPerformed(ActionEvent actionEvent) {
        if (!this.jToggleButtonPause.isSelected()) {
            this._$30398 = 0.0f;
            this.table.setRepaintEnabled(false);
            Enumeration enumeration = this._$30411.elements();
            while (enumeration.hasMoreElements()) {
                Pair pair = (Pair)enumeration.nextElement();
                this._$4260.addRow(Integer.MAX_VALUE, pair.first, (Vector)pair.second);
            }
            this._$30411.removeAllElements();
            this._$18933.sort();
            this.table.setRepaintEnabled(true);
            this.table.traverse(this._$4260.getNumRows() - 1, 0, false, false);
        }
        this._$30429();
    }

    public void removeMIBObjectListener(MIBObjectListener mIBObjectListener) {
        this.browsePanel.removeMIBObjectListener(mIBObjectListener);
    }

    public void addMIBObjectListener(MIBObjectListener mIBObjectListener) {
        this.browsePanel.addMIBObjectListener(mIBObjectListener);
    }

    private ValueConverter _$29800(ObjectID objectID, Class clazz) {
        try {
            Pair pair = this._$18643.getSplittedObjectID(objectID);
            MIBObject mIBObject = this._$18643.getObject((ObjectID)pair.first);
            if (mIBObject != null && mIBObject instanceof MIBObjectType) {
                MIBObjectType mIBObjectType = (MIBObjectType)mIBObject;
                MIBTextualConvention mIBTextualConvention = this._$18643.getEffectiveSyntax(mIBObjectType.getSyntax());
                return new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            // empty catch block
        }
        return new ValueConverter(clazz);
    }

    private JCEditableVectorDataSource _$29856(int n) {
        Vector vector = (Vector)this._$4260.getTableDataItem(n, 9);
        if (vector == null) {
            vector = new Vector(1);
        }
        String string = this._$4260.getTableDataItem(n, 6).toString();
        int n2 = 2;
        if (string.equals(GenTarget.getVersionString(0))) {
            n2 = 3;
        }
        Object[] objectArray = new VariableBinding[vector.size()];
        vector.copyInto(objectArray);
        JCEditableVectorDataSource jCEditableVectorDataSource = new JCEditableVectorDataSource();
        jCEditableVectorDataSource.setNumColumns(MultiVariablePanel.TITLES.length);
        jCEditableVectorDataSource.setNumRows(0);
        jCEditableVectorDataSource.setColumnLabels(MultiVariablePanel.TITLES);
        jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(0), null);
        Vector<Object> vector2 = new Vector<Object>(MultiVariablePanel.TITLES.length);
        ObjectID objectID = new ObjectID(SnmpConstants.sysUpTime.toString());
        vector2.add(objectID);
        vector2.add(new Integer(11));
        ValueConverter valueConverter = this._$29800(objectID, TimeTicks.class);
        vector2.add(valueConverter.toNative((TimeTicks)this._$4260.getTableDataItem(n, 4)));
        vector2.add(valueConverter);
        jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(1), vector2);
        vector2 = new Vector(MultiVariablePanel.TITLES.length);
        objectID = new ObjectID(SnmpConstants.snmpTrapOID.toString());
        vector2.add(objectID);
        vector2.add(new Integer(2));
        vector2.add(this._$4260.getTableDataItem(n, 1));
        vector2.add(this._$29800(objectID, OID.class));
        jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(2), vector2);
        if (n2 == 3) {
            vector2 = new Vector(MultiVariablePanel.TITLES.length);
            objectID = new ObjectID(SnmpConstants.snmpTrapAddress.toString());
            vector2.add(objectID);
            vector2.add(new Integer(9));
            valueConverter = this._$29800(objectID, IpAddress.class);
            vector2.add(valueConverter.toNative(new IpAddress(this._$4260.getTableDataItem(n, 2).toString())));
            vector2.add(valueConverter);
            jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(3), vector2);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            vector2 = new Vector(MultiVariablePanel.TITLES.length);
            objectID = new ObjectID(((VariableBinding)objectArray[i]).getOid().toString());
            valueConverter = this._$29800(objectID, ((VariableBinding)objectArray[i]).getVariable().getClass());
            vector2.add(objectID);
            vector2.add(new Integer(valueConverter.getSMISyntax()));
            vector2.add(valueConverter.toNative(((VariableBinding)objectArray[i]).getVariable()));
            vector2.add(valueConverter);
            jCEditableVectorDataSource.addRow(Integer.MAX_VALUE, new Integer(n2 + i + 1), vector2);
        }
        return jCEditableVectorDataSource;
    }

    public boolean saveSelected() {
        int n = TableUtils.getFirstSelectedRow(this.table);
        if (n < 0) {
            return false;
        }
        JFileChooser jFileChooser = new JFileChooser(this._$4288.get("mibexplorer.PDUPath", ""));
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter();
        exampleFileFilter.addExtension("pdu");
        exampleFileFilter.setDescription("MIB Explorer PDU Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(this._$4288.get("mibexplorer.PDUPath", "")));
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 == 0) {
            this._$4288.put("mibexplorer.PDUPath", jFileChooser.getSelectedFile().getParent());
            try {
                Object[] objectArray;
                int n3;
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().toUpperCase().endsWith(".PDU")) {
                    file = new File(file.getParentFile(), file.getName() + ".pdu");
                }
                if (Boolean.valueOf(this._$4288.get("mibexplorer.AskBeforeOverwritingFile", "true")).booleanValue() && file.exists() && (n3 = JOptionPane.showOptionDialog(this, "File already exists! Replace it?", "Confirm Replace", 0, 3, null, objectArray = new Object[]{"Yes", "Cancel"}, objectArray[1])) == 1) {
                    return true;
                }
                objectArray = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)objectArray);
                objectOutputStream.writeObject(this._$29856(n));
                objectOutputStream.flush();
                objectOutputStream.close();
                JOptionPane.showMessageDialog(this._$18902, "Saved PDU to " + file.getPath(), "Saved", 1);
                return true;
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{"Error while saving PDU file:", exception.getMessage()};
                JOptionPane.showMessageDialog(this._$18902, stringArray, "IO Error", 0);
                return false;
            }
        }
        return false;
    }

    void jButtonSaveAsPDU_actionPerformed(ActionEvent actionEvent) {
        this.saveSelected();
    }

    void jButtonPreferences_actionPerformed(ActionEvent actionEvent) {
        PrioritiesPanel prioritiesPanel = new PrioritiesPanel(this._$4288, this._$18643);
        StandardDialog standardDialog = new StandardDialog((Frame)this._$18902, "Trap Severities", true, true);
        standardDialog.setCenterPanel(prioritiesPanel);
        standardDialog.setLocationRelativeTo(this);
        prioritiesPanel.load();
        standardDialog.setVisible(true);
        if (standardDialog.getResult() == 0) {
            prioritiesPanel.save();
            this._$18901.loadPriorities();
            this.table.repaint();
        }
    }

    public Map getHostnames() {
        return this._$30416;
    }

    public void setMaxqueue(float f) {
        this._$30400 = f;
    }

    public float getMaxqueue() {
        return this._$30400;
    }

    public float getInterval() {
        return this._$18928;
    }

    public StatusBar getTitle() {
        return this._$4364;
    }

    public void setInterval(float f) {
        this._$18928 = f;
    }

    public void setTitle(StatusBar statusBar) {
        this._$4364 = statusBar;
    }

    public boolean isBring2FrontOnTrap() {
        return this._$30417;
    }

    public void updateConfig() {
        this._$30417 = this._$4288.getBoolean("mibexplorer.trap.toFront", false);
        this._$30418 = this._$4288.getBoolean("mibexplorer.trap.beep", false);
        this._$30400 = this._$4288.getInteger("mibexplorer.trap.autoinhibition.queue.size", 2);
    }

    public boolean isBeepOnTrap() {
        return this._$30418;
    }

    class TrapOIDRenderer
    extends JCLabelCellRenderer {
        public Component getRendererComponent(JCCellInfo jCCellInfo, Object object, boolean bl) {
            super.getRendererComponent(jCCellInfo, object, bl);
            if (!bl && object != null) {
                Color color;
                ObjectID objectID = object instanceof ObjectID ? (ObjectID)object : new ObjectID(object.toString());
                ObjectID objectID2 = TrapReceiverDialog.this._$18643.resolveOID(objectID);
                if (objectID2 != null && (color = TrapReceiverDialog.this._$30432(objectID2)) != null) {
                    this.setOpaque(true);
                    this.setBackground(color);
                }
            }
            return this;
        }
    }

    class HistoryEdit
    extends AbstractUndoableEdit {
        private int _$4402;

        public HistoryEdit(int n) {
            this._$4402 = n;
        }

        public void undo() {
            super.undo();
            boolean bl = TrapReceiverDialog.this.jToggleButtonHistory.isSelected();
            TrapReceiverDialog.this.table.getDataView().setTableDataItem(new Boolean(bl), this._$4402, 0);
            TrapReceiverDialog.this.table.setRowHidden(this._$4402, bl);
            TrapReceiverDialog.this._$30403++;
            TrapReceiverDialog.this._$30429();
        }

        public void redo() {
            super.redo();
            boolean bl = !TrapReceiverDialog.this.jToggleButtonHistory.isSelected();
            TrapReceiverDialog.this.table.getDataView().setTableDataItem(new Boolean(bl), this._$4402, 0);
            TrapReceiverDialog.this.table.setRowHidden(this._$4402, bl);
            TrapReceiverDialog.this._$30403--;
            TrapReceiverDialog.this._$30429();
        }
    }

    class RowAddEdit
    extends AbstractUndoableEdit {
        private int _$4402;
        private boolean _$12164 = true;
        private Vector _$4418;
        private Object _$30445;

        public RowAddEdit(int n, boolean bl, Object object, Vector vector) {
            this._$4402 = n;
            this._$12164 = bl;
            this._$4418 = vector;
            this._$30445 = object;
        }

        public void undo() {
            super.undo();
            if (this._$12164) {
                if (!TrapReceiverDialog.this._$4260.deleteRows(this._$4402, 1)) {
                    throw new CannotUndoException();
                }
                if (!((Boolean)this._$4418.firstElement()).booleanValue()) {
                    TrapReceiverDialog.this._$30403--;
                }
            } else {
                if (!TrapReceiverDialog.this._$4260.addRow(this._$4402, this._$30445, this._$4418)) {
                    throw new CannotUndoException();
                }
                if (!((Boolean)this._$4418.firstElement()).booleanValue()) {
                    TrapReceiverDialog.this._$30403++;
                }
            }
            TrapReceiverDialog.this._$30429();
        }

        public void redo() {
            super.redo();
            if (this._$12164) {
                if (!TrapReceiverDialog.this._$4260.addRow(this._$4402, this._$30445, this._$4418)) {
                    throw new CannotRedoException();
                }
                if (!((Boolean)this._$4418.firstElement()).booleanValue()) {
                    TrapReceiverDialog.this._$30403++;
                }
            } else {
                if (!TrapReceiverDialog.this._$4260.deleteRows(this._$4402, 1)) {
                    throw new CannotRedoException();
                }
                if (!((Boolean)this._$4418.firstElement()).booleanValue()) {
                    TrapReceiverDialog.this._$30403--;
                }
            }
            TrapReceiverDialog.this._$30429();
        }
    }
}

