/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.traps;

import com.agentpp.common.net.HostnameResolver;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.explorer.script.MIBContext;
import com.agentpp.explorer.script.PduBean;
import com.agentpp.explorer.script.ScriptContext;
import com.agentpp.explorer.script.UtilsContext;
import com.agentpp.explorer.traps.TrapReceiverDialog;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smi.IObjectID;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.UserConfigFile;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;

public class TrapProxy
implements CommandResponder {
    private Snmp _$4261;
    private UserConfigFile _$4288;
    private transient Vector _$30132;
    private Vector _$30133 = new Vector();
    private Hashtable _$30134;
    private GenTarget _$29778;
    private Hashtable _$4957;
    private RepositoryManager _$18642;
    private MIBRepository _$18643 = new MIBRepository();
    private SnmpLogger _$30135;
    private HostnameResolver _$30136 = null;

    public TrapProxy(UserConfigFile userConfigFile, GenTarget genTarget, Hashtable hashtable, RepositoryManager repositoryManager, Snmp snmp) {
        this._$4288 = userConfigFile;
        this._$4261 = snmp;
        this._$29778 = genTarget;
        this._$4957 = hashtable;
        this._$18642 = repositoryManager;
        this._$30135 = new SnmpLogger(this._$18643);
    }

    public void loadConfig() {
        this.loadPriorities();
    }

    public synchronized void loadPriorities() {
        this._$30134 = new Hashtable();
        Vector vector = this._$4288.getArray("mibexplorer.trap.priorities.OID");
        Vector vector2 = this._$4288.getArray("mibexplorer.trap.priorities.level", vector.size());
        Vector vector3 = this._$4288.getArray("mibexplorer.trap.priorities.script", vector.size());
        Vector vector4 = this._$4288.getArray("mibexplorer.trap.priorities.comment", vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            File file = null;
            String string2 = null;
            if (vector3.size() > i && vector3.elementAt(i) != null && !(file = new File((String)vector3.elementAt(i))).isFile()) {
                SnmpLogger.cTrapRcv.warn("Trap script '" + file.getPath() + "' not found");
                file = null;
            }
            if (vector4.size() > i) {
                string2 = (String)vector4.get(i);
            }
            if ((string = (String)vector.elementAt(i)) == null) {
                string = "";
            }
            this._$30134.put(new ObjectID(string), new TrapConfig(Level.toLevel(vector2.elementAt(i).toString()), file, string2, null));
        }
    }

    public TrapConfig getLoggingLevel(ObjectID objectID) {
        if (objectID == null) {
            return new TrapConfig(Level.ERROR, null, null, null);
        }
        TrapConfig trapConfig = new TrapConfig(Level.INFO, null, null, objectID);
        while (objectID.size() > 0) {
            TrapConfig trapConfig2 = (TrapConfig)this._$30134.get(objectID);
            if (trapConfig2 != null) {
                return trapConfig2;
            }
            objectID = ObjectID.trim(objectID);
        }
        return trapConfig;
    }

    private TrapConfig _$30145(PDU pDU) {
        ObjectID objectID = null;
        if (pDU instanceof PDUv1) {
            objectID = new ObjectID(TrapReceiverDialog.getTrapOID((PDUv1)pDU).getValue());
        } else {
            OID oID = TrapReceiverDialog.getTrapOID(pDU.toArray());
            if (oID != null) {
                objectID = new ObjectID(oID.getValue());
            }
        }
        return this.getLoggingLevel(objectID);
    }

    public synchronized void processPdu(CommandResponderEvent commandResponderEvent) {
        TrapConfig trapConfig = this._$30145(commandResponderEvent.getPDU());
        SnmpLogger.logTrapReceived(commandResponderEvent, trapConfig.level);
        if (commandResponderEvent.getPDU().getType() == -90) {
            // empty if block
        }
        Object object = this._$30132.elements();
        while (object.hasMoreElements()) {
            CommandResponder commandResponder = (CommandResponder)object.nextElement();
            commandResponder.processPdu(commandResponderEvent);
        }
        if (trapConfig.script != null) {
            try {
                object = new ScriptThread(ScriptContext.getScriptText((String)trapConfig.script.getPath()), trapConfig.script, commandResponderEvent.getPDU(), commandResponderEvent.getPeerAddress(), trapConfig);
                ((ScriptThread)object).run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Vector getCurrentConfig() {
        return this._$30133;
    }

    public synchronized void removeTrapListener(CommandResponder commandResponder) {
        if (this._$30132 != null && this._$30132.contains(commandResponder)) {
            Vector vector = (Vector)this._$30132.clone();
            vector.removeElement(commandResponder);
            this._$30132 = vector;
        }
    }

    public synchronized void addTrapListener(CommandResponder commandResponder) {
        Vector vector;
        Vector vector2 = vector = this._$30132 == null ? new Vector(2) : (Vector)this._$30132.clone();
        if (!vector.contains(commandResponder)) {
            vector.addElement(commandResponder);
            this._$30132 = vector;
        }
    }

    public void saveCurrentConfig() {
        Vector<String> vector = new Vector<String>(this._$30133.size() + 1);
        int n = 0;
        Enumeration enumeration = this._$30133.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2 = (Vector)enumeration.nextElement();
            vector.addElement(vector2.firstElement().toString());
            ++n;
        }
        this._$4288.putArray("mibexplorer.TrapAddress", vector);
    }

    public Snmp getSession() {
        return this._$4261;
    }

    public void setTargets(Hashtable hashtable) {
        this._$4957 = hashtable;
    }

    public void setDefaultTarget(GenTarget genTarget) {
        this._$29778 = genTarget;
    }

    public void setHostnameResolver(HostnameResolver hostnameResolver) {
        this._$30136 = hostnameResolver;
    }

    class ScriptThread
    implements Runnable {
        private VelocityContext _$12191;
        private ScriptContext _$29744;
        private MIBContext _$29898;
        private String _$4142;
        private File _$29709;

        public ScriptThread(String string, File file, PDU pDU, Address address, TrapConfig trapConfig) {
            String[] stringArray;
            this._$4142 = string;
            this._$29709 = file;
            this._$12191 = new VelocityContext();
            if (pDU instanceof PDUv1) {
                stringArray = (String[])pDU;
                PDU pDU2 = new PDU();
                VariableBinding variableBinding = new VariableBinding(SnmpConstants.sysUpTime, new TimeTicks(stringArray.getTimestamp()));
                pDU2.add(variableBinding);
                variableBinding = stringArray.getGenericTrap() == 6 ? new VariableBinding(SnmpConstants.snmpTrapOID, new OID(stringArray.getEnterprise().toString() + ".0." + stringArray.getSpecificTrap())) : new VariableBinding(SnmpConstants.snmpTrapOID, new OID(SnmpConstants.snmpTraps.toString() + "." + stringArray.getGenericTrap()));
                pDU2.add(variableBinding);
                for (int i = 0; i < pDU.size(); ++i) {
                    pDU2.add(pDU.get(i));
                }
                pDU = pDU2;
            }
            this._$29744 = new ScriptContext(TrapProxy.this._$4261, TrapProxy.this._$4288, TrapProxy.this._$29778, TrapProxy.this._$4957, TrapProxy.this._$30135, TrapProxy.this._$18643, file.getPath(), new PduBean(TrapProxy.this._$18643, pDU, null));
            this._$29898 = new MIBContext(TrapProxy.this._$18642, TrapProxy.this._$18643);
            this._$12191.put("snmp", this._$29744);
            this._$12191.put("mib", this._$29898);
            this._$12191.put("utils", new UtilsContext());
            this._$12191.put("severity", trapConfig.level.toString());
            this._$12191.put("comment", trapConfig.comment);
            this._$12191.put("sourceAddress", address.toString());
            stringArray = HostnameResolver.getHostParts(address.toString());
            if (TrapProxy.this._$30136 != null) {
                this._$12191.put("sourceHost", TrapProxy.this._$30136.getHostname(stringArray[0]));
            } else {
                this._$12191.put("sourceHost", stringArray[0]);
            }
            this._$12191.put("sourcePort", stringArray[1]);
        }

        public void run() {
            try {
                this._$29744.reinit();
                SnmpLogger.cTrapRcv.debug("Executing '" + this._$29709.getPath() + "' trap/notification script");
                StringWriter stringWriter = new StringWriter();
                Velocity.evaluate((Context)this._$12191, (Writer)stringWriter, this._$29709.getPath(), this._$4142);
                stringWriter.flush();
                stringWriter.close();
                SnmpLogger.cTrapRcv.debug("Output of trap script '" + this._$29709.getPath() + "' is: " + stringWriter.toString());
                SnmpLogger.cTrapRcv.info("Trap script '" + this._$29709.getPath() + "' executed successfully.");
            }
            catch (Exception exception) {
                SnmpLogger.cTrapRcv.fatal("Trap script execution failed: " + exception.getMessage());
            }
        }
    }

    public class TrapConfig {
        public Level level;
        public File script;
        public String comment;
        private ObjectID _$4512;

        public TrapConfig(Level level, File file, String string, ObjectID objectID) {
            this.level = level;
            this.script = file;
            this.comment = string;
            this._$4512 = objectID;
        }

        public IObjectID getNotificationID() {
            return this._$4512;
        }
    }
}

