/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.topology;

import com.agentpp.common.TableSorter;
import com.agentpp.common.table.PopupListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.ToolPanelPlugin;
import com.agentpp.explorer.topology.DiscoveryModel;
import com.agentpp.explorer.topology.TopoItem;
import com.agentpp.explorer.topology.TopologyConfigPanel;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.GenTargetEvent;
import com.agentpp.snmp.GenTargetListener;
import com.agentpp.snmp.UserProfile;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.snmp4j.netscan.MonitoredVariableBinding;
import com.snmp4j.netscan.NetworkScanner;
import com.snmp4j.netscan.SNMPScanEntity;
import com.snmp4j.netscan.ScanListener;
import com.snmp4j.netscan.ScanOID;
import com.snmp4j.netscan.ScanTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TransportIpAddress;

public class TopologyPanel
extends JPanel
implements ToolPanelPlugin,
CommandResponder,
JCSelectListener {
    private static Logger _$4326 = Logger.getLogger("Discoverer");
    private static final String[] _$33532 = new String[]{"Repeater", "Bridge", "Gateway", "Host", "Application"};
    private static final String[] _$5516 = new String[]{"Address", "Ping", "Source", "Hops", "Last Contact", "Forwarding", "Interfaces", "Versions", "System Name", "Up Time", "Location", "Contact", "Description", "System ID", "Services"};
    private static final int _$15016 = 0;
    private static final int _$33533 = 1;
    private static final int _$33534 = 8;
    private static final int[] _$14753 = new int[]{10, 4, 10, 5, 11, 5, 5, 5, 8, 10, 10, 15, 20, 10};
    BorderLayout borderLayout1 = new BorderLayout();
    private PopupListTable _$4160 = new PopupListTable(){

        public boolean isEditable(int n, int n2) {
            return false;
        }
    };
    private DiscoveryModel _$4260 = new DiscoveryModel();
    private NetworkScanner _$33535;
    private Hashtable _$4957;
    private JToolBar _$24769 = new JToolBar();
    private JButton _$33536 = new JButton();
    private JButton _$33537 = new JButton();
    private JButton _$33538 = new JButton();
    private UserConfigFile _$4288;
    private Vector _$33539 = new Vector(5);
    private Vector _$33540 = new Vector(5);
    private Vector _$33541 = new Vector();
    private GenTarget _$29778;
    private JScrollPane _$28742 = new JScrollPane();
    private JButton _$18874 = new JButton();
    private transient Vector _$33542;
    private TopologyConfigPanel _$5047;
    private Snmp _$4261;
    private TableSorter _$18933;
    private ScanTask _$33543;

    public TopologyPanel(UserConfigFile userConfigFile, MIBRepository mIBRepository, Snmp snmp, Hashtable hashtable) {
        this();
        this._$4288 = userConfigFile;
        this._$33535 = new NetworkScanner(snmp);
        this._$4957 = hashtable;
        this._$4261 = snmp;
        this._$33543 = new ScanTask();
        this._$4260.setRepository(mIBRepository);
        this._$33544();
        this._$5900();
        if (!this._$33535.isPingAvailable()) {
            this._$4160.setColumnHidden(1, true);
        }
    }

    public TopologyPanel() {
        this._$4260.setNumRows(0);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$4160.setRowLabelDisplay(false);
        this._$4160.setDataSource(this._$4260);
        this._$4160.addCellDisplayListener(this._$4260);
        this._$4160.addSelectListener(this);
        for (int i = 0; i < _$14753.length; ++i) {
            this._$4160.setCharWidth(i, _$14753[i]);
        }
    }

    private String[] _$33544() {
        this._$33541.setSize(0);
        Vector<OID> vector = new Vector<OID>(Arrays.asList(TopoItem.SYS_OIDS));
        for (int i = 0; i < TopoItem.SYS_OIDS.length; ++i) {
            this._$33541.add(new ScanOID(TopoItem.SYS_OIDS[i], 0));
        }
        Vector vector2 = this._$4288.getArray("mibexplorer.topo.instance");
        Vector vector3 = this._$4288.getArray("mibexplorer.topo.instance.title");
        String[] stringArray = new String[_$5516.length + vector2.size()];
        System.arraycopy(_$5516, 0, stringArray, 0, _$5516.length);
        for (int i = 0; i < vector2.size(); ++i) {
            stringArray[TopologyPanel._$5516.length + i] = (String)vector3.get(i);
            OID oID = new OID((String)vector2.get(i));
            vector.add(oID);
            this._$33541.add(new ScanOID(oID, 0));
        }
        this._$4260.setColumnOIDs(vector);
        this._$4260.setNumColumns(stringArray.length);
        this._$4260.setColumnLabels(stringArray);
        this._$18933 = new TableSorter((JCTable)this._$4160, (JCVectorDataSource)this._$4260, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof TransportIpAddress && object2 instanceof TransportIpAddress) {
                    byte[] byArray;
                    TransportIpAddress transportIpAddress = (TransportIpAddress)object;
                    TransportIpAddress transportIpAddress2 = (TransportIpAddress)object2;
                    byte[] byArray2 = transportIpAddress.getInetAddress().getAddress();
                    if (byArray2.length != (byArray = transportIpAddress2.getInetAddress().getAddress()).length) {
                        return byArray2.length - byArray.length;
                    }
                    for (int i = 0; i < byArray2.length; ++i) {
                        int n = (byArray2[i] & 0xFF) - (byArray[i] & 0xFF);
                        if (n == 0) continue;
                        return n;
                    }
                    return transportIpAddress.getPort() - transportIpAddress2.getPort();
                }
                if (object == null && object2 == null) {
                    return 0;
                }
                if (object == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                return object.toString().compareTo(object2.toString());
            }

            public boolean equals(Object object) {
                return this == object;
            }
        });
        return stringArray;
    }

    private void _$5900() {
        this._$5047 = new TopologyConfigPanel(this._$4288, this._$4260.getRepository());
        this._$5047.setTargets(this._$4957);
        this._$5047.load();
        this.setScanItemsFromTargets(this._$5047.getSeedTargets());
        this._$33543.addScanListener((ScanListener)this._$4260);
        this._$33543.setMaxHops(this._$4288.getInteger("mibexplorer.topo.maxhops", 10));
        this._$33543.setRefreshInterval((long)(this._$4288.getInteger("mibexplorer.topo.refresh", 60) * 1000));
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this._$33536.setToolTipText("Start discovery process");
        this._$33536.setIcon(MIBExplorerFrame.imagePlay16);
        this._$33536.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyPanel.this.startButton_actionPerformed(actionEvent);
            }
        });
        this._$33537.setEnabled(false);
        this._$33537.setToolTipText("Stop discovery process");
        this._$33537.setIcon(MIBExplorerFrame.imageStop16);
        this._$33537.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyPanel.this.stopButton_actionPerformed(actionEvent);
            }
        });
        this._$33538.setToolTipText("Start here to configure seed targets for the discovery and other properties");
        this._$33538.setIcon(MIBExplorerFrame.imagePreferences16);
        this._$33538.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyPanel.this.configButton_actionPerformed(actionEvent);
            }
        });
        this._$18874.setToolTipText("Add selected target(s) to the MIB Explorer configuration/preferences");
        this._$18874.setIcon(MIBExplorerFrame.imageAdd16);
        this._$18874.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TopologyPanel.this.jButtonAdd_actionPerformed(actionEvent);
            }
        });
        this._$4160.setSelectionPolicy(3);
        this.add((Component)this._$4160, "Center");
        this.add((Component)this._$24769, "North");
        this._$24769.add((Component)this._$33536, null);
        this._$24769.add((Component)this._$33537, null);
        this._$24769.addSeparator();
        this._$24769.add((Component)this._$18874, null);
        this._$24769.addSeparator();
        this._$24769.add((Component)this._$33538, null);
        this._$18874.setEnabled(false);
    }

    void stopButton_itemStateChanged(ItemEvent itemEvent) {
        this.stop();
    }

    void startButton_itemStateChanged(ItemEvent itemEvent) {
        this.restart();
    }

    void configButton_actionPerformed(ActionEvent actionEvent) {
        this._$5047.setTargets(this._$4957);
        this._$5047.load();
        if (JOptionPane.showConfirmDialog(this, this._$5047, "Discovery Preferences", 2, -1) == 0) {
            this._$5047.save();
            this.setScanItemsFromTargets(this._$5047.getSeedTargets());
            this._$33543.setRefreshInterval((long)(this._$4288.getInteger("mibexplorer.topo.refresh", 60) * 1000));
            this.restart();
        }
    }

    public void setScanItemsFromTargets(Vector vector) {
        this._$33539 = new Vector(vector.size() + 1);
        if (vector.size() == 0) {
            if (this._$29778 != null) {
                this._$33539.add(this._$29778.getTarget());
            }
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                GenTarget genTarget = (GenTarget)vector.get(i);
                if (genTarget == null) continue;
                this._$33539.add(genTarget.getTarget());
            }
        }
    }

    public void restart() {
        this.stop();
        this._$4260.reset();
        this._$33544();
        this._$33543.getScannedEntities().clear();
        this.start();
    }

    public UserConfigFile getConfig() {
        return this._$4288;
    }

    public void start() {
        try {
            this._$33543.getSeeds().clear();
            Iterator iterator = this._$33539.iterator();
            while (iterator.hasNext()) {
                this._$33543.addSeed((Target)iterator.next());
            }
            this._$33543.setScanOIDs((Vector)this._$33541.clone());
            this._$33535.start(this._$33543);
            this._$33536.setEnabled(false);
            this._$33537.setEnabled(true);
            _$4326.info("Discovering started...");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _$4326.error(exception);
        }
    }

    public void stop() {
        this._$33537.setEnabled(false);
        this._$33535.stop(this._$33543);
        _$4326.warn("Discoverer stopped, found " + this._$33543.getScannedEntities().size() + " NEs");
        this._$33536.setEnabled(true);
    }

    public void setTarget(GenTarget genTarget) {
        this._$29778 = genTarget;
    }

    public void setTargets(Hashtable hashtable) {
        this._$4957 = hashtable;
    }

    void startButton_actionPerformed(ActionEvent actionEvent) {
        this.restart();
    }

    void stopButton_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(){

            public void run() {
                TopologyPanel.this.stop();
            }
        };
        thread.start();
    }

    void jButtonAdd_actionPerformed(ActionEvent actionEvent) {
        this._$18874.setEnabled(false);
        this.addTargets();
    }

    public void addTargets() {
        int[] nArray = TableUtils.getSelectedRows(this._$4160);
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "No targets selected!", "No Selection", 2);
            this._$18874.setEnabled(true);
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            MonitoredVariableBinding monitoredVariableBinding = (MonitoredVariableBinding)this._$4260.getTableDataItem(nArray[i], 8);
            String string = "";
            if (monitoredVariableBinding == null || monitoredVariableBinding.getVariable() == null || !(monitoredVariableBinding.getVariable() instanceof OctetString)) {
                ++n2;
                continue;
            }
            string = ((OctetString)monitoredVariableBinding.getVariable()).toString();
            TopoItem topoItem = (TopoItem)this._$4260.getTableRowLabel(nArray[i]);
            if (topoItem.getDiscoveredItem() instanceof SNMPScanEntity) {
                SNMPScanEntity sNMPScanEntity = (SNMPScanEntity)topoItem.getDiscoveredItem();
                GenTarget genTarget = new GenTarget(sNMPScanEntity.getScanTarget(), string);
                if (sNMPScanEntity.getScanTarget() instanceof UserTarget) {
                    UserTarget userTarget = (UserTarget)sNMPScanEntity.getScanTarget();
                    UsmUserEntry usmUserEntry = this._$4261.getUSM().getUser(genTarget.getEngineID(), userTarget.getSecurityName());
                    if (usmUserEntry == null) {
                        _$4326.warn("User " + userTarget.getSecurityName() + " not found in USM! Skipping target " + sNMPScanEntity.getScanTarget());
                        continue;
                    }
                    genTarget.setUser(new UserProfile(userTarget.getSecurityName().toString(), usmUserEntry.getUsmUser()));
                } else {
                    genTarget.setCommunity(((CommunityTarget)sNMPScanEntity.getScanTarget()).getCommunity());
                }
                this.fireTargetChanged(new GenTargetEvent(this, genTarget, 1));
                ++n;
                continue;
            }
            ++n2;
        }
        if (n2 == 0) {
            JOptionPane.showMessageDialog(this, "Added " + n + " target(s) successfully!", "Discovered Targets Added", 1);
        } else {
            JOptionPane.showMessageDialog(this, new String[]{"Added " + n + " target(s) successfully, but skipped ", "" + n2 + " because of insufficient information!"}, "Discovered Targets Added", 2);
        }
        this._$18874.setEnabled(true);
    }

    public synchronized void removeGenTargetListener(GenTargetListener genTargetListener) {
        if (this._$33542 != null && this._$33542.contains(genTargetListener)) {
            Vector vector = (Vector)this._$33542.clone();
            vector.removeElement(genTargetListener);
            this._$33542 = vector;
        }
    }

    public synchronized void addGenTargetListener(GenTargetListener genTargetListener) {
        Vector vector;
        Vector vector2 = vector = this._$33542 == null ? new Vector(2) : (Vector)this._$33542.clone();
        if (!vector.contains(genTargetListener)) {
            vector.addElement(genTargetListener);
            this._$33542 = vector;
        }
    }

    protected void fireTargetChanged(GenTargetEvent genTargetEvent) {
        if (this._$33542 != null) {
            Vector vector = this._$33542;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GenTargetListener)vector.elementAt(i)).targetChanged(genTargetEvent);
            }
        }
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this._$18874.setEnabled(TableUtils.getSelectedRows(this._$4160).length > 0);
    }

    public void processPdu(CommandResponderEvent commandResponderEvent) {
        if (this._$33543.getSeeds().size() > 0) {
            if (_$4326.isInfoEnabled()) {
                _$4326.info("Adding seed " + commandResponderEvent.getPeerAddress() + " received from notification: " + commandResponderEvent);
            }
            Target target = (Target)this._$33543.getSeeds().get(0);
            target = (Target)target.clone();
            target.setAddress(commandResponderEvent.getPeerAddress());
            this._$33543.addSeed(target);
        }
    }

    public boolean onExit() {
        return false;
    }
}

