/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.topology;

import com.agentpp.explorer.topology.TopoItem;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.snmp4j.netscan.MonitoredVariableBinding;
import com.snmp4j.netscan.SNMPScanEntity;
import com.snmp4j.netscan.ScanEntity;
import com.snmp4j.netscan.ScanEvent;
import com.snmp4j.netscan.ScanListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DiscoveryModel
extends JCEditableVectorDataSource
implements ScanListener,
JCCellDisplayListener {
    private static final Logger _$4326 = Logger.getLogger("Discovery");
    private static final String _$29528 = "yyyy-MM-dd HH:mm:ss";
    private SimpleDateFormat _$30401 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private static final String[] _$33532 = new String[]{"Repeater", "Bridge", "Gateway", "Host", "Application"};
    private Hashtable _$33774 = new Hashtable(25);
    private Hashtable _$33775 = new Hashtable(25);
    private Vector _$29811;
    private MIBRepository _$18643;
    private boolean _$29665 = false;

    protected void addRow(TopoItem topoItem) {
        Vector<Object> vector = new Vector<Object>(super.getNumColumns());
        Integer n = null;
        if (topoItem.getDiscoveredItem() != null) {
            StringBuffer stringBuffer;
            ScanEntity scanEntity = topoItem.getDiscoveredItem();
            n = (Integer)this._$33775.get(topoItem.getKey());
            vector.add(topoItem.getDiscoveredItem().getAddress());
            vector.add(new Boolean(scanEntity.isReachable()));
            if (topoItem.getDiscoveredItem().getSource() != null) {
                vector.add(topoItem.getDiscoveredItem().getSource().getAddress());
            } else {
                vector.add(null);
            }
            vector.add(new Integer(scanEntity.getHopsFromRoot()));
            vector.add(new Date(scanEntity.getLastUpdateTime()));
            MonitoredVariableBinding monitoredVariableBinding = scanEntity.getVariable((OID)this._$29811.get(1));
            if (monitoredVariableBinding != null && monitoredVariableBinding.getVariable() instanceof Integer32) {
                int n2 = ((Integer32)monitoredVariableBinding.getVariable()).getValue();
                vector.add(n2 == 1 ? new Boolean(true) : new Boolean(false));
            } else {
                vector.add(null);
            }
            MonitoredVariableBinding monitoredVariableBinding2 = scanEntity.getVariable((OID)this._$29811.get(0));
            if (monitoredVariableBinding2 != null && monitoredVariableBinding2.getVariable() instanceof Integer32) {
                vector.add(monitoredVariableBinding2.getVariable());
            } else {
                vector.add("-");
            }
            if (!(scanEntity instanceof SNMPScanEntity)) {
                vector.add("?");
            } else {
                SNMPScanEntity sNMPScanEntity = (SNMPScanEntity)scanEntity;
                stringBuffer = new StringBuffer(10);
                if (sNMPScanEntity.isSNMPv1()) {
                    stringBuffer.append("v1");
                }
                if (sNMPScanEntity.isSNMPv2c()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("v2c");
                }
                if (sNMPScanEntity.isSNMPv3()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("v3");
                }
                vector.add(stringBuffer.toString());
            }
            for (int i = 2; i < this._$29811.size(); ++i) {
                stringBuffer = scanEntity.getVariable((OID)this._$29811.get(i));
                if (stringBuffer != null) {
                    vector.add(stringBuffer);
                    continue;
                }
                vector.add(null);
            }
        }
        if (n != null) {
            this._$33774.put(topoItem.getKey(), n);
            this._$33775.put(topoItem.getKey(), n);
            if (topoItem.getDiscoveredItem() != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    super.setTableDataItem(vector.get(i), n, i);
                }
            }
        } else {
            n = new Integer(super.getNumRows());
            super.addRow(Integer.MAX_VALUE, topoItem, vector);
            this._$33774.put(topoItem.getKey(), n);
            this._$33775.put(topoItem.getKey(), n);
        }
    }

    private String _$22453(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < _$33532.length; ++i) {
            if ((n & 1 << i) <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(_$33532[i]);
        }
        return stringBuffer.toString();
    }

    public void cellDisplay(JCCellDisplayEvent jCCellDisplayEvent) {
        if (jCCellDisplayEvent.getCellData() != null) {
            if (!this._$29665 && jCCellDisplayEvent.getDisplayData() instanceof MonitoredVariableBinding && ((MonitoredVariableBinding)jCCellDisplayEvent.getDisplayData()).getVariable() instanceof OID) {
                ObjectID objectID = new ObjectID(((Object)((MonitoredVariableBinding)jCCellDisplayEvent.getDisplayData()).getVariable()).toString());
                String string = this._$18643.getObjectName(objectID);
                if (string == null) {
                    string = this._$18643.getPathSuffix(objectID);
                }
                if (string != null) {
                    jCCellDisplayEvent.setDisplayData(string);
                }
            } else if (jCCellDisplayEvent.getCellData() instanceof MonitoredVariableBinding) {
                MonitoredVariableBinding monitoredVariableBinding = (MonitoredVariableBinding)jCCellDisplayEvent.getCellData();
                Variable variable = monitoredVariableBinding.getVariable();
                if (monitoredVariableBinding.getOid().equals(TopoItem.SYS_OIDS[8])) {
                    if (variable instanceof Integer32) {
                        jCCellDisplayEvent.setDisplayData(this._$22453(((Integer32)variable).getValue()));
                    } else {
                        jCCellDisplayEvent.setDisplayData(((Object)variable).toString());
                    }
                } else {
                    jCCellDisplayEvent.setDisplayData(((Object)variable).toString());
                }
            } else if (jCCellDisplayEvent.getCellData() instanceof Date) {
                jCCellDisplayEvent.setDisplayData(this._$30401.format((Date)jCCellDisplayEvent.getCellData()));
            }
        }
    }

    public void reset() {
        this._$33774.clear();
        this._$33775.clear();
        super.setNumRows(0);
    }

    public Vector getColumnOIDs() {
        return this._$29811;
    }

    public void setColumnOIDs(Vector vector) {
        this._$29811 = vector;
    }

    public void setRepository(MIBRepository mIBRepository) {
        this._$18643 = mIBRepository;
    }

    public MIBRepository getRepository() {
        return this._$18643;
    }

    public void onScanEvent(ScanEvent scanEvent) {
        ScanEntity scanEntity = scanEvent.getScanEntity();
        if (scanEvent.getType() == 1) {
            _$4326.info("Network item discovered: " + scanEntity);
        }
        this.addRow(new TopoItem(scanEntity));
    }
}

