/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.snapshots;

import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.snapshots.RefreshTask;
import com.agentpp.explorer.snapshots.RestoreConfigPanel;
import com.agentpp.explorer.snapshots.RestoreTask;
import com.agentpp.explorer.snapshots.SnapshotModel;
import com.agentpp.explorer.snapshots.SnapshotPanel_jButtonApplyToTarget_actionAdapter;
import com.agentpp.explorer.snapshots.SnapshotPanel_jButtonRefreshRight_actionAdapter;
import com.agentpp.explorer.snapshots.SnapshotPanel_jButtonRefresh_actionAdapter;
import com.agentpp.explorer.snapshots.SnapshotPanel_jButtonRestoreRight_actionAdapter;
import com.agentpp.explorer.snapshots.SnapshotPanel_jButtonSaveRight_actionAdapter;
import com.agentpp.explorer.snapshots.SnapshotPanel_jButtonSave_actionAdapter;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.swing.JCTreeTable;
import com.klg.jclass.util.swing.JCTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.snmp4j.Snmp;

public class SnapshotPanel
extends JPanel
implements TableModelListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelCenter = new JPanel();
    JScrollPane jScrollPaneSnapShot = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JCTreeTable treeTable = new JCTreeTable();
    private static final int[][] _$37282 = new int[][]{{270, 120, 140, 25, 120, 140, 100}, {270, 120, 140, 120}};
    JPanel jPanelToolbar = new JPanel();
    JToolBar toolBar = new JToolBar();
    JButton jButtonApplyToTarget = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    private Snmp _$4261;
    private GenTarget _$4262;
    private SnapshotModel _$4260;
    private UserConfigFile _$4288;
    private boolean _$11983 = false;
    JButton jButtonRefresh = new JButton();
    JButton jButtonSave = new JButton();
    JToolBar jToolBarRight = new JToolBar();
    JButton jButtonRefreshRight = new JButton();
    JButton jButtonSaveRight = new JButton();
    JButton jButtonRestoreRight = new JButton();
    private int _$37288 = 10;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();

    public SnapshotPanel(Snmp snmp, GenTarget genTarget, UserConfigFile userConfigFile, boolean bl) {
        this._$4261 = snmp;
        this._$4262 = genTarget;
        this._$4288 = userConfigFile;
        this._$11983 = bl;
        this._$37288 = userConfigFile.getInteger("mibexplorer.MaxVBS", 10);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SnapshotPanel() {
        this(null, null, null, true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTarget(GenTarget genTarget) {
        this._$4262 = genTarget;
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanelCenter.setLayout(this.borderLayout2);
        this.jButtonApplyToTarget.setToolTipText("Restore snapshot (diff) to current target using SET requests");
        this.jButtonApplyToTarget.setText("Restore...");
        this.jButtonApplyToTarget.setIcon(MIBExplorerFrame.imageEdit16);
        this.jButtonApplyToTarget.addActionListener(new SnapshotPanel_jButtonApplyToTarget_actionAdapter(this));
        this.jPanelToolbar.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.jButtonRefresh.setToolTipText("Refresh snapshot contents from current target");
        this.jButtonRefresh.setText("Refresh");
        this.jButtonRefresh.setIcon(MIBExplorerFrame.imageRefresh16);
        this.jButtonRefresh.addActionListener(new SnapshotPanel_jButtonRefresh_actionAdapter(this));
        this.jButtonSave.setToolTipText("Save snapshot to a file");
        this.jButtonSave.setIcon(MIBExplorerFrame.imageSaveAs16);
        this.jButtonSave.setText("Save...");
        this.jButtonRefreshRight.setToolTipText("Refresh right hand side instances from the current target");
        this.jButtonRefreshRight.setText("Refresh");
        this.jButtonRefreshRight.setIcon(MIBExplorerFrame.imageRefresh16);
        this.jButtonRefreshRight.addActionListener(new SnapshotPanel_jButtonRefreshRight_actionAdapter(this));
        this.jButtonSaveRight.setToolTipText("Save right snapshot as a file");
        this.jButtonSaveRight.setText("Save...");
        this.jButtonSaveRight.setIcon(MIBExplorerFrame.imageSaveAs16);
        this.jButtonRestoreRight.setToolTipText("Restore right hand side values to the current target");
        this.jButtonRestoreRight.setText("Restore...");
        this.jButtonRestoreRight.setIcon(MIBExplorerFrame.imageEdit16);
        this.jButtonRestoreRight.addActionListener(new SnapshotPanel_jButtonRestoreRight_actionAdapter(this));
        this.jLabel1.setText("Left:");
        this.jLabel2.setText("Right:");
        this.jButtonSave.addActionListener(new SnapshotPanel_jButtonSave_actionAdapter(this));
        this.jButtonSaveRight.addActionListener(new SnapshotPanel_jButtonSaveRight_actionAdapter(this));
        this.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jScrollPaneSnapShot, "Center");
        this.add((Component)this.jPanelToolbar, "North");
        this.jScrollPaneSnapShot.getViewport().add((Component)this.treeTable, null);
        this.jPanelToolbar.add((Component)this.toolBar, null);
        if (this._$11983) {
            this.jPanelToolbar.add(this.jToolBarRight);
            this.toolBar.add(this.jLabel1);
            this.toolBar.addSeparator();
        }
        this.jToolBarRight.add(this.jLabel2);
        this.jToolBarRight.addSeparator();
        this.jToolBarRight.add(this.jButtonRefreshRight);
        this.jToolBarRight.addSeparator();
        this.jToolBarRight.add(this.jButtonSaveRight);
        this.jToolBarRight.addSeparator();
        this.jToolBarRight.add(this.jButtonRestoreRight);
        this.toolBar.add(this.jButtonRefresh);
        this.toolBar.addSeparator();
        this.toolBar.add(this.jButtonSave);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.jButtonApplyToTarget, null);
        this.treeTable.setRootVisible(false);
        this.treeTable.setAutoResizeMode(0);
        this.treeTable.setShowNodeLines(3);
        this.treeTable.setShowGrid(true);
        this.treeTable.setExpandInTreeColumnOnly(true);
        this.treeTable.setShowHorizontalLines(true);
        this.treeTable.setScrollsOnExpand(true);
        this.treeTable.setIntercellSpacing(new Dimension(1, 1));
    }

    private void _$37299() {
        Enumeration<TableColumn> enumeration = this.treeTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn != null || tableColumn instanceof JCTableColumn) {
                JCTableColumn jCTableColumn = (JCTableColumn)tableColumn;
                jCTableColumn.setPreferredWidth(_$37282[this._$11983 ? 0 : 1][n]);
            }
            ++n;
        }
    }

    public void setModel(SnapshotModel snapshotModel) {
        if (this._$4260 != null) {
            snapshotModel.removeTableModelListener(this);
        }
        this._$4260 = snapshotModel;
        snapshotModel.addTableModelListener(this);
        this.treeTable.setTreeTableModel(snapshotModel);
        this._$37299();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.treeTable.getTreeTableModel().getRoot()).depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            SnapshotModel.SnapshotNode snapshotNode = (SnapshotModel.SnapshotNode)defaultMutableTreeNode.getUserObject();
            if (snapshotNode == null || !defaultMutableTreeNode.isLeaf() || snapshotModel.isComparison() && (snapshotNode.getColumn(3) == null || snapshotNode.getColumn(3) == SnapshotModel.imageEquals)) continue;
            this.treeTable.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (defaultMutableTreeNode2 == null) continue;
            while (enumeration.hasMoreElements() && defaultMutableTreeNode2.equals((defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement()).getParent())) {
            }
        }
    }

    public void setMaxVBsPerPDU(int n) {
        this._$37288 = n;
    }

    public SnapshotModel getModel() {
        return this._$4260;
    }

    public int getMaxVBsPerPDU() {
        return this._$37288;
    }

    void jButtonApplyToTarget_actionPerformed(ActionEvent actionEvent) {
        RestoreConfigPanel restoreConfigPanel = new RestoreConfigPanel();
        restoreConfigPanel.setUpdateOnlyDifferences(true);
        restoreConfigPanel.setUpdateWritableOnly(true);
        restoreConfigPanel.setUseNotInServiceState(true);
        restoreConfigPanel.setUpdateOnlyDifferencesEnabled(this._$11983);
        Object[] objectArray = new String[]{"Restore Values", "Cancel"};
        if (JOptionPane.showOptionDialog(this, restoreConfigPanel, "Select Restore Options", 2, -1, null, objectArray, objectArray[0]) == 0) {
            ProgressMonitor progressMonitor = new ProgressMonitor(this, "Restoring...", "initializing", 0, this.getModel().getRowCount());
            Runnable runnable = new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(SnapshotPanel.this, new String[]{"Restore task finished! Please inspect", "the Status column for details."}, "Restore Finished", 1);
                }
            };
            RestoreTask restoreTask = new RestoreTask(this._$4261, this._$4262, this.getModel(), progressMonitor, runnable);
            restoreTask.setColumn2Restore(0);
            restoreTask.setMaxVBsPerPDU(this._$4288.getInteger("mibexplorer.MaxVBS", 10));
            restoreTask.setSetDifferencesOnly(restoreConfigPanel.isUpdateOnlyDifferences());
            restoreTask.setSetWritableOnly(restoreConfigPanel.isUpdateWritableOnly());
            restoreTask.setUseNotInServiceState(restoreConfigPanel.isUseNotInServiceState());
            Thread thread = new Thread(restoreTask);
            thread.start();
        }
    }

    public void jButtonRefresh_actionPerformed(ActionEvent actionEvent) {
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Refreshing...", "initializing", 0, this.getModel().getRowCount());
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(SnapshotPanel.this, new String[]{"The values " + (SnapshotPanel.this._$11983 ? "on the left " : "") + " have been refreshed. ", "Please inspect the Status column for details."}, "Refresh Finished", 1);
            }
        };
        RefreshTask refreshTask = new RefreshTask(this._$4261, this._$4262, this.getModel(), progressMonitor, runnable);
        refreshTask.setColumn2Update(0);
        refreshTask.setMaxVBsPerPDU(this._$37288);
        Thread thread = new Thread(refreshTask);
        thread.start();
    }

    public void jButtonRefreshRight_actionPerformed(ActionEvent actionEvent) {
        ProgressMonitor progressMonitor = new ProgressMonitor(this, "Refreshing...", "initializing", 0, this.getModel().getRowCount());
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(SnapshotPanel.this, new String[]{"The values on the right have been refreshed. ", "Please inspect the Status column for details."}, "Refresh Finished", 1);
            }
        };
        RefreshTask refreshTask = new RefreshTask(this._$4261, this._$4262, this.getModel(), progressMonitor, runnable);
        refreshTask.setColumn2Update(1);
        refreshTask.setMaxVBsPerPDU(this._$37288);
        Thread thread = new Thread(refreshTask);
        thread.start();
    }

    public void jButtonRestoreRight_actionPerformed(ActionEvent actionEvent) {
        RestoreConfigPanel restoreConfigPanel = new RestoreConfigPanel();
        restoreConfigPanel.setUpdateOnlyDifferences(true);
        restoreConfigPanel.setUpdateWritableOnly(true);
        restoreConfigPanel.setUseNotInServiceState(true);
        restoreConfigPanel.setUpdateOnlyDifferencesEnabled(this._$11983);
        Object[] objectArray = new String[]{"Restore Values", "Cancel"};
        if (JOptionPane.showOptionDialog(this, restoreConfigPanel, "Select Restore Options", 2, -1, null, objectArray, objectArray[0]) == 0) {
            ProgressMonitor progressMonitor = new ProgressMonitor(this, "Restoring...", "initializing", 0, this.getModel().getRowCount());
            Runnable runnable = new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(SnapshotPanel.this, new String[]{"Restore task finished! Please inspect", "the Status column for details."}, "Restore Finished", 1);
                }
            };
            RestoreTask restoreTask = new RestoreTask(this._$4261, this._$4262, this.getModel(), progressMonitor, runnable);
            restoreTask.setColumn2Restore(1);
            restoreTask.setMaxVBsPerPDU(this._$4288.getInteger("mibexplorer.MaxVBS", 10));
            restoreTask.setSetDifferencesOnly(restoreConfigPanel.isUpdateOnlyDifferences());
            restoreTask.setSetWritableOnly(restoreConfigPanel.isUpdateWritableOnly());
            restoreTask.setUseNotInServiceState(restoreConfigPanel.isUseNotInServiceState());
            Thread thread = new Thread(restoreTask);
            thread.start();
        }
    }

    public void jButtonSave_actionPerformed(ActionEvent actionEvent) {
        List list = this._$4260.getInstances();
        SnapshotPanel.saveSnapshot(list, this._$4288, this);
    }

    public void jButtonSaveRight_actionPerformed(ActionEvent actionEvent) {
        List list = this._$4260.getInstances2Compare();
        SnapshotPanel.saveSnapshot(list, this._$4288, this);
    }

    public static File saveSnapshot(List list, UserConfigFile userConfigFile, Component component) {
        list = MIBExplorerFrame.convertToSerializableInstances(list);
        JFileChooser jFileChooser = new JFileChooser(userConfigFile.get("mibexplorer.snapshot.dir", ""));
        jFileChooser.setDialogTitle("Save Snapshot to File");
        jFileChooser.setFileSelectionMode(0);
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("sf", "Snapshot Files");
        jFileChooser.setFileFilter(exampleFileFilter);
        if (jFileChooser.showSaveDialog(component) == 0) {
            userConfigFile.put("mibexplorer.snapshot.dir", jFileChooser.getSelectedFile().getParent());
            try {
                File file = jFileChooser.getSelectedFile();
                if (!file.getName().toUpperCase().endsWith(".SF")) {
                    file = new File(file.getParentFile(), file.getName() + ".sf");
                }
                if (file.exists() && JOptionPane.showConfirmDialog(component, "File '" + jFileChooser.getSelectedFile().getPath() + "' already exists! Overwrite it?", "Confirm Overwrite", 2, 3) == 2) {
                    return null;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(list);
                objectOutputStream.flush();
                objectOutputStream.close();
                return jFileChooser.getSelectedFile();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(component, new String[]{"An error occurred while trying to write snapshot file: ", iOException.getMessage()}, "Snapshot not Saved", 0);
                return null;
            }
        }
        return null;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.treeTable.repaint();
    }
}

