/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.snapshots;

import com.agentpp.common.StandardDialog;
import com.agentpp.common.StandardWizard;
import com.agentpp.common.WizardStepList;
import com.agentpp.explorer.MIBExplorerFrame;
import com.agentpp.explorer.snapshots.SnapshotComparisonPanel;
import com.agentpp.explorer.snapshots.SnapshotModel;
import com.agentpp.explorer.snapshots.SnapshotPanel;
import com.agentpp.explorer.snapshots.SnapshotSelectionPanel;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.UserConfigFile;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.snmp4j.Snmp;

public class SnapshotCompareWizard {
    private Snmp _$4261;
    private UserConfigFile _$4288;
    StandardWizard[] dialogs = new StandardWizard[3];
    SnapshotSelectionPanel[] selectionPanels = new SnapshotSelectionPanel[2];
    SnapshotComparisonPanel comparisonPanel = new SnapshotComparisonPanel();
    private MIBExplorerFrame _$18902;
    private MIBRepository _$18643;
    private GenTarget _$4262;
    private static final String[] _$29857 = new String[]{"Select First Snapshot", "Select Second Snapshot", "Comparison Parameters"};
    private static final String[] _$34445 = new String[]{"Choose the source of the first (left) snapshot between tree, browse panel, or file.", "Choose the source for the second (right) snapshot to be compared with the first between tree, browse panel, or file.", "Select which syntaxes to include in the comparison. Instances whose syntax is excluded from comparison will only be compared regarding their presence not by their values. In addition, please specify whether only instances present in both snapshots should be compared."};

    public SnapshotCompareWizard(MIBExplorerFrame mIBExplorerFrame, MIBRepository mIBRepository, Snmp snmp, UserConfigFile userConfigFile, GenTarget genTarget) {
        this._$18902 = mIBExplorerFrame;
        this._$4261 = snmp;
        this._$4288 = userConfigFile;
        this._$18643 = mIBRepository;
        this._$4262 = genTarget;
    }

    public boolean init() {
        this.comparisonPanel.setPreferredSize(new Dimension(500, 500));
        for (int i = 0; i < 2; ++i) {
            this.dialogs[i] = new StandardWizard(this._$18902, _$29857[i], true);
            this.dialogs[i].setPrevButtonEnabled(i > 0);
            this.dialogs[i].setFinishButtonEnabled(i == 1);
            this.dialogs[i].setNextButtonEnabled(true);
            this.dialogs[i].setLeftPanel(new WizardStepList(null, new Vector<String>(Arrays.asList(_$34445)), i));
            this.selectionPanels[i] = new SnapshotSelectionPanel();
            this.selectionPanels[i].setSnapshotDir(this._$4288.get("mibexplorer.snapshot.dir", ""));
            this.selectionPanels[i].setPreferredSize(new Dimension(500, 500));
            this.dialogs[i].setCenterPanel(this.selectionPanels[i]);
            this.selectionPanels[i].addWizardListener(this.dialogs[i]);
        }
        this.selectionPanels[1].setFinishEnabled(true);
        this.dialogs[2] = new StandardWizard(this._$18902, _$29857[2], true);
        this.dialogs[2].setPrevButtonEnabled(true);
        this.dialogs[2].setFinishButtonEnabled(true);
        this.dialogs[2].setNextButtonEnabled(false);
        this.dialogs[2].setLeftPanel(new WizardStepList(null, new Vector<String>(Arrays.asList(_$34445)), 2));
        this.dialogs[2].setCenterPanel(this.comparisonPanel);
        return true;
    }

    public void show() {
        this.dialogs[0].setCenterPanel(this.selectionPanels[0]);
        int n = 0;
        int n2 = 0;
        do {
            n2 = n;
            this._$34452(n);
            this.dialogs[n].setLocationRelativeTo(this._$18902);
            this.dialogs[n].setVisible(true);
            if (!this._$34453(n, this.dialogs[n].getResult())) continue;
            n += this.dialogs[n].getResult();
        } while (this.dialogs[n2].getResult() != 2 && this.dialogs[n2].getResult() != 0);
        if (this.dialogs[n2].getResult() == 2) {
            this.compare();
        }
    }

    protected void compare() {
        SnapshotPanel snapshotPanel = new SnapshotPanel(this._$4261, this._$4262, this._$4288, true);
        SnapshotModel snapshotModel = new SnapshotModel();
        for (int i = 0; i < 2; ++i) {
            List list = null;
            switch (this.selectionPanels[i].getSelection()) {
                case 2: {
                    list = this._$18902.getBrowseSnapshot();
                    list = MIBExplorerFrame.convertToSerializableInstances(list);
                    list = MIBExplorerFrame.convertFromSerializableInstances(list);
                    break;
                }
                case 1: {
                    list = this._$18902.getTreeSnapshot();
                    list = MIBExplorerFrame.convertToSerializableInstances(list);
                    list = MIBExplorerFrame.convertFromSerializableInstances(list);
                    break;
                }
                case 3: {
                    File file = this.selectionPanels[i].getSnapshotFile();
                    FileInputStream fileInputStream = null;
                    ObjectInputStream objectInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        objectInputStream = new ObjectInputStream(fileInputStream);
                        try {
                            list = (List)objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this._$18902, new String[]{"The file '" + file.getPath() + "' is not a valid snapshot file!"}, "File Format Error", 0);
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this._$18902, new String[]{"The file '" + file.getPath() + "' cannot be read: ", iOException.getMessage()}, "File Format Error", 0);
                        return;
                    }
                    list = MIBExplorerFrame.convertFromSerializableInstances(list);
                    break;
                }
            }
            if (i == 0) {
                snapshotModel.setInstances(list);
                continue;
            }
            snapshotModel.setInstances2Compare(list);
        }
        snapshotModel.setCompareTuplesOnly(this.comparisonPanel.isCompareOnlyPresent());
        snapshotModel.setSyntaxes2Compare(this.comparisonPanel.getSelectedSyntaxes());
        snapshotModel.setRepository(this._$18643);
        snapshotModel.buildTree();
        snapshotPanel.setModel(snapshotModel);
        StandardDialog standardDialog = new StandardDialog((Frame)this._$18902, "Snapshot Comparison Browser - " + this._$4262.toString(), false, false);
        standardDialog.setCenterPanel(snapshotPanel);
        standardDialog.setSize(900, 600);
        standardDialog.setLocationRelativeTo(this._$18902);
        standardDialog.setVisible(true);
    }

    private boolean _$34453(int n, int n2) {
        if (n2 != 1) {
            return true;
        }
        if (n == 0 || n == 1) {
            File file;
            if (!(this.selectionPanels[n].getSelection() != 3 || (file = this.selectionPanels[n].getSnapshotFile()).exists() && file.canRead())) {
                String[] stringArray = new String[]{"The snapshot file '" + file.getPath() + "' cannot be read or does not exists.", "Please choose a different file or snapshot source!"};
                JOptionPane.showMessageDialog(this._$18902, stringArray, "Snapshot File Error", 0);
                return false;
            }
        } else if (n == 2 && this.comparisonPanel.getSelectedSyntaxes().length == 0) {
            String[] stringArray = new String[]{"Please select at least one SMI base syntax to be compared!", "Otherwise a comparison does not make any sense, since an", "empty comparison tree would have to be displayed."};
            JOptionPane.showMessageDialog(this._$18902, stringArray, "Invalid Comparison", 0);
            return false;
        }
        return true;
    }

    private void _$34452(int n) {
        File file;
        if (!(n != 0 && n != 1 || this.selectionPanels[n].getSelection() != 3 || (file = this.selectionPanels[n].getSnapshotFile()).exists() && file.canRead())) {
            this.dialogs[n].setFinishButtonEnabled(false);
            this.dialogs[n].setNextButtonEnabled(false);
            return;
        }
        if (n < 2) {
            this.dialogs[n].setNextButtonEnabled(true);
        }
        if (n == 1) {
            this.dialogs[n].setFinishButtonEnabled(true);
        }
    }
}

