/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.snapshots;

import com.agentpp.explorer.SMITableUtils;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.explorer.snapshots.SnapshotModel;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.ProgressMonitor;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.VariableBinding;

public class RefreshTask
implements Runnable {
    private static final Logger _$4326 = Logger.getLogger("Snapshots");
    private Snmp _$4261;
    private GenTarget _$4262;
    private SnapshotModel _$37225;
    private ProgressMonitor _$23635;
    private MIBRepository _$18643;
    private SnmpLogger _$30135;
    private int _$48069 = 0;
    private int _$37288 = 1;
    private Runnable _$48042;

    public RefreshTask(Snmp snmp, GenTarget genTarget, SnapshotModel snapshotModel, ProgressMonitor progressMonitor, Runnable runnable) {
        this._$4261 = snmp;
        this._$4262 = genTarget;
        this._$37225 = snapshotModel;
        this._$23635 = progressMonitor;
        this._$18643 = snapshotModel.getRepository();
        this._$30135 = new SnmpLogger(this._$18643);
        this._$48042 = runnable;
    }

    public void run() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._$37225.getRoot();
        TreeMap treeMap = new TreeMap();
        this._$23635.setMinimum(0);
        this._$23635.setMaximum(this._$37225.getRowCount());
        int n = 0;
        LinkedList<SnapshotModel.SnapshotNode> linkedList = new LinkedList<SnapshotModel.SnapshotNode>();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements() && !this._$23635.isCanceled()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            SnapshotModel.SnapshotNode snapshotNode = (SnapshotModel.SnapshotNode)defaultMutableTreeNode2.getUserObject();
            if (snapshotNode == null) continue;
            snapshotNode.setStatus(null);
            if (snapshotNode.getInstance(this._$48069) == null) continue;
            this._$23635.setProgress(++n);
            this._$23635.setNote(SMITableUtils.getPathSuffixWithIndex(this._$18643, snapshotNode.getOID()));
            linkedList.add(snapshotNode);
            if (linkedList.size() < this._$37288) continue;
            this._$10049(linkedList);
            linkedList.clear();
        }
        if (linkedList.size() > 0) {
            this._$10049(linkedList);
            linkedList.clear();
        }
        this._$37225.fireTableChanged(new TableModelEvent(this._$37225));
        this._$23635.close();
        this._$48042.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer32 _$10049(List list) {
        BERSerializable bERSerializable;
        Object object;
        Target target = this._$4262.getTarget();
        PDU pDU = this._$4262.makePDU();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (SnapshotModel.SnapshotNode)object2.next();
            bERSerializable = new VariableBinding();
            bERSerializable.setOid(((SnapshotModel.SnapshotNode)object).getInstance(this._$48069).getOid());
            pDU.add((VariableBinding)bERSerializable);
        }
        object = object2 = new RespListener();
        synchronized (object) {
            try {
                this._$4261.get(pDU, target, null, (ResponseListener)object2);
            }
            catch (IOException iOException) {
                _$4326.error("Could not send refresh request: " + iOException.getMessage());
            }
            SnmpLogger.logRequest(pDU, this._$4262, false);
            try {
                object2.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bERSerializable = ((RespListener)object2).getEvent().getResponse();
            this._$30135.logResponse(((RespListener)object2).getEvent().getPeerAddress(), ((RespListener)object2).getEvent().getRequest(), (PDU)bERSerializable, false);
            return this._$48057((PDU)bERSerializable, list);
        }
    }

    private void _$48058(List list, String string) {
        for (SnapshotModel.SnapshotNode snapshotNode : list) {
            snapshotNode.setStatus(string);
        }
    }

    private Integer32 _$48057(PDU pDU, List list) {
        if (pDU == null) {
            this._$48058(list, "Timeout");
            return null;
        }
        if (pDU.getErrorStatus() != 0) {
            if (pDU.getErrorIndex() > 0) {
                int n = pDU.getErrorIndex() - 1;
                if (n >= 0 && n < list.size()) {
                    this._$48058(list, "Not Refreshed");
                    ((SnapshotModel.SnapshotNode)list.get(n)).setStatus(pDU.getErrorStatusText());
                } else {
                    this._$48058(list, pDU.getErrorStatusText());
                }
            } else {
                this._$48058(list, pDU.getErrorStatusText());
            }
        } else {
            this._$48058(list, "Refreshed");
        }
        return new Integer32(pDU.getErrorStatus());
    }

    public void setSession(Snmp snmp) {
        this._$4261 = snmp;
    }

    public void setTarget(GenTarget genTarget) {
        this._$4262 = genTarget;
    }

    public void setSnapshotModel(SnapshotModel snapshotModel) {
        this._$37225 = snapshotModel;
    }

    public void setColumn2Update(int n) {
        this._$48069 = n;
    }

    public void setMaxVBsPerPDU(int n) {
        this._$37288 = n;
    }

    public Session getSession() {
        return this._$4261;
    }

    public GenTarget getTarget() {
        return this._$4262;
    }

    public SnapshotModel getSnapshotModel() {
        return this._$37225;
    }

    public int getColumn2Update() {
        return this._$48069;
    }

    public int getMaxVBsPerPDU() {
        return this._$37288;
    }

    class RespListener
    implements ResponseListener {
        private ResponseEvent _$4146 = null;

        RespListener() {
        }

        public synchronized void onResponse(ResponseEvent responseEvent) {
            this._$4146 = responseEvent;
            this.notify();
        }

        public ResponseEvent getEvent() {
            return this._$4146;
        }
    }
}

