/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.monitor.db;

import com.agentpp.common.table.RoundRobinDataSource;
import com.agentpp.common.table.RoundRobinEvent;
import com.agentpp.common.table.RoundRobinListener;
import com.agentpp.explorer.MIBExplorerRemoteServer;
import com.agentpp.explorer.monitor.Monitor2XML;
import com.agentpp.explorer.monitor.MonitorObserver;
import com.agentpp.explorer.monitor.MonitorProperty;
import com.agentpp.explorer.monitor.MonitorServer;
import com.agentpp.slimdao.Parameter;
import com.agentpp.slimdao.ParameterRenderer;
import com.agentpp.slimdao.ParameterValue;
import com.agentpp.slimdao.SQLParameterRenderer;
import com.agentpp.slimdao.SlimDAO;
import com.agentpp.slimdao.SlimDAOImpl;
import com.agentpp.slimdao.SlimResult;
import com.agentpp.slimdao.SlimStatement;
import com.agentpp.slimdao.SlimUpdateResult;
import com.agentpp.slimdao.StatementRepository;
import com.agentpp.slimdao.parser.ParameterResolver;
import com.agentpp.slimdao.sql.PlaceholderParameter;
import com.agentpp.slimdao.xml.StatementCacheXML;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Monitor2DB
implements RoundRobinListener,
MIBExplorerRemoteServer {
    private static final Logger _$4326 = Logger.getLogger("Monitor.DB");
    private Connection _$39978;
    private boolean _$39979 = true;
    private String _$18973;
    private String _$39972;
    private SlimDAO _$39980;
    private Map<String, SlimStatement> _$39981 = new HashMap<String, SlimStatement>(5);

    public Monitor2DB(String string, final String string2, String string3) {
        InputStream inputStream;
        String string4 = "internal storage";
        if (string3 == null || string3.trim().length() == 0) {
            inputStream = Monitor2DB.class.getResourceAsStream("Monitor2DB.xml");
        } else {
            try {
                inputStream = new FileInputStream(string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException.getMessage());
            }
            string4 = string3;
        }
        StatementCacheXML statementCacheXML = new StatementCacheXML(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        _$4326.info("DB configuration loaded from " + string4);
        this._$39980 = new SlimDAOImpl((StatementRepository)statementCacheXML, string, (ParameterRenderer)new SQLParameterRenderer(), new ParameterResolver(){

            public Parameter resolve(String string) {
                if ("SCHEMA".equals(string)) {
                    return new ParameterValue("SCHEMA", (Object)string2);
                }
                return new PlaceholderParameter(string);
            }
        });
    }

    public void connect(String string, String string2, Properties properties) throws SQLException, ClassNotFoundException {
        this._$39972 = string2;
        this._$18973 = string;
        try {
            Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this._$39978 = DriverManager.getConnection(string, properties);
    }

    public void close() {
        try {
            this._$39978.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int getSchemaVersion() {
        try {
            SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "check.schema");
            SlimResult slimResult = this._$39980.executeQuery(slimStatement);
            boolean bl = slimResult.getResultSet().next();
            if (bl) {
                return slimResult.getResultSet().getInt(1);
            }
            slimResult.close();
            slimStatement.close();
        }
        catch (SQLException sQLException) {
            _$4326.warn("SLQException while getting schema version: " + sQLException.getMessage(), sQLException);
        }
        return -1;
    }

    public void createSchema() throws SQLException {
        List list = this._$39980.createScript(this._$39978, "create.schema", Collections.emptyMap());
        for (SlimStatement slimStatement : list) {
            this._$39980.executeUpdate(slimStatement);
        }
    }

    public Long saveMonitorToDB(String string, Long l, MonitorProperty monitorProperty, JCEditableVectorDataSource jCEditableVectorDataSource, OutputStream outputStream) throws IOException, SQLException {
        if (l == null) {
            l = this._$5193("MONITOR");
        } else {
            this.deleteMonitor(l);
        }
        monitorProperty.setId(l);
        this._$40002(l, string, monitorProperty, jCEditableVectorDataSource, " ");
        Properties properties = new Properties();
        properties.put("jdbc.url", this._$18973);
        properties.put("jdbc.driver", this._$39972);
        properties.put("monitor.name", string);
        properties.put("monitor.id", l.toString());
        properties.store(outputStream, null);
        return l;
    }

    public boolean updateMonitorNewStatus(Long l, String string) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("ID", l);
        hashMap.put("NEXT_STATUS", string);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "update.next.status", hashMap);
        SlimUpdateResult slimUpdateResult = this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
        return slimUpdateResult.updateCount() > 0;
    }

    public boolean updateMonitorStatus(Long l, String string) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("ID", l);
        hashMap.put("STATUS", string);
        hashMap.put("NEXT_STATUS", " ");
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "update.monitor.status", hashMap);
        int n = this._$39980.executeUpdate(slimStatement).updateCount();
        slimStatement.close();
        if (_$4326.isDebugEnabled()) {
            _$4326.debug("Status update to " + string + " for id=" + l + " is " + n);
        }
        return n > 0;
    }

    public void updateMonitor(Long l, String string, MonitorProperty monitorProperty, JCEditableVectorDataSource jCEditableVectorDataSource, String string2, boolean bl) throws IOException, SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Monitor2XML.convert2XML((MonitorProperty)monitorProperty, (JCEditableVectorDataSource)jCEditableVectorDataSource, (OutputStream)byteArrayOutputStream, (boolean)false);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("NAME", string);
        hashMap.put("CONFIGXML", new ParameterValue("CONFIGXML", (Object)byteArrayInputStream, 2005, byteArrayOutputStream.size()));
        hashMap.put("NEXT_STATUS", string2);
        hashMap.put("ID", l);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "update.monitor", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
        if (bl) {
            this._$40011(l);
            RoundRobinDataSource roundRobinDataSource = monitorProperty.getData();
            this._$40013(l, null, roundRobinDataSource, 0);
            for (int i = 0; i < monitorProperty.getConsolidationConfig().size(); ++i) {
                roundRobinDataSource = (RoundRobinDataSource)monitorProperty.getConsolidationConfig().get(i);
                this._$40013(l, null, roundRobinDataSource, i + 1);
            }
        }
    }

    private void _$40002(Long l, String string, MonitorProperty monitorProperty, JCEditableVectorDataSource jCEditableVectorDataSource, String string2) throws SQLException, IOException {
        boolean bl = false;
        if (l == null) {
            l = this._$5193("MONITOR");
            bl = true;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Monitor2XML.convert2XML((MonitorProperty)monitorProperty, (JCEditableVectorDataSource)jCEditableVectorDataSource, (OutputStream)byteArrayOutputStream, (boolean)false);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("ID", l);
        hashMap.put("NAME", string);
        hashMap.put("CONFIGXML", new ParameterValue("CONFIGXML", (Object)byteArrayInputStream, 2005, byteArrayOutputStream.size()));
        hashMap.put("NEXT_STATUS", string2);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "insert.monitor", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
        RoundRobinDataSource roundRobinDataSource = monitorProperty.getData();
        this._$40013(l, bl ? null : roundRobinDataSource.getId(), roundRobinDataSource, 0);
        for (int i = 0; i < monitorProperty.getConsolidationConfig().size(); ++i) {
            roundRobinDataSource = (RoundRobinDataSource)monitorProperty.getConsolidationConfig().get(i);
            this._$40013(l, bl ? null : roundRobinDataSource.getId(), roundRobinDataSource, i + 1);
        }
    }

    private Long _$40013(Long l, Long l2, RoundRobinDataSource roundRobinDataSource, int n) throws SQLException {
        SlimStatement slimStatement;
        SlimStatement[] slimStatementArray;
        if (l2 == null) {
            l2 = this._$40016(l, roundRobinDataSource.getName(), n);
            roundRobinDataSource.setId(l2);
        }
        if (l2 == null) {
            l2 = this._$5193("MONITORDATASET");
            roundRobinDataSource.setId(l2);
            slimStatementArray = roundRobinDataSource.getName();
            slimStatement = this._$39980.createStatement(this._$39978, "insert.monitor.dataset", new Parameter[]{new ParameterValue("ID", (Object)l2), new ParameterValue("MONITOR_ID", (Object)l), new ParameterValue("NAME", slimStatementArray == null ? "" : slimStatementArray), new ParameterValue("DATATYPE", (Object)new Integer(n))});
            this._$39980.executeUpdate(slimStatement);
            slimStatement.close();
        } else {
            slimStatementArray = roundRobinDataSource.getName();
            slimStatement = this._$39980.createStatement(this._$39978, "update.monitor.dataset", new Parameter[]{new ParameterValue("NAME", slimStatementArray == null ? "" : slimStatementArray), new ParameterValue("DATATYPE", (Object)new Integer(n)), new ParameterValue("ID", (Object)l2)});
            this._$39980.executeUpdate(slimStatement);
            slimStatement.close();
            this.deleteDataSetRows(l2);
        }
        slimStatement = null;
        slimStatementArray = this._$40019();
        slimStatement = slimStatementArray[0];
        for (int i = 0; i < roundRobinDataSource.getNumRows(); ++i) {
            this._$36590(l2, roundRobinDataSource, slimStatementArray, i);
        }
        if (this._$39979) {
            this._$39980.executeBatch(slimStatement);
            this._$39980.executeBatch(slimStatementArray[1]);
        }
        List list = roundRobinDataSource.getLastSamples();
        int n2 = 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        SlimStatement[] slimStatementArray2 = list.iterator();
        while (slimStatementArray2.hasNext()) {
            Long l3 = this._$5193("MONITORDATAROW");
            RoundRobinEvent roundRobinEvent = (RoundRobinEvent)slimStatementArray2.next();
            java.util.Date date = (java.util.Date)roundRobinEvent.getLabel();
            hashMap.put("MONITORDATAROW_ID", l3);
            hashMap.put("MONITORDATASET_ID", l2);
            hashMap.put("CTIME", new Timestamp(date.getTime()));
            hashMap.put("ROWTYPE", "S");
            this._$40020(slimStatement, hashMap);
            hashMap.clear();
            this._$36590(slimStatementArray[1], l3, roundRobinEvent.getRow());
            ++n2;
        }
        if (this._$39979) {
            this._$39980.executeBatch(slimStatement);
            this._$39980.executeBatch(slimStatementArray[1]);
        }
        for (SlimStatement slimStatement2 : slimStatementArray) {
            slimStatement2.close();
        }
        return l2;
    }

    private void _$36590(Long l, RoundRobinDataSource roundRobinDataSource, SlimStatement[] slimStatementArray, int n) throws SQLException {
        java.util.Date date = (java.util.Date)roundRobinDataSource.getTableRowLabel(n);
        if (date == null) {
            return;
        }
        Long l2 = this._$5193("MONITORDATAROW");
        HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
        hashMap.put("MONITORDATAROW_ID", l2);
        hashMap.put("MONITORDATASET_ID", l);
        hashMap.put("CTIME", new Timestamp(date.getTime()));
        hashMap.put("ROWTYPE", "R");
        this._$40020(slimStatementArray[0], hashMap);
        this._$36590(slimStatementArray[1], l2, roundRobinDataSource, n);
    }

    private void _$36590(SlimStatement[] slimStatementArray, Long l, java.util.Date date, List list, boolean bl, int n) throws SQLException {
        this.deleteDataRow(l, new Date(date.getTime()), bl ? "S" : "R");
        HashMap<String, Object> hashMap = new HashMap<String, Object>(5);
        Long l2 = this._$5193("MONITORDATAROW");
        hashMap.put("MONITORDATAROW_ID", l2);
        hashMap.put("MONITORDATASET_ID", l);
        hashMap.put("CTIME", new Timestamp(date.getTime()));
        hashMap.put("ROWTYPE", bl ? "S" : "R");
        this._$40020(slimStatementArray[0], hashMap);
        this._$36590(slimStatementArray[1], l2, list);
    }

    private Long _$40016(Long l, String string, int n) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("ID", l);
        hashMap.put("NAME", string);
        hashMap.put("DATATYPE", n);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.dataset.by.id", hashMap);
        SlimResult slimResult = this._$39980.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        if (resultSet.next()) {
            long l2 = resultSet.getLong("ID");
            resultSet.close();
            slimStatement.close();
            return new Long(l2);
        }
        resultSet.close();
        slimStatement.close();
        return null;
    }

    private SlimStatement[] _$40019() throws SQLException {
        SlimStatement[] slimStatementArray = new SlimStatement[]{this._$39980.createStatement(this._$39978, "insert.monitor.row"), this._$39980.createStatement(this._$39978, "insert.monitor.value")};
        return slimStatementArray;
    }

    private void _$40020(SlimStatement slimStatement, Map map) throws SQLException {
        try {
            if (this._$39979) {
                if (_$4326.isDebugEnabled()) {
                    _$4326.debug("Adding batch " + slimStatement.getStatementSource() + "<-" + map);
                }
                slimStatement.setParameters(map);
                slimStatement.addBatch(map);
                if (slimStatement.getBatchSize() % 10 == 0) {
                    this._$39980.executeBatch(slimStatement);
                }
            } else {
                slimStatement.setParameters(map);
                this._$39980.executeUpdate(slimStatement);
            }
        }
        catch (SQLException sQLException) {
            _$4326.warn("SQL exception while executing statement '" + slimStatement.getStatementSource() + "<-" + map + ": " + Monitor2DB.getNestedExceptionMessage(sQLException));
        }
    }

    public static String getNestedExceptionMessage(SQLException sQLException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sQLException.getMessage());
        stringBuffer.append("\nNext exception is:\n");
        if (sQLException.getNextException() != null) {
            stringBuffer.append(Monitor2DB.getNestedExceptionMessage(sQLException.getNextException()));
        }
        return stringBuffer.toString();
    }

    private void _$36590(SlimStatement slimStatement, Long l, RoundRobinDataSource roundRobinDataSource, int n) throws SQLException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(5);
        for (int i = 0; i < roundRobinDataSource.getNumColumns(); ++i) {
            hashMap.put("MONITORDATAROW_ID", l);
            hashMap.put("COLINDEX", new Integer(i));
            Object object = roundRobinDataSource.getTableDataItem(n, i);
            this._$40035(hashMap, object);
            this._$40020(slimStatement, hashMap);
            hashMap.clear();
        }
    }

    private void _$36590(SlimStatement slimStatement, Long l, List list) throws SQLException {
        int n = 0;
        HashMap<String, Number> hashMap = new HashMap<String, Number>(5);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            hashMap.put("MONITORDATAROW_ID", l);
            hashMap.put("COLINDEX", new Integer(n));
            Object e = iterator.next();
            this._$40035(hashMap, e);
            this._$40020(slimStatement, hashMap);
            hashMap.clear();
            ++n;
        }
    }

    private void _$40035(HashMap hashMap, Object object) {
        if (object instanceof Number) {
            hashMap.put("DOUBLEVALUE", new Double(((Number)object).doubleValue()));
            hashMap.put("STRINGVALUE", new ParameterValue("STRINGVALUE", null, 12));
        } else if (object instanceof String) {
            hashMap.put("DOUBLEVALUE", new ParameterValue("DOUBLEVALUE", null, 8));
            hashMap.put("STRINGVALUE", object.toString());
        } else {
            hashMap.put("DOUBLEVALUE", new ParameterValue("DOUBLEVALUE", null, 8));
            hashMap.put("STRINGVALUE", new ParameterValue("STRINGVALUE", null, 12));
        }
    }

    private Long _$5193(String string) throws SQLException {
        ResultSet resultSet;
        SlimStatement slimStatement = this._$39981.get(string);
        if (slimStatement == null) {
            slimStatement = this._$39980.createStatement(this._$39978, "generate.id", Collections.singletonMap("TABLE_NAME", string));
            this._$39981.put(string, slimStatement);
        }
        if ((resultSet = this._$39980.executeQuery(slimStatement).getResultSet()).next()) {
            long l = resultSet.getLong(1);
            resultSet.close();
            return new Long(l);
        }
        resultSet.close();
        return null;
    }

    public void deleteDataSet(Number number) throws SQLException {
        this.deleteDataSetRows(number);
        Map<String, Number> map = Collections.singletonMap("ID", number);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.datasets.by.id", map);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public void deleteDataSetRows(Number number) throws SQLException {
        this.deleteDataRow(number.longValue(), null, null);
    }

    public void deleteDataRow(Long l, java.util.Date date, String string) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(3);
        hashMap.put("MONITORDATASET_ID", l);
        if (date != null) {
            hashMap.put("CTIME", new Timestamp(date.getTime()));
        }
        if (string != null) {
            hashMap.put("ROWTYPE", string);
        }
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.values.by.dataset_id", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.rows.by.dataset_id", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public void deleteDataRowBefore(Long l, java.util.Date date, String string) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("MONITORDATASET_ID", l);
        hashMap.put("CTIME", new Timestamp(date.getTime()));
        if (string != null) {
            hashMap.put("ROWTYPE", string);
        }
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.rows.before", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.values.before", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public void deleteMonitor(Number number) throws SQLException {
        this._$40011(number);
        Map<String, Number> map = Collections.singletonMap("ID", number);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.by.id", map);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
    }

    private void _$40011(Number number) throws SQLException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
        hashMap.put("ID", number);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.values.by.id", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.rows.by.id", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.datasets.by.id", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public Long getMonitorID(String string) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("NAME", string);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.id.by.name", hashMap);
        SlimResult slimResult = this._$39980.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        if (resultSet.next()) {
            long l = resultSet.getLong(1);
            slimResult.close();
            slimStatement.close();
            return new Long(l);
        }
        slimResult.close();
        slimStatement.close();
        return null;
    }

    public List listMonitors() throws SQLException, IOException {
        ArrayList<DBRemoteMonitor> arrayList = new ArrayList<DBRemoteMonitor>();
        if (_$4326.isInfoEnabled()) {
            _$4326.info("List monitors from " + this._$39978);
        }
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "list.monitors", new Parameter[0]);
        SlimResult slimResult = this._$39980.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        while (resultSet.next()) {
            DBRemoteMonitor dBRemoteMonitor = new DBRemoteMonitor(new Long(resultSet.getLong("ID")), resultSet.getString("NAME"), "R".equals(resultSet.getString("STATUS")) || "R".equals(resultSet.getString("NEXT_STATUS")));
            if (_$4326.isInfoEnabled()) {
                _$4326.info(dBRemoteMonitor.toString());
            }
            arrayList.add(dBRemoteMonitor);
        }
        slimResult.close();
        slimStatement.close();
        return arrayList;
    }

    public List loadMonitor(Number number) throws SQLException, IOException {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
        hashMap.put("ID", number);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.by.id", hashMap);
        SlimResult slimResult = this._$39980.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        if (resultSet.next()) {
            int n;
            InputStream inputStream = resultSet.getAsciiStream("CONFIGXML");
            Vector vector = Monitor2XML.readXML((InputStream)inputStream);
            inputStream.close();
            slimResult.close();
            slimStatement.close();
            MonitorProperty monitorProperty = (MonitorProperty)vector.get(1);
            monitorProperty.setId(new Long(number.longValue()));
            slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.dataset.by.id", hashMap);
            slimResult = this._$39980.executeQuery(slimStatement);
            resultSet = slimResult.getResultSet();
            boolean bl = false;
            while (resultSet.next()) {
                RoundRobinDataSource roundRobinDataSource;
                n = resultSet.getInt("DATATYPE");
                long l = resultSet.getLong("ID");
                if (n == 0) {
                    roundRobinDataSource = monitorProperty.getData();
                    bl = true;
                } else {
                    if (monitorProperty.getConsolidationConfig().size() <= n - 1) continue;
                    roundRobinDataSource = (RoundRobinDataSource)monitorProperty.getConsolidationConfig().get(n - 1);
                }
                JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)vector.get(0);
                if (jCEditableVectorDataSource != null) {
                    roundRobinDataSource.setNumColumns(jCEditableVectorDataSource.getNumRows() - 1);
                    for (int i = 1; i < jCEditableVectorDataSource.getNumRows(); ++i) {
                        roundRobinDataSource.setColumnLabel(i - 1, jCEditableVectorDataSource.getTableDataItem(i, 0));
                    }
                }
                roundRobinDataSource.setId(new Long(l));
                this._$40050(l, roundRobinDataSource);
            }
            slimResult.close();
            slimStatement.close();
            if (!bl) {
                this._$40013(monitorProperty.getId(), null, monitorProperty.getData(), 0);
            }
            for (n = 0; n < monitorProperty.getConsolidationConfig().size(); ++n) {
                RoundRobinDataSource roundRobinDataSource = (RoundRobinDataSource)monitorProperty.getConsolidationConfig().get(n);
                if (roundRobinDataSource.getId() == null) {
                    this._$40013(monitorProperty.getId(), null, roundRobinDataSource, n + 1);
                    continue;
                }
                this._$40050(roundRobinDataSource.getId(), roundRobinDataSource);
            }
            return vector;
        }
        slimStatement.close();
        return null;
    }

    private List _$40051(Long l, java.util.Date date) throws SQLException {
        ArrayList<RoundRobinEvent> arrayList = new ArrayList<RoundRobinEvent>();
        HashMap<String, Comparable<Long>> hashMap = new HashMap<String, Comparable<Long>>(5);
        hashMap.put("ID", l);
        hashMap.put("CTIME", date);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.rows.by.date", hashMap);
        SlimResult slimResult = this._$39980.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        SlimStatement slimStatement2 = null;
        while (resultSet.next()) {
            String string = resultSet.getString("ROWTYPE");
            long l2 = resultSet.getLong("ID");
            hashMap = new HashMap(2);
            hashMap.put("ID", new Long(l2));
            Timestamp timestamp = resultSet.getTimestamp("CTIME");
            if (slimStatement2 == null) {
                slimStatement2 = this._$39980.createStatement(this._$39978, "select.monitor.values.by.row", hashMap);
            }
            RoundRobinEvent roundRobinEvent = new RoundRobinEvent(null, timestamp, new Vector(this._$40054(slimStatement2, hashMap)), "S".equals(string));
            arrayList.add(roundRobinEvent);
        }
        resultSet.close();
        if (slimStatement2 != null) {
            slimStatement2.close();
        }
        slimStatement.close();
        return arrayList;
    }

    private void _$40050(long l, RoundRobinDataSource roundRobinDataSource) throws SQLException {
        Vector vector = new Vector();
        Vector<Timestamp> vector2 = new Vector<Timestamp>();
        Vector vector3 = roundRobinDataSource.getColumnLabels();
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.rows.by.dataset", new Parameter[]{new ParameterValue("ID", (Object)new Long(l))});
        SlimStatement slimStatement2 = this._$39980.createStatement(this._$39978, "select.monitor.values.by.dataset", new Parameter[]{new ParameterValue("ID", (Object)new Long(l))});
        ResultSet resultSet = this._$39980.executeQuery(slimStatement2).getResultSet();
        Map<Long, List> map = this._$40058(resultSet);
        resultSet.close();
        slimStatement2.close();
        ResultSet resultSet2 = this._$39980.executeQuery(slimStatement).getResultSet();
        ArrayList<RoundRobinEvent> arrayList = new ArrayList<RoundRobinEvent>();
        while (resultSet2.next()) {
            String string = resultSet2.getString("ROWTYPE");
            long l2 = resultSet2.getLong("ID");
            Timestamp timestamp = resultSet2.getTimestamp("CTIME");
            ArrayList arrayList2 = map.get(l2);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList(0);
            }
            if ("R".equals(string)) {
                vector2.add(timestamp);
                vector.add(new Vector(arrayList2));
                continue;
            }
            RoundRobinEvent roundRobinEvent = new RoundRobinEvent(roundRobinDataSource, timestamp, new Vector(arrayList2));
            arrayList.add(roundRobinEvent);
        }
        resultSet2.close();
        slimStatement.close();
        roundRobinDataSource.setData(0, vector.size(), vector3.size(), vector2, vector3, vector);
        roundRobinDataSource.setLastSamples(arrayList);
    }

    private Map<Long, List> _$40058(ResultSet resultSet) throws SQLException {
        HashMap<Long, List> hashMap = new HashMap<Long, List>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Long l = null;
        while (resultSet.next()) {
            Long l2 = resultSet.getLong("MONITORDATAROW_ID");
            if (l2 == null) continue;
            if (l != null && !l2.equals(l)) {
                hashMap.put(l, arrayList);
                arrayList = new ArrayList();
            }
            double d = resultSet.getDouble("DOUBLEVALUE");
            String string = resultSet.getString("STRINGVALUE");
            if (string != null) {
                arrayList.add(string);
            } else {
                arrayList.add(new Double(d));
            }
            l = l2;
        }
        if (l != null) {
            hashMap.put(l, arrayList);
        }
        return hashMap;
    }

    private List _$40054(SlimStatement slimStatement, Map map) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        slimStatement.setParameters(map);
        SlimResult slimResult = this._$39980.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        while (resultSet.next()) {
            double d = resultSet.getDouble("DOUBLEVALUE");
            String string = resultSet.getString("STRINGVALUE");
            if (string != null) {
                arrayList.add(string);
                continue;
            }
            arrayList.add(new Double(d));
        }
        resultSet.close();
        return arrayList;
    }

    @Override
    public void addDataPoint(RoundRobinEvent roundRobinEvent) {
        RoundRobinDataSource roundRobinDataSource = roundRobinEvent.getRRDS();
        Long l = roundRobinDataSource.getId();
        if (l != null) {
            try {
                SlimStatement[] slimStatementArray = this._$40019();
                Long l2 = this._$5193("MONITORDATAROW");
                java.util.Date date = (java.util.Date)roundRobinEvent.getLabel();
                if (date != null) {
                    HashMap hashMap = new HashMap(5);
                    hashMap.put("MONITORDATAROW_ID", l2);
                    hashMap.put("MONITORDATASET_ID", l);
                    hashMap.put("CTIME", new Timestamp(date.getTime()));
                    int n = roundRobinEvent.isSample() ? 1 : 0;
                    hashMap.put("ROWTYPE", n != 0 ? "S" : "R");
                    slimStatementArray[0].setParameters((Map)hashMap);
                    this._$39980.executeUpdate(slimStatementArray[0]);
                    this._$36590(slimStatementArray[1], l2, roundRobinEvent.getRow());
                    if (this._$39979) {
                        this._$39980.executeBatch(slimStatementArray[1]);
                    }
                    if (n == 0 && roundRobinDataSource.getNumRows() >= roundRobinDataSource.getNumSamples() && roundRobinDataSource.getNumRows() > 0) {
                        this.deleteObsoleteRows(l, (java.util.Date)roundRobinDataSource.getTableRowLabel(0));
                    }
                }
                for (SlimStatement slimStatement : slimStatementArray) {
                    slimStatement.close();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new RuntimeException(sQLException);
            }
        }
    }

    public void deleteObsoleteRows(Long l, java.util.Date date) throws SQLException {
        this.deleteDataRowBefore(l, date, null);
    }

    private void _$40064(Long l) throws SQLException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("MONITORDATASET_ID", l);
        hashMap.put("ROWTYPE", "S");
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.values.by.dataset_id", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
        slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.rows.by.dataset_id", hashMap);
        this._$39980.executeUpdate(slimStatement);
        slimStatement.close();
    }

    public void resetDataSeries(Long l, RoundRobinDataSource roundRobinDataSource, int n) throws SQLException {
        Long l2 = roundRobinDataSource.getId();
        this._$40013(l, l2, roundRobinDataSource, n);
    }

    public void deleteUnusedDataSeries(Long l, List list) throws SQLException {
        List list2 = this.getDataSetIDs(l);
        list2.removeAll(list);
        for (Long l2 : list2) {
            if (l2 == null) continue;
            this.deleteDataSet(l2);
        }
    }

    public List getDataSetIDs(Long l) throws SQLException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Map<String, Long> map = Collections.singletonMap("MONITOR_ID", l);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.dataset.id", map);
        SlimResult slimResult = this._$39980.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        while (resultSet.next()) {
            long l2 = resultSet.getLong("ID");
            arrayList.add(new Long(l2));
        }
        slimResult.close();
        slimStatement.close();
        return arrayList;
    }

    @Override
    public void resetSamples(RoundRobinEvent roundRobinEvent) {
        try {
            this._$40064(roundRobinEvent.getRRDS().getId());
            SlimStatement[] slimStatementArray = this._$40019();
            if (roundRobinEvent.getRow() != null) {
                for (int i = 0; i < roundRobinEvent.getRow().size(); ++i) {
                    this._$36590(slimStatementArray, roundRobinEvent.getRRDS().getId(), (java.util.Date)roundRobinEvent.getLabel(), (List)roundRobinEvent.getRow().get(i), true, i);
                }
                if (this._$39979) {
                    this._$39980.executeBatch(slimStatementArray[0]);
                    this._$39980.executeBatch(slimStatementArray[1]);
                }
            }
            for (SlimStatement slimStatement : slimStatementArray) {
                slimStatement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public void setUseBatch(boolean bl) {
        this._$39979 = bl;
    }

    public boolean isUseBatch() {
        return this._$39979;
    }

    public String getUrl() {
        return this._$18973;
    }

    public String getDriver() {
        return this._$39972;
    }

    @Override
    public Vector getRunningMonitors() throws RemoteException {
        try {
            List list = this.listMonitors();
            Vector<String> vector = new Vector<String>();
            for (DBRemoteMonitor dBRemoteMonitor : list) {
                if (!dBRemoteMonitor._$40075) continue;
                vector.add(dBRemoteMonitor._$46);
            }
            return vector;
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public MonitorServer getMonitor(String string) throws RemoteException {
        Long l = null;
        try {
            l = this.getMonitorID(string);
            if (l != null) {
                Map<String, Long> map = Collections.singletonMap("ID", l);
                SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.keyValues.by.id", map);
                SlimResult slimResult = this._$39980.executeQuery(slimStatement);
                ResultSet resultSet = slimResult.getResultSet();
                if (resultSet.next()) {
                    DBRemoteMonitor dBRemoteMonitor = new DBRemoteMonitor(new Long(resultSet.getLong("ID")), resultSet.getString("NAME"), "R".equals(resultSet.getString("STATUS")));
                    slimResult.close();
                    slimStatement.close();
                    return dBRemoteMonitor;
                }
                slimResult.close();
                slimStatement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage(), sQLException);
        }
        return null;
    }

    @Override
    public MonitorServer newMonitor(String string, Vector vector) throws RemoteException {
        Long l = null;
        try {
            l = this.getMonitorID(string);
            if (l == null) {
                this._$40002(null, string, (MonitorProperty)vector.get(1), (JCEditableVectorDataSource)vector.get(0), "R");
                return new DBRemoteMonitor(l, string, true);
            }
            this.updateMonitor(l, string, (MonitorProperty)vector.get(1), (JCEditableVectorDataSource)vector.get(0), "U", true);
            return new DBRemoteMonitor(l, string, true);
        }
        catch (SQLException sQLException) {
            throw new RemoteException("Could not start new DB monitor '" + string + "':" + sQLException.getMessage(), sQLException);
        }
        catch (IOException iOException) {
            throw new RemoteException("Could not start new DB monitor '" + string + "':" + iOException.getMessage(), iOException);
        }
    }

    @Override
    public void stopMonitor(String string) throws RemoteException {
        Long l = null;
        try {
            l = this.getMonitorID(string);
            if (l != null) {
                this.updateMonitorNewStatus(l, "S");
            }
        }
        catch (SQLException sQLException) {
            throw new RemoteException("Could not stop DB monitor '" + string + "':" + sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public Vector getAvailableMonitors() throws RemoteException {
        try {
            List list = this.listMonitors();
            Vector<String> vector = new Vector<String>();
            for (DBRemoteMonitor dBRemoteMonitor : list) {
                vector.add(dBRemoteMonitor._$46);
            }
            return vector;
        }
        catch (IOException iOException) {
            throw new RemoteException(iOException.getMessage(), iOException);
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage(), sQLException);
        }
    }

    @Override
    public MonitorServer runMonitor(String string) throws RemoteException {
        Long l = null;
        try {
            l = this.getMonitorID(string);
            if (l != null) {
                this.updateMonitorNewStatus(l, "R");
                return new DBRemoteMonitor(l, string, true);
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RemoteException("Could not stop DB monitor '" + string + "':" + sQLException.getMessage(), sQLException);
        }
    }

    public String[] getMonitorStatus(Long l) throws SQLException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>(2);
        hashMap.put("ID", l);
        SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "select.monitor.status.by.id", hashMap);
        SlimResult slimResult = this._$39980.executeQuery(slimStatement);
        ResultSet resultSet = slimResult.getResultSet();
        if (resultSet.next()) {
            String[] stringArray = new String[]{resultSet.getString("STATUS"), resultSet.getString("NEXT_STATUS")};
            slimResult.close();
            slimStatement.close();
            return stringArray;
        }
        slimResult.close();
        slimStatement.close();
        return null;
    }

    public int getRequiredSchemaVersion() {
        return 0;
    }

    @Override
    public void removeDataPoint(RoundRobinEvent roundRobinEvent) {
        RoundRobinDataSource roundRobinDataSource = roundRobinEvent.getRRDS();
        Long l = roundRobinDataSource.getId();
        if (l != null) {
            try {
                java.util.Date date = (java.util.Date)roundRobinEvent.getLabel();
                if (date != null) {
                    HashMap<String, Comparable<Long>> hashMap = new HashMap<String, Comparable<Long>>(5);
                    hashMap.put("MONITORDATASET_ID", l);
                    hashMap.put("CTIME", new Timestamp(date.getTime()));
                    SlimStatement slimStatement = this._$39980.createStatement(this._$39978, "delete.monitor.rows.by.date", hashMap);
                    SlimUpdateResult slimUpdateResult = this._$39980.executeUpdate(slimStatement);
                    if (_$4326.isInfoEnabled()) {
                        _$4326.info("Deleted " + slimUpdateResult.updateCount() + " data rows for '" + roundRobinDataSource.getName() + "' and timestamp " + date);
                    }
                }
            }
            catch (SQLException sQLException) {
                _$4326.error("Failed to delete data rows for '" + roundRobinDataSource.getName() + ", because: " + sQLException.getMessage(), sQLException);
            }
        }
    }

    public class DBRemoteMonitor
    implements MonitorServer {
        private String _$46;
        private Long _$40083;
        private boolean _$40075;

        DBRemoteMonitor(Long l, String string, boolean bl) {
            this._$46 = string;
            this._$40083 = l;
            this._$40075 = bl;
        }

        public String toString() {
            return "DBRemoteMonitor[name=" + this._$46 + ",remoteMonitorID=" + this._$40083 + ",running=" + this._$40075 + "]";
        }

        public Vector getMonitor() throws RemoteException {
            if (this._$40083 != null) {
                List list = null;
                try {
                    list = Monitor2DB.this.loadMonitor(this._$40083);
                }
                catch (IOException iOException) {
                    throw new RemoteException("Cannot load remote DB monitor: " + iOException.getMessage(), iOException);
                }
                catch (SQLException sQLException) {
                    throw new RemoteException("Failed to load remote DB monitor: " + sQLException.getMessage(), sQLException);
                }
                if (list != null) {
                    return new Vector(list);
                }
            }
            return null;
        }

        public void setMonitor(Vector vector) throws RemoteException {
            JCEditableVectorDataSource jCEditableVectorDataSource = (JCEditableVectorDataSource)vector.get(0);
            MonitorProperty monitorProperty = (MonitorProperty)vector.get(1);
            try {
                Long l = monitorProperty.getId();
                if (!this._$40083.equals(l)) {
                    throw new RuntimeException("DB Monitor could not be updated because IDs do not match: " + l + "<>" + this._$40083);
                }
                Monitor2DB.this.updateMonitor(l, monitorProperty.getChartName(), monitorProperty, jCEditableVectorDataSource, "U", true);
            }
            catch (SQLException sQLException) {
                throw new RemoteException("Could not update remote monitor because of DB error: " + sQLException.getMessage(), sQLException);
            }
            catch (IOException iOException) {
                throw new RemoteException("Could not update remote monitor because of IO error: " + iOException.getMessage(), iOException);
            }
        }

        public void addRemoteListener(MonitorObserver monitorObserver) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        public void removeRemoteListener(MonitorObserver monitorObserver) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        public Vector getRowsAfter(java.util.Date date) throws RemoteException {
            try {
                List list = Monitor2DB.this._$40051(this._$40083, date);
                return new Vector(list);
            }
            catch (SQLException sQLException) {
                throw new RemoteException("Failed to load rows after '" + date + "': " + sQLException.getMessage(), sQLException);
            }
        }
    }
}

