/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.monitor.alarm;

import com.agentpp.common.FilePanel;
import com.agentpp.common.TextInputPanel;
import com.agentpp.common.formula.FormulaParser;
import com.agentpp.common.formula.ParseException;
import com.agentpp.explorer.monitor.alarm.AlarmConfig;
import com.agentpp.explorer.monitor.parser.TemplateParser;
import com.agentpp.explorer.script.ScriptContext;
import com.agentpp.mib.MIBRepository;
import com.agentpp.snmp.GenTarget;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.Result;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class AlarmConfigPanel
extends JPanel
implements ActionListener {
    private Border _$4251;
    private BorderLayout _$4239 = new BorderLayout();
    private JPanel _$23855 = new JPanel();
    private GridBagLayout _$5758 = new GridBagLayout();
    private JLabel _$48719 = new JLabel();
    private JTextField _$48720 = new JTextField();
    private JLabel _$34961 = new JLabel();
    private JTextField _$39876 = new JTextField();
    private TitledBorder _$5640;
    private String _$39877;
    private MIBRepository _$18643;
    private JPanel _$23856 = new JPanel();
    private GridBagLayout _$6308 = new GridBagLayout();
    private JLabel _$27167 = new JLabel();
    private JComboBox _$4262 = new JComboBox();
    private JLabel _$48721 = new JLabel();
    private JComboBox _$29750 = new JComboBox();
    private Border _$30404;
    private TitledBorder _$48722;
    private static FormulaParser _$34601 = new FormulaParser();
    private static TemplateParser _$39880 = new TemplateParser();
    private static final Object[] _$48723 = new Object[]{Level.INFO, Level.WARN, Level.ERROR, Level.FATAL};
    private FilePanel _$48724 = new FilePanel();
    private JTabbedPane _$48392 = new JTabbedPane();
    private JPanel _$48725 = new JPanel();
    private JPanel _$48726 = new JPanel();
    private GridBagLayout _$39886 = new GridBagLayout();
    private JLabel _$48727 = new JLabel();
    private JTextField _$48728 = new JTextField();
    private FilePanel _$18765 = new FilePanel();
    private GridBagLayout _$39889 = new GridBagLayout();
    private static Logger _$4675 = Logger.getLogger("Monitor.Alarm");
    private static ExampleFileFilter _$27733 = new ExampleFileFilter("vm", "MIB Explorer Scripts");
    private JCheckBox _$48729 = new JCheckBox();
    private JButton _$48730 = new JButton();
    private TextInputPanel _$48731 = new TextInputPanel();
    private TextInputPanel _$48732 = new TextInputPanel();
    JCheckBox embedClearScript = new JCheckBox();
    JButton jButtonEditClearScript = new JButton();
    JButton jButtonTestClear = new JButton();
    JButton jButtonTestRaise = new JButton();
    private Runnable _$48737 = null;
    private Runnable _$48738 = null;

    public AlarmConfigPanel(UserConfigFile userConfigFile, Hashtable hashtable, MIBRepository mIBRepository) {
        this._$18643 = mIBRepository;
        int n = 0;
        this._$4262.addItem("MIB Explorer");
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this._$4262.addItem(enumeration.nextElement());
            ++n;
        }
        this._$4262.setSelectedIndex(0);
        for (int i = 0; i < _$48723.length; ++i) {
            this._$29750.addItem(_$48723[i]);
        }
        this._$29750.setSelectedIndex(0);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$18765.addActionListener(this);
        this._$18765.setDefaultPath(userConfigFile.get("mibexplorer.scriptsPath", ""));
        this._$18765.setFilter(_$27733);
        this._$48724.addActionListener(this);
        this._$48724.setDefaultPath(userConfigFile.get("mibexplorer.scriptsPath", ""));
        this._$48724.setFilter(_$27733);
    }

    public AlarmConfigPanel() {
        this(null, null, null);
    }

    public void setTestClearAlarm(Runnable runnable) {
        this._$48737 = runnable;
    }

    public void setTestRaiseAlarm(Runnable runnable) {
        this._$48738 = runnable;
    }

    void jbInit() throws Exception {
        this._$4251 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this._$5640 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), "Alarm Text");
        this._$30404 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this._$48722 = new TitledBorder(this._$30404, "Target");
        this.setLayout(this._$4239);
        this._$23855.setLayout(this._$5758);
        this._$48719.setText("Condition:");
        this._$34961.setText("Value:");
        this._$39876.setToolTipText("Alarm text template which may be any string optionally containing value references enclosed in '{' and '}' brakets (e.g. \"Alarm value = {Z*100}\")");
        this._$39876.setText("Z");
        this._$23855.setBorder(this._$5640);
        this._$23856.setLayout(this._$6308);
        this._$27167.setText("Target:");
        this._$48721.setText("Log Severity:");
        this._$23856.setBorder(this._$48722);
        this._$48724.setLabelText("Script:");
        this._$48724.setToolTipText("Script to be executed if alarm is cleared (that is if clear condition is true and alarm is open)");
        this._$48725.setLayout(this._$39886);
        this._$48727.setText("Condition:");
        this._$18765.setToolTipText("Script to be executed if alarm is raised (that is if raise condition is true and clear condition is not present or alarm is not already raised)");
        this._$18765.setLabelText("Script:");
        this._$48726.setLayout(this._$39889);
        this._$48728.setToolTipText("Boolean expression which could reference any data from the primary table (e.g. \"Z > 100\" = raise alarm if last retrieved value > 100)");
        this._$48720.setToolTipText("Boolean expression which could reference any data from the primary table (e.g. \"Z \\< 90\" = clear alarm if last retrieved value \\< 90)");
        this._$4262.setToolTipText("Default target for Scripts. This target will be saved with this monitor and is thus independent from the MIB Explorer config");
        this._$29750.setToolTipText("The logging severity. Choose ERROR or FATAL if alarm should trigger an email");
        this._$48729.setToolTipText("If checked the supplied script will be copied into the alarm configuration instead referencing it at runtime through a file name");
        this._$48729.setText("Embed script");
        this._$48729.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AlarmConfigPanel.this.embeddedScript_itemStateChanged(itemEvent);
            }
        });
        this._$48730.setEnabled(false);
        this._$48730.setToolTipText("Edit the embedded script with a text editor");
        this._$48730.setText("Edit...");
        this._$48730.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConfigPanel.this.jButtonEditScript_actionPerformed(actionEvent);
            }
        });
        this.embedClearScript.setToolTipText("If checked the supplied script will be copied into the alarm configuration instead referencing it at runtime through a file name");
        this.embedClearScript.setText("Embed Script");
        this.embedClearScript.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AlarmConfigPanel.this.embedClearScript_itemStateChanged(itemEvent);
            }
        });
        this.jButtonEditClearScript.setEnabled(false);
        this.jButtonEditClearScript.setToolTipText("Edit the embedded script with a text editor");
        this.jButtonEditClearScript.setText("Edit...");
        this.jButtonEditClearScript.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConfigPanel.this.jButtonEditClearScript_actionPerformed(actionEvent);
            }
        });
        this.jButtonTestClear.setToolTipText("Execute the specified script as if the given condition would be true");
        this.jButtonTestClear.setText("Test");
        this.jButtonTestClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConfigPanel.this.jButtonTestClear_actionPerformed(actionEvent);
            }
        });
        this.jButtonTestRaise.setText("Test");
        this.jButtonTestRaise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmConfigPanel.this.jButtonTestRaise_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this._$23855, "South");
        this._$23855.add((Component)this._$34961, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$23855.add((Component)this._$39876, new GridBagConstraints(1, 1, 1, 1, 0.2, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$23856, "North");
        this._$23856.add((Component)this._$27167, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this._$23856.add((Component)this._$4262, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._$23856.add((Component)this._$48721, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$23856.add((Component)this._$29750, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$48392, "Center");
        this._$48392.add((Component)this._$48725, "Raise");
        this._$48725.add((Component)this._$48728, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._$48725.add((Component)this._$18765, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 0, 10), 0, 0));
        this._$48725.add((Component)this._$48727, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$48725.add((Component)this._$48729, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this._$48392.add((Component)this._$48726, "Clear");
        this._$48726.add((Component)this._$48719, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$48726.add((Component)this._$48720, new GridBagConstraints(1, 0, 3, 1, 0.2, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this._$48726.add((Component)this._$48724, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 17, 2, new Insets(10, 20, 10, 10), 0, 0));
        this._$48726.add((Component)this.embedClearScript, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this._$48725.add((Component)this._$48730, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 10, 0), 0, 0));
        this._$48726.add((Component)this.jButtonEditClearScript, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this._$48726.add((Component)this.jButtonTestClear, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 20), 0, 0));
        this._$48725.add((Component)this.jButtonTestRaise, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 20), 0, 0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            try {
                if (actionEvent.getSource().equals(this._$18765)) {
                    String string = this._$18765.getPath();
                    File file = new File(string);
                    if (!file.isAbsolute()) {
                        file = new File(this._$39877, string);
                    }
                    if (!file.isFile()) {
                        throw new FileNotFoundException(file.getPath());
                    }
                } else {
                    String string = this._$48724.getPath();
                    File file = new File(string);
                    if (!file.isAbsolute()) {
                        file = new File(this._$39877, string);
                    }
                    if (!file.isFile()) {
                        throw new FileNotFoundException(file.getPath());
                    }
                }
            }
            catch (Exception exception) {
                if (!actionEvent.getActionCommand().equals("FILE_SELECTED")) break block8;
                JOptionPane.showMessageDialog(this, "Cannot find script: " + exception.getMessage(), "Invalid PDU", 0);
            }
        }
    }

    public void setScriptDirectory(String string) {
        this._$39877 = string;
    }

    public String getScriptDirectory() {
        return this._$39877;
    }

    public void load(AlarmConfig alarmConfig) {
        this._$48729.setSelected(alarmConfig.isEmbeddedRaiseScript());
        if (alarmConfig.isEmbeddedRaiseScript()) {
            this._$48731.setText(alarmConfig.getRaiseScript());
            this._$48732.setText(alarmConfig.getClearScript());
        } else {
            this._$18765.setPath(alarmConfig.getRaiseScript());
            this._$48724.setPath(alarmConfig.getClearScript());
        }
        this._$48729.setSelected(alarmConfig.isEmbeddedRaiseScript());
        if (alarmConfig.isEmbeddedClearScript()) {
            this._$48732.setText(alarmConfig.getClearScript());
        } else {
            this._$48724.setPath(alarmConfig.getClearScript());
        }
        this._$48728.setText(alarmConfig.getRaiseFormula());
        this._$48720.setText(alarmConfig.getClearFormula());
        this._$29750.setSelectedItem(Level.toLevel(alarmConfig.getLogSeverity()));
        this._$39876.setText(alarmConfig.getValueFormula());
        if (alarmConfig.getTarget() == null) {
            this._$4262.setSelectedIndex(0);
        } else {
            this._$4262.setSelectedItem(alarmConfig.getTarget());
        }
        this.actionPerformed(new ActionEvent(this._$18765, 1001, "LOADED"));
        this.actionPerformed(new ActionEvent(this._$48724, 1001, "LOADED"));
    }

    public void save(AlarmConfig alarmConfig) {
        alarmConfig.setEmbeddedRaiseScript(this._$48729.isSelected());
        if (this._$48729.isSelected()) {
            alarmConfig.setRaiseScript(this._$48731.getText());
        } else {
            alarmConfig.setRaiseScript(this._$18765.getPath());
        }
        alarmConfig.setEmbeddedClearScript(this.embedClearScript.isSelected());
        if (this.embedClearScript.isSelected()) {
            alarmConfig.setClearScript(this._$48732.getText());
        } else {
            alarmConfig.setClearScript(this._$48724.getPath());
        }
        alarmConfig.setRaiseFormula(this._$48728.getText());
        alarmConfig.setLogSeverity(((Level)this._$29750.getSelectedItem()).toInt());
        alarmConfig.setClearFormula(this._$48720.getText());
        alarmConfig.setValueFormula(this._$39876.getText());
        if (this._$4262.getSelectedIndex() == 0) {
            alarmConfig.setTarget(null);
        } else {
            alarmConfig.setTarget((GenTarget)this._$4262.getSelectedItem());
        }
    }

    public static synchronized String getValueExpression(String string, TableDataModel tableDataModel, int n, int n2, MIBRepository mIBRepository) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        AlarmConfigPanel._$34601.rep = mIBRepository;
        AlarmConfigPanel._$34601.tableModel = tableDataModel;
        AlarmConfigPanel._$34601.currentRow = n2;
        AlarmConfigPanel._$34601.currentCol = n;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Vector vector = _$39880.parseStream(stringReader);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof StringBuffer) {
                    try {
                        Expression expression = _$34601.parseStream(new StringReader(e.toString()), 2);
                        Result result = expression.evaluate();
                        stringBuffer.append(result);
                    }
                    catch (ParseException parseException) {
                        _$4675.error("Syntax error in alarm value formula of row " + (char)(64 + n) + ": " + parseException.getMessage());
                        stringBuffer.append(e.toString());
                    }
                    continue;
                }
                stringBuffer.append(e);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            _$4675.error("Syntax error in alarm value formula of row " + (char)(64 + n) + ": " + exception.getMessage());
            return "";
        }
    }

    public static synchronized Expression getConditionalExpression(String string, TableDataModel tableDataModel, int n, int n2) throws ParseException {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        AlarmConfigPanel._$34601.currentRow = n2;
        AlarmConfigPanel._$34601.currentCol = n;
        AlarmConfigPanel._$34601.tableModel = tableDataModel;
        return _$34601.parseStream(stringReader, 3);
    }

    public boolean isOK() {
        try {
            AlarmConfigPanel.getValueExpression(this._$39876.getText(), null, 0, 0, this._$18643);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, "Syntax error in value formula: " + parseException.getMessage(), "Syntax Error", 0);
            return false;
        }
        try {
            Expression expression = AlarmConfigPanel.getConditionalExpression(this._$48728.getText(), null, 0, 0);
            if (expression == null) {
                JOptionPane.showMessageDialog(this, "Alarm raising formula cannot be empty!", "Invalid Formula", 0);
                return false;
            }
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, "Syntax error in raising formula: " + parseException.getMessage(), "Syntax Error", 0);
            return false;
        }
        try {
            AlarmConfigPanel.getConditionalExpression(this._$48728.getText(), null, 0, 0);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, "Syntax error in clearing formula: " + parseException.getMessage(), "Syntax Error", 0);
            return false;
        }
        return this._$48748(this._$18765.getPath()) && this._$48748(this._$48724.getPath());
    }

    private boolean _$48748(String string) {
        File file;
        if (string != null && string.length() > 0 && !(file = new File(this._$18765.getPath())).isFile()) {
            JOptionPane.showMessageDialog(this, "Script not found: " + string, "Invalid Script", 0);
            return false;
        }
        return true;
    }

    void embeddedScript_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this._$48730.setEnabled(true);
            String string = ScriptContext.getScriptText((String)this._$18765.getPath());
            if (string != null) {
                this._$48731.setText(string);
            }
            this._$18765.setPathTextEnabled(false);
        } else {
            this._$48730.setEnabled(false);
            this._$18765.setPathTextEnabled(true);
        }
    }

    void jButtonEditScript_actionPerformed(ActionEvent actionEvent) {
        String string = this._$48731.getText();
        if (JOptionPane.showOptionDialog(this, this._$48731, "Raise Alarm Script", 2, -1, null, new String[]{"Save", "Cancel"}, "Save") == 2) {
            this._$48731.setText(string);
        }
    }

    void embedClearScript_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.jButtonEditClearScript.setEnabled(true);
            String string = ScriptContext.getScriptText((String)this._$48724.getPath());
            if (string != null) {
                this._$48732.setText(string);
            }
            this._$48724.setPathTextEnabled(false);
        } else {
            this.jButtonEditClearScript.setEnabled(false);
            this._$48724.setPathTextEnabled(true);
        }
    }

    void jButtonTestClear_actionPerformed(ActionEvent actionEvent) {
        if (this._$48737 != null) {
            this._$48737.run();
            JOptionPane.showMessageDialog(this, new String[]{"Alarm has been cleared for testing.", "Please check in the Log panel for entries of category", "'Monitor.Alarm' and 'Script' for details."}, "Alarm Test", 1);
        }
    }

    void jButtonTestRaise_actionPerformed(ActionEvent actionEvent) {
        if (this._$48738 != null) {
            this._$48738.run();
            JOptionPane.showMessageDialog(this, new String[]{"Alarm has been raised for testing.", "Please check in the Log panel for entries of category", "'Monitor.Alarm' and 'Script' for details."}, "Alarm Test", 1);
        }
    }

    void jButtonEditClearScript_actionPerformed(ActionEvent actionEvent) {
        String string = this._$48732.getText();
        if (JOptionPane.showOptionDialog(this, this._$48732, "Clear Alarm Script", 2, -1, null, new String[]{"Save", "Cancel"}, "Save") == 2) {
            this._$48732.setText(string);
        }
    }
}

