/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.monitor;

import com.agentpp.common.table.ConsolidationFunction;
import com.agentpp.common.table.RoundRobinDataSource;
import com.agentpp.explorer.monitor.AxisProperty;
import com.agentpp.explorer.monitor.Chart3dAreaProperty;
import com.agentpp.explorer.monitor.ExportProperty;
import com.agentpp.explorer.monitor.LegendProperty;
import com.agentpp.explorer.monitor.TitleProperty;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart3d.JCChart3d;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;

public class MonitorProperty
implements Serializable {
    public static final long serialVersionUID = -4709153269928786254L;
    public static final int DATA_MODE_DEFAULT = 0;
    public static final int DATA_MODE_DELTA = 1;
    public static final int DATA_SOURCE_DEFAULT = 0;
    public static final int DATA_SOURCE_TRAP = 1;
    private int dataMode;
    private transient JCChart chart;
    private transient JCChart3d chart3d;
    private Color chartForeground;
    private Color chartBackground;
    private int chartType;
    private AxisProperty YAxis;
    private AxisProperty XAxis;
    private Font chartAreaFont;
    private LegendProperty legend;
    private TitleProperty header = new TitleProperty();
    private TitleProperty footer = new TitleProperty();
    private int dataCoverage;
    private Vector consolidationConfig = new Vector(1);
    private String chartName;
    private RoundRobinDataSource data;
    private boolean cacheIndexes;
    private boolean fixedRate = true;
    private ExportProperty exportConfig = new ExportProperty();
    private int depth = 0;
    private int elevation = 0;
    private int rotation = 0;
    private Date startTime = null;
    private boolean useChart3d = false;
    private Chart3dAreaProperty chart3dAreaConfig = new Chart3dAreaProperty();
    private AxisProperty ZAxis;
    private int sizeX = 640;
    private int sizeY = 200;
    private int dataSource = 0;
    private String dataSourcePrefix = null;
    private double deltaRateFactor = 0.0;
    private boolean useRoundStartTime = false;
    private transient Long id;
    private transient String name;

    public MonitorProperty(JCChart chart, RoundRobinDataSource data) {
        this.chart = chart;
        this.data = data;
        this.useChart3d = false;
        this.getDefaultValues();
    }

    public MonitorProperty(JCChart3d chart, RoundRobinDataSource data) {
        this.chart3d = chart;
        this.data = data;
        this.useChart3d = true;
        this.getDefaultValues();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setChart(JCChart chart) {
        this.chart3d = null;
        this.chart = chart;
        this.save();
    }

    public void setChart(JCChart3d chart) {
        this.chart = null;
        this.chart3d = chart;
        this.save();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getDataMode() {
        return this.dataMode;
    }

    public void setDataMode(int newDataMode) {
        this.dataMode = newDataMode;
    }

    public void getDefaultValues() {
        if (this.isUseChart3d()) {
            this.ZAxis = new AxisProperty(this.chart3d.getChart3dArea().getZAxis());
            this.YAxis = new AxisProperty(this.chart3d.getChart3dArea().getYAxis());
            this.XAxis = new AxisProperty(this.chart3d.getChart3dArea().getXAxis());
            this.chartForeground = this.chart3d.getForeground();
            this.chartBackground = this.chart3d.getBackground();
            this.dataMode = 0;
            this.legend = new LegendProperty(this.chart3d.getLegend());
            MonitorProperty.loadTitle(this.header, (JLabel)this.chart3d.getHeader());
            MonitorProperty.loadTitle(this.footer, (JLabel)this.chart3d.getFooter());
            this.chartName = "";
            this.chart3dAreaConfig = new Chart3dAreaProperty(this.chart3d.getChart3dArea());
        } else {
            this.ZAxis = null;
            this.YAxis = new AxisProperty(this.chart.getDataView(0).getYAxis());
            this.XAxis = new AxisProperty(this.chart.getDataView(0).getXAxis());
            this.chartForeground = this.chart.getForeground();
            this.chartBackground = this.chart.getBackground();
            this.dataMode = 0;
            this.legend = new LegendProperty(this.chart.getLegend());
            MonitorProperty.loadTitle(this.header, (JLabel)this.chart.getHeader());
            MonitorProperty.loadTitle(this.footer, (JLabel)this.chart.getFooter());
            this.chartName = "";
            this.depth = this.chart.getChartArea().getDepth();
        }
    }

    private static void saveTitle(TitleProperty p, JLabel h) {
        h.setText(p.getText());
        h.setVisible(p.isVisible());
        h.setFont(p.getFont());
        h.setForeground(p.getForeground());
        h.setBackground(p.getForeground());
        h.setOpaque(p.isOpaque());
    }

    private static void loadTitle(TitleProperty p, JLabel h) {
        p.setBackground(h.getBackground());
        p.setForeground(h.getForeground());
        p.setFont(h.getFont());
        p.setOpaque(h.isOpaque());
        p.setVisible(h.isVisible());
        p.setText(h.getText());
    }

    public void save() {
        if (this.chart != null) {
            if (this.XAxis == null) {
                this.XAxis = new AxisProperty(this.chart.getDataView(0).getXAxis());
            }
            if (this.YAxis == null) {
                this.YAxis = new AxisProperty(this.chart.getDataView(0).getYAxis());
            }
            this.XAxis.getAxis(this.chart.getDataView(0).getXAxis());
            this.YAxis.getAxis(this.chart.getDataView(0).getYAxis());
            this.chart.setForeground(this.chartForeground);
            this.chart.setBackground(this.chartBackground);
            this.chart.getDataView(0).setChartType(this.chartType);
            if (this.legend == null) {
                this.legend = new LegendProperty(this.chart.getLegend());
            }
            this.legend.getLegend(this.chart.getLegend());
            if (this.header == null) {
                this.header = new TitleProperty();
            }
            if (this.footer == null) {
                this.footer = new TitleProperty();
            }
            MonitorProperty.saveTitle(this.header, (JLabel)this.chart.getHeader());
            MonitorProperty.saveTitle(this.footer, (JLabel)this.chart.getFooter());
            this.chart.getLegend().setName(this.chartName);
            this.chart.setName(this.chartName);
            this.chart.getChartArea().setDepth(this.depth);
            this.chart.getChartArea().setElevation(this.elevation);
            this.chart.getChartArea().setRotation(this.rotation);
        } else {
            if (this.XAxis == null) {
                this.XAxis = new AxisProperty(this.chart3d.getChart3dArea().getXAxis());
            }
            if (this.YAxis == null) {
                this.YAxis = new AxisProperty(this.chart3d.getChart3dArea().getYAxis());
            }
            if (this.ZAxis == null) {
                this.ZAxis = new AxisProperty(this.chart3d.getChart3dArea().getZAxis());
            }
            this.XAxis.getAxis(this.chart3d.getChart3dArea().getXAxis());
            this.YAxis.getAxis(this.chart3d.getChart3dArea().getYAxis());
            this.ZAxis.getAxis(this.chart3d.getChart3dArea().getZAxis());
            this.chart3d.setForeground(this.chartForeground);
            this.chart3d.setBackground(this.chartBackground);
            this.chart3d.getDataView(0).setChartType(this.chartType);
            if (this.legend == null) {
                this.legend = new LegendProperty(this.chart3d.getLegend());
            }
            this.legend.getLegend(this.chart3d.getLegend());
            if (this.header == null) {
                this.header = new TitleProperty();
            }
            if (this.footer == null) {
                this.footer = new TitleProperty();
            }
            MonitorProperty.saveTitle(this.header, (JLabel)this.chart3d.getHeader());
            MonitorProperty.saveTitle(this.footer, (JLabel)this.chart3d.getFooter());
            this.chart3d.getLegend().setName(this.chartName);
            this.chart3d.setName(this.chartName);
            if (this.chart3dAreaConfig == null) {
                this.chart3dAreaConfig = new Chart3dAreaProperty(this.chart3d.getChart3dArea());
            }
            this.chart3dAreaConfig.getChart3dArea(this.chart3d.getChart3dArea());
        }
    }

    public void setChartForeground(Color newChartForeground) {
        this.chartForeground = newChartForeground;
    }

    public Color getChartForeground() {
        return this.chartForeground;
    }

    public void setChartBackground(Color newChartBackground) {
        this.chartBackground = newChartBackground;
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    public void setChartType(int newChartType) {
        this.chartType = newChartType;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setXAxis(AxisProperty newXAxis) {
        this.XAxis = newXAxis;
        if (this.useChart3d) {
            if (this.chart3d != null) {
                this.XAxis.getAxis(this.chart3d.getChart3dArea().getXAxis());
            }
        } else if (this.chart != null) {
            this.XAxis.getAxis(this.chart.getChartArea().getXAxis(0));
        }
    }

    public AxisProperty getXAxis() {
        return this.XAxis;
    }

    public void setYAxis(AxisProperty newYAxis) {
        this.YAxis = newYAxis;
        if (this.useChart3d) {
            if (this.chart3d != null) {
                this.YAxis.getAxis(this.chart3d.getChart3dArea().getYAxis());
            }
        } else if (this.chart != null) {
            this.YAxis.getAxis(this.chart.getChartArea().getYAxis(0));
        }
    }

    public void setZAxis(AxisProperty newZAxis) {
        this.ZAxis = newZAxis;
        if (this.chart3d != null) {
            this.ZAxis.getAxis(this.chart3d.getChart3dArea().getZAxis());
        }
    }

    public AxisProperty getYAxis() {
        return this.YAxis;
    }

    public void setChartAreaFont(Font newChartAreaFont) {
        this.chartAreaFont = newChartAreaFont;
    }

    public Font getChartAreaFont() {
        return this.chartAreaFont;
    }

    public void setLegend(LegendProperty newLegend) {
        this.legend = newLegend;
        this.legend.getLegend(this.chart.getLegend());
    }

    public LegendProperty getLegend() {
        return this.legend;
    }

    public void setHeader(TitleProperty newHeader) {
        this.header = newHeader;
        MonitorProperty.saveTitle(this.header, (JLabel)this.chart.getHeader());
    }

    public TitleProperty getHeader() {
        return this.header;
    }

    public void setFooter(TitleProperty newFooter) {
        this.footer = newFooter;
        MonitorProperty.saveTitle(this.footer, (JLabel)this.chart.getHeader());
    }

    public TitleProperty getFooter() {
        return this.footer;
    }

    public void setDataCoverage(int newDataCoverage) {
        this.dataCoverage = newDataCoverage;
    }

    public int getDataCoverage() {
        return this.dataCoverage;
    }

    public void setNumPrimarySamples(int newNumPrimarySamples) {
        this.data.setNumSamples(newNumPrimarySamples);
    }

    public int getNumPrimarySamples() {
        return this.data.getNumSamples();
    }

    public void setSampleInterval(int newSampleInterval) {
        this.data.setSampleRate(newSampleInterval);
    }

    public int getSampleInterval() {
        return this.data.getSampleRate();
    }

    public void setConsolidationConfig(Vector newConsolidationConfig) {
        this.consolidationConfig = newConsolidationConfig;
    }

    public ConsolidationFunction getConsolidation(String name) {
        Enumeration en = this.consolidationConfig.elements();
        while (en.hasMoreElements()) {
            ConsolidationFunction cf = (ConsolidationFunction)en.nextElement();
            if (cf.getName() == null || !cf.getName().equals(name)) continue;
            return cf;
        }
        return null;
    }

    public Vector getConsolidationConfig() {
        return this.consolidationConfig;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public String getChartName() {
        return this.chartName;
    }

    public RoundRobinDataSource getData() {
        return this.data;
    }

    public void setData(RoundRobinDataSource data) {
        this.data = data;
    }

    public void activate() {
        this.data.activate();
        if (this.consolidationConfig != null) {
            Enumeration en = this.consolidationConfig.elements();
            while (en.hasMoreElements()) {
                RoundRobinDataSource rr = (RoundRobinDataSource)en.nextElement();
                this.data.addRoundRobinListener(rr);
                rr.activate();
            }
        }
    }

    public void deactivate() {
        this.data.deactivate();
        if (this.consolidationConfig != null) {
            Enumeration en = this.consolidationConfig.elements();
            while (en.hasMoreElements()) {
                RoundRobinDataSource rr = (RoundRobinDataSource)en.nextElement();
                this.data.removeRoundRobinListener(rr);
                rr.deactivate();
            }
        }
    }

    public void setCacheIndexes(boolean cacheIndexes) {
        this.cacheIndexes = cacheIndexes;
    }

    public boolean isCacheIndexes() {
        return this.cacheIndexes;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public void setExportConfig(ExportProperty exportConfig) {
        this.exportConfig = exportConfig;
    }

    public ExportProperty getExportConfig() {
        return this.exportConfig;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setElevation(int elevation) {
        this.elevation = elevation;
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public boolean isUseChart3d() {
        return this.useChart3d;
    }

    public void setUseChart3d(boolean useChart3d) {
        this.useChart3d = useChart3d;
    }

    public AxisProperty getZAxis() {
        return this.ZAxis;
    }

    public Chart3dAreaProperty getChart3dAreaConfig() {
        return this.chart3dAreaConfig;
    }

    public void setChart3dAreaConfig(Chart3dAreaProperty chart3dAreaConfig) {
        this.chart3dAreaConfig = chart3dAreaConfig;
        if (this.useChart3d && this.chart3d != null) {
            chart3dAreaConfig.getChart3dArea(this.chart3d.getChart3dArea());
        }
    }

    public void setSizeX(int sizeX) {
        this.sizeX = sizeX;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public void setSizeY(int sizeY) {
        this.sizeY = sizeY;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public String getDataSourcePrefix() {
        return this.dataSourcePrefix;
    }

    public int getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(int dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSourcePrefix(String dataSourcePrefix) {
        this.dataSourcePrefix = dataSourcePrefix;
    }

    public double getDeltaRateFactor() {
        return this.deltaRateFactor;
    }

    public void setDeltaRateFactor(double deltaRateFactor) {
        this.deltaRateFactor = deltaRateFactor;
    }

    public void setUseRoundStartTime(boolean useRoundStartTime) {
        this.useRoundStartTime = useRoundStartTime;
    }

    public boolean isUseRoundStartTime() {
        return this.useRoundStartTime;
    }
}

