/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.explorer.grid;

import com.agentpp.explorer.IndexConverter;
import com.agentpp.explorer.MIBTableModel;
import com.agentpp.explorer.MIBTablePanel;
import com.agentpp.explorer.RequestObserverPanel;
import com.agentpp.explorer.grid.DisabledCellValueEditor;
import com.agentpp.explorer.grid.GridRowEvent;
import com.agentpp.explorer.grid.GridRowListener;
import com.agentpp.explorer.grid.Index;
import com.agentpp.explorer.grid.IndexComparator;
import com.agentpp.explorer.log.SnmpLogger;
import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmp.GenTarget;
import com.agentpp.snmp.JCValueConverter;
import com.agentpp.snmp.ValueConverter;
import com.agentpp.util.Vector2Matrix;
import com.klg.jclass.datasource.BaseColumn;
import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.DataModelAdapter;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.TreeData;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MIBTreeData
extends TreeData
implements ResponseListener {
    static final String INDEX_COL_SUFFIX = "i";
    private static final Logger _$4675 = Logger.getLogger("GridTree");
    private SnmpLogger _$4326;
    private MIBGridTable _$18769;
    private Vector _$35531;
    private TreeMap _$35532;
    private MIBRepository _$5443;
    private Snmp _$4261;
    private GenTarget _$4262;
    private RequestObserverPanel _$24536;
    private int _$29680 = 20;
    private int _$35142 = 0;
    private int _$35533 = 10;
    protected DataModelListener dataModelListener = new DataModelAdapter();
    private Object _$4339 = new Object();
    private transient Vector _$35535;

    public MIBTreeData() {
    }

    public MIBTreeData(Snmp snmp, GenTarget genTarget, MIBRepository mIBRepository, Vector vector, RequestObserverPanel requestObserverPanel) {
        this._$5443 = mIBRepository;
        this._$4326 = new SnmpLogger(mIBRepository);
        this._$35531 = vector;
        this._$4261 = snmp;
        this._$4262 = genTarget;
        this._$24536 = requestObserverPanel;
        this._$35532 = new TreeMap(new IndexComparator(false));
        this.createMetaData();
    }

    protected void createMetaData() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Object object;
        this._$18769 = null;
        Cloneable cloneable3 = null;
        for (int i = 0; i < this._$35531.size(); ++i) {
            Serializable serializable;
            Object object2;
            JCValueConverter[] jCValueConverterArray;
            MIBObjectType mIBObjectType = (MIBObjectType)this._$35531.get(i);
            object = this._$5443.getColumnarObjectsOfTable(mIBObjectType, true, false);
            cloneable2 = new BaseMetaData(this);
            cloneable = this._$5443.getColumnarObjectsOfTable(mIBObjectType, true, true);
            Vector vector = MIBTableModel.getTitlesFromNames(mIBObjectType.getName(), (Vector)cloneable);
            Vector<JCValueConverter> vector2 = new Vector<JCValueConverter>(((Vector)cloneable).size());
            for (int j = 0; j < ((Vector)cloneable).size(); ++j) {
                jCValueConverterArray = (JCValueConverter[])((Vector)cloneable).get(j);
                this._$35539(mIBObjectType, (BaseMetaData)cloneable2, vector.get(j).toString(), j < ((Vector)object).size(), (MIBObjectType)jCValueConverterArray);
                object2 = this._$5443.getEffectiveSyntax(jCValueConverterArray.getSyntax());
                serializable = new JCValueConverter((MIBObjectType)jCValueConverterArray, ((MIBTextualConvention)object2).getSyntax(), ((MIBTextualConvention)object2).getDisplayHint());
                vector2.addElement((JCValueConverter)serializable);
            }
            try {
                ((BaseMetaData)cloneable2).setCommitPolicy(1);
                ((BaseMetaData)cloneable2).setCacheChildren(true);
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
            IndexStruct[] indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(this._$5443);
            jCValueConverterArray = new JCValueConverter[indexStructArray.length];
            for (int j = 0; j < jCValueConverterArray.length; ++j) {
                jCValueConverterArray[j] = (JCValueConverter)vector2.get(j);
            }
            object2 = new Index(mIBObjectType, (Vector)object, (Vector)cloneable, vector2, indexStructArray, jCValueConverterArray);
            ((DefaultMutableTreeNode)cloneable2).setUserObject(object2);
            ((BaseMetaData)cloneable2).setDescription(mIBObjectType.getName());
            if (i == 0) {
                this._$18769 = new MIBGridTable((MetaDataModel)((Object)cloneable2), (Index)((DefaultMutableTreeNode)cloneable2).getUserObject());
                cloneable3 = cloneable2;
                ((DataSourceTreeModel)this.getMetaDataTree()).setRoot((TreeNode)((Object)cloneable3));
                ((DataSourceTreeModel)this.getDataTableTree()).setRoot(this._$18769);
                continue;
            }
            serializable = (Vector)this._$35532.get(object2);
            if (serializable != null) {
                ((Vector)serializable).add(cloneable2);
                continue;
            }
            serializable = new Vector(3);
            ((Vector)serializable).add(cloneable2);
            this._$35532.put(object2, serializable);
        }
        for (MIBObjectType mIBObjectType : this._$35532.keySet()) {
            int n;
            object = (Index)((Object)mIBObjectType);
            cloneable2 = (Vector)this._$35532.get(object);
            cloneable = this._$5118((Index)object);
            if (cloneable == null) {
                for (n = 0; n < ((Vector)cloneable2).size(); ++n) {
                    cloneable3.add((MutableTreeNode)((Vector)cloneable2).get(n));
                }
                continue;
            }
            for (n = 0; n < ((Vector)cloneable2).size(); ++n) {
                ((DefaultMutableTreeNode)cloneable).add((MutableTreeNode)((Vector)cloneable2).get(n));
            }
        }
    }

    public MIBGridTable getTable(DataModelListener dataModelListener, ObjectID objectID, Index index, String string) throws DataModelException {
        if (((BaseMetaData)this._$18769.getMetaData()).getUserObject() == index) {
            return this._$18769;
        }
        return this._$18769.getTableForIndex(dataModelListener, objectID, index, string);
    }

    private void _$35539(MIBObjectType mIBObjectType, BaseMetaData baseMetaData, String string, boolean bl, MIBObjectType mIBObjectType2) {
        BaseColumn baseColumn = new BaseColumn();
        baseColumn.setColumnLabel(string);
        MIBTextualConvention mIBTextualConvention = this._$5443.getEffectiveSyntax(mIBObjectType2.getSyntax());
        ValueConverter valueConverter = new ValueConverter(mIBObjectType2, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        baseColumn.setColumnClassName(valueConverter.getNativeExample().getClass().getName());
        baseColumn.setAutoIncrement(false);
        baseColumn.setSchemaName(mIBObjectType.getName());
        if (bl) {
            baseColumn.setColumnName(mIBObjectType2.getOid().toString() + INDEX_COL_SUFFIX);
        } else {
            baseColumn.setColumnName(mIBObjectType2.getOid().toString());
        }
        try {
            baseMetaData.addColumn(baseColumn);
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
    }

    static boolean isColumnReadOnly(MIBObjectType mIBObjectType) {
        String string = mIBObjectType.getAccess();
        return string.equals(SMI.ACCESS[1]);
    }

    private BaseMetaData _$5118(Index index) {
        SortedMap sortedMap = this._$35532.headMap(index);
        IndexComparator indexComparator = new IndexComparator(false);
        try {
            Index index2 = sortedMap.lastKey();
            return (BaseMetaData)sortedMap.get(index2);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public void refresh(ObjectID objectID, ObjectID objectID2) {
        this._$18769.removeAll();
        Vector vector = this._$18769.getColumnIDs();
        Walker walker = new Walker(this._$18769, vector, this._$35533);
        walker.setIndexFrom(objectID);
        walker.setIndexTo(objectID2);
        walker.setRecursive(true);
        walker.next();
    }

    public Vector getTables() {
        return this._$35531;
    }

    protected void refreshFinished() {
        this.enableDataModelEvents(true);
        try {
            super.requeryAll(this.dataModelListener);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        this._$35142 = 0;
    }

    private boolean _$35558(ResponseEvent responseEvent, boolean bl) {
        boolean bl2 = true;
        MIBGridTable mIBGridTable = ((Walker)responseEvent.getUserObject()).getModel();
        if (!bl && responseEvent.getResponse() != null && responseEvent.getResponse().getType() != -88 && responseEvent.getResponse().getErrorStatus() != 0 && responseEvent.getUserObject() == null && responseEvent.getResponse().getErrorStatus() == 2) {
            mIBGridTable.removeRow(responseEvent.getRequest().get(0).getOid());
            return true;
        }
        if (bl) {
            Object[] objectArray = responseEvent.getResponse().toArray();
            this._$35142 += objectArray.length;
            if (responseEvent.getUserObject() instanceof Walker) {
                Walker walker = (Walker)responseEvent.getUserObject();
                Vector vector = walker.getLastSend();
                Vector vector2 = Vector2Matrix.getMatrix(objectArray, vector.size());
                for (int i = 0; i < vector2.size(); ++i) {
                    Serializable serializable;
                    Vector vector3 = (Vector)vector2.elementAt(i);
                    Vector vector4 = new Vector(vector3.size() + 1);
                    for (int j = 0; j < vector3.size(); ++j) {
                        OID oID = (OID)vector.elementAt(j);
                        serializable = (VariableBinding)vector3.elementAt(j);
                        if (((VariableBinding)serializable).isException() || ((VariableBinding)serializable).getOid().leftMostCompare(oID.size(), oID) != 0) continue;
                        vector4.addElement(vector3.elementAt(j));
                    }
                    Object[] objectArray2 = new VariableBinding[vector4.size()];
                    vector4.copyInto(objectArray2);
                    if (objectArray2.length <= 0) continue;
                    boolean bl3 = true;
                    if (walker.getIndexFrom() != null || walker.getIndexTo() != null) {
                        serializable = mIBGridTable.getIndex(((VariableBinding)objectArray2[0]).getOid());
                        if (serializable != null) {
                            if (walker.getIndexFrom() != null && ((ObjectID)serializable).compareTo(walker.getIndexFrom()) < 0) {
                                bl3 = false;
                            }
                            if (walker.getIndexTo() != null && ((ObjectID)serializable).compareTo(walker.getIndexTo()) > 0) {
                                bl3 = false;
                            }
                        } else {
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        mIBGridTable.refreshRow((VariableBinding[])objectArray2);
                    }
                    if (i + 1 < vector2.size() && objectArray2.length <= ((Vector)vector2.elementAt(i + 1)).size()) continue;
                    try {
                        Cloneable cloneable;
                        Serializable serializable2;
                        boolean bl4 = true;
                        if (walker.getIndexTo() != null) {
                            serializable2 = mIBGridTable.getColumnIDs();
                            cloneable = new OID(((OID)((Vector)serializable2).firstElement()).getValue());
                            cloneable.append(walker.getIndexTo().toString());
                            if (cloneable.leftMostCompare(cloneable.size(), ((VariableBinding)objectArray2[0]).getOid()) <= 0) {
                                bl4 = false;
                            }
                        }
                        if (bl4) {
                            serializable2 = this._$4262.makePDU();
                            ((PDU)serializable2).addAll((VariableBinding[])objectArray2);
                            ((PDU)serializable2).setMaxRepetitions(this._$29680);
                            walker.setLastSend(vector);
                            cloneable = this._$4262.getTarget();
                            this._$24536.resendRequest(-91, (PDU)serializable2, this._$4262, (Target)cloneable, walker, this, this._$35234());
                            bl2 = false;
                            break;
                        }
                        if (!walker.next()) break;
                        bl2 = false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                if (bl2) {
                    boolean bl5 = bl2 = !walker.next();
                    if (bl2 && walker.isRecursive() && !walker.getModel().getMetaData().isLeaf()) {
                        Walker[] walkerArray = new Walker[2];
                        for (int i = 0; i < walker.getModel().getRowCount(); ++i) {
                            long l = walker.getModel().getRowIdentifier(i);
                            Walker[] walkerArray2 = walker.getModel()._$35562(l);
                            if (walkerArray[0] == null) {
                                walkerArray[0] = walkerArray2[0];
                            } else {
                                walkerArray[1].setNext(walkerArray2[0]);
                            }
                            walkerArray[1] = walkerArray2[1];
                            bl2 = false;
                        }
                        if (!bl2) {
                            walkerArray[0].next();
                        }
                    }
                    if (bl2 && walker.getNext() != null) {
                        walker.getNext().next();
                        bl2 = false;
                    }
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(ResponseEvent responseEvent) {
        Object object = this._$4339;
        synchronized (object) {
            try {
                this._$4261.cancel(responseEvent.getRequest(), this);
                this._$24536.removeOutstanding(responseEvent.getRequest());
                if (this._$24536.isRequestCanceled()) {
                    this.refreshFinished();
                    return;
                }
                boolean bl = this._$4326.logResponse(responseEvent, this._$24536);
                if (this._$35558(responseEvent, bl)) {
                    if (bl) {
                        this._$24536.requestFinished();
                    }
                    this._$4339.notify();
                    this.refreshFinished();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.refreshFinished();
            }
        }
    }

    public void requeryAll(DataModelListener dataModelListener) {
        try {
            this._$18769.cancelAllRowChanges(dataModelListener);
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
        this._$18769.removeAll();
        this.refresh(null, null);
    }

    public TreeMap getMetaData() {
        return this._$35532;
    }

    public MIBRepository getRepository() {
        return this._$5443;
    }

    public void setRepository(MIBRepository mIBRepository) {
        this._$5443 = mIBRepository;
    }

    private String _$35234() {
        return "Received " + this._$35142 + " instances...";
    }

    public synchronized void removeGridRowListener(GridRowListener gridRowListener) {
        if (this._$35535 != null && this._$35535.contains(gridRowListener)) {
            Vector vector = (Vector)this._$35535.clone();
            vector.removeElement(gridRowListener);
            this._$35535 = vector;
        }
    }

    public synchronized void addGridRowListener(GridRowListener gridRowListener) {
        Vector vector;
        Vector vector2 = vector = this._$35535 == null ? new Vector(2) : (Vector)this._$35535.clone();
        if (!vector.contains(gridRowListener)) {
            vector.addElement(gridRowListener);
            this._$35535 = vector;
        }
    }

    protected void fireGridRowEvent(GridRowEvent gridRowEvent) {
        if (this._$35535 != null) {
            Vector vector = this._$35535;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((GridRowListener)vector.elementAt(i)).gridRowEvent(gridRowEvent);
            }
        }
    }

    class CellValue {
        public JCValueConverter vc;
        public Object value;

        public CellValue(JCValueConverter jCValueConverter, Object object) {
            this.vc = jCValueConverter;
            this.value = object;
        }

        public MIBRepository getRepository() {
            return MIBTreeData.this._$5443;
        }

        public String toString() {
            Object object = this.value;
            if (this.vc.getEffectiveSyntax().hasEnums()) {
                if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    if (n == null) {
                        return "";
                    }
                    MIBEnum mIBEnum = this.vc.getEffectiveSyntax().getEnum(n.intValue());
                    if (mIBEnum != null) {
                        object = mIBEnum.toString();
                    }
                }
            } else if (this.vc.getSMISyntax() == 11 && object instanceof Long) {
                object = new TimeTicks((Long)object).toString();
            } else if (object instanceof ObjectID) {
                ObjectID objectID = (ObjectID)object;
                String string = MIBTreeData.this._$5443.getObjectName(objectID);
                if (string == null) {
                    string = MIBTreeData.this._$5443.getPathSuffix(objectID);
                }
                if (string != null) {
                    object = string;
                }
            }
            if (object != null) {
                return object.toString();
            }
            return "";
        }
    }

    class CellValueComparator
    implements Comparator {
        CellValueComparator() {
        }

        public boolean equals(Object object) {
            return this == object;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof CellValue && object2 instanceof CellValue) {
                CellValue cellValue = (CellValue)object;
                CellValue cellValue2 = (CellValue)object2;
                return cellValue.vc.compare(cellValue.value, cellValue2.value);
            }
            return ((Comparable)object).compareTo(object2);
        }
    }

    class Setter
    implements ResponseListener {
        private PDU _$5153;
        private long _$4402;
        private Target _$4262;
        private PDU _$5469;
        private String _$4142;
        private String _$35598;
        private boolean _$5562 = false;

        public Setter(PDU pDU, Target target, long l, String string) {
            this._$5153 = pDU;
            this._$4402 = l;
            this._$4262 = target;
            this._$4142 = string;
        }

        public void run() throws IOException {
            MIBTreeData.this._$24536.setCurrentRequest(this._$5153, this, "Comitting row with index " + this._$4142);
            MIBTreeData.this._$4261.set(this._$5153, this._$4262, null, this);
            MIBTreeData.this._$4326;
            SnmpLogger.logRequest(this._$5153, MIBTreeData.this._$4262);
        }

        public PDU getResponse() {
            return this._$5469;
        }

        public long getRow() {
            return this._$4402;
        }

        public String getErrorText() {
            return this._$35598;
        }

        public synchronized void onResponse(ResponseEvent responseEvent) {
            MIBTreeData.this._$4261.cancel(responseEvent.getRequest(), this);
            MIBTreeData.this._$24536.requestFinished();
            this._$5469 = responseEvent.getResponse();
            if (MIBTreeData.this._$4326.logResponse(responseEvent.getPeerAddress(), this._$5153, this._$5469, true)) {
                MIBTreeData.this._$24536.requestFinished();
            } else {
                this._$5562 = true;
                String string = "Timeout";
                if (this._$5469 != null) {
                    string = "Error while trying to commit row " + this._$4142 + ": " + this._$5469.getErrorStatusText();
                }
                MIBTreeData.this._$24536.requestFinishedWithError(string);
                this._$35598 = string;
            }
            this.notify();
        }

        public boolean isError() {
            return this._$5562;
        }
    }

    class Walker {
        private int _$4971 = 0;
        private Vector _$34997;
        private Vector _$35325;
        private int _$35249;
        private ObjectID _$35153;
        private ObjectID _$35154;
        private MIBGridTable _$4260;
        private boolean _$35590 = false;
        private Walker _$35597 = null;

        public Walker(MIBGridTable mIBGridTable, Vector vector, int n) {
            this._$34997 = vector;
            this._$35249 = n;
            this._$4260 = mIBGridTable;
        }

        public Vector getLastSend() {
            return this._$35325;
        }

        public void setMaxColumns(int n) {
            this._$35249 = n;
        }

        public void setLastSend(Vector vector) {
            this._$35325 = vector;
        }

        public MIBGridTable getModel() {
            return this._$4260;
        }

        public ObjectID getIndexFrom() {
            return this._$35153;
        }

        public ObjectID getIndexTo() {
            return this._$35154;
        }

        public void setIndexFrom(ObjectID objectID) {
            this._$35153 = objectID;
        }

        public void setIndexTo(ObjectID objectID) {
            this._$35154 = objectID;
        }

        public Walker getNext() {
            return this._$35597;
        }

        public void setNext(Walker walker) {
            this._$35597 = walker;
        }

        public boolean next() {
            if (this._$4971 >= this._$34997.size()) {
                return false;
            }
            PDU pDU = MIBTreeData.this._$4262.makePDU();
            int n = Math.min(this._$35249, this._$34997.size() - this._$4971);
            if (MIBTreeData.this._$29680 > 0) {
                if (this._$4971 == 0) {
                    pDU.setMaxRepetitions(2);
                } else {
                    pDU.setMaxRepetitions(MIBTreeData.this._$29680);
                }
                pDU.setNonRepeaters(0);
            } else {
                pDU.setNonRepeaters(n);
                pDU.setMaxRepetitions(0);
            }
            this._$35325 = new Vector(n + 1);
            for (int i = this._$4971; i < this._$4971 + n; ++i) {
                Serializable serializable;
                OID oID = (OID)this._$34997.elementAt(i);
                if (this._$35153 != null) {
                    serializable = new ObjectID(oID.toString());
                    ((ObjectID)serializable).append(this._$35153);
                    serializable = MIBTablePanel.predecessor((ObjectID)serializable);
                    oID = new OID(((ObjectID)serializable).toString());
                }
                serializable = new VariableBinding();
                ((VariableBinding)serializable).setOid(oID);
                pDU.add((VariableBinding)serializable);
                this._$35325.add(this._$34997.elementAt(i));
            }
            try {
                Target target = MIBTreeData.this._$4262.getTarget();
                if (this._$4971 == 0) {
                    MIBTreeData.this._$24536.request(-91, pDU, MIBTreeData.this._$4262, target, this, MIBTreeData.this, MIBTreeData.this._$35234());
                } else {
                    MIBTreeData.this._$24536.resendRequest(-91, pDU, MIBTreeData.this._$4262, target, this, MIBTreeData.this, MIBTreeData.this._$35234());
                }
                this._$4971 += pDU.size();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }

        public void setRecursive(boolean bl) {
            this._$35590 = bl;
        }

        public boolean isRecursive() {
            return this._$35590;
        }
    }

    class MIBGridTable
    extends BaseDataTable {
        protected Vector colids;
        protected Index index;
        protected Vector indexes;
        protected TreeMap index2row;
        protected int lastRowSet;

        public MIBGridTable(MetaDataModel metaDataModel, Index index) {
            super(metaDataModel);
            this.index = null;
            this.indexes = new Vector(10, 10);
            this.index2row = new TreeMap();
            this.lastRowSet = -1;
            this.index = index;
            this._$5900();
        }

        public MIBGridTable(MetaDataModel metaDataModel, long l, Index index) {
            super(metaDataModel, l);
            this.index = null;
            this.indexes = new Vector(10, 10);
            this.index2row = new TreeMap();
            this.lastRowSet = -1;
            this.index = index;
            this._$5900();
        }

        public Object createNewRow() throws DataModelException {
            Vector vector = this.createDefaultInstances();
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public Index getIndex() {
            return this.index;
        }

        public int getFirstWritableColumn() {
            Vector vector = this.index.getColumns();
            for (int i = 0; i < vector.size(); ++i) {
                MIBObjectType mIBObjectType = (MIBObjectType)vector.get(i);
                if (MIBTreeData.isColumnReadOnly(mIBObjectType)) continue;
                return i;
            }
            return 0;
        }

        public DataTableModel materializeTable(DataModelListener dataModelListener, long l, TreeNode treeNode) throws DataModelException {
            return new MIBGridTable((BaseMetaData)treeNode, l, (Index)((BaseMetaData)treeNode).getUserObject());
        }

        public MIBGridTable getTableForIndex(DataModelListener dataModelListener, ObjectID objectID, Index index, String string) throws DataModelException {
            if (this.index == index) {
                return this;
            }
            BaseMetaData baseMetaData = null;
            baseMetaData = this._$27633((BaseMetaData)this.getMetaData(), index);
            if (baseMetaData != null) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    ObjectID objectID2 = (ObjectID)this.indexes.get(i);
                    long l = this.getRowIdentifier(i);
                    if (objectID.equals(objectID2) || objectID.isChildOf(objectID2)) {
                        MIBGridTable mIBGridTable = (MIBGridTable)this.getTable(l, baseMetaData);
                        if (mIBGridTable == null) {
                            return (MIBGridTable)this.createTable(dataModelListener, l, baseMetaData);
                        }
                        return mIBGridTable.getTableForIndex(dataModelListener, objectID, index, string);
                    }
                    try {
                        if (objectID.isLessThan(objectID2)) {
                            return (MIBGridTable)this.createTable(dataModelListener, l, baseMetaData);
                        }
                        if (i + 1 >= this.getRowCount() && objectID2.isLessThan(objectID)) {
                            return (MIBGridTable)this.createTable(dataModelListener, l, baseMetaData);
                        }
                        continue;
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {
                        objectIDFormatException.printStackTrace();
                    }
                }
            }
            return null;
        }

        private BaseMetaData _$27633(BaseMetaData baseMetaData, Index index) {
            BaseMetaData baseMetaData2 = null;
            for (int i = 0; baseMetaData2 == null && i < baseMetaData.getChildCount(); ++i) {
                BaseMetaData baseMetaData3 = (BaseMetaData)baseMetaData.getChildAt(i);
                if (baseMetaData3.getUserObject() == index) {
                    baseMetaData2 = baseMetaData3;
                    break;
                }
                baseMetaData2 = this._$27633(baseMetaData3, index);
            }
            return baseMetaData2;
        }

        public void setValueAt(long l, String string, Object object) throws DataModelException {
            Object object2 = super.getCell(l, string);
            if (object instanceof DisabledCellValueEditor || !(object2 instanceof CellValue)) {
                super.setValueAt(l, string, object2);
                return;
            }
            CellValue cellValue = (CellValue)object2;
            super.setValueAt(l, string, new CellValue(cellValue.vc, cellValue.vc.toNative(cellValue.vc.fromString(object.toString()))));
        }

        public void removeAll() {
            super.removeAllChildren();
            this.store.clear();
            this.internalData.clear();
            this.insertedRows.clear();
            this.index2row = new TreeMap();
            this.indexes.clear();
        }

        private void _$5900() {
            this.colids = new Vector(this.index.getColumns().size() + 1);
            int n = 0;
            Enumeration enumeration = this.index.getColumns().elements();
            while (enumeration.hasMoreElements()) {
                MIBObjectType mIBObjectType = (MIBObjectType)enumeration.nextElement();
                if (n >= this.index.getIndexStructure().length && !mIBObjectType.getAccess().equals(SMI.ACCESS[0])) {
                    this.colids.addElement(new OID(mIBObjectType.getOid().toString()));
                }
                ++n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveRow(long l) throws DataModelException {
            Object object;
            int n = this.getRowIndex(l);
            ObjectID objectID = (ObjectID)this.indexes.get(n);
            String string = ((Index)((BaseMetaData)this.getMetaData()).getUserObject()).getTable().getName() + "." + objectID;
            if (_$4675.isInfoEnabled()) {
                _$4675.info("Comitting row with index " + string);
            }
            PDU pDU = MIBTreeData.this._$4262.makePDU();
            for (int i = this.index.getIndexStructure().length; i < this.getMetaData().getColumnCount(); ++i) {
                object = this.getMetaData().getColumnIdentifier(i);
                if (!this.getMetaData().getColumnObject((String)object).isWritable()) continue;
                VariableBinding variableBinding = new VariableBinding();
                variableBinding.setOid(new OID(this.getColumnObject(i).getOid().toString() + "." + this.getIndexOf(n)));
                CellValue cellValue = (CellValue)this.getResultData(l, (String)object);
                Variable variable = cellValue.vc.fromNative(cellValue.value);
                if (variable == null) continue;
                variableBinding.setVariable(variable);
                pDU.add(variableBinding);
            }
            Setter setter = new Setter(pDU, MIBTreeData.this._$4262.getTarget(), l, string);
            object = setter;
            synchronized (object) {
                try {
                    setter.run();
                }
                catch (IOException iOException) {
                    throw new DataModelException(l, "", this, 10, iOException);
                }
                try {
                    setter.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (setter.isError()) {
                object = null;
                if (setter.getResponse() != null && setter.getResponse().getErrorIndex() > 0) {
                    try {
                        object = this.getMetaData().getColumnIdentifier(setter.getResponse().getErrorIndex() - 1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                throw new DataModelException(l, (String)object, this, 10, new RuntimeException(setter.getErrorText()));
            }
        }

        public Vector getColumnIDs() {
            return this.colids;
        }

        public Vector getColumns() {
            return this.index.getColumns();
        }

        public int getColumn(OID oID) {
            for (int i = 0; i < this.colids.size(); ++i) {
                OID oID2 = (OID)this.colids.elementAt(i);
                if (oID.leftMostCompare(oID2.size(), oID2) != 0) continue;
                return this.index.getIndexStructure().length + i;
            }
            return -1;
        }

        public int getColumn(OID oID, int n) {
            for (int i = n; i < this.colids.size(); ++i) {
                OID oID2 = (OID)this.colids.elementAt(i);
                if (oID.leftMostCompare(oID2.size(), oID2) != 0) continue;
                return this.index.getIndexStructure().length + i;
            }
            return -1;
        }

        public OID getOidOf(int n, int n2) {
            MIBObject mIBObject = (MIBObject)this.index.getColumns().elementAt(n2);
            OID oID = new OID(mIBObject.getPrintableOid());
            oID.append(new OID(this.getIndexOf(n).toString()));
            return oID;
        }

        public MIBObjectType getColumnObject(int n) {
            return (MIBObjectType)this.getColumns().elementAt(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return SMI.isWritable(this.getColumnObject(n2).getAccess());
        }

        public int getRow(ObjectID objectID) {
            if (this.index2row.containsKey(objectID)) {
                return this.index2row.headMap(objectID).size();
            }
            return -1;
        }

        public int getRow(OID oID) {
            ObjectID objectID = new ObjectID(oID.toString());
            try {
                objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$5443.getSplittedObjectID((ObjectID)objectID).second;
                return this.getRow(objectID);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                objectIDFormatException.printStackTrace();
                return -1;
            }
        }

        public ObjectID getIndex(OID oID) {
            if (oID == null) {
                return null;
            }
            ObjectID objectID = new ObjectID(oID.toString());
            try {
                objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$5443.getSplittedObjectID((ObjectID)objectID).second;
                return objectID;
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                objectIDFormatException.printStackTrace();
                return null;
            }
        }

        public ObjectID getIndexOf(int n) {
            if (n < 0 || n >= this.indexes.size()) {
                return null;
            }
            return (ObjectID)this.indexes.elementAt(n);
        }

        public int getIndexColumnCount() {
            return this.index.getIndexStructure().length;
        }

        public void refreshStart() {
            MIBTreeData.this._$35142 = 0;
            this.lastRowSet = -1;
        }

        public void refreshEnd() {
        }

        public Vector createDefaultInstances() {
            Vector<CellValue> vector = new Vector<CellValue>(this.getColumns().size());
            for (int i = 0; i < this.getColumns().size(); ++i) {
                MIBObjectType mIBObjectType = this.getColumnObject(i);
                JCValueConverter jCValueConverter = this.getValueConverter(i);
                Variable variable = JCValueConverter.getDefaultValue(MIBTreeData.this._$5443, mIBObjectType, jCValueConverter.getEffectiveSyntax());
                if (variable == null) {
                    variable = this.getInitialValue(jCValueConverter.getEffectiveSyntax());
                }
                vector.addElement(new CellValue(jCValueConverter, jCValueConverter.toNative(variable)));
            }
            return vector;
        }

        protected void setIndexObjects(int n, ObjectID objectID) {
            ObjectID[] objectIDArray = null;
            objectIDArray = MIBTreeData.this._$5443.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            for (int i = 0; i < this.getIndexColumnCount(); ++i) {
                if (objectIDArray == null) continue;
                JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(i);
                Variable variable = IndexConverter.getIndexVariable(this.index.getIndexStructure()[i], objectIDArray[i]);
                if (variable == null) continue;
                try {
                    super.setValueAt(this.getRowIdentifier(n), objectIDArray[i].toString(), new CellValue(jCValueConverter, jCValueConverter.toNative(variable)));
                    continue;
                }
                catch (DataModelException dataModelException) {
                    dataModelException.printStackTrace();
                }
            }
        }

        public JCValueConverter getValueConverter(int n) {
            return (JCValueConverter)this.index.getValueConverter().elementAt(n);
        }

        public Vector getValueConverters() {
            return this.index.getValueConverter();
        }

        private void _$35026(ObjectID objectID, VariableBinding[] variableBindingArray) {
            int n;
            int n2 = this.getRowIndex(objectID);
            if (n2 == Integer.MAX_VALUE) {
                n2 = this.getRowCount();
            }
            if (n2 - this.lastRowSet > 1) {
                for (n = 0; n < n2 - this.lastRowSet - 1; ++n) {
                    this.removeRow(this.lastRowSet + 1);
                }
            }
            if ((n = this.setRow(variableBindingArray, true)) > this.lastRowSet) {
                this.lastRowSet = n;
            }
        }

        public void refreshRow(VariableBinding[] variableBindingArray) {
            if (variableBindingArray.length <= 0) {
                return;
            }
            ObjectID objectID = new ObjectID(variableBindingArray[0].getOid().getValue());
            try {
                objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$5443.getSplittedObjectID((ObjectID)objectID).second;
                if (objectID != null) {
                    OID oID = new OID(objectID.asIntArray());
                    VariableBinding[] variableBindingArray2 = variableBindingArray;
                    for (int i = 0; i < variableBindingArray2.length; ++i) {
                        if (variableBindingArray2[i].getOid().rightMostCompare(oID.size(), oID) == 0) continue;
                        VariableBinding[] variableBindingArray3 = new VariableBinding[i];
                        if (variableBindingArray3.length > 0) {
                            System.arraycopy(variableBindingArray2, 0, variableBindingArray3, 0, i);
                            this._$35026(objectID, variableBindingArray3);
                        }
                        variableBindingArray3 = new VariableBinding[variableBindingArray2.length - i];
                        objectID = new ObjectID(variableBindingArray2[i].getOid().getValue());
                        System.arraycopy(variableBindingArray2, i, variableBindingArray3, 0, variableBindingArray2.length - i);
                        variableBindingArray2 = variableBindingArray3;
                        objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$5443.getSplittedObjectID((ObjectID)objectID).second;
                        if (objectID != null) {
                            oID = new OID(objectID.asIntArray());
                        }
                        i = 0;
                    }
                    if (variableBindingArray2.length > 0) {
                        this._$35026(objectID, variableBindingArray2);
                    }
                }
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.err.println("MIBTableModel: Error setting row: " + objectIDFormatException.getMessage());
                objectIDFormatException.printStackTrace();
            }
        }

        public int getNumDataRows() {
            return this.indexes.size();
        }

        public int setRow(VariableBinding[] variableBindingArray, boolean bl) {
            if (variableBindingArray.length <= 0) {
                return -1;
            }
            return this.setSparseRow(variableBindingArray, bl);
        }

        public int setSparseRow(VariableBinding[] variableBindingArray, boolean bl) {
            if (variableBindingArray.length <= 0) {
                return -1;
            }
            ObjectID objectID = new ObjectID(variableBindingArray[0].getOid().toString());
            try {
                objectID = (ObjectID)((MIBTreeData)MIBTreeData.this)._$5443.getSplittedObjectID((ObjectID)objectID).second;
                int n = -1;
                if (objectID != null) {
                    n = this.getRow(objectID);
                    if (n < 0) {
                        n = bl ? this.addEmptyRow(objectID, null) : this.addNewRow(objectID);
                    }
                    int n2 = this.getIndexColumnCount();
                    for (int i = 0; i < variableBindingArray.length; ++i) {
                        int n3 = this.getColumn(variableBindingArray[i].getOid(), i);
                        if (n3 < 0) continue;
                        JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(n3);
                        try {
                            CellValue cellValue = new CellValue(jCValueConverter, jCValueConverter.toNative(variableBindingArray[i].getVariable()));
                            super.setValueAt(this.getRowIdentifier(n), this.colids.get(n3 - n2).toString(), cellValue);
                            continue;
                        }
                        catch (DataModelException dataModelException) {
                            dataModelException.printStackTrace();
                        }
                    }
                }
                return n;
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.err.println("MIBTableModel: Error setting row: " + objectIDFormatException.getMessage());
                objectIDFormatException.printStackTrace();
                return -1;
            }
        }

        protected int getRowIndex(ObjectID objectID) {
            try {
                if (((ObjectID)this.index2row.lastKey()).isLessThan(objectID)) {
                    return Integer.MAX_VALUE;
                }
            }
            catch (Exception exception) {
                return Integer.MAX_VALUE;
            }
            int n = this.index2row.headMap(objectID).size();
            return n;
        }

        protected int addRowAt(ObjectID objectID, Vector vector, DataModelListener dataModelListener) {
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            int n = this.getRowIndex(objectID);
            if (n >= 0) {
                if (n == Integer.MAX_VALUE) {
                    n = this.getRowCount();
                    this.addInternalRow(objectArray);
                    this.indexes.addElement(objectID);
                } else {
                    this.addInternalRow(objectArray, n);
                    this.indexes.insertElementAt(objectID, n);
                }
                this.index2row.put(objectID, objectID);
            }
            return n;
        }

        protected long addRowAt(ObjectID objectID, Vector vector) {
            long l = -1L;
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            int n = this.getRowIndex(objectID);
            if (n >= 0) {
                if (n == Integer.MAX_VALUE) {
                    n = this.getRowCount();
                    l = this.addInternalRow(objectArray);
                    this.indexes.addElement(objectID);
                } else {
                    l = this.addInternalRow(objectArray, n);
                    this.indexes.insertElementAt(objectID, n);
                }
                this.index2row.put(objectID, objectID);
            }
            return l;
        }

        public int addNewRow(ObjectID objectID) {
            int n;
            Vector vector = this.createDefaultInstances();
            ObjectID[] objectIDArray = MIBTreeData.this._$5443.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            for (n = this.getIndexColumnCount() - 1; n >= 0; --n) {
                JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(n);
                Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index.getIndexStructure()[n], objectIDArray[n]));
                vector.setElementAt(new CellValue(jCValueConverter, object), n);
            }
            n = this.addRowAt(objectID, vector, null);
            return n;
        }

        public String getIndexString(ObjectID objectID) {
            if (objectID == null) {
                return "<null>";
            }
            ObjectID[] objectIDArray = MIBTreeData.this._$5443.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            ValueConverter[] valueConverterArray = new JCValueConverter[this.getIndexColumnCount()];
            for (int i = 0; i < valueConverterArray.length; ++i) {
                valueConverterArray[i] = (JCValueConverter)this.index.getValueConverter().elementAt(i);
            }
            return IndexConverter.getIndexString(valueConverterArray, this.index.getIndexStructure(), objectIDArray);
        }

        public int addEmptyRow(ObjectID objectID, DataModelListener dataModelListener) {
            int n;
            ObjectID[] objectIDArray = MIBTreeData.this._$5443.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            Vector<CellValue> vector = new Vector<CellValue>(this.getIndexColumnCount() + 1);
            for (n = 0; n < this.getIndexColumnCount(); ++n) {
                JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(n);
                Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index.getIndexStructure()[n], objectIDArray[n]));
                vector.addElement(new CellValue(jCValueConverter, object));
            }
            for (n = this.getIndexColumnCount(); n < this.index.getColumns().size(); ++n) {
                vector.add(new CellValue((JCValueConverter)this.index.getValueConverter().get(n), null));
            }
            return this.addRowAt(objectID, vector, dataModelListener);
        }

        public long addEmptyRow(ObjectID objectID) {
            int n;
            ObjectID[] objectIDArray = MIBTreeData.this._$5443.getIndexObjectIDs(objectID, this.index.getIndexStructure());
            Vector<CellValue> vector = new Vector<CellValue>(this.getIndexColumnCount() + 1);
            for (n = 0; n < this.getIndexColumnCount(); ++n) {
                JCValueConverter jCValueConverter = (JCValueConverter)this.index.getValueConverter().get(n);
                Object object = jCValueConverter.toNative(IndexConverter.getIndexVariable(this.index.getIndexStructure()[n], objectIDArray[n]));
                vector.addElement(new CellValue(jCValueConverter, object));
            }
            for (n = this.getIndexColumnCount(); n < this.index.getColumns().size(); ++n) {
                vector.add(new CellValue((JCValueConverter)this.index.getValueConverter().get(n), null));
            }
            return this.addRowAt(objectID, vector);
        }

        public boolean removeRow(OID oID) {
            try {
                ObjectID objectID = this.getIndex(oID);
                int n = this.getRowIndex(objectID);
                this.index2row.remove(objectID);
                this.indexes.removeElementAt(n);
                this.store.removeRow(this.getRowIdentifier(n));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean removeRow(int n) {
            try {
                ObjectID objectID = (ObjectID)this.indexes.elementAt(n);
                this.index2row.remove(objectID);
                this.indexes.removeElementAt(n);
                this.store.removeRow(this.getRowIdentifier(n));
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        public Variable getInitialValue(MIBSyntax mIBSyntax) {
            if (mIBSyntax.getType() == 3 && (mIBSyntax = MIBTreeData.this._$5443.resolveTC(mIBSyntax.getSyntax())) == null) {
                return null;
            }
            if (mIBSyntax.hasEnums()) {
                return new Integer32((int)((MIBEnum)mIBSyntax.getEnumsVector().firstElement()).getLongValue());
            }
            if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("Integer32")) {
                return new Integer32();
            }
            if (mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32")) {
                return new Counter32();
            }
            if (mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32")) {
                return new Gauge32();
            }
            if (mIBSyntax.getSyntax().equals("Counter64")) {
                return new Counter64();
            }
            if (mIBSyntax.getSyntax().equals("TimeTicks")) {
                return new TimeTicks();
            }
            if (mIBSyntax.getSyntax().equals("IpAddress") || mIBSyntax.getSyntax().equals("NetworkAddress")) {
                return new IpAddress("0.0.0.0");
            }
            if (mIBSyntax.getSyntax().equals("Opaque")) {
                return new Opaque();
            }
            if (mIBSyntax.getSyntax().startsWith("OCTET STRING")) {
                return new OctetString();
            }
            if (mIBSyntax.getSyntax().equals("OBJECT-IDENTITY") || mIBSyntax.getSyntax().equals("OBJECT IDENTIFIER")) {
                return new OID();
            }
            return null;
        }

        public void removeAllChildren() {
        }

        public Walker makeRefresh(ObjectID objectID, ObjectID objectID2, boolean bl) {
            Vector vector = this.getColumnIDs();
            Walker walker = new Walker(this, vector, MIBTreeData.this._$35533);
            walker.setIndexFrom(objectID);
            walker.setIndexTo(objectID2);
            walker.setRecursive(bl);
            return walker;
        }

        public void refreshRow(long l) {
            ObjectID objectID = this.getIndexOf(super.getRowIndex(l));
            Walker walker = this.makeRefresh(objectID, objectID, false);
            walker.next();
        }

        public void refresh(long l) throws DataModelException {
            super.refreshRow(l);
        }

        public void requeryTable(DataModelListener dataModelListener) {
            try {
                this.cancelAllRowChanges(dataModelListener);
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
            try {
                this.removeAll();
                ObjectID objectID = null;
                MIBGridTable mIBGridTable = (MIBGridTable)this.getParent();
                if (mIBGridTable != null) {
                    objectID = mIBGridTable.getIndexOf(mIBGridTable.getRowIndex(super.getParentBookmark()));
                }
                Walker walker = this.makeRefresh(objectID, objectID, true);
                walker.next();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void requeryRowAndDetails(DataModelListener dataModelListener, long l) throws DataModelException {
            this.cancelAllRowChanges(dataModelListener);
            try {
                ObjectID objectID = this.getIndexOf(super.getRowIndex(l));
                Walker walker = this.makeRefresh(objectID, objectID, false);
                Walker[] walkerArray = this._$35562(l);
                if (walkerArray[0] != null) {
                    walker.setNext(walkerArray[0]);
                }
                walker.next();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private Walker[] _$35562(long l) {
            int n = super.getRowIndex(l);
            ObjectID objectID = this.getIndexOf(n);
            ObjectID objectID2 = null;
            if (n + 1 < this.getRowCount()) {
                objectID2 = this.getIndexOf(n + 1);
                objectID2 = MIBTablePanel.predecessor(new ObjectID(objectID2));
            }
            Walker[] walkerArray = new Walker[2];
            for (int i = 0; i < this.getMetaData().getChildCount(); ++i) {
                if (_$4675.isDebugEnabled()) {
                    _$4675.debug("Requery row details for child " + i);
                }
                BaseMetaData baseMetaData = (BaseMetaData)this.getMetaData().getChildAt(i);
                MIBGridTable mIBGridTable = new MIBGridTable(baseMetaData, l, (Index)baseMetaData.getUserObject());
                this.add(mIBGridTable);
                Walker walker = new Walker(mIBGridTable, mIBGridTable.getColumnIDs(), MIBTreeData.this._$35533);
                walker.setIndexFrom(objectID);
                walker.setIndexTo(objectID2);
                if (walkerArray[0] == null) {
                    walkerArray[0] = walker;
                } else {
                    walkerArray[1].setNext(walker);
                }
                walkerArray[1] = walker;
            }
            return walkerArray;
        }

        public void requeryDetails(long l) {
            Walker[] walkerArray = this._$35562(l);
            if (walkerArray[0] != null) {
                walkerArray[0].next();
            }
        }
    }
}

